/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.customreport;

import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTApi;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.CustomAttribUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportMgmtAction {
    private static volatile CustomReportMgmtAction instance = null;
    private static Logger reportLogger = Logger.getLogger(CustomReportMgmtAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomReportMgmtAction getInstance() {
        if (instance != null) return instance;
        Class<CustomReportMgmtAction> clazz = CustomReportMgmtAction.class;
        synchronized (CustomReportMgmtAction.class) {
            if (instance != null) return instance;
            instance = new CustomReportMgmtAction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CustomReportMgmtAction() {
    }

    public void save(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject reportData = new JSONObject(request.getParameter("report"));
            String action = request.getParameter("action");
            JSONObject resultParams = new JSONObject();
            String status = "";
            Long subCategoryId = Long.parseLong(String.valueOf(reportData.get("subCategoryId")));
            if (ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                if (CustomReportUtil.isSubCategoryExists((Long)subCategoryId)) {
                    if (action.equalsIgnoreCase("save")) {
                        resultParams = CustomReportHandler.addCustomReportDetails((Long)loginId, (JSONObject)reportData, (AdventNetResourceBundle)rb);
                    } else {
                        status = CustomReportHandler.updateCustomReportDetails((Long)loginId, (JSONObject)reportData, (AdventNetResourceBundle)rb);
                        resultParams.put("status_message", (Object)status);
                    }
                    HDTApi.getInstance().updateAuthObject();
                } else {
                    resultParams.put("status_message", (Object)rb.getString("admp.reports.custom_reports.custom_report_mgmt_status.subcategory_not_exists"));
                }
            } else {
                resultParams.put("status_message", (Object)rb.getString("admp.reports.custom_reports.custom_report_mgmt_status.custom_mgmt_not_delegated"));
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(resultParams.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSubCategory(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultParams = new JSONObject();
            resultParams.put("status_message", (Object)"Error occured while adding the new sub category.");
            String subCategory = request.getParameter("subCategory");
            if (ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                resultParams = CustomReportHandler.addSubCategory((String)subCategory, (AdventNetResourceBundle)rb);
            } else {
                resultParams.put("status_message", (Object)"Technician is not authorized to adding the new sub category.");
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(resultParams.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeSubCategory(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultParams = new JSONObject();
            resultParams.put("status_message", (Object)"Error occured while deleting the new sub category.");
            Long subCategoryId = Long.parseLong(request.getParameter("subCategoryId"));
            if (ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                String status = CustomReportHandler.removeSubCategory((Long)subCategoryId, (AdventNetResourceBundle)rb);
                resultParams.put("status_message", (Object)status);
            } else {
                resultParams.put("status_message", (Object)"Technician is not authorized to adding the new sub category.");
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(resultParams.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateSubCategory(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultParams = new JSONObject();
            resultParams.put("status_message", (Object)"Error occured while updating the new sub category.");
            Long subCategoryId = Long.parseLong(request.getParameter("subCategoryId"));
            String newSubCategoryName = request.getParameter("newSubCategoryName");
            if (ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                String status = CustomReportHandler.updateSubCategory((Long)subCategoryId, (String)newSubCategoryName, (AdventNetResourceBundle)rb);
                resultParams.put("status_message", (Object)status);
            } else {
                resultParams.put("status_message", (Object)"Technician is not authorized to adding the new sub category.");
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(resultParams.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getInputParams(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            JSONObject inputParams = new JSONObject();
            JSONArray categoryList = new JSONArray();
            categoryList = CustomReportHandler.getSubCategoryList((AdventNetResourceBundle)rb);
            inputParams.put("categories", (Object)categoryList);
            JSONArray objectList = new JSONArray();
            objectList = CustomReportHandler.getAvaiableObjects((AdventNetResourceBundle)rb);
            inputParams.put("objectTypes", (Object)objectList);
            JSONObject filterInputs = new JSONObject();
            JSONObject availableCols = new JSONObject();
            JSONObject customCols = new JSONObject();
            JSONObject mandatoryCols = new JSONObject();
            for (int i = 0; i < objectList.length(); ++i) {
                JSONObject objectType = objectList.getJSONObject(i);
                Integer objectId = (Integer)objectType.get("objectId");
                filterInputs.put(Integer.toString(objectId), (Object)CustomReportHandler.getColumnFilterInputs((Integer)objectId, (AdventNetResourceBundle)rb));
                availableCols.put(Integer.toString(objectId), (Object)CustomReportHandler.getAvailableColumns((Integer)objectId, (AdventNetResourceBundle)rb));
                mandatoryCols.put(Integer.toString(objectId), (Object)CustomReportHandler.getMandatoryAttribs((Integer)objectId, (AdventNetResourceBundle)rb));
                ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectId);
                customCols.put(Integer.toString(objectId), (Object)FcJSONUtility.listToJSONArray((List)CustomAttribUtil.getCustomAttribForReport(objectClass)));
            }
            inputParams.put("filterInputs", (Object)filterInputs);
            inputParams.put("availableCols", (Object)availableCols);
            inputParams.put("customCols", (Object)customCols);
            inputParams.put("mandatoryCols", (Object)mandatoryCols);
            JSONArray domainList = new JSONArray();
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList delegatedDomainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)32101L);
            domainList = CustomReportHandler.getAvailableDomains((ArrayList)delegatedDomainList);
            inputParams.put("domainList", (Object)domainList);
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(inputParams.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportDetails(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject reportDetails = new JSONObject();
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            if (ClientAuthorizationUtil.isAuthorized(request, 32101L).booleanValue()) {
                reportDetails = CustomReportHandler.getReportDetails((HttpServletRequest)request, (Integer)reportId, (Long)loginId, (AdventNetResourceBundle)rb);
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(reportDetails.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getFilterFieldComponent(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String domainName = request.getParameter("domainName");
            JSONObject fieldDetailsJsonObj = new JSONObject(request.getParameter("fieldDetails"));
            if (fieldDetailsJsonObj.length() > 0) {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                JSONObject componentDetailsObj = AutomationUtil.getComponentDetails((JSONObject)fieldDetailsJsonObj, (String)domainName, (Long)loginId, (AdventNetResourceBundle)rb);
                response.setContentType("application/json");
                PrintWriter out = response.getWriter();
                out.println(componentDetailsObj.toString());
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateQueryString(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (loginId == null) {
                loginId = 1L;
            }
            JSONArray selectedDomains = new JSONArray(request.getParameter("selectedDomains"));
            ArrayList domainList = (ArrayList)FcJSONUtility.JSONArrayToList((JSONArray)selectedDomains);
            JSONArray filterDetails = new JSONArray(request.getParameter("filterDetails"));
            if (filterDetails.length() > 0) {
                JSONObject json = new JSONObject();
                String searchString = CustomReportUtil.getSearchString((JSONArray)filterDetails, (ArrayList)domainList, (Long)loginId, (AdventNetResourceBundle)rb);
                json.put("searchString", (Object)searchString);
                response.setContentType("application/json");
                PrintWriter out = response.getWriter();
                out.println(json.toString());
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

