/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.server.resultview.ColumnCustomizationHandler;
import com.adventnet.sym.adsm.common.server.resultview.IDataModel;
import com.adventnet.sym.adsm.common.server.resultview.SelectionTableModel;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportResultUtil {
    private static Logger reportLogger = Logger.getLogger(CustomReportResultUtil.class.getName());
    public static int CRV_COLUMN_LIMIT_SIZE = 5;
    public static String TABLE_KEY = "OBJECT_GUID";

    public static ArrayList getTabList(Integer reportId, AdventNetResourceBundle rb) {
        ArrayList tabList = new ArrayList();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMCRObjectMapping"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addJoin(new Join(Table.getTable((String)"ADSMCRObjectMapping"), Table.getTable((String)"ADMPObjects"), new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSMCRObjectMapping", (String)"REPORT_ID"), (Object)reportId, 0));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADMPObjects");
                while (it.hasNext()) {
                    Hashtable<String, Object> tabProp = new Hashtable<String, Object>();
                    Row r = (Row)it.next();
                    tabProp.put("TAB_ID", (Integer)r.get("OBJECT_ID"));
                    tabProp.put("TAB_NAME", rb.getString((String)r.get("OBJECT_DISP_NAME")));
                    tabProp.put("OBJECT_NAME", (String)r.get("OBJECT_NAME"));
                    tabProp.put("OBJECT_CLASS", (String)r.get("OBJECT_CLASS"));
                    tabList.add(tabProp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabList;
    }

    public static ArrayList getViewColumnIds(Long loginId, Integer reportId, Integer objectId) {
        ArrayList reportColumnList = new ArrayList();
        try {
            reportColumnList = ColumnCustomizationHandler.getReportColumnList((Integer)reportId, (Integer)objectId, (Long)loginId);
            if (reportColumnList.isEmpty()) {
                ArrayList<Integer> objectList = new ArrayList<Integer>();
                objectList.add(objectId);
                ArrayList uiMandatoryAttribList = ReportAttributesUtil.getUIMandatoryAttribs((Integer)new Integer(602), objectList);
                for (int counter = 0; counter < uiMandatoryAttribList.size() && counter < CRV_COLUMN_LIMIT_SIZE; ++counter) {
                    reportColumnList.add((Integer)uiMandatoryAttribList.get(counter));
                }
                ArrayList availableColumnList = CustomReportUtil.getAttributeIds((Integer)reportId, (Integer)objectId);
                for (int i = 0; reportColumnList.size() < CRV_COLUMN_LIMIT_SIZE && i < availableColumnList.size(); ++i) {
                    Integer attribId = (Integer)availableColumnList.get(i);
                    if (reportColumnList.contains(attribId)) continue;
                    reportColumnList.add(attribId);
                }
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                int priority = 0;
                for (int i = 0; i < reportColumnList.size(); ++i) {
                    Row row = new Row("ADSMViewReports");
                    row.set("REPORT_ID", (Object)reportId);
                    row.set("ATTRIB_ID", (Object)((Integer)reportColumnList.get(i)));
                    row.set("LOGIN_ID", (Object)loginId);
                    row.set("PRIORITY_ID", (Object)(++priority));
                    dataObj.addRow(row);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportColumnList;
    }

    public static JSONObject getViewColumns(Long loginId, Integer reportId, AdventNetResourceBundle rb) {
        JSONObject reportColumnList = new JSONObject();
        try {
            ArrayList objectList = CustomReportUtil.getObjectIds((Integer)reportId);
            for (int i = 0; i < objectList.size(); ++i) {
                Integer objectId = (Integer)objectList.get(i);
                ArrayList columnIds = CustomReportResultUtil.getViewColumnIds(loginId, reportId, objectId);
                reportColumnList.put(Integer.toString(objectId), (Object)CustomReportResultUtil.getViewColumns(columnIds, rb));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportColumnList;
    }

    public static JSONArray getViewColumns(ArrayList reportColumnList, AdventNetResourceBundle rb) {
        JSONArray columnList = new JSONArray();
        try {
            DataObject attributeDO = CommonUtil.getCachedPersistence().get("ADSMAttributeDetails", (Criteria)null);
            for (int i = 0; i < reportColumnList.size(); ++i) {
                Criteria colCrit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)((Integer)reportColumnList.get(i)), 0);
                Row r = attributeDO.getRow("ADSMAttributeDetails", colCrit);
                if (r == null) continue;
                JSONObject columnProp = new JSONObject();
                columnProp.put("ATTRIB_ID", (Object)((Integer)r.get("ATTRIB_ID")));
                columnProp.put("ATTRIB_COLUMN_NAME", (Object)((String)r.get("ATTRIB_COLUMN_NAME")));
                columnProp.put("ATTRIB_LDAP_NAME", (Object)((String)r.get("ATTRIB_LDAP_NAME")));
                columnProp.put("ATTRIB_DISP_NAME", (Object)rb.getString((String)r.get("ATTRIB_DISP_NAME")));
                columnProp.put("TABLE_NAME", (Object)((String)r.get("TABLE_NAME")));
                columnProp.put("RELATIONAL_TYPE", (Object)((Integer)r.get("RELATIONAL_TYPE")));
                columnProp.put("DATA_HANDLER_TYPE", (Object)((Long)r.get("DATA_HANDLER_TYPE")));
                columnProp.put("IS_SORT", (Object)((Boolean)r.get("IS_SORT")));
                columnProp.put("SHOW_SEARCH", (Object)((String)r.get("SHOW_SEARCH")));
                columnProp.put("TRANSFORMER_CLASS", (Object)((String)r.get("TRANSFORMER_CLASS")));
                columnProp.put("TRIM_SIZE", (Object)((Integer)r.get("TRIM_SIZE")));
                columnProp.put("HELP_TEXT", (Object)(r.get("HELP_TEXT") != null ? (String)r.get("HELP_TEXT") : ""));
                columnList.put((Object)columnProp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public static JSONObject getReportResultRows(Long loginId, Integer reportId, Long generationId, JSONObject reqParams) {
        JSONObject resultTable = new JSONObject();
        try {
            Integer objectId = (Integer)reqParams.get("tabId");
            JSONArray attributeList = reqParams.getJSONArray("columns");
            JSONObject pageNavigateData = reqParams.getJSONObject("pageNavigateData");
            ArrayList<Column> columnList = new ArrayList<Column>();
            Row reportDetails = ReportHandler.getReportDetailsRow((Integer)reportId);
            ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectId);
            String baseTableName = objectClass.getBaseTable();
            String resultTableName = (String)reportDetails.get("RESULT_TABLE_NAME");
            boolean isRelationTypeExists = false;
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add(baseTableName);
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProp = (JSONObject)attributeList.get(i);
                String tableName = (String)attributeProp.get("TABLE_NAME");
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    isRelationTypeExists = true;
                    continue;
                }
                Column column = new Column(tableName, (String)attributeProp.get("ATTRIB_COLUMN_NAME"));
                columnList.add(column);
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            ArrayList onClickTextAttributeList = CustomReportResultUtil.getOnClickTextAttributes(objectId);
            for (int i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                String columnName;
                Properties p = (Properties)onClickTextAttributeList.get(i);
                String table = p.getProperty("TABLE_NAME");
                Column column = new Column(table, columnName = p.getProperty("ATTRIB_COLUMN_NAME"));
                if (!columnList.contains(column)) {
                    columnList.add(column);
                }
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            Criteria crit = null;
            Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributeList, reqParams, tableNames);
            if (columnSearchCriteria != null) {
                crit = columnSearchCriteria;
            }
            SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, resultTableName, tableNames, TABLE_KEY);
            Integer count = DBUtil.getCount((SelectQuery)sq);
            resultTable.put("count", (Object)count);
            if (count != null && count != 0) {
                JSONObject sortAttributeProp;
                tableNames.remove(baseTableName);
                Integer sortAttributeId = reqParams.getInt("sortAttribId");
                if (sortAttributeId == null || sortAttributeId.equals(new Integer(-1))) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                }
                if ((sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList)) == null) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                    sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList);
                }
                resultTable.put("sortAttribId", (Object)((Integer)sortAttributeProp.get("ATTRIB_ID")));
                JSONObject multipleValuesSids = new JSONObject();
                JSONArray resultRows = ReportResultUtil.getResultRows(generationId, baseTableName, resultTableName, tableNames, columnList, attributeList, onClickTextAttributeList, crit, sortAttributeProp, reqParams.getBoolean("sortingOrder"), (Integer)pageNavigateData.get("startIndex"), (Integer)pageNavigateData.get("range"), multipleValuesSids, isRelationTypeExists, TABLE_KEY, reportId, loginId);
                ReportResultUtil.getMultipleValues(attributeList, multipleValuesSids, TABLE_KEY, null);
                resultTable.put("resultRows", (Object)resultRows);
                resultTable.put("multipleValuesSids", (Object)multipleValuesSids);
            } else {
                resultTable.put("resultRows", (Object)new JSONArray());
                resultTable.put("multipleValuesSids", (Object)new JSONObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultTable;
    }

    public static ArrayList getOnClickTextAttributes(Integer objectId) {
        ArrayList<Properties> onClickTextAttributeList = new ArrayList<Properties>();
        try {
            switch (Integer.valueOf(objectId)) {
                case 1: {
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(1145)));
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(1143)));
                    break;
                }
                case 2: {
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(2021)));
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(2022)));
                    break;
                }
                case 3: {
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(3016)));
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(3017)));
                    break;
                }
                case 4: {
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(10048)));
                    onClickTextAttributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.valueOf(10050)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return onClickTextAttributeList;
    }

    public static IDataModel getDataModel(Hashtable reqParams, JSONObject params, AdventNetResourceBundle rb) {
        IDataModel dataModel = null;
        try {
            Integer objectId = (Integer)reqParams.get("objectId");
            Integer reportId = (Integer)reqParams.get("reportId");
            Long generationId = (Long)reqParams.get("generationId");
            Long loginId = (Long)reqParams.get("loginId");
            JSONArray attributeList = CustomReportResultUtil.getViewColumns(CustomReportResultUtil.getViewColumnIds(loginId, reportId, objectId), rb);
            ArrayList<Column> columnList = new ArrayList<Column>();
            Row reportDetails = ReportHandler.getReportDetailsRow((Integer)reportId);
            ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectId);
            String baseTableName = objectClass.getBaseTable();
            String objClass = objectClass.getObjectClass();
            String resultTableName = (String)reportDetails.get("RESULT_TABLE_NAME");
            boolean isRelationTypeExists = false;
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add(baseTableName);
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProp = (JSONObject)attributeList.get(i);
                String tableName = (String)attributeProp.get("TABLE_NAME");
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    isRelationTypeExists = true;
                    continue;
                }
                Column column = new Column(tableName, (String)attributeProp.get("ATTRIB_COLUMN_NAME"));
                columnList.add(column);
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            Criteria crit = null;
            Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributeList, params, tableNames);
            if (columnSearchCriteria != null) {
                crit = columnSearchCriteria;
            }
            SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, resultTableName, tableNames, TABLE_KEY);
            Integer count = DBUtil.getCount((SelectQuery)sq);
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList resultRows = new ArrayList();
            if (count != null && count != 0) {
                JSONObject sortAttributeProp;
                tableNames.remove(baseTableName);
                Integer sortAttributeId = params.getInt("sortAttribId");
                if (sortAttributeId == null || sortAttributeId.equals(new Integer(-1))) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                }
                if ((sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList)) == null) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                    sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList);
                }
                resultRows = ReportResultUtil.getResultRows(generationId, baseTableName, resultTableName, tableNames, columnList, attributeList, new ArrayList(), crit, sortAttributeProp, params.getBoolean("sortingOrder"), 0, count, multipleValuesSids, isRelationTypeExists, TABLE_KEY, reportId, loginId, objClass);
                ReportResultUtil.getMultipleValues(attributeList, multipleValuesSids, TABLE_KEY, null, true);
            }
            dataModel = (IDataModel)Class.forName("com.adventnet.sym.adsm.common.webclient.resultview.RVTableModel").newInstance();
            SelectionTableModel tableDataModel = (SelectionTableModel)dataModel;
            ArrayList columns = (ArrayList)FcJSONUtility.JSONArrayToList((JSONArray)attributeList, (String)"map");
            tableDataModel.setTableData(resultRows);
            tableDataModel.setColumnList(columns);
            tableDataModel.setMulitpleValuesSids(multipleValuesSids);
            Hashtable<String, Object> details = new Hashtable<String, Object>();
            details.put("JOIN_TABLE_KEY", "OBJECT_GUID");
            details.put("SELECTABLE", 0);
            tableDataModel.setDetails(details);
            HashMap<String, String> uniqueColumnIdentityMap = new HashMap<String, String>();
            uniqueColumnIdentityMap.put("COLUMN_ID", "ATTRIB_ID");
            uniqueColumnIdentityMap.put("COLUMN_NAME", "ATTIB_DISP_NAME");
            tableDataModel.setUniqueColIdentityMap(uniqueColumnIdentityMap);
            tableDataModel.setTotalResultCount(new Long(count.intValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }
}

