/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExchangeUserList
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;
    private String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
    private int licensedCount;

    public ExchangeUserList() {
        if (this.noOfObjects == null) {
            this.noOfObjects = "100";
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            this.licensedCount = Integer.parseInt(this.noOfObjects);
        }
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            JSONObject custParams;
            if (reqParams.getSelectedObjectsView() == 2 || reqParams.getSelectedObjectsView() == 3) {
                this.initDataSourceForCSVView(rb, reqParams, dataObject);
                return;
            }
            Long loginId = reqParams.getLoginId();
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList headerColumnList = new ArrayList();
            String moduleName = RVHandler.getCustomViewModuleName((int)reqParams.getFilterId());
            Long cvId = ColumnConfiguration.getCVId((String)moduleName, (long)DelegationUtil.ADMIN_LOGIN_ID);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            String customParams = reqParams.getCustomParams();
            String domainName = "";
            if (customParams != null && customParams.length() > 0 && (custParams = new JSONObject(customParams)).has("adDomain")) {
                domainName = (String)custParams.get("adDomain");
            }
            String baseTableName = "ADSMMailBoxObjects";
            String joinTableName = "ADSMUserGeneralDetails";
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            Join join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            Integer sortColumnId = reqParams.getSortAttribId();
            String sortColumnName = "DISPLAY_NAME";
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            selectColumnList.add(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"));
            boolean relationalTypePresent = false;
            for (HashMap columnDetailMap : this.totalColumnList) {
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) {
                    relationalTypePresent = true;
                    continue;
                }
                String columnName = (String)columnDetailMap.get("COLUMN_NAME");
                columnDetailMap.put("SHOW_SEARCH", "true");
                columnDetailMap.put("ATTRIB_COLUMN_NAME", columnName);
                if (columnName.equals("FULL_NAME") || columnName.equals("DISPLAY_NAME")) {
                    selectColumnList.add(Column.getColumn((String)joinTableName, (String)columnName));
                } else {
                    selectColumnList.add(Column.getColumn((String)baseTableName, (String)columnName));
                }
                if (!((Integer)columnDetailMap.get("COLUMN_ID")).equals(sortColumnId)) continue;
                sortColumnName = columnName;
            }
            query.addSelectColumns(selectColumnList);
            query.addSortColumn(new SortColumn(joinTableName, sortColumnName, reqParams.isSortOrder()));
            Criteria domainCrit = null;
            String[] mbxRecipientTypes = new String[]{"128", "8388608", "549755813888"};
            Criteria crit1 = new Criteria(Column.getColumn((String)baseTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria crit2 = new Criteria(Column.getColumn((String)baseTableName, (String)"RECIPIENT_TYPE"), (Object)mbxRecipientTypes, 9);
            crit1 = crit1.and(crit2);
            Criteria ouCrit = null;
            if (ouList != null && !ouList.isEmpty()) {
                for (int i = 0; i < ouList.size(); ++i) {
                    String ouDN = (String)ouList.get(i);
                    Criteria crite = new Criteria(Column.getColumn((String)baseTableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11, false);
                    ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                }
                crit1 = crit1 != null ? crit1.and(ouCrit) : ouCrit;
            }
            domainCrit = domainCrit == null ? crit1 : domainCrit.or(crit1);
            JSONObject searchJsonObj = reqParams.getSearchStringJson();
            String matchingCriteria = reqParams.getMatchCriteria();
            Criteria searchCrit = null;
            if (searchJsonObj != null) {
                Iterator keys = searchJsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = searchJsonObj.getString(key);
                    Criteria crit = key.equals("FULL_NAME") || key.equals("DISPLAY_NAME") ? new Criteria(Column.getColumn((String)joinTableName, (String)key), (Object)value, 12) : new Criteria(Column.getColumn((String)baseTableName, (String)key), (Object)value, 12);
                    if (searchCrit == null) {
                        searchCrit = crit;
                        continue;
                    }
                    if (matchingCriteria.equalsIgnoreCase("OR")) {
                        searchCrit = searchCrit.or(crit);
                        continue;
                    }
                    if (!matchingCriteria.equalsIgnoreCase("AND")) continue;
                    searchCrit = searchCrit.and(crit);
                }
            }
            Criteria criteria = null;
            if (domainCrit != null) {
                criteria = domainCrit;
            }
            if (searchCrit != null) {
                criteria = criteria == null ? searchCrit : criteria.and(searchCrit);
            }
            if (reqParams.getSelectedObjectsView() == 1) {
                Criteria crit = null;
                if (reqParams.getCheckAll()) {
                    JSONArray deSelectedObjectIds = reqParams.getDeSelectedObjectIds();
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    crit = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    JSONArray selectedObjectIds = reqParams.getSelectedObjectIds();
                    String[] selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    crit = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"), (Object)selectedObjectIdsArr, 8);
                }
                criteria = criteria.and(crit);
            }
            query.setCriteria(criteria);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex() - reqParams.getFromIndex() + 1);
            query.setRange(range);
            if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
                int fromIndex = reqParams.getFromIndex();
                int toIndex = reqParams.getToIndex();
                if (fromIndex > this.licensedCount) {
                    fromIndex = 1;
                }
                if (toIndex > this.licensedCount) {
                    toIndex = this.licensedCount;
                }
                range = new Range(fromIndex, toIndex - fromIndex + 1);
                query.setRange(range);
            }
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<Object, Object>();
                HashMap inputValues = null;
                if (dataSet.getValue("OBJECT_GUID") != null) {
                    rowData.put("OBJECT_GUID", dataSet.getValue("OBJECT_GUID"));
                    if (relationalTypePresent) {
                        this.multipleValueSids.put(dataSet.getValue("OBJECT_GUID"), new Hashtable());
                    }
                }
                String homestore = "";
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer relationalType = (Integer)details.get("RELATIONAL_TYPE");
                    if (relationalType.equals(1)) continue;
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    if (transformerClassName != null && transformerClassName.length() > 0) {
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        HashMap<String, Integer> colDetails = new HashMap<String, Integer>();
                        colDetails.put("TRIM_SIZE", 2);
                        Object columnValue = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), colDetails, inputValues, false);
                        rowData.put(columnId, columnValue);
                        continue;
                    }
                    rowData.put(columnId, rb.getString((String)dataSet.getValue(columnName)));
                    homestore = rb.getString((String)dataSet.getValue(columnName));
                }
                rowData.put("ONCLICK_ACTION_SCRIPT", "AutoReplyHandler.checkBoxEvent(this)");
                this.tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            query.addJoin(join);
            query.setCriteria(criteria);
            int totalCount = DBUtil.getCount((SelectQuery)query);
            this.setTotalResultCount(Long.valueOf(totalCount));
            if (!this.noOfObjects.equalsIgnoreCase("unlimited") && totalCount > this.licensedCount) {
                this.setTotalResultCount(Long.valueOf(this.licensedCount));
            }
            this.getMultipleValues(rb, this.totalColumnList, "OBJECT_GUID", isForExport, isForScheduler);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSourceForCSVView(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            JSONObject searchJsonObj;
            Criteria userCreationCrit;
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long userCreationID = reqParams.getUserCreationId();
            JSONArray headerJsonArray = reqParams.getHeaderJsonArray();
            this.details.put("headerJsonArray", headerJsonArray);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("USER_INDEX");
            selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"));
            for (int i = 0; i < headerJsonArray.length(); ++i) {
                ArrayList l;
                String currentHeader = headerJsonArray.getString(i);
                Hashtable attributesdetails = null;
                if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else {
                    attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                }
                columns.add((String)attributesdetails.get("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)((String)attributesdetails.get("ATTRIB_COLUMN_NAME"))));
            }
            this.details.put("columnList", columns);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumns(selectColumnList);
            Criteria crit = userCreationCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0);
            if (reqParams.getSelectedObjectsView() == 3) {
                Criteria selectedObjectsViewCrit = null;
                if (reqParams.getCheckAll()) {
                    JSONArray deSelectedObjectIds = reqParams.getDeSelectedObjectIds();
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    selectedObjectsViewCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    JSONArray selectedObjectIds = reqParams.getSelectedObjectIds();
                    String[] selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    selectedObjectsViewCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)selectedObjectIdsArr, 8);
                }
                crit = crit.and(selectedObjectsViewCrit);
            }
            if ((searchJsonObj = reqParams.getSearchStringJson()) != null && searchJsonObj.has("csvSearchText")) {
                Criteria searchCrit = null;
                String value = searchJsonObj.getString("csvSearchText");
                for (int i = 1; i < columns.size(); ++i) {
                    String curColName = (String)columns.get(i);
                    Criteria c = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)curColName), (Object)value, 12);
                    searchCrit = searchCrit == null ? c : searchCrit.or(c);
                }
                crit = crit.and(searchCrit);
            }
            query.setCriteria(crit);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex() - reqParams.getFromIndex() + 1);
            query.setRange(range);
            if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
                int fromIndex = reqParams.getFromIndex();
                int toIndex = reqParams.getToIndex();
                if (fromIndex > this.licensedCount) {
                    fromIndex = 1;
                }
                if (toIndex > this.licensedCount) {
                    toIndex = this.licensedCount;
                }
                range = new Range(fromIndex, toIndex - fromIndex + 1);
                query.setRange(range);
            }
            query.addSortColumn(new SortColumn("ADSMAUNamingAttributes", "USER_INDEX", true));
            ArrayList tableData = new ArrayList();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<String, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<String, Object>();
                for (int index = 0; index < columns.size(); ++index) {
                    String columnName = (String)columns.get(index);
                    rowData.put(columnName, dataSet.getValue(columnName));
                }
                tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            query.setCriteria(crit);
            int totalCount = DBUtil.getCount((SelectQuery)query);
            this.setTotalResultCount(Long.valueOf(totalCount));
            if (!this.noOfObjects.equalsIgnoreCase("unlimited") && totalCount > this.licensedCount) {
                this.setTotalResultCount(Long.valueOf(this.licensedCount));
            }
            this.details.put("ONCLICK_ACTION_SCRIPT", "AutoReplyHandler.csvCheckBoxEvent(this)");
            this.details.put("uniqueId", reqParams.getFilterId());
            this.details.put("tableData", tableData);
            this.details.put("SHOW_IMAGE", false);
            this.details.put("SHOW_SEARCH", false);
            this.details.put("IS_ACTION_COLUMN", false);
            this.details.put("COLUMN_CUSTOM_ENABLE", false);
            this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_GUID");
            this.details.put("SELECTED_OBJECTS_VIEW", reqParams.getSelectedObjectsView());
            this.details.put("REMOVE_ALL_OBJ_SCRIPT", "AutoReplyHandler.clearSelectedObjects()");
            this.details.put("REMOVE_THIS_OBJ_SCRIPT", "AutoReplyHandler.addCurrentObjectForRemovalFromSelectedList(this)");
            this.details.put("SELECT_ALL_OBJ_SCRIPT", "AutoReplyHandler.selectAllObjectsInPage");
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    private void getMultipleValues(AdventNetResourceBundle rb, ArrayList totalColumnList, String tableKey, boolean isExport, boolean isForScheduler) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < totalColumnList.size(); ++i) {
                String tableName;
                HashMap columnDetailMap = (HashMap)totalColumnList.get(i);
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                if (relationalType.equals(0) || checkList.contains(tableName = (String)columnDetailMap.get("TABLE_NAME"))) continue;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                Object[] guids = new Object[this.multipleValueSids.size()];
                int j = 0;
                Enumeration e = this.multipleValueSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = null;
                crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Object s = r.get(tableKey);
                        ArrayList tableValues = ColumnConfiguration.getColumnListProperties((ArrayList)totalColumnList, (String)tableName);
                        Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("COLUMN_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("COLUMN_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
            HashMap inputValues = null;
            boolean flag = isExport || isForScheduler;
            Enumeration e = this.multipleValueSids.keys();
            while (e.hasMoreElements()) {
                inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_GUID", objectId);
                Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < totalColumnList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)totalColumnList.get(index);
                    String columnName = (String)attributeProperties.get("COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("COLUMN_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(1)) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    Object columnValue = uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, flag);
                    attributeIds.put(attributeId, columnValue.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("JOIN_TABLE_KEY", "OBJECT_GUID");
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 2);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_GUID");
        this.details.put("SELECTED_OBJECTS_VIEW", reqParams.getSelectedObjectsView());
        this.details.put("REMOVE_ALL_OBJ_SCRIPT", "AutoReplyHandler.clearSelectedObjects()");
        this.details.put("REMOVE_THIS_OBJ_SCRIPT", "AutoReplyHandler.addCurrentObjectForRemovalFromSelectedList(this)");
        this.details.put("SELECT_ALL_OBJ_SCRIPT", "AutoReplyHandler.selectAllObjectsInPage");
    }

    Criteria getUsageLocationCriteria(String value) {
        Criteria c = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMCountriesList"));
            query.addSelectColumn(Column.getColumn((String)"ADSMCountriesList", (String)"co"));
            query.addSelectColumn(Column.getColumn((String)"ADSMCountriesList", (String)"c"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMCountriesList", (String)"co"), (Object)value, 12);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMCountriesList", (String)"IS_USAGE_LOCATION"), (Object)true, 0));
            query.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMCountriesList");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String countryNameAbbr = (String)r.get("c");
                    Criteria curCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"USAGE_LOCATION"), (Object)countryNameAbbr, 0);
                    if (c != null) {
                        c = c.or(curCrit);
                        continue;
                    }
                    c = curCrit;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return c;
    }

    public int getserverid(Criteria criteria, String tableName, String columnName) {
        int id = 0;
        try {
            Persistence per1 = (Persistence)BeanUtil.lookup((String)"Persistence");
            DataObject d1 = per1.get(tableName, criteria);
            Iterator it1 = d1.getRows(tableName);
            if (it1.hasNext()) {
                Row r = (Row)it1.next();
                id = (Integer)r.get(columnName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return id;
    }

    public String getStringValue(Criteria criteria, String tableName, String columnName) {
        String name = "";
        try {
            Persistence per1 = (Persistence)BeanUtil.lookup((String)"Persistence");
            DataObject d1 = per1.get(tableName, criteria);
            Iterator it1 = d1.getRows(tableName);
            if (it1.hasNext()) {
                Row r = (Row)it1.next();
                name = (String)r.get(columnName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }
}

