/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.util.AdvancedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import com.adventnet.sym.adsm.common.webclient.util.URLUtil;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import org.json.JSONObject;

public class ViewScheduledTask
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long loginId = reqParams.getLoginId();
            ArrayList headerColumnList = new ArrayList();
            String moduleName = RVUtil.getCustomViewModuleName((int)reqParams.getRvId());
            Long cvId = ColumnConfiguration.getCVId((String)moduleName, (long)loginId);
            if (cvId == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)moduleName);
            }
            logger.log(Level.FINE, "CV ID for the rvid " + reqParams.getRvId() + " is " + cvId);
            this.setDetails(dataObject, reqParams);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            this.setUniqueId(reqParams.getFilterId());
            ArrayList totalColumnList = ColumnConfiguration.getTotalColumnList((long)cvId);
            String baseTableName = "ADSMScheduler";
            ArrayList<Column> selectColumns = new ArrayList<Column>();
            for (int index = 0; index < totalColumnList.size(); ++index) {
                String tableName;
                HashMap details = (HashMap)totalColumnList.get(index);
                String columnName = (String)details.get("COLUMN_NAME");
                if (columnName.equalsIgnoreCase("DOMAIN_NAME") || columnName.equalsIgnoreCase("EMAIL_Address") || columnName.equalsIgnoreCase("LOGIN_ID")) continue;
                baseTableName = tableName = (String)details.get("TABLE_NAME");
                selectColumns.add(Column.getColumn((String)tableName, (String)columnName));
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            if (moduleName.equalsIgnoreCase("VIEWADVSCHEDULER")) {
                query.addSortColumn(new SortColumn(baseTableName, "CREATED_TIME", false));
            } else if (reqParams.getSortAttribId() != 10001) {
                String sortColumnName = ColumnConfiguration.getColumnName((Integer)reqParams.getSortAttribId());
                query.addSortColumn(new SortColumn(baseTableName, sortColumnName, reqParams.isSortOrder()));
            } else {
                query.addSortColumn(new SortColumn(baseTableName, "SCHEDULE_ID", true));
            }
            selectColumns.add(Column.getColumn((String)baseTableName, (String)"SCHEDULER_NAME"));
            query.addSelectColumns(selectColumns);
            Criteria criteria = null;
            ArrayList outputFilters = reqParams.getOutputFilters();
            for (int index = 0; index < outputFilters.size(); ++index) {
                JSONObject json = (JSONObject)outputFilters.get(index);
                if (!json.has("Share")) continue;
                if (json.getString("Share").equalsIgnoreCase("Created By me")) {
                    criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"LOGIN_ID"), (Object)loginId, 0);
                    continue;
                }
                if (json.getString("Share").equalsIgnoreCase("Shared By me")) {
                    ArrayList sharedByMeSheduleList = SchedulerUtil.getSharedByMeScheduleList((Long)loginId);
                    Long[] sharedByMeSheduleArray = new Long[sharedByMeSheduleList.size()];
                    sharedByMeSheduleArray = sharedByMeSheduleList.toArray(sharedByMeSheduleArray);
                    criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"SCHEDULE_ID"), (Object)sharedByMeSheduleArray, 8);
                    continue;
                }
                if (!json.getString("Share").equalsIgnoreCase("Shared For me")) continue;
                ArrayList sharedForMeSheduleList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                Long[] sharedForMeSheduleArray = new Long[sharedForMeSheduleList.size()];
                sharedForMeSheduleArray = sharedForMeSheduleList.toArray(sharedForMeSheduleArray);
                criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"SCHEDULE_ID"), (Object)sharedForMeSheduleArray, 8);
            }
            Column col = Column.getColumn((String)baseTableName, (String)"LOGIN_ID");
            query.addSelectColumn(col);
            ArrayList sharedSheduleList = new ArrayList();
            Criteria loginIdCriteria = null;
            if (loginId == 1L) {
                loginIdCriteria = new Criteria(col, null, 1);
            } else {
                loginIdCriteria = new Criteria(col, (Object)loginId, 0);
                sharedSheduleList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                Long[] sharedSheduleArray = new Long[sharedSheduleList.size()];
                sharedSheduleArray = sharedSheduleList.toArray(sharedSheduleArray);
                loginIdCriteria = loginIdCriteria.or(new Criteria(Column.getColumn((String)baseTableName, (String)"SCHEDULE_ID"), (Object)sharedSheduleArray, 8));
            }
            criteria = criteria != null ? criteria.and(loginIdCriteria) : loginIdCriteria;
            query.setCriteria(criteria);
            Hashtable schedulerIdVsOwnersMap = SchedulerUtil.getSchedulerOwners((String)baseTableName, (String)"LOGIN_ID", (Criteria)criteria);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getRange());
            query.setRange(range);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Integer, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<Integer, Object>();
                HashMap<String, Object> inputValues = null;
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    Transformers uiTransformer;
                    String modifyScheduler;
                    Long schedulerId;
                    inputValues = new HashMap<String, Object>();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    String transformerClass = (String)details.get("");
                    ArrayList mailIdList = null;
                    ArrayList domains = new ArrayList();
                    if (columnName.equalsIgnoreCase("ACTION")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        Long createdBy = (Long)dataSet.getValue("LOGIN_ID");
                        modifyScheduler = "false";
                        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID) || loginId.equals(createdBy)) {
                            modifyScheduler = "true";
                        }
                        inputValues.put("schedulerOwner", createdBy);
                        inputValues.put("modifyScheduler", modifyScheduler);
                        inputValues.put("SchedulerName", dataSet.getValue("SCHEDULER_NAME"));
                        inputValues.put("Status", SchedulerUtil.getSchedulerStatus((String)dataSet.getValue("SCHEDULER_NAME").toString()));
                        inputValues.put("cvId", cvId);
                        inputValues.put("moduleName", moduleName);
                        inputValues.put("rvId", reqParams.getRvId());
                        inputValues.put("CREATED_BY", createdBy);
                        Transformers uiTransformer2 = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        Object columnValue = uiTransformer2.renderCell(rb, columnName, schedulerId, details, inputValues, false);
                        int rvId = reqParams.getRvId();
                        if (rvId == 12 || rvId == 22) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("value", columnValue.toString());
                            map.put("schedulerId", schedulerId);
                            map.put("automationId", schedulerId);
                            map.put("rvId", rvId);
                            map.put("schedulerName", dataSet.getValue("SCHEDULER_NAME"));
                            rowData.put(columnId, map);
                            continue;
                        }
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("EMAIL_Address")) {
                        mailIdList = MailServerUtil.getMailIds((Long)((Long)dataSet.getValue("SCHEDULE_ID")));
                        if (moduleName.equalsIgnoreCase("VIEWADVSCHEDULER")) {
                            mailIdList = AdvancedSchedulerUtil.getAdvancedSchedulerMailIds((Long)((Long)dataSet.getValue("ADMP_SCHEDULE_ID")));
                        }
                        uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        Object columnValue = uiTransformer.renderCell(rb, columnName, mailIdList, details, inputValues, false);
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
                        domains = SchedulerUtil.getSchedulerDomains((Long)((Long)dataSet.getValue("SCHEDULE_ID")));
                        if (moduleName.equalsIgnoreCase("VIEWADVSCHEDULER")) {
                            domains = CVCDataUtil.getCVCSelectedDomain((Long)((Long)dataSet.getValue("CVC_DATA_ID")));
                        }
                        uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        Object columnValue = uiTransformer.renderCell(rb, columnName, domains, details, inputValues, false);
                        rowData.put(columnId, columnValue.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("TIME")) {
                        String time = rb.getString((String)dataSet.getValue(columnName));
                        time = SchedulerInputsUtil.getTimeStringFromJson(time, rb);
                        int timeLen = time.length();
                        String dotString = "";
                        if (timeLen > 30) {
                            timeLen = 30;
                            dotString = "...";
                        }
                        StringBuilder htmlString = new StringBuilder();
                        htmlString.append("<span class=\"blacktxt\" alt=\"" + time + " \"title=\"" + time + "\">" + time.substring(0, timeLen) + dotString + "</span>");
                        rowData.put(columnId, htmlString.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("RUN_NOW")) {
                        StringBuilder htmlString = new StringBuilder();
                        String schedulerName = (String)dataSet.getValue("SCHEDULER_NAME");
                        String escapedName = ClientUtil.htmlEscape(ClientUtil.scriptEscape(schedulerName));
                        Long schedulerId2 = (Long)dataSet.getValue("SCHEDULE_ID");
                        SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstance();
                        String reportDir = runNowObj.getSchedulerStoragePath(loginId, schedulerId2);
                        String scheduleCurrStat = runNowObj.getSchedulerStatus(loginId, schedulerId2);
                        String loadingDivDisplay = "display:none;";
                        if (scheduleCurrStat.equalsIgnoreCase("PROCESSING")) {
                            loadingDivDisplay = "display:block;";
                        }
                        String statusMessage = "";
                        String href = "";
                        String displayStyle = "display:none;";
                        if (!reportDir.equals("") && reportDir != null) {
                            String[] pathArray = reportDir.split("audit-data");
                            String schedulerZipFileName = "admp-reports.zip";
                            if (pathArray.length > 1) {
                                reportDir = "audit-data" + pathArray[pathArray.length - 1] + File.separator + schedulerZipFileName;
                                reportDir = reportDir.replace("\\", "/");
                                URI uri = new URI(null, null, reportDir, null, null);
                                reportDir = uri.toString();
                            } else {
                                reportDir = "file:///" + pathArray[pathArray.length - 1] + File.separator + schedulerZipFileName;
                                reportDir = URLUtil.getURLEncodedPath(reportDir);
                            }
                            statusMessage = rb.getString("admp.reports.sche_reports.common.text.success");
                            href = reportDir;
                            displayStyle = "";
                        }
                        htmlString.append("<a class='greenlinktxt' href=\"javascript:SchedulerRunNowHandler.runNowScheduler('" + schedulerId2 + "','" + escapedName + "')\">" + rb.getString("admp.reports.schedule_reports.scheduler.run_now") + "</a> &nbsp; <span id=\"stat_" + schedulerId2 + "\" style='" + displayStyle + "'>" + statusMessage + "</span>&nbsp;<a class='greenlinktxt' download=\"admp-reports.zip\" target=\"_blank\" href=\"" + href + "\" id=\"link_" + schedulerId2 + "\" style='" + displayStyle + "'>" + rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.details") + "</a><div class='flRight' style='width:30;" + loadingDivDisplay + "' id=\"loadingDiv_" + schedulerId2 + "\"> <img src='../images/s_progressbar.gif' /></div>");
                        rowData.put(columnId, htmlString.toString());
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("LOGIN_ID")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        rowData.put(columnId, schedulerIdVsOwnersMap.get(schedulerId));
                        continue;
                    }
                    if (columnName.equalsIgnoreCase("SCHEDULER_NAME")) {
                        schedulerId = (Long)dataSet.getValue("SCHEDULE_ID");
                        Long createdBy = (Long)dataSet.getValue("LOGIN_ID");
                        modifyScheduler = "false";
                        String style = "cursor:not-allowed";
                        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID) || loginId.equals(createdBy)) {
                            modifyScheduler = "true";
                            style = "cursor:pointer";
                        }
                        String name = (String)dataSet.getValue(columnName);
                        String schedulerName = ClientUtil.htmlEscape(ClientUtil.scriptEscape(rb.getString(name)));
                        StringBuilder sb = new StringBuilder();
                        if (name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.ad_update_scheduler") || name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.daily_report_scheduler") || name.equalsIgnoreCase("admp.reports.sched_reports.sch_view.scheduler_name.significant_reports")) {
                            sb.append("<table width=\"100%\" height=\"25px\"><tr>");
                            sb.append("<td width=\"90%\"><div class=\"blacktxt\">" + rb.getString(name) + "</div></td>");
                            sb.append("<td></td></tr></table>");
                        } else {
                            sb.append("<table width=\"100%\" height=\"25px\"><tr>");
                            sb.append("<td width=\"90%\"><div class=\"blacktxt\">" + ClientUtil.htmlEscape(rb.getString(name)) + "</div></td>");
                            sb.append("</tr></table>");
                        }
                        rowData.put(columnId, sb.toString());
                        continue;
                    }
                    rowData.put(columnId, ClientUtil.htmlEscape(rb.getString((String)dataSet.getValue(columnName))));
                }
                this.tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"SCHEDULE_ID").count());
            query.setCriteria(criteria);
            this.setTotalResultCount((long)DBUtil.getCount((SelectQuery)query));
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams) throws Exception {
        Row viewConfigToMenuRow = dataObject.getRow(RVCConstants.RVTOMENUMAPPING_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVTOMENUMAPPING_TABLE, (String)RVCConstants.FILTER_ID), (Object)reqParams.getFilterId(), 0));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(RVCConstants.RVMENUDETAILS_TABLE, new Criteria(Column.getColumn((String)RVCConstants.RVMENUDETAILS_TABLE, (String)RVCConstants.RV_MENU_ID), (Object)((Integer)viewConfigToMenuRow.get(RVCConstants.RV_MENU_ID)), 0));
        if (dataObj != null) {
            Row viewToObjectTypeMapping = dataObj.getRow(RVCConstants.RVMENUDETAILS_TABLE);
            this.details.put("SHOW_IMAGE", (Boolean)viewToObjectTypeMapping.get("SHOW_OBJECT_IMAGE"));
            this.details.put("SHOW_SEARCH", (Boolean)viewToObjectTypeMapping.get("SHOW_SEARCH"));
            this.details.put("SELECTABLE", Integer.valueOf((Integer)viewToObjectTypeMapping.get("IS_SELECTABLE")));
            this.details.put("IS_ACTION_COLUMN", true);
            this.details.put("COLUMN_CUSTOM_ENABLE", (Boolean)viewToObjectTypeMapping.get("COLUMN_CUSTOM_ENABLE"));
            this.details.put("POPUP_TYPE_ID", 62L);
        }
        this.details.put("RELATIONALTYPE", false);
    }
}

