/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.resultview;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.GroupByColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.DataSource;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableDataSource;
import com.adventnet.sym.adsm.common.server.resultview.TableViewQueryHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class WAADUserList
implements DataSource,
TableDataSource {
    private List tableData = new ArrayList();
    private ArrayList totalColumnList = new ArrayList();
    private Long totalResultCount = 0L;
    private Hashtable multipleValueSids = new Hashtable();
    private Hashtable details = new Hashtable();
    private HashMap uniqueColumnIdentityMap = new HashMap();
    private int uniqueId;
    private String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
    private int licensedCount;
    private Join o365LicenseFilterJoin;
    private Criteria o365LicenseFilterCriteria;
    public static final Integer O365_CRT_USER_RV_ID = 226;
    public static final Integer O365_REMORDIS_USER_RV_ID = 228;
    public static final Integer O365_MAILDEL_USER_RV_ID = 230;
    public static final Integer O365_HIDE_USER_RV_ID = 232;
    public static final Integer O365_EMAILFRWD_USER_RV_ID = 234;
    public static final Integer O365_LIT_HOLD_RV_ID = 239;
    public static final Integer O365_PROXY_ADDRESSES_RV_ID = 241;
    public static final Integer O365_IN_PLACE_ARCHIVE_RV_ID = 243;
    public static final Integer O365_IAMAPP_ID = 3;

    public WAADUserList() {
        if (this.noOfObjects == null) {
            this.noOfObjects = "100";
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            this.licensedCount = Integer.parseInt(this.noOfObjects);
        }
    }

    public List getTableData() {
        return this.tableData;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public Hashtable getMulitpleValuesSids() {
        return this.multipleValueSids;
    }

    public ArrayList getColumnList() {
        return this.totalColumnList;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getUniqueColIdentityMap() {
        this.uniqueColumnIdentityMap.put("COLUMN_ID", "COLUMN_ID");
        this.uniqueColumnIdentityMap.put("COLUMN_NAME", "DISPLAY_NAME");
        return this.uniqueColumnIdentityMap;
    }

    public Hashtable getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSource(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject, boolean isForExport, boolean isForScheduler) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            Criteria isDeletedCrit;
            String[] selectedObjectIdsArr;
            JSONArray selectedObjectIds;
            boolean isOnTheFlyMgmt;
            if (reqParams.getSelectedObjectsView() == 2 || reqParams.getSelectedObjectsView() == 3) {
                this.initDataSourceForCSVView(rb, reqParams, dataObject);
                return;
            }
            String selectedWAADAccount = "";
            String[] mailboxTableColumn = new String[]{"MAIL_ALIAS", "HIDDEN_TO_ADDRESSLISTS", "FORWARD_TO", "DELIVER_AND_REDIRECT", "WARN_AT", "PROHIBIT_SEND_MESSAGES_AT", "PROHIBIT_SEND_REC_MESSAGES_AT"};
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList headerColumnList = new ArrayList();
            String moduleName = RVHandler.getCustomViewModuleName((int)reqParams.getFilterId());
            Long cvId = ColumnConfiguration.getCVId((String)moduleName, (long)DelegationUtil.ADMIN_LOGIN_ID);
            headerColumnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setTotalColumnList(headerColumnList);
            String objId = new String();
            String sortColumnName = "";
            String sortColumnTable = "";
            JSONObject domainOUdetJson = new JSONObject(reqParams.getCustomParams());
            String adDomain = null;
            boolean excludeChildOU = false;
            boolean useOUFilter = true;
            boolean applyOURestriction = reqParams.getApplyOURestriction();
            ArrayList delegatedO365Domains = reqParams.getDelegatedO365Domains();
            JSONArray selectedOUsJsonArray = null;
            JSONArray unSelectedOUsJsonArray = null;
            Hashtable<String, HashMap> columnNameVsColumnDetails = new Hashtable<String, HashMap>();
            JSONObject onTheFlyMgmtDetails = reqParams.getOnTheFlyMgmtDetails();
            boolean bl = isOnTheFlyMgmt = onTheFlyMgmtDetails.length() > 0;
            if (domainOUdetJson.has("adDomain")) {
                adDomain = domainOUdetJson.getString("adDomain");
                excludeChildOU = Boolean.parseBoolean(domainOUdetJson.getString("excludeChildOU"));
                selectedOUsJsonArray = domainOUdetJson.getJSONArray("selectedOUs");
                if (!excludeChildOU && domainOUdetJson.has("unSelectedOUs")) {
                    unSelectedOUsJsonArray = domainOUdetJson.getJSONArray("unSelectedOUs");
                }
            }
            String baseTableName = new String();
            Integer sortColumnId = reqParams.getSortAttribId();
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            if (this.getUniqueId() == O365_CRT_USER_RV_ID.intValue()) {
                baseTableName = "ADSMUserGeneralDetails";
                objId = "OBJECT_GUID";
            } else if (this.getUniqueId() == O365_REMORDIS_USER_RV_ID.intValue()) {
                baseTableName = "ADSMMailBoxObjects";
                objId = "OBJECT_GUID";
            } else {
                baseTableName = "O365UserGeneralDetails";
                selectedWAADAccount = domainOUdetJson.getString("waadAccountId");
                objId = "OBJECT_ID";
            }
            this.setDetails(dataObject, reqParams, objId);
            selectColumnList.add(Column.getColumn((String)baseTableName, (String)objId));
            boolean relationalTypePresent = false;
            for (HashMap columnDetailMap : this.totalColumnList) {
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) {
                    relationalTypePresent = true;
                    continue;
                }
                String columnName = (String)columnDetailMap.get("COLUMN_NAME");
                String tableName = (String)columnDetailMap.get("TABLE_NAME");
                columnDetailMap.put("SHOW_SEARCH", "true");
                columnDetailMap.put("ATTRIB_COLUMN_NAME", columnName);
                columnNameVsColumnDetails.put(columnName, columnDetailMap);
                selectColumnList.add(Column.getColumn((String)tableName, (String)columnName));
                if (!((Integer)columnDetailMap.get("COLUMN_ID")).equals(sortColumnId)) continue;
                sortColumnName = columnName;
                sortColumnTable = tableName;
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumns(selectColumnList);
            if (cvId == 213L) {
                query.addSortColumn(new SortColumn("O365UserExchangeDetails", "MAIL_ALIAS", reqParams.isSortOrder()));
            } else if (cvId == 220L) {
                query.addSortColumn(new SortColumn("ADSMMailBoxObjects", "LOGON_NAME", reqParams.isSortOrder()));
            } else {
                query.addSortColumn(new SortColumn(sortColumnTable, sortColumnName, reqParams.isSortOrder()));
            }
            Criteria domainCrit = null;
            Criteria joinCrit = null;
            Criteria splCaseJoinCrit = null;
            Criteria exchJoinCrit = null;
            int joinType = isOnTheFlyMgmt ? 1 : 2;
            String joinTableName = new String();
            if (baseTableName.equals("O365UserGeneralDetails")) {
                long waadDomainId = O365MgmtHandler.getWaadDomainId((String)selectedWAADAccount);
                domainCrit = O365DelegationUtil.getO365DelegatedDomainCrit((ArrayList)delegatedO365Domains, (Long)waadDomainId, (String)"user", (String)baseTableName);
                if (domainCrit == null) {
                    domainCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"WAAD_DOMAIN_ID"), (Object)waadDomainId, 0);
                }
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0));
                if (adDomain == null && !domainOUdetJson.has("domainList") && !applyOURestriction) {
                    useOUFilter = false;
                } else if (!isOnTheFlyMgmt) {
                    SelectQueryImpl q = new SelectQueryImpl(Table.getTable((String)"WAADADMapping"));
                    q.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"));
                    q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                    q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
                    q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                    q.addJoin(new Join("WAADADMapping", "ADSMWAADDomainConfiguration", new String[]{"WAAD_DOMAIN_ID"}, new String[]{"WAAD_DOMAIN_ID"}, 2));
                    q.addJoin(new Join("WAADADMapping", "ADSMAttributeDetails", new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                    Criteria attrCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)selectedWAADAccount, 0);
                    attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)O365_IAMAPP_ID, 0));
                    attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"), (Object)"user", 0));
                    q.setCriteria(attrCrit);
                    DataObject joinAttrDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)q);
                    String joinColumnName = new String();
                    if (!joinAttrDataObj.isEmpty()) {
                        Row r = joinAttrDataObj.getFirstRow("ADSMAttributeDetails");
                        joinTableName = (String)r.get("TABLE_NAME");
                        joinColumnName = (String)r.get("ATTRIB_COLUMN_NAME");
                    }
                    joinCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"IS_DELETED"), (Object)0, 1);
                    joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)Column.getColumn((String)joinTableName, (String)joinColumnName), 0));
                    if (joinTableName.equalsIgnoreCase("ADSMUserGeneralDetails")) {
                        joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0));
                    }
                    query.addJoin(new Join(baseTableName, joinTableName, joinCrit, 2));
                    if (!joinTableName.equalsIgnoreCase("ADSMUserGeneralDetails")) {
                        splCaseJoinCrit = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0);
                        splCaseJoinCrit = splCaseJoinCrit.and(new Criteria(Column.getColumn((String)joinTableName, (String)"OBJECT_GUID"), (Object)Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), 0));
                        query.addJoin(new Join(joinTableName, "ADSMUserGeneralDetails", splCaseJoinCrit, 2));
                    }
                    domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)"-", 1));
                    if (adDomain != null) {
                        domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)adDomain, 0));
                    } else if (domainOUdetJson.has("domainList")) {
                        ArrayList authOUList = reqParams.getAuthOUList();
                        JSONArray domainList = domainOUdetJson.getJSONArray("domainList");
                        Criteria crit = null;
                        for (int indx = 0; indx < domainList.length(); ++indx) {
                            String domain = domainList.getString(indx);
                            crit = crit == null ? new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)domain, 0) : crit.or(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)domain, 0));
                        }
                        if (crit != null) {
                            domainCrit = domainCrit.and(crit);
                        }
                        if (authOUList != null && authOUList.size() > 0) {
                            domainCrit = domainCrit.and(O365MgmtHandler.getAllOUSelectedCriteria((ArrayList)authOUList));
                        }
                        useOUFilter = false;
                    } else {
                        useOUFilter = false;
                    }
                }
            } else if (baseTableName.equals("ADSMMailBoxObjects")) {
                domainCrit = new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"DOMAIN_NAME"), (Object)adDomain, 0);
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"RECIPIENT_TYPE"), (Object)"2147483648", 0));
            } else {
                domainCrit = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)adDomain, 0);
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0));
            }
            if (this.getUniqueId() == O365_HIDE_USER_RV_ID.intValue() || this.getUniqueId() == O365_EMAILFRWD_USER_RV_ID.intValue() || this.getUniqueId() == O365_MAILDEL_USER_RV_ID.intValue()) {
                exchJoinCrit = O365MgmtHandler.getExchOnlineJoinCrit((String[])new String[]{"UserMailbox"}, null);
                exchJoinCrit = exchJoinCrit.and(new Criteria(Column.getColumn((String)"O365UserExchangeDetails", (String)"RECIPIENT_TYPE"), null, 1));
                query.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", exchJoinCrit, joinType));
            }
            if (useOUFilter || applyOURestriction) {
                ArrayList authOUList = reqParams.getAuthOUList();
                Criteria ouCrit = null;
                ouCrit = this.getUniqueId() == O365_REMORDIS_USER_RV_ID.intValue() ? O365MgmtHandler.getAuthentictedOUCriteriaMailObject((JSONArray)selectedOUsJsonArray, (JSONArray)unSelectedOUsJsonArray, (ArrayList)authOUList, (boolean)excludeChildOU) : O365MgmtHandler.getAuthentictedOUCriteria((JSONArray)selectedOUsJsonArray, (JSONArray)unSelectedOUsJsonArray, (ArrayList)authOUList, (boolean)excludeChildOU);
                if (ouCrit != null) {
                    domainCrit = domainCrit.and(ouCrit);
                }
            }
            JSONObject searchJsonObj = reqParams.getSearchStringJson();
            String matchingCriteria = reqParams.getMatchCriteria();
            Criteria searchCrit = null;
            if (searchJsonObj != null) {
                Iterator keys = searchJsonObj.keys();
                while (keys.hasNext()) {
                    Criteria usageLocationCrit;
                    String key = (String)keys.next();
                    String searchTableName = (String)((HashMap)columnNameVsColumnDetails.get(key)).get("TABLE_NAME");
                    String value = searchJsonObj.getString(key);
                    Criteria crit = new Criteria(Column.getColumn((String)searchTableName, (String)key), (Object)value, 12);
                    if (key.equals("USAGE_LOCATION") && (usageLocationCrit = this.getUsageLocationCriteria(value)) != null) {
                        crit = usageLocationCrit;
                    }
                    if (searchCrit == null) {
                        searchCrit = crit;
                        continue;
                    }
                    if (matchingCriteria.equalsIgnoreCase("OR")) {
                        searchCrit = searchCrit.or(crit);
                        continue;
                    }
                    if (!matchingCriteria.equalsIgnoreCase("AND")) continue;
                    searchCrit = searchCrit.and(crit);
                }
            }
            if (baseTableName.equals("O365UserGeneralDetails")) {
                this.getO365LicenseFilterJoinAndCriteria(reqParams);
            }
            if (this.o365LicenseFilterJoin != null) {
                query.addJoin(this.o365LicenseFilterJoin);
            }
            Criteria criteria = null;
            if (domainCrit != null) {
                criteria = domainCrit;
            }
            if (searchCrit != null) {
                criteria = criteria == null ? searchCrit : criteria.and(searchCrit);
            }
            if (this.o365LicenseFilterCriteria != null) {
                criteria = criteria == null ? this.o365LicenseFilterCriteria : criteria.and(this.o365LicenseFilterCriteria);
            }
            Criteria selectedObjectsCrit = null;
            if (reqParams.getSelectedObjectsView() == 1) {
                if (reqParams.getCheckAll()) {
                    JSONArray deSelectedObjectIds = reqParams.getDeSelectedObjectIds();
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    selectedObjectsCrit = new Criteria(Column.getColumn((String)baseTableName, (String)objId), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    selectedObjectIds = reqParams.getSelectedObjectIds();
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    selectedObjectsCrit = new Criteria(Column.getColumn((String)baseTableName, (String)objId), (Object)selectedObjectIdsArr, 8);
                }
                criteria = criteria.and(selectedObjectsCrit);
            }
            if (this.getUniqueId() == O365_LIT_HOLD_RV_ID.intValue() || this.getUniqueId() == O365_IN_PLACE_ARCHIVE_RV_ID.intValue()) {
                exchJoinCrit = O365MgmtHandler.getExchOnlineJoinCrit((String[])new String[]{"UserMailbox"}, null);
                exchJoinCrit = exchJoinCrit.and(new Criteria(Column.getColumn((String)"O365UserExchangeDetails", (String)"RECIPIENT_TYPE"), null, 1));
                query.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", exchJoinCrit, joinType));
                isDeletedCrit = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_DELETED"), (Object)0, 1);
                criteria = criteria.and(isDeletedCrit);
            }
            if (this.getUniqueId() == O365_PROXY_ADDRESSES_RV_ID.intValue()) {
                exchJoinCrit = O365MgmtHandler.getExchOnlineJoinCrit((String[])new String[]{"UserMailbox", "MailUser"}, null);
                exchJoinCrit = exchJoinCrit.and(new Criteria(Column.getColumn((String)"O365UserExchangeDetails", (String)"RECIPIENT_TYPE"), null, 1));
                query.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", exchJoinCrit, joinType));
                isDeletedCrit = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_DELETED"), (Object)0, 1);
                criteria = criteria.and(isDeletedCrit);
            }
            if (isOnTheFlyMgmt) {
                long waadDomainId;
                Criteria delegatedO365DomainCrit;
                if (onTheFlyMgmtDetails.getBoolean("checkAll")) {
                    long genid = onTheFlyMgmtDetails.getLong("generationID");
                    SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)"O365UserReportResult"));
                    subQuery.addSelectColumn(Column.getColumn((String)"O365UserReportResult", (String)"OBJECT_ID"));
                    Criteria subQueryCrit = new Criteria(Column.getColumn((String)"O365UserReportResult", (String)"REPORT_GENERATION_ID"), (Object)genid, 0);
                    subQuery.setCriteria(subQueryCrit);
                    DerivedColumn subQueryResCol = new DerivedColumn("O365UserReportResult", (SelectQuery)subQuery);
                    Criteria reportResultCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"), (Object)subQueryResCol, 8);
                    JSONArray deSelectedObjectIds = (JSONArray)onTheFlyMgmtDetails.get("deSelectedObjectIds");
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    Criteria deSelectedObjIdCrit = null;
                    if (deSelectedObjectIdsArr.length > 0) {
                        deSelectedObjIdCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"), (Object)deSelectedObjectIdsArr, 9);
                    }
                    criteria = deSelectedObjIdCrit != null ? reportResultCrit.and(deSelectedObjIdCrit) : reportResultCrit;
                } else {
                    Criteria selectedObjIdCrit;
                    selectedObjectIds = (JSONArray)onTheFlyMgmtDetails.get("selectedObjectIds");
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    criteria = selectedObjIdCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"), (Object)selectedObjectIdsArr, 8);
                }
                if (this.o365LicenseFilterCriteria != null) {
                    criteria = criteria == null ? this.o365LicenseFilterCriteria : criteria.and(this.o365LicenseFilterCriteria);
                }
                if (searchCrit != null) {
                    criteria = criteria.and(searchCrit);
                }
                int onTheFlyMgmtReportId = (Integer)onTheFlyMgmtDetails.get("onTheFlyMgmtReportId");
                long cvcDataId = onTheFlyMgmtDetails.getLong("cvcDataId");
                RVReqParams tempReqParams = new RVReqParams();
                tempReqParams.setCvcDataId(cvcDataId);
                tempReqParams.setReportId(onTheFlyMgmtReportId);
                Criteria waadInactiveUsersCrit = TableViewQueryHandler.getWaadInactiveUsersReportCrit((RVReqParams)tempReqParams);
                if (waadInactiveUsersCrit != null || applyOURestriction) {
                    Hashtable joinCrits;
                    if (waadInactiveUsersCrit != null) {
                        criteria = criteria.and(waadInactiveUsersCrit);
                    }
                    if ((joinCrits = WAADBulkMgmtUtil.getDirSyncJoinCrit(selectedWAADAccount)).containsKey("joinTableName")) {
                        joinTableName = (String)joinCrits.get("joinTableName");
                    }
                    if (joinCrits.containsKey("joinCrit") && joinTableName.length() > 0) {
                        joinCrit = (Criteria)joinCrits.get("joinCrit");
                        query.addJoin(new Join(baseTableName, joinTableName, joinCrit, 1));
                    }
                    if (joinCrits.containsKey("splCaseJoinCrit")) {
                        if (joinTableName.length() > 0) {
                            splCaseJoinCrit = (Criteria)joinCrits.get("splCaseJoinCrit");
                        }
                        query.addJoin(new Join(baseTableName, "ADSMUserGeneralDetails", splCaseJoinCrit, 1));
                    }
                    if (applyOURestriction) {
                        Criteria ouCrit = null;
                        ArrayList authOUList = reqParams.getAuthOUList();
                        ouCrit = O365MgmtHandler.getAuthentictedOUCriteria(null, null, (ArrayList)authOUList, (boolean)false, (String)"ADSMUserGeneralDetails");
                        if (ouCrit != null) {
                            criteria = criteria.and(ouCrit);
                        }
                    }
                }
                if (reqParams.getSelectedObjectsView() == 1) {
                    criteria = criteria.and(selectedObjectsCrit);
                }
                if ((delegatedO365DomainCrit = O365DelegationUtil.getO365DelegatedDomainCrit((ArrayList)delegatedO365Domains, (Long)(waadDomainId = O365MgmtHandler.getWaadDomainId((String)selectedWAADAccount)), (String)"user", (String)baseTableName)) != null) {
                    criteria = criteria.and(delegatedO365DomainCrit);
                }
            }
            query.setCriteria(criteria);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex() - reqParams.getFromIndex() + 1);
            query.setRange(range);
            if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
                int fromIndex = reqParams.getFromIndex();
                int toIndex = reqParams.getToIndex();
                if (fromIndex > this.licensedCount) {
                    fromIndex = 1;
                }
                if (toIndex > this.licensedCount) {
                    toIndex = this.licensedCount;
                }
                range = new Range(fromIndex, toIndex - fromIndex + 1);
                query.setRange(range);
            }
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<Object, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<Object, Object>();
                HashMap inputValues = null;
                if (dataSet.getValue(objId) != null) {
                    rowData.put(objId, dataSet.getValue(objId));
                    if (relationalTypePresent) {
                        this.multipleValueSids.put(dataSet.getValue(objId), new Hashtable());
                    }
                }
                for (int index = 0; index < headerColumnList.size(); ++index) {
                    inputValues = new HashMap();
                    HashMap details = (HashMap)headerColumnList.get(index);
                    Integer relationalType = (Integer)details.get("RELATIONAL_TYPE");
                    if (relationalType.equals(1)) continue;
                    Integer columnId = (Integer)details.get("COLUMN_ID");
                    String columnName = (String)details.get("COLUMN_NAME");
                    String transformerClassName = (String)details.get("TRANSFORMER_CLASS");
                    if (transformerClassName != null && transformerClassName.length() > 0) {
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        HashMap<String, Integer> colDetails = new HashMap<String, Integer>();
                        colDetails.put("TRIM_SIZE", 2);
                        Object columnValue = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), colDetails, inputValues, false);
                        rowData.put(columnId, columnValue);
                        continue;
                    }
                    if (dataSet.getValue(columnName) != null) {
                        rowData.put(columnId, rb.getString((String)dataSet.getValue(columnName)));
                        continue;
                    }
                    rowData.put(columnId, "-");
                }
                rowData.put("ONCLICK_ACTION_SCRIPT", "WAADMgmtHandler.checkBoxEvent(this)");
                this.tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            if (joinCrit != null) {
                query.addJoin(new Join(baseTableName, joinTableName, joinCrit, joinType));
                if (splCaseJoinCrit != null) {
                    query.addJoin(new Join(joinTableName, "ADSMUserGeneralDetails", splCaseJoinCrit, joinType));
                }
            }
            if (exchJoinCrit != null) {
                query.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", exchJoinCrit, joinType));
            }
            if (this.o365LicenseFilterJoin != null) {
                query.addJoin(this.o365LicenseFilterJoin);
            }
            query.setCriteria(criteria);
            int totalCount = DBUtil.getCount((SelectQuery)query);
            this.setTotalResultCount(Long.valueOf(totalCount));
            if (!this.noOfObjects.equalsIgnoreCase("unlimited") && totalCount > this.licensedCount) {
                this.setTotalResultCount(Long.valueOf(this.licensedCount));
            }
            this.getMultipleValues(rb, this.totalColumnList, objId, isForExport, isForScheduler);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDataSourceForCSVView(AdventNetResourceBundle rb, RVReqParams reqParams, DataObject dataObject) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            JSONObject searchJsonObj;
            Criteria userCreationCrit;
            this.setUniqueId(reqParams.getFilterId());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            Long userCreationID = reqParams.getUserCreationId();
            JSONArray headerJsonArray = reqParams.getHeaderJsonArray();
            this.details.put("headerJsonArray", headerJsonArray);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("USER_INDEX");
            selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"));
            for (int i = 0; i < headerJsonArray.length(); ++i) {
                ArrayList l;
                String currentHeader = headerJsonArray.getString(i);
                Hashtable attributesdetails = null;
                if (this.uniqueId == O365_CRT_USER_RV_ID || this.uniqueId == O365_REMORDIS_USER_RV_ID) {
                    if (currentHeader.equalsIgnoreCase("userPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("objectGuid")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1145"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("samAccountName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1006"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("distinguishedName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                    }
                } else if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17004"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17001"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else if (currentHeader.equalsIgnoreCase("EmailAddress")) {
                    l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17031"}, (String)"ATTRIB_ID", null);
                    attributesdetails = (Hashtable)l.get(0);
                } else {
                    attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                }
                columns.add((String)attributesdetails.get("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)((String)attributesdetails.get("ATTRIB_COLUMN_NAME"))));
            }
            this.details.put("columnList", columns);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumns(selectColumnList);
            Criteria crit = userCreationCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0);
            if (reqParams.getSelectedObjectsView() == 3) {
                Criteria selectedObjectsViewCrit = null;
                if (reqParams.getCheckAll()) {
                    JSONArray deSelectedObjectIds = reqParams.getDeSelectedObjectIds();
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    selectedObjectsViewCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    JSONArray selectedObjectIds = reqParams.getSelectedObjectIds();
                    String[] selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    selectedObjectsViewCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)selectedObjectIdsArr, 8);
                }
                crit = crit.and(selectedObjectsViewCrit);
            }
            if ((searchJsonObj = reqParams.getSearchStringJson()) != null && searchJsonObj.has("csvSearchText")) {
                Criteria searchCrit = null;
                String value = searchJsonObj.getString("csvSearchText");
                for (int i = 1; i < columns.size(); ++i) {
                    String curColName = (String)columns.get(i);
                    Criteria c = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)curColName), (Object)value, 12);
                    searchCrit = searchCrit == null ? c : searchCrit.or(c);
                }
                crit = crit.and(searchCrit);
            }
            query.setCriteria(crit);
            Range range = new Range(reqParams.getFromIndex(), reqParams.getToIndex() - reqParams.getFromIndex() + 1);
            query.setRange(range);
            if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
                int fromIndex = reqParams.getFromIndex();
                int toIndex = reqParams.getToIndex();
                if (fromIndex > this.licensedCount) {
                    fromIndex = 1;
                }
                if (toIndex > this.licensedCount) {
                    toIndex = this.licensedCount;
                }
                range = new Range(fromIndex, toIndex - fromIndex + 1);
                query.setRange(range);
            }
            query.addSortColumn(new SortColumn("ADSMAUNamingAttributes", "USER_INDEX", true));
            ArrayList tableData = new ArrayList();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            HashMap<String, Object> rowData = null;
            while (dataSet.next()) {
                rowData = new HashMap<String, Object>();
                for (int index = 0; index < columns.size(); ++index) {
                    String columnName = (String)columns.get(index);
                    rowData.put(columnName, dataSet.getValue(columnName));
                }
                tableData.add(rowData);
            }
            query = new SelectQueryImpl(Table.getTable((String)"ADSMAUNamingAttributes"));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            query.setCriteria(crit);
            int totalCount = DBUtil.getCount((SelectQuery)query);
            this.setTotalResultCount(Long.valueOf(totalCount));
            if (!this.noOfObjects.equalsIgnoreCase("unlimited") && totalCount > this.licensedCount) {
                this.setTotalResultCount(Long.valueOf(this.licensedCount));
            }
            this.details.put("ONCLICK_ACTION_SCRIPT", "WAADMgmtHandler.csvCheckBoxEvent(this)");
            this.details.put("uniqueId", reqParams.getFilterId());
            this.details.put("tableData", tableData);
            this.details.put("SHOW_IMAGE", false);
            this.details.put("SHOW_SEARCH", false);
            this.details.put("IS_ACTION_COLUMN", false);
            this.details.put("COLUMN_CUSTOM_ENABLE", false);
            this.details.put("UNIQUE_COLUMN_NAME", "OBJECT_ID");
            this.details.put("SELECTED_OBJECTS_VIEW", reqParams.getSelectedObjectsView());
            this.details.put("REMOVE_ALL_OBJ_SCRIPT", "WAADMgmtHandler.clearSelectedObjects()");
            this.details.put("REMOVE_THIS_OBJ_SCRIPT", "WAADMgmtHandler.addCurrentObjectForRemovalFromSelectedList(this)");
            this.details.put("SELECT_ALL_OBJ_SCRIPT", "WAADMgmtHandler.selectAllObjectsInPage");
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    private void getMultipleValues(AdventNetResourceBundle rb, ArrayList totalColumnList, String tableKey, boolean isExport, boolean isForScheduler) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < totalColumnList.size(); ++i) {
                String tableName;
                HashMap columnDetailMap = (HashMap)totalColumnList.get(i);
                Integer relationalType = (Integer)columnDetailMap.get("RELATIONAL_TYPE");
                if (relationalType.equals(0) || checkList.contains(tableName = (String)columnDetailMap.get("TABLE_NAME"))) continue;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                Object[] guids = new Object[this.multipleValueSids.size()];
                int j = 0;
                Enumeration e = this.multipleValueSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = null;
                crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Object s = r.get(tableKey);
                        ArrayList tableValues = ColumnConfiguration.getColumnListProperties((ArrayList)totalColumnList, (String)tableName);
                        Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("COLUMN_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("COLUMN_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
            HashMap inputValues = null;
            boolean flag = isExport || isForScheduler;
            Enumeration e = this.multipleValueSids.keys();
            while (e.hasMoreElements()) {
                inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_ID", objectId);
                Hashtable attributeIds = (Hashtable)this.multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < totalColumnList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)totalColumnList.get(index);
                    String columnName = (String)attributeProperties.get("COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("COLUMN_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(1)) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    Object columnValue = uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, flag);
                    attributeIds.put(attributeId, columnValue.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setTotalColumnList(ArrayList columnList) {
        this.totalColumnList = columnList;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    private void setDetails(DataObject dataObject, RVReqParams reqParams, String objId) throws Exception {
        this.details.put("uniqueId", reqParams.getFilterId());
        this.details.put("JOIN_TABLE_KEY", "OBJECT_ID");
        this.details.put("SHOW_IMAGE", false);
        this.details.put("SHOW_SEARCH", false);
        this.details.put("SELECTABLE", 2);
        this.details.put("IS_ACTION_COLUMN", false);
        this.details.put("COLUMN_CUSTOM_ENABLE", false);
        this.details.put("RELATIONALTYPE", false);
        this.details.put("UNIQUE_COLUMN_NAME", objId);
        this.details.put("SELECTED_OBJECTS_VIEW", reqParams.getSelectedObjectsView());
        this.details.put("REMOVE_ALL_OBJ_SCRIPT", "WAADMgmtHandler.clearSelectedObjects()");
        this.details.put("REMOVE_THIS_OBJ_SCRIPT", "WAADMgmtHandler.addCurrentObjectForRemovalFromSelectedList(this)");
        this.details.put("SELECT_ALL_OBJ_SCRIPT", "WAADMgmtHandler.selectAllObjectsInPage");
    }

    Criteria getUsageLocationCriteria(String value) {
        Criteria c = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMCountriesList"));
            query.addSelectColumn(Column.getColumn((String)"ADSMCountriesList", (String)"co"));
            query.addSelectColumn(Column.getColumn((String)"ADSMCountriesList", (String)"c"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMCountriesList", (String)"co"), (Object)value, 12);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMCountriesList", (String)"IS_USAGE_LOCATION"), (Object)true, 0));
            query.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMCountriesList");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String countryNameAbbr = (String)r.get("c");
                    Criteria curCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"USAGE_LOCATION"), (Object)countryNameAbbr, 0);
                    if (c != null) {
                        c = c.or(curCrit);
                        continue;
                    }
                    c = curCrit;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return c;
    }

    private void getO365LicenseFilterJoinAndCriteria(RVReqParams reqParams) {
        String baseTableName = "O365UserGeneralDetails";
        try {
            this.o365LicenseFilterJoin = null;
            this.o365LicenseFilterCriteria = null;
            JSONObject customParams = new JSONObject(reqParams.getCustomParams());
            String o365UserLicenseServiceMappingTableName = "O365UserLicenseServiceMapping";
            if (customParams.has("o365LicenseFilterType")) {
                String o365LicenseFilterType = customParams.getString("o365LicenseFilterType");
                if (o365LicenseFilterType.equals("any")) {
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_LICENSED"), (Object)"True", 0);
                } else if (o365LicenseFilterType.equals("none")) {
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_LICENSED"), (Object)"False", 0);
                } else if (o365LicenseFilterType.equals("custom")) {
                    Boolean isAllLicenses = customParams.get("customFilterType").equals("all");
                    if (isAllLicenses.booleanValue()) {
                        String o365UserTableName = "o365User";
                        String o365UserLicenseMappingTableName = "o365UserLicenseMapping";
                        SelectQueryImpl o365UserLMQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserLMQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserLMQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"));
                        o365UserLMQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserLMQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"));
                        SelectQueryImpl o365UserQuery = new SelectQueryImpl((Table)new DerivedTable(o365UserLicenseMappingTableName, (Query)o365UserLMQuery));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"OBJECT_ID"));
                        Criteria cri = null;
                        JSONArray selectedLicenses = customParams.getJSONArray("licenses");
                        for (int k = 0; k < selectedLicenses.length(); ++k) {
                            cri = cri == null ? new Criteria(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0) : cri.or(new Criteria(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0));
                        }
                        o365UserQuery.setCriteria(cri);
                        Column col = Column.getColumn(null, (String)"*").count();
                        GroupByColumn gc1 = new GroupByColumn(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"OBJECT_ID"), true);
                        ArrayList<GroupByColumn> gcl = new ArrayList<GroupByColumn>();
                        gcl.add(gc1);
                        GroupByClause gbc = new GroupByClause(gcl, new Criteria(col, (Object)selectedLicenses.length(), 4));
                        o365UserQuery.setGroupByClause(gbc);
                        this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                    } else {
                        String o365UserTableName = "o365User";
                        String o365UserLicenseMappingTableName = "o365UserLicenseMapping";
                        SelectQueryImpl o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        Criteria cri = null;
                        JSONArray selectedLicenses = customParams.getJSONArray("licenses");
                        for (int k = 0; k < selectedLicenses.length(); ++k) {
                            cri = cri == null ? new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0) : cri.or(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0));
                        }
                        o365UserQuery.setCriteria(cri);
                        this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                    }
                } else if (o365LicenseFilterType.equals("advanced")) {
                    Criteria cri;
                    String ser;
                    String lic;
                    int k;
                    Criteria cr;
                    JSONArray o365alfSelected = customParams.getJSONArray("o365alfSelected");
                    SelectQueryImpl o365UserQuery = null;
                    String o365UserTableName = "o365User";
                    if (customParams.getString("advancedFilterType").equals("any")) {
                        o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        cr = null;
                        for (k = 0; k < o365alfSelected.length(); ++k) {
                            lic = o365alfSelected.getJSONObject(k).getString("license_id");
                            ser = o365alfSelected.getJSONObject(k).getString("service_id");
                            cri = new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)lic, 0);
                            cri = cri.and(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"SERVICES"), (Object)ser, 0));
                            cr = cr == null ? cri : cr.or(cri);
                        }
                        if (cr != null) {
                            o365UserQuery.setCriteria(cr);
                        }
                    }
                    if (customParams.getString("advancedFilterType").equals("all")) {
                        o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        cr = null;
                        for (k = 0; k < o365alfSelected.length(); ++k) {
                            lic = o365alfSelected.getJSONObject(k).getString("license_id");
                            ser = o365alfSelected.getJSONObject(k).getString("service_id");
                            cri = new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)lic, 0);
                            cri = cri.and(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"SERVICES"), (Object)ser, 0));
                            cr = cr == null ? cri : cr.or(cri);
                        }
                        if (cr != null) {
                            o365UserQuery.setCriteria(cr);
                        }
                        Column col = Column.getColumn(null, (String)"*").count();
                        GroupByColumn gc1 = new GroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"), true);
                        ArrayList<GroupByColumn> gcl = new ArrayList<GroupByColumn>();
                        gcl.add(gc1);
                        GroupByClause gbc = new GroupByClause(gcl, new Criteria(col, (Object)o365alfSelected.length(), 4));
                        o365UserQuery.setGroupByClause(gbc);
                    }
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.o365LicenseFilterJoin = null;
            this.o365LicenseFilterCriteria = null;
        }
    }
}

