/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.statusupdater;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportStatusUpdater
implements StatusUpdater {
    private boolean isCompleted;
    private ArrayList guidList = null;
    ArrayList rowList = null;
    private int currentTaskCode;
    private String currentObjectName = null;
    private JSONObject multiDCDetails = new JSONObject();
    private Long loginId = 1L;
    private ArrayList<Hashtable> errorList = null;

    public ReportStatusUpdater() {
        this.guidList = new ArrayList();
        this.errorList = new ArrayList();
    }

    public void init(DataObject rvcDataObject, Long cvcDataId) {
    }

    public void init(Hashtable reportDomains) {
        JSONObject domainNameVsDCProps = null;
        Enumeration e = reportDomains.keys();
        while (e.hasMoreElements()) {
            try {
                domainNameVsDCProps = new JSONObject();
                String domainName = (String)e.nextElement();
                ReportDomain reportDomain = (ReportDomain)reportDomains.get(domainName);
                ArrayList dcList = reportDomain.getDCList();
                JSONObject dcProperies = null;
                for (int j = 0; j < dcList.size(); ++j) {
                    dcProperies = new JSONObject();
                    Hashtable hash = (Hashtable)dcList.get(j);
                    Integer status = (Integer)hash.get("status");
                    String dcName = (String)hash.get("dcName");
                    dcProperies.put("count", 0);
                    dcProperies.put("status", (Object)status);
                    dcProperies.put("image", (Object)"domain_icon.gif");
                    domainNameVsDCProps.put(dcName, (Object)dcProperies);
                }
                this.multiDCDetails.put(domainName, (Object)domainNameVsDCProps);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateStatus(Properties prop, String objClass, String guid) {
        if (!this.guidList.contains(guid)) {
            if (this.rowList == null) {
                this.rowList = new ArrayList();
            }
            if (this.rowList.size() < 25) {
                this.rowList.add(prop);
            }
            this.guidList.add(guid);
        }
    }

    public void updateStatus(JSONArray jsonArray, String domainName) {
        try {
            if (this.multiDCDetails.has(domainName)) {
                this.multiDCDetails.put(domainName, (Object)jsonArray);
            } else {
                this.multiDCDetails.put(domainName, (Object)new JSONArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateErrorStatus(Hashtable errors) {
        this.errorList.add(errors);
    }

    public void setIsCompleted(boolean flag) {
        this.isCompleted = flag;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public JSONObject getJSONObject(JSONObject reqJsonObject, AdventNetResourceBundle rb) {
        JSONObject statusJson = this.getCommonJSONObject(rb);
        try {
            Integer viewType = reqJsonObject.getInt("viewType");
            if (viewType == 1) {
                JSONArray attributeList = (JSONArray)reqJsonObject.get("attributeList");
                statusJson.put("rowData", (Object)this.getRowDetails(attributeList, rb));
            } else if (viewType == 2) {
                statusJson.put("dcDetails", (Object)this.multiDCDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return statusJson;
    }

    public ArrayList getCriterias() {
        return null;
    }

    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return rb.getString("admp.report.adv_grp_members.stat_msg.selected_groups_empty");
    }

    public int getCurrentTaskCode() {
        return this.currentTaskCode;
    }

    public void setProgressTask(int taskCode) {
        this.currentTaskCode = taskCode;
    }

    public ArrayList<Hashtable> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(ArrayList<Hashtable> errorList) {
        this.errorList = errorList;
    }

    public void setTaskObject(Object obj) {
        this.currentObjectName = (String)obj;
    }

    public void setMultiDCDetails(JSONObject multiDCDetails) {
        this.multiDCDetails = multiDCDetails;
    }

    private JSONObject getCommonJSONObject(AdventNetResourceBundle rb) {
        JSONObject jsonObject = new JSONObject();
        Long date = new Long(System.currentTimeMillis());
        Long loginId = 1L;
        try {
            jsonObject.put("errorCount", this.errorList.size());
            jsonObject.put("isCompleted", this.isCompleted);
            jsonObject.put("count", this.guidList.size());
            jsonObject.put("isErrorOccurred", !this.errorList.isEmpty());
            jsonObject.put("statusMessage", (Object)this.getCurrentStatusMessage(rb));
            if (this.isCompleted) {
                String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(date));
                jsonObject.put("generatedTime", (Object)genTime);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }

    private String getCurrentStatusMessage(AdventNetResourceBundle rb) {
        String message = rb.getString("reports.final_report_page.generating_reports");
        String commonMessage = "reports.final_report_page.generating_reports";
        if (this.guidList.size() > 1) {
            message = rb.getString("admp.reports.common.text.generating_reports");
        }
        if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_GROUP_MEMBERS.getValue()) {
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString("admp.reports.adv_group_members.status.fetching_members_of"), this.currentObjectName) : rb.getString("admp.reports.adv_group_members.status.fetching_members");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue()) {
            message = rb.getString("reports.final_report_page.generating_reports");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_USERS_MEMBEROF.getValue()) {
            message = "admp.reports.status.text.fetching_memberof_users";
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString(message), this.currentObjectName) : rb.getString(commonMessage);
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_OS_DETAILS.getValue()) {
            message = "admp.reports.status.text.fetching_osdetails";
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString(message), this.currentObjectName) : rb.getString(commonMessage);
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCTING_MANAGER_USERS.getValue()) {
            message = "admp.reports.status.text.fetching_user_details_from_manager";
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString(message), this.currentObjectName) : rb.getString(commonMessage);
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_OBJECTS_AND_PERMISSION_FOR_USERS.getValue()) {
            message = "admp.reports.status.text.fetching_object_and_permissions_for_user";
            message = this.currentObjectName != null ? MessageFormat.format(rb.getString(message), this.currentObjectName) : rb.getString(commonMessage);
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue()) {
            message = rb.getString("admp.reports.common.stat_msg.process_interrupted_loading_fetched_data");
        }
        return message;
    }

    private JSONArray getRowDetails(JSONArray filterIdAttributeList, AdventNetResourceBundle rb) {
        JSONArray rowDetails = new JSONArray();
        JSONArray row = null;
        try {
            for (int index = 0; this.rowList != null && index < this.rowList.size(); ++index) {
                row = new JSONArray();
                Properties prop = (Properties)this.rowList.get(index);
                for (int innerIndex = 0; innerIndex < filterIdAttributeList.length(); ++innerIndex) {
                    Integer attribId = (Integer)filterIdAttributeList.get(innerIndex);
                    String attribValue = (String)prop.get(attribId);
                    if (attribValue == null || attribValue.trim().equalsIgnoreCase("")) {
                        row.put((Object)"-");
                        continue;
                    }
                    attribValue = ListenerUtil.getDynamicUpdateValues(attribId, attribValue);
                    row.put((Object)ClientUtil.htmlEscape(rb.getString(attribValue)));
                }
                rowDetails.put((Object)row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    public JSONObject getMultiDCDetails() {
        return this.multiDCDetails;
    }

    public Hashtable getTaskErrors(AdventNetResourceBundle rb) {
        return null;
    }

    public void setTaskError(Object message) {
    }

    public void init(DataObject rvcDataObject) {
    }
}

