/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.transformers;

import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;

public class MultipleValueTransformer
implements Transformers {
    @Override
    public Object renderCell(AdventNetResourceBundle rb, String columnName, Object value, HashMap attributeProperties, HashMap inputValues, boolean isExport) {
        StringBuilder tdCellValue = new StringBuilder("<span class=\"blacktxt1\" ");
        if (isExport) {
            tdCellValue = new StringBuilder();
        }
        String tableName = (String)attributeProperties.get("TABLE_NAME");
        String objectGuid = (String)inputValues.get("OBJECT_GUID");
        boolean isCMA = tableName.toUpperCase().startsWith("CMA");
        if (objectGuid == null) {
            objectGuid = (String)inputValues.get("OBJECT_ID");
        }
        if (columnName.equalsIgnoreCase("MEMBER_OF") || columnName.equalsIgnoreCase("GROUP_MEMBEROF_OBJECTGUID") || columnName.equalsIgnoreCase("MEMBERS") || columnName.equalsIgnoreCase("DISPLAY_MEMBERS") || columnName.equalsIgnoreCase("GROUP_MEMBER_OBJECTGUID") || columnName.equalsIgnoreCase("MEMBEROF_LOCATION") || columnName.equalsIgnoreCase("GPO_LINK_OBJECT") || columnName.equalsIgnoreCase("REJECT_MESSAGES_FROM") || columnName.equalsIgnoreCase("ACCEPT_MESSAGES_FROM") || columnName.equalsIgnoreCase("SEND_ON_BEHALF") || columnName.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES") || columnName.equalsIgnoreCase("PROXY_ADDRESSES") || columnName.equalsIgnoreCase("SEND_AS") || columnName.equalsIgnoreCase("FULL_PERMISSION") || isCMA) {
            ArrayList valuesList = (ArrayList)value;
            if (valuesList != null && !valuesList.isEmpty()) {
                int trimSize = 1;
                if (attributeProperties.get("TRIM_SIZE") != null) {
                    trimSize = (Integer)attributeProperties.get("TRIM_SIZE");
                }
                if (!isExport) {
                    if (valuesList.size() > trimSize) {
                        tdCellValue.append(">");
                        String moreToolTipText = rb.getString("admp.report.common.text.view_full_list");
                        tdCellValue.append(ClientUtil.getTrimedString((String)valuesList.get(0), RVCConstants.RVC_MEMBER_OF_VALUE_TRIM_SIZE));
                        tdCellValue.append("<a class=\"greenlinktxt\" href=\"javascript:void(0)\" alt=\"" + moreToolTipText + "\" title=\"" + moreToolTipText + "\" onclick=\"showMore('" + objectGuid + "','" + columnName + "','" + tableName + "')\">");
                        tdCellValue.append("more...(" + valuesList.size() + ")");
                        tdCellValue.append("</a>");
                    } else {
                        String resultString = ClientUtil.getSemicolonSepString(valuesList);
                        String finalString = ClientUtil.htmlEscape(ClientUtil.getTrimedString(resultString, RVCConstants.RVC_MEMBER_OF_VALUE_TRIM_SIZE));
                        tdCellValue.append("alt=\"" + ClientUtil.htmlEscape(resultString) + "\" title=\"" + ClientUtil.htmlEscape(resultString) + "\"> ");
                        tdCellValue.append(finalString);
                    }
                } else {
                    tdCellValue.append(ClientUtil.getSemicolonSepString(valuesList));
                }
            } else if (!isExport) {
                tdCellValue.append(">-</span>");
            } else {
                tdCellValue.append("-");
            }
            if (!isExport) {
                tdCellValue.append("</span>");
            }
        } else if (columnName.equalsIgnoreCase("EMAIL_Address") || columnName.equalsIgnoreCase("DOMAIN_NAME")) {
            if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
                ArrayList domainList = (ArrayList)value;
                tdCellValue.append(">");
                if (domainList.isEmpty()) {
                    tdCellValue.append(rb.getString("admp.reports.schedule_reports.scheduler.all_domains"));
                } else {
                    for (int index = 0; index < domainList.size(); ++index) {
                        String domainName = (String)domainList.get(index);
                        if (index != 0) {
                            tdCellValue.append(", ");
                        }
                        tdCellValue.append(domainName);
                    }
                }
                tdCellValue.append("</span>");
            } else {
                ArrayList notificationIds = (ArrayList)value;
                if (notificationIds.size() < 2) {
                    tdCellValue.append(">");
                    for (int k = 0; k < notificationIds.size(); ++k) {
                        String mail_id = (String)notificationIds.get(k);
                        if (k != 0) {
                            tdCellValue.append(", ");
                        }
                        tdCellValue.append(mail_id);
                    }
                } else {
                    tdCellValue.append(" alt=\"" + StrUtil.getString((ArrayList)notificationIds).toString() + "\" title=\"" + StrUtil.getString((ArrayList)notificationIds).toString() + "\">");
                    tdCellValue.append(notificationIds.get(0) + "...");
                }
            }
        } else if (columnName.equalsIgnoreCase("LICENSES") || columnName.equalsIgnoreCase("SERVICES")) {
            ArrayList valuesList = (ArrayList)value;
            objectGuid = (String)inputValues.get("OBJECT_ID");
            if (valuesList != null && !valuesList.isEmpty()) {
                if (columnName.equalsIgnoreCase("LICENSES")) {
                    LinkedHashSet s = new LinkedHashSet(valuesList);
                    valuesList.clear();
                    valuesList.addAll(s);
                }
                O365MgmtHandler.getUserFriendlyValues((ArrayList)valuesList, (String)columnName, (AdventNetResourceBundle)rb);
                if (!isExport) {
                    if (valuesList.size() == 1) {
                        tdCellValue.append(" alt=\"" + StrUtil.getString((ArrayList)valuesList).toString() + "\" title=\"" + StrUtil.getString((ArrayList)valuesList).toString() + "\">");
                        tdCellValue.append(StrUtil.getString((ArrayList)valuesList).toString());
                        tdCellValue.append("</span>");
                    } else {
                        tdCellValue.append(">");
                        String moreToolTipText = rb.getString("admp.report.common.text.view_full_list");
                        tdCellValue.append(ClientUtil.getTrimedString((String)valuesList.get(0), RVCConstants.RVC_MEMBER_OF_VALUE_TRIM_SIZE));
                        tdCellValue.append("<a id=\"more_" + columnName + "_" + objectGuid + "\" class=\"greenlinktxt\" href=\"javascript:void(0)\" alt=\"" + moreToolTipText + "\" title=\"" + moreToolTipText + "\" onclick=\"showDetailedServices('" + objectGuid + "','" + columnName + "','" + tableName + "')\">");
                        tdCellValue.append(rb.getString("admp.reports.common.text.more") + "...(" + valuesList.size() + ")");
                        tdCellValue.append("</a>");
                    }
                } else {
                    tdCellValue.append(ClientUtil.getSemicolonSepString(valuesList));
                }
            } else if (!isExport) {
                tdCellValue.append(">-</span>");
            } else {
                tdCellValue.append("-");
            }
        } else if (columnName.equalsIgnoreCase("OBJECT_PROPERTIES")) {
            tdCellValue = new StringBuilder();
            String taskId = (String)inputValues.get("DELAYED_TASK_ID");
            if (!isExport) {
                tdCellValue.append("<a id=\"show_prop" + taskId + "\" class='greenlinktxt' onclick=\"javascript:showDetails('" + taskId + "')\" href=\"javascript:void(0)\"" + ">" + rb.getString("admp.deleg.hdt_deleg.hdt_reports.view_properties") + "</a>");
            } else {
                String objProps = value.toString();
                tdCellValue.append(objProps);
            }
        }
        return tdCellValue.toString();
    }
}

