/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ApplyTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AddUserClientUtil {
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String[] ids = new String[]{"80070005", "8007052e", "80071392", "License", "80070775", "80070035", "80072037", "80072035", "8007200b", "8007001f", "800708c5", "80072030"};
    private static String[] errorMessages = new String[]{"client.DomainAction.access_is_denied", "client.usrmgmt.AddUserClientUtil.Suppliedcredentialisinvalid", "client.usrmgmt.AddUserClientUtil.Theobjectalreadyexists", "jsp.tab_component.license", "client.usrmgmt.AddUserClientUtil.Thereferencedaccountiscurrentlylockedoutandmaynotbeloggedonto", "client.usrmgmt.AddUserClientUtil.Thenetworkpathnotfound", "client.usrmgmt.AddUserClientUtil.Thereisanamingviolation", "client.usrmgmt.AddUserClientUtil.Theserverisunwillingtoprocesstherequest", "client.usrmgmt.AddUserClientUtil.Theattributesyntaxspecifiedtothedirectoryserviceisinvalid", "client.usrmgmt.AddUserClientUtil.Adeviceattachedtothesystemisnotfunctioning", "client.usrmgmt.AddUserClientUtil.ThepassworddoesnotmeetthepasswordpolicyrequirementsChecktheminimumpasswordlengthpasswordcomplexityandpasswordhistoryrequirements", "client.usrmgmt.AddUserClientUtil.Thereisnosuchobjectontheserver"};

    public static Integer getIntegerValue(String attribute, String value) {
        Integer integer = 0;
        try {
            if (attribute.equalsIgnoreCase("ACCOUNT_STATUS")) {
                integer = 512;
            }
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return integer;
        }
    }

    public static Long getLongValue(String value) {
        Long long1 = 0L;
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return long1;
        }
    }

    public static Boolean getBooleanValue(String value) {
        Boolean boolean1 = false;
        try {
            if (!value.equals("1")) {
                return Boolean.valueOf(value);
            }
            boolean1 = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return boolean1;
    }

    public static void initComboValues(HttpServletRequest request, UserBean userBean) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String[] ldapNameArray = new String[]{"TITLE", "COMPANY", "DEPARTMENT", "OFFICE"};
            String[] attribNameArray = new String[]{"TITLE", "COMPANY", "DEPT", "OFFICE"};
            String[] attribListNameArray = new String[]{"titleList", "companyList", "deptList", "officesList"};
            for (int i = 0; i < ldapNameArray.length; ++i) {
                AddUserClientUtil.setOrgAttribList(userBean, ldapNameArray[i], attribNameArray[i], attribListNameArray[i], rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        userBean.set("homeDriveList", UserMgmtUtil.homeDriveList);
        userBean.set("tsHomeDriveList", UserMgmtUtil.homeDriveList);
        userBean.set("disconnectionValues", UserMgmtUtil.sessionValuesList);
        ArrayList<String> sessionLabels = new ArrayList<String>();
        for (int i = 0; i < UserMgmtUtil.sessionLabelList.size(); ++i) {
            sessionLabels.add(i, rb.getString((String)UserMgmtUtil.sessionLabelList.get(i)));
        }
        userBean.set("disconnectionLabel", sessionLabels);
        userBean.set("activeSessionValues", UserMgmtUtil.sessionValuesList);
        userBean.set("activeSessionLabel", sessionLabels);
        userBean.set("idleSessionValues", UserMgmtUtil.sessionValuesList);
        userBean.set("idleSessionLabel", sessionLabels);
    }

    public static void setTobeAddedAttributes(UserBean userBean, ArrayList<String> toBeAddedAttributes, HttpServletRequest request, boolean update) {
        try {
            Boolean LCSEnabled;
            String homeDir;
            Integer COUNTRY_CODE;
            Object defaultValue;
            String attributeValue;
            String mailEnabled;
            ArrayList mailServerDNs;
            ArrayList attributeList = (ArrayList)request.getSession().getAttribute("attributeList");
            String[][] arr$ = UserMgmtUtil.attribsCheckEmpty;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] strings;
                for (String string : strings = arr$[i$]) {
                    if (string.equalsIgnoreCase("PASSWORD_LAST_SET")) {
                        toBeAddedAttributes.add(string);
                        continue;
                    }
                    String attributeValue2 = (String)userBean.get(string);
                    if (attributeValue2.equals("")) continue;
                    toBeAddedAttributes.add(string);
                }
            }
            for (int i = 0; i < UserMgmtUtil.attribsCheckDefault.length; ++i) {
                String[] strings = UserMgmtUtil.attribsCheckDefault[i];
                Object[] objects = UserMgmtUtil.attribsDefaultValues[i];
                for (int j = 0; j < strings.length; ++j) {
                    String attribute = strings[j];
                    Object value = userBean.get(attribute);
                    Object defaultValue2 = objects[j];
                    if (value == null) continue;
                    if (value.equals(defaultValue2)) {
                        if (!update || !AddUserClientUtil.isAttribAvailable(attributeList, attribute)) continue;
                        toBeAddedAttributes.add(attribute);
                        continue;
                    }
                    toBeAddedAttributes.add(attribute);
                }
            }
            HttpSession session = request.getSession();
            String domainName = (String)session.getAttribute("userCreationDomain");
            ArrayList mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
            boolean isMailServerAvailable = false;
            if (mailServersList != null && !mailServersList.isEmpty() && !(mailServerDNs = (ArrayList)mailServersList.get(1)).isEmpty()) {
                isMailServerAvailable = true;
            }
            if ((mailEnabled = (String)userBean.get("mailEnabled")).equalsIgnoreCase("mailBox") && isMailServerAvailable) {
                for (String string : UserMgmtUtil.exchangePropCheckEmpty) {
                    attributeValue = (String)userBean.get(string);
                    if (attributeValue.equals("")) continue;
                    toBeAddedAttributes.add(string);
                }
                for (int j = 0; j < UserMgmtUtil.exchangePropCheckDefault.length; ++j) {
                    String attribute = UserMgmtUtil.exchangePropCheckDefault[j];
                    Object value = userBean.get(attribute);
                    defaultValue = UserMgmtUtil.exchangePropDefaultValues[j];
                    if (value == null) continue;
                    if (value.equals(defaultValue)) {
                        if (!update || !AddUserClientUtil.isAttribAvailable(attributeList, attribute)) continue;
                        toBeAddedAttributes.add(attribute);
                        continue;
                    }
                    toBeAddedAttributes.add(attribute);
                }
                for (String string : UserMgmtUtil.exchangePropNoCheck) {
                    toBeAddedAttributes.add(string);
                }
                for (String string : UserMgmtUtil.exchangeServerAttributes) {
                    attributeValue = (String)userBean.get(string);
                    if (attributeValue.equalsIgnoreCase("0")) continue;
                    toBeAddedAttributes.add(string);
                }
            } else if (mailEnabled.equalsIgnoreCase("mail") && isMailServerAvailable) {
                for (String string : UserMgmtUtil.mailEnablePropCheckEmpty) {
                    attributeValue = (String)userBean.get(string);
                    if (attributeValue.equals("")) continue;
                    toBeAddedAttributes.add(string);
                }
                for (int j = 0; j < UserMgmtUtil.mailEnablePropCheckDefault.length; ++j) {
                    String attribute = UserMgmtUtil.mailEnablePropCheckDefault[j];
                    Object value = userBean.get(attribute);
                    defaultValue = UserMgmtUtil.mailEnablePropDefaultValues[j];
                    if (value == null) continue;
                    if (value.equals(defaultValue)) {
                        if (!update || !AddUserClientUtil.isAttribAvailable(attributeList, attribute)) continue;
                        toBeAddedAttributes.add(attribute);
                        continue;
                    }
                    toBeAddedAttributes.add(attribute);
                }
                toBeAddedAttributes.add("MS_EXCH_ADMIN_GROUP");
                for (String string : UserMgmtUtil.mailEnablePropNoCheck) {
                    toBeAddedAttributes.add(string);
                }
            }
            for (String string : UserMgmtUtil.multiValuAttribs) {
                ArrayList list;
                if (string.equalsIgnoreCase("MEMBERS") || (list = (ArrayList)userBean.get(string)) == null || list.isEmpty()) continue;
                toBeAddedAttributes.add(string);
            }
            if (!mailEnabled.equalsIgnoreCase("MailBox") || !isMailServerAvailable) {
                toBeAddedAttributes.remove("PROTOCOL_SETTINGS");
            }
            toBeAddedAttributes.add("PASSWORD_TYPE");
            toBeAddedAttributes.add("PASSWORD");
            toBeAddedAttributes.add("ACCOUNT_STATUS");
            String email = (String)userBean.get("EMAIL_ADDRESS");
            if (email != null && !email.equals("") && !toBeAddedAttributes.contains("EMAIL_ADDRESS")) {
                toBeAddedAttributes.add("EMAIL_ADDRESS");
            }
            if ((COUNTRY_CODE = (Integer)userBean.get("COUNTRY_CODE")) != null && !COUNTRY_CODE.equals(-1)) {
                toBeAddedAttributes.add("COUNTRY_CODE");
                toBeAddedAttributes.add("COUNTRY");
                toBeAddedAttributes.add("COUNRTY_TWO_DIGIT_CODE");
            }
            if ((homeDir = (String)userBean.get("HOME_DIRECTORY")).startsWith("\\")) {
                toBeAddedAttributes.add("HOME_DRIVE");
            }
            if (userBean.get("LCS_ENABLED") != null && (LCSEnabled = (Boolean)userBean.get("LCS_ENABLED")).booleanValue()) {
                Integer optionFlags;
                toBeAddedAttributes.add("LCS_ENABLED");
                for (String string : UserTemplateUtil.userLCSAttributesNoCheck) {
                    toBeAddedAttributes.add(string);
                }
                if (userBean.get("LCS_OPTION_FLAG") != null && ((optionFlags = (Integer)userBean.get("LCS_OPTION_FLAG")) == 16 || optionFlags == 17)) {
                    toBeAddedAttributes.add("LCS_DEVICE_LINE_URI");
                    toBeAddedAttributes.add("LCS_DEVICE_LINE_SERVER");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isAttribAvailable(ArrayList<Hashtable> attributeList, String attribName) {
        boolean available = false;
        try {
            for (Hashtable hashtable : attributeList) {
                String attrib = (String)hashtable.get("ATTRIB_COLUMN_NAME");
                if (!attrib.equalsIgnoreCase(attribName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return available;
    }

    public static void setProtocolSettings(ArrayList<String> list, UserBean userBean) {
        String encoding = "ISO-8859-1";
        String owaccess = "owaEnable";
        String pop = "popEnable";
        String imap = "imapEnable";
        String special = "\u00a7";
        if (!list.isEmpty()) {
            for (String string : list) {
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE)) {
                    owaccess = "owaEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE)) {
                    owaccess = "owaDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE)) {
                    pop = "popEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE)) {
                    pop = "popDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE)) {
                    imap = "imapEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE)) {
                    imap = "imapDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE_X07)) {
                    owaccess = "owaEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE_X07)) {
                    owaccess = "owaDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE_X07)) {
                    pop = "popEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE_X07)) {
                    pop = "popDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE_X07)) {
                    imap = "imapEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE_X07)) {
                    imap = "imapDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE_X10)) {
                    owaccess = "owaEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE_X10)) {
                    owaccess = "owaDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE_X10)) {
                    pop = "popEnable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE_X10)) {
                    pop = "popDisable";
                    continue;
                }
                if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE_X10)) {
                    imap = "imapEnable";
                    continue;
                }
                if (!string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE_X10)) continue;
                imap = "imapDisable";
            }
        }
        userBean.set("owaccess", owaccess);
        userBean.set("pop", pop);
        userBean.set("imap", imap);
    }

    public static void setExchangeAttributes(UserBean userBean, String domainName) {
        String oma = (String)userBean.get("OMA");
        String omaccess = "omaEnable";
        String uis = "uisEnable";
        String updNotify = "updNotifyEnable";
        if (oma != null && !oma.equals("")) {
            if (oma.equals("0")) {
                omaccess = "omaEnable";
                uis = "uisEnable";
                updNotify = "updNotifyEnable";
            } else if (oma.equals("2")) {
                omaccess = "omaDisable";
                uis = "uisEnable";
                updNotify = "updNotifyEnable";
            } else if (oma.equals("5")) {
                omaccess = "omaEnable";
                uis = "uisDisable";
                updNotify = "updNotifyDisable";
            } else if (oma.equals("1")) {
                omaccess = "omaEnable";
                uis = "uisEnable";
                updNotify = "updNotifyDisable";
            } else if (oma.equals("3")) {
                omaccess = "omaDisable";
                uis = "uisEnable";
                updNotify = "updNotifyDisable";
            } else if (oma.equals("7")) {
                omaccess = "omaDisable";
                uis = "uisDisable";
                updNotify = "updNotifyDisable";
            } else if (oma.equals("4")) {
                omaccess = "omaEnable";
                uis = "uisDisable";
                updNotify = "updNotifyDisable";
            }
        }
        userBean.set("omaccess", omaccess);
        userBean.set("uis", uis);
        userBean.set("updNotify", updNotify);
        Long KEEP_DELETED_ITEMS = (Long)userBean.get("KEEP_DELETED_ITEMS");
        Long days = KEEP_DELETED_ITEMS / 86400L;
        userBean.set("keepDelItemsDays", days.toString());
        String forwardTo = (String)userBean.get("FORWARD_TO");
        if (!forwardTo.equals("")) {
            userBean.set("forwardToText", UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)forwardTo));
        }
    }

    public static void setAccountProperties(UserBean userBean, String domainName) {
        AddUserClientUtil.setAccountExpires(userBean);
        String manager = (String)userBean.get("MANAGER");
        if (!manager.equals("")) {
            String managerText = UserMgmtUtil.getDisplayNameFromDN((String)domainName, (String)manager, (int)1);
            if (managerText != null) {
                userBean.set("managerText", managerText);
            } else {
                System.out.println("User Creation -- Manager User is not available");
                userBean.set("managerText", manager);
            }
        } else {
            userBean.set("managerText", "");
        }
        String logonTo = (String)userBean.get("LOGON_TO");
        if (logonTo != null) {
            userBean.set("logonSystems", logonTo);
            if (logonTo.equals("")) {
                userBean.set("logonToPermission", "allComputers");
            } else {
                userBean.set("logonToPermission", "followingComputers");
            }
        }
    }

    public static void setTSProperties(UserBean userBean) {
        String homeTsDirectory = (String)userBean.get("TS_HOME_DIRECTORY");
        if (homeTsDirectory.startsWith("\\")) {
            userBean.set("TS_REMOTE_HOME_DIRECTORY", "1");
            userBean.set("networkTsHomeDirectory", homeTsDirectory);
            userBean.set("localTsHomeDirectory", "");
        } else {
            userBean.set("TS_REMOTE_HOME_DIRECTORY", "0");
            userBean.set("TS_HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
            userBean.set("networkTsHomeDirectory", "");
            userBean.set("localTsHomeDirectory", homeTsDirectory);
        }
        String TS_INHERIT_INITIAL_PROGRAM = (String)userBean.get("TS_INHERIT_INITIAL_PROGRAM");
        if (TS_INHERIT_INITIAL_PROGRAM.equals("0")) {
            userBean.set("tsInheritInitial", true);
        } else {
            userBean.set("tsInheritInitial", false);
        }
        String TS_ALLOW_LOGON = (String)userBean.get("TS_ALLOW_LOGON");
        if (TS_ALLOW_LOGON.equals("0")) {
            userBean.set("tsAllowLogOn", false);
        } else {
            userBean.set("tsAllowLogOn", true);
        }
        String TS_DC_DRIVES = (String)userBean.get("TS_DC_DRIVES");
        if (TS_DC_DRIVES.equals("0")) {
            userBean.set("tsDcDrives", false);
        } else {
            userBean.set("tsDcDrives", true);
        }
        String TS_DC_PRINTERS = (String)userBean.get("TS_DC_PRINTERS");
        if (TS_DC_PRINTERS.equals("0")) {
            userBean.set("tsDcPrinters", false);
        } else {
            userBean.set("tsDcPrinters", true);
        }
        String TS_DC_DEFAULT_PRINTER = (String)userBean.get("TS_DC_DEFAULT_PRINTER");
        if (TS_DC_DEFAULT_PRINTER.equals("0")) {
            userBean.set("tsDcDedaultPrinter", false);
        } else {
            userBean.set("tsDcDedaultPrinter", true);
        }
    }

    private static String getNamingAttribute(String format, String attribute, UserBean userBean, String presentLogonName, String domainName, Hashtable presentTemplateDetails, Hashtable toBeSetTemplateDetails, ArrayList customAttribList) {
        String presentName = "";
        if (userBean.get(attribute) != null) {
            presentName = (String)userBean.get(attribute);
        }
        return AddUserClientUtil.getNamingAttribute(format, attribute, presentName, userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList);
    }

    public static String getNamingAttribute(String format, String attribute, String presentName, UserBean userBean, String presentLogonName, String domainName, Hashtable presentTemplateDetails, Hashtable toBeSetTemplateDetails, ArrayList customAttribList) {
        String name = presentName;
        try {
            Long presentFormatValue = (Long)presentTemplateDetails.get(format);
            String presentFormatName = null;
            if (presentFormatValue != null) {
                presentFormatName = presentFormatValue.equals(0L) ? presentLogonName : FormatClientUtil.getFormattedName(presentFormatValue, userBean, domainName, presentLogonName, customAttribList);
                Long toBeSetFormatValue = (Long)toBeSetTemplateDetails.get(format);
                String toBeSetFormatName = null;
                toBeSetFormatName = toBeSetFormatValue == null || toBeSetFormatValue.equals(0L) ? (String)userBean.get("LOGON_NAME") : FormatClientUtil.getFormattedName(toBeSetFormatValue, userBean, domainName, (String)userBean.get("LOGON_NAME"), customAttribList);
                name = presentFormatName.equalsIgnoreCase(presentName) || presentName.equalsIgnoreCase("") ? toBeSetFormatName : presentName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static void setNamingAttribute(String format, UserBean userBean, String presentLogonName, String domainName, Hashtable presentTemplateDetails, Hashtable toBeSetTemplateDetails, ArrayList customAttribList) {
        String attribute = format.substring(0, format.lastIndexOf("_"));
        userBean.set(attribute, AddUserClientUtil.getNamingAttribute(format, attribute, userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList));
    }

    public static String getBeanProperty(String property, String defaultValue, UserBean userBean, Hashtable presentTemplateDetails, Hashtable toBeSetTemplateDetails) {
        String toBeSetAttribute = null;
        if (toBeSetTemplateDetails.get(property) != null) {
            toBeSetAttribute = toBeSetTemplateDetails.get(property).toString();
        }
        String attribValue = "";
        try {
            String presentAttribute = "";
            if (userBean.get(property) != null) {
                presentAttribute = userBean.get(property).toString();
            }
            String presentTemplateAttribute = null;
            if (presentTemplateDetails.get(property) != null) {
                presentTemplateAttribute = presentTemplateDetails.get(property).toString();
            }
            if (toBeSetAttribute != null && !toBeSetAttribute.equals("")) {
                attribValue = presentAttribute != null && presentTemplateAttribute != null ? (presentAttribute.equals(presentTemplateAttribute) || presentAttribute.equals(defaultValue) || presentAttribute.equals("") ? toBeSetAttribute : presentAttribute) : (presentAttribute != null ? (presentAttribute.equals(defaultValue) || presentAttribute.equals("") ? toBeSetAttribute : presentAttribute) : toBeSetAttribute);
            } else if (presentAttribute != null && presentTemplateAttribute != null) {
                attribValue = presentAttribute.equals(presentTemplateAttribute) ? defaultValue : presentAttribute;
            } else if (presentAttribute != null) {
                attribValue = presentAttribute;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attribValue == null) {
            attribValue = "";
        }
        return attribValue;
    }

    public static void setCustomAttributes(UserBean userBean, ArrayList<Properties> arrayList) {
        String[] ldapNames = new String[arrayList.size()];
        String[] ldapValues = new String[arrayList.size()];
        if (!arrayList.isEmpty()) {
            for (Properties properties : arrayList) {
                int i = arrayList.indexOf(properties);
                ldapNames[i] = properties.getProperty("CUSTOM_ATTRIB_NAME");
                ldapValues[i] = properties.getProperty("CUSTOM_ATTRIB_VALUE");
            }
            userBean.set("CUSTOM_ATTRIB_NAME", ldapNames);
            userBean.set("CUSTOM_ATTRIB_VALUE", ldapValues);
        } else {
            userBean.set("CUSTOM_ATTRIB_NAME", ldapNames);
            userBean.set("CUSTOM_ATTRIB_VALUE", ldapValues);
        }
    }

    public static void setIteratedUserName(String domainName, Long loginId, ArrayList<Hashtable> valuesList, Long userIndex, Properties props, String containerName) {
        Criteria criteria = new Criteria(new Column(AddUserHandler.USER_ATTRIBUTE_TABLE, "USER_INDEX"), (Object)userIndex, 0);
        Long templateId = AddUserHandler.getTemplateId((Long)userIndex);
        Hashtable iterateHash = UserTemplateHandler.getIterationSettings((Long)templateId);
        Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
        try {
            String[] ITERATION_LDAP_NAMES = new String[]{"name", "sAMAccountName", "displayName", "mailNickname", "displayNamePrintable", "mail", "targetAddress", "userPrincipalName"};
            String[] ITERATION_ATTRIBUTE = new String[]{"FULL_NAME", "SAM_ACCOUNT_NAME", "DISPLAY_NAME", "MAIL_ALIAS", "SIMPLE_DISPLAY_NAME", "EMAIL_ADDRESS", "TARGET_ADDRESS", "LOGON_NAME"};
            String logonName = "";
            UpdateQueryImpl query = new UpdateQueryImpl(AddUserHandler.USER_ATTRIBUTE_TABLE);
            query.setCriteria(criteria);
            for (int i = 0; i < ITERATION_ATTRIBUTE.length; ++i) {
                int index;
                String attributeName = ITERATION_ATTRIBUTE[i];
                String ldapName = ITERATION_LDAP_NAMES[i];
                if (!((Boolean)iterateHash.get(attributeName)).booleanValue()) continue;
                Long startingIndex = (Long)iterateHash.get("ITERATE_BEGIN_INDEX");
                String attribValue = "";
                String newAttribValue = "";
                String domainDNSName = "";
                String mailEnabled = (String)templateDetails.get("mailEnabled");
                if (mailEnabled.equals("mail")) {
                    if (attributeName.equals("MAIL_ALIAS")) {
                        attributeName = "ME_MAIL_ALIAS";
                    } else if (attributeName.equals("SIMPLE_DISPLAY_NAME")) {
                        attributeName = "ME_SIMPLE_DISPLAY_NAME";
                    }
                }
                if (attributeName.equals("FULL_NAME")) {
                    attribValue = props.getProperty("userName");
                } else if (attributeName.equals("SAM_ACCOUNT_NAME")) {
                    attribValue = props.getProperty("samAccountName");
                } else {
                    for (Hashtable hashtable : valuesList) {
                        String attrib = (String)hashtable.get("ATTRIB_LDAP_NAME");
                        if (!attrib.equalsIgnoreCase(ldapName)) continue;
                        attribValue = (String)hashtable.get("ATTRIB_VALUE");
                    }
                }
                boolean isUserAvailable = true;
                String iteration = "";
                startingIndex = startingIndex - 1L;
                while (isUserAvailable) {
                    newAttribValue = AddUserClientUtil.getNewAttributeValue(attribValue, iteration, attributeName, iterateHash, templateDetails, domainDNSName);
                    String ldapQuery = "(&(objectCategory=person)(objectclass=user)(" + ldapName + "=" + newAttribValue;
                    String searchScope = null;
                    if (attributeName.equals("FULL_NAME")) {
                        searchScope = containerName;
                    }
                    isUserAvailable = ADHandler.checkObjectExist((String)domainName, (Long)loginId, (String)(ldapQuery + "))"), (String)searchScope);
                    Long l = startingIndex;
                    Long l2 = startingIndex = Long.valueOf(startingIndex + 1L);
                    iteration = AddUserClientUtil.getIteration(iterateHash, startingIndex);
                    if (!attributeName.equals("SAM_ACCOUNT_NAME") || !iteration.equals("1000")) continue;
                    break;
                }
                if (isUserAvailable || newAttribValue.equalsIgnoreCase(attribValue)) continue;
                AddUserClientUtil.setAttributeValues(templateDetails, attributeName, (UpdateQuery)query, props, valuesList, ldapName, newAttribValue);
                if (!attributeName.equals("LOGON_NAME") || (index = newAttribValue.lastIndexOf("@")) == -1) continue;
                logonName = newAttribValue.substring(0, index);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)query);
            if (!logonName.equals("")) {
                AddUserClientUtil.setOtherAttributes(logonName, templateDetails, valuesList, criteria, props, iterateHash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getNewAttributeValue(String attribValue, String iteration, String attributeName, Hashtable iterateHash, Hashtable templateDetails, String domainDNSName) {
        int attribValLen;
        Integer restrictedLength;
        int index;
        if ((attributeName.equals("LOGON_NAME") || attributeName.equals("EMAIL_ADDRESS") || attributeName.equals("TARGET_ADDRESS")) && (index = attribValue.lastIndexOf("@")) != -1) {
            domainDNSName = (String)attribValue.subSequence(index + 1, attribValue.length());
            attribValue = attribValue.substring(0, index);
        }
        if (!iteration.equals("") && attributeName.equals("SAM_ACCOUNT_NAME") && attribValue.length() > 17) {
            attribValue = attribValue.substring(0, 17);
        }
        String newAttribValue = attribValue + iteration;
        Long formatValue = (Long)templateDetails.get(attributeName + "_FORMAT");
        if (formatValue != null && (restrictedLength = FormatClientUtil.getNamingFormatRestrictedLength(formatValue)) != null && (attribValLen = newAttribValue.length()) > restrictedLength) {
            int endIndex = restrictedLength - iteration.length();
            newAttribValue = newAttribValue.substring(0, endIndex) + iteration;
        }
        if (!domainDNSName.equals("")) {
            newAttribValue = newAttribValue + "@" + domainDNSName;
        }
        return newAttribValue;
    }

    public static void setAttributeValues(Hashtable templateDetails, String attributeName, UpdateQuery query, Properties props, ArrayList<Hashtable> valuesList, String ldapName, String newAttribValue) {
        try {
            query.setUpdateColumn(attributeName, (Object)newAttribValue);
            if (attributeName.equals("FULL_NAME")) {
                props.setProperty("userName", newAttribValue);
            } else if (attributeName.equals("SAM_ACCOUNT_NAME")) {
                props.setProperty("samAccountName", newAttribValue);
            } else {
                for (Hashtable hashtable : valuesList) {
                    String attrib = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    if (!attrib.equalsIgnoreCase(ldapName)) continue;
                    hashtable.put("ATTRIB_VALUE", newAttribValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setOtherAttributes(String logonName, Hashtable templateDetails, ArrayList<Hashtable> valuesList, Criteria criteria, Properties props, Hashtable iterateHash) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl(AddUserHandler.USER_ATTRIBUTE_TABLE);
            query.setCriteria(criteria);
            Long format = new Long(1L);
            String[] ITERATION_LDAP_NAMES = new String[]{"name", "sAMAccountName", "displayName", "mailNickname", "displayNamePrintable", "userPrincipalName", "mail", "targetAddress", "mailNickname", "displayNamePrintable"};
            for (Object object : UserTemplateUtil.allFormatColumns) {
                String[] formatNameArray = (String[])object;
                for (int i = 0; i < formatNameArray.length; ++i) {
                    String formatName = formatNameArray[i];
                    String ldapName = ITERATION_LDAP_NAMES[i];
                    String attribName = formatName.substring(0, formatName.lastIndexOf("_"));
                    if (attribName.equals("ME_MAIL_ALIAS")) {
                        attribName = "MAIL_ALIAS";
                    }
                    if (attribName.equals("ME_SIMPLE_DISPLAY_NAME")) {
                        attribName = "SIMPLE_DISPLAY_NAME";
                    }
                    if (((Boolean)iterateHash.get(attribName)).booleanValue() || (format = (Long)templateDetails.get(formatName)) == null || !format.equals(0L)) continue;
                    String value = logonName;
                    String column = formatName.substring(0, formatName.lastIndexOf("_"));
                    if (formatName.equals("FULL_NAME_FORMAT")) {
                        props.setProperty("userName", value);
                    } else if (formatName.equals("SAM_ACCOUNT_NAME_FORMAT")) {
                        props.setProperty("samAccountName", value);
                    } else if (formatName.equals("EMAIL_ADDRESS_FORMAT") || formatName.equals("TARGET_ADDRESS_FORMAT")) {
                        for (Hashtable hashtable : valuesList) {
                            String emailId;
                            int index;
                            if (!hashtable.get("ATTRIB_COLUMN_NAME").equals(column) || (index = (emailId = (String)hashtable.get("ATTRIB_VALUE")).lastIndexOf("@")) == -1) continue;
                            String domainDNSName = (String)emailId.subSequence(index, emailId.length());
                            value = value + domainDNSName;
                            hashtable.put("ATTRIB_VALUE", value);
                        }
                    } else {
                        for (Hashtable hashtable : valuesList) {
                            if (!hashtable.get("ATTRIB_COLUMN_NAME").equals(column)) continue;
                            hashtable.put("ATTRIB_VALUE", value);
                        }
                    }
                    query.setUpdateColumn(formatName.substring(0, formatName.lastIndexOf("_")), (Object)value);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setIteratedUserName(String domainName, Long loginId, UserBean userBean, HttpServletRequest request) {
        HttpSession session = request.getSession();
        Long userCreationId = (Long)session.getAttribute("userCreationID");
        Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationId);
        Hashtable iterateHash = UserTemplateHandler.getIterationSettings((Long)templateId);
        String sAMAccountName = (String)userBean.get("SAM_ACCOUNT_NAME");
        try {
            String[] ITERATION_LDAP_NAMES = new String[]{"name", "sAMAccountName", "displayName", "mailNickname", "displayNamePrintable", "mail", "targetAddress", "userPrincipalName"};
            String[] ITERATION_ATTRIBUTE = new String[]{"FULL_NAME", "SAM_ACCOUNT_NAME", "DISPLAY_NAME", "MAIL_ALIAS", "SIMPLE_DISPLAY_NAME", "EMAIL_ADDRESS", "TARGET_ADDRESS", "LOGON_NAME"};
            String logonName = "";
            for (int i = 0; i < ITERATION_ATTRIBUTE.length; ++i) {
                int index;
                String attribName = ITERATION_ATTRIBUTE[i];
                String ldapName = ITERATION_LDAP_NAMES[i];
                if (!((Boolean)iterateHash.get(attribName)).booleanValue()) continue;
                Long startingIndex = (Long)iterateHash.get("ITERATE_BEGIN_INDEX");
                String attribValue = "";
                String newAttribValue = "";
                String domainDNSName = "";
                String mailEnabled = (String)userBean.get("mailEnabled");
                if (mailEnabled.equalsIgnoreCase("mail")) {
                    if (attribName.equals("MAIL_ALIAS")) {
                        attribName = "ME_MAIL_ALIAS";
                    } else if (attribName.equals("SIMPLE_DISPLAY_NAME")) {
                        attribName = "ME_SIMPLE_DISPLAY_NAME";
                    }
                }
                attribValue = (String)userBean.get(attribName);
                if (attribName.equals("SAM_ACCOUNT_NAME") && attribValue.length() > 20) {
                    attribValue = attribValue.substring(0, 20);
                }
                boolean isUserAvailable = true;
                String iteration = "";
                startingIndex = startingIndex - 1L;
                while (isUserAvailable) {
                    Hashtable formatHash = UserMgmtUtil.getNamingFormats((Long)userCreationId);
                    newAttribValue = AddUserClientUtil.getNewAttributeValue(attribValue, iteration, attribName, iterateHash, formatHash, domainDNSName);
                    String ldapQuery = "(&(objectCategory=person)(objectclass=user)(" + ldapName + "=" + newAttribValue;
                    String searchScope = null;
                    if (attribName.equals("FULL_NAME")) {
                        String containerName;
                        searchScope = containerName = (String)userBean.get("container");
                    }
                    isUserAvailable = ADHandler.checkObjectExist((String)domainName, (Long)loginId, (String)(ldapQuery + "))"), (String)searchScope);
                    Long l = startingIndex;
                    Long l2 = startingIndex = Long.valueOf(startingIndex + 1L);
                    iteration = AddUserClientUtil.getIteration(iterateHash, startingIndex);
                    if (!attribName.equals("SAM_ACCOUNT_NAME") || !iteration.equals("1000")) continue;
                    break;
                }
                if (isUserAvailable || newAttribValue.equalsIgnoreCase(attribValue)) continue;
                userBean.set(attribName, newAttribValue);
                if (!attribName.equals("LOGON_NAME") || (index = newAttribValue.lastIndexOf("@")) == -1) continue;
                logonName = newAttribValue.substring(0, index);
            }
            if (!logonName.equals("")) {
                AddUserClientUtil.setOtherAttributes(logonName, userBean, userCreationId, session, iterateHash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setOtherAttributes(String logonName, UserBean userBean, Long userCreationId, HttpSession session, Hashtable iterateHash) {
        Hashtable formatProps = UserMgmtUtil.getNamingFormats((Long)userCreationId);
        for (Object object : UserTemplateUtil.allFormatColumns) {
            String[] formatNameArray;
            for (String string : formatNameArray = (String[])object) {
                Long format;
                String attribName = string.substring(0, string.lastIndexOf("_"));
                if (attribName.equals("ME_MAIL_ALIAS")) {
                    attribName = "MAIL_ALIAS";
                }
                if (attribName.equals("ME_SIMPLE_DISPLAY_NAME")) {
                    attribName = "SIMPLE_DISPLAY_NAME";
                }
                if (((Boolean)iterateHash.get(attribName)).booleanValue() || !(format = (Long)formatProps.get(string)).equals(0L)) continue;
                String value = logonName;
                if (string.equals("EMAIL_ADDRESS_FORMAT") || string.equals("TARGET_ADDRESS_FORMAT")) {
                    String mailServer = (String)session.getAttribute("emailServerDNSName");
                    value = logonName + "@" + mailServer;
                }
                userBean.set(string.substring(0, string.lastIndexOf("_")), value);
            }
        }
    }

    private static String getIteration(Hashtable iterateHash, Long startingIndex) {
        String iteration = startingIndex.toString();
        Boolean fixedLengthChk = (Boolean)iterateHash.get("ITERATION_FIXD_LEN_CHK");
        if (fixedLengthChk.booleanValue()) {
            String charToBeFilled = (String)iterateHash.get("ITERATION_FILLED_CHAR");
            Long fixedLength = (Long)iterateHash.get("ITERATION_FIXD_LEN");
            int fixedLengthVal = fixedLength.intValue();
            int itLen = iteration.length();
            while (itLen < fixedLengthVal) {
                iteration = charToBeFilled + iteration;
                itLen = iteration.length();
            }
            if (itLen > fixedLengthVal) {
                iteration = iteration.substring(0, fixedLengthVal);
            }
        }
        return iteration;
    }

    public static ArrayList getUpdatedBean(UserBean amBean, UserBean bmBean, String distinguishedName, String method, String domainName, Hashtable domainVsIds) {
        int len$;
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList dependentList = new ArrayList();
        ArrayList userList = new ArrayList();
        Hashtable<String, Serializable> hash = new Hashtable<String, Serializable>();
        Map amMap = amBean.getMap();
        Map bmMap = bmBean.getMap();
        String[][] multiPassProps = new String[][]{UserMgmtUtil.multiValuAttribs, UserMgmtUtil.passwordAttribs};
        String[][] mailBoxProps = new String[][]{UserMgmtUtil.exchangePropCheckEmpty, UserMgmtUtil.exchangePropCheckDefault, UserMgmtUtil.exchangeServerAttributes, UserMgmtUtil.exchangePropNoCheck};
        String[][] mailEnabledProps = new String[][]{UserMgmtUtil.mailEnablePropCheckEmpty, UserMgmtUtil.mailEnablePropCheckDefault, UserMgmtUtil.mailEnablePropNoCheck};
        String[][][] genAttributes = new String[][][]{UserMgmtUtil.attribsCheckEmpty, UserMgmtUtil.attribsCheckDefault};
        String homeFolder = (String)amMap.get("homeFolder");
        int uac = (Integer)amMap.get("ACCOUNT_STATUS");
        amMap.put("ACCOUNT_STATUS", uac);
        if (homeFolder.equalsIgnoreCase("local")) {
            String localHomeDirectory = (String)amMap.get("localHomeDirectory");
            amMap.put("HOME_DIRECTORY", localHomeDirectory);
        } else if (homeFolder.equalsIgnoreCase("connect")) {
            String networkHomeDirectory = (String)amMap.get("networkHomeDirectory");
            amMap.put("HOME_DIRECTORY", (String)amMap.get("networkHomeDirectory"));
        }
        String[][][] arr$ = genAttributes;
        int len$2 = arr$.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            String[][] generalAttributes;
            String[][] arr$2 = generalAttributes = arr$[i$];
            int len$3 = arr$2.length;
            for (int i$2 = 0; i$2 < len$3; ++i$2) {
                String[] strings;
                for (String string : strings = arr$2[i$2]) {
                    String value;
                    if ((string.equals("HOME_DIRECTORY") || string.equals("PROFILE_PATH") || string.equals("TS_PROFILE_PATH") || string.equals("TS_HOME_DIRECTORY") || string.equals("TS_WORKING_DIRECTORY")) && !amMap.get(string).equals(bmMap.get(string)) && !(value = FormatClientUtil.getFormatValue(domainName, amMap.get(string).toString(), amBean, new ArrayList())).equals("")) {
                        amMap.put(string, value);
                    }
                    AddUserClientUtil.assignModifiedValues(string, amMap, bmMap, list, method, domainVsIds, domainName);
                }
            }
        }
        String mailEnabled = (String)amMap.get("mailEnabled");
        if (mailEnabled.equalsIgnoreCase("mailBox")) {
            String[][] arr$3 = mailBoxProps;
            len$ = arr$3.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] mailBox;
                for (String string : mailBox = arr$3[i$]) {
                    AddUserClientUtil.assignModifiedValues(string, amMap, bmMap, list, method, domainVsIds, domainName);
                }
            }
        } else if (mailEnabled.equalsIgnoreCase("mail")) {
            String[][] arr$4 = mailEnabledProps;
            len$ = arr$4.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] mailEnable;
                for (String string : mailEnable = arr$4[i$]) {
                    AddUserClientUtil.assignModifiedValues(string, amMap, bmMap, list, method, domainVsIds, domainName);
                }
            }
        } else {
            AddUserClientUtil.assignModifiedValues("EMAIL_ADDRESS", amMap, bmMap, list, method, domainVsIds, domainName);
        }
        Integer COUNTRY_CODE = (Integer)amMap.get("COUNTRY_CODE");
        if (!COUNTRY_CODE.equals(-1)) {
            for (String string : UserMgmtUtil.generalProp) {
                AddUserClientUtil.assignModifiedValues(string, amMap, bmMap, list, method, domainVsIds, domainName);
            }
        }
        String[][] arr$5 = multiPassProps;
        int len$4 = arr$5.length;
        for (int i$ = 0; i$ < len$4; ++i$) {
            String[] props;
            for (String string : props = arr$5[i$]) {
                if (string.equalsIgnoreCase("MEMBERS")) continue;
                AddUserClientUtil.assignModifiedValues(string, amMap, bmMap, list, method, domainVsIds, domainName);
            }
        }
        AddUserClientUtil.assignExtendedAttributesValues(amMap, bmMap, list, domainVsIds, domainName);
        Hashtable h = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)"DISTINGUISHED_NAME");
        h.put("ATTRIB_VALUE", distinguishedName);
        list.add(h);
        hash.put("USER_VALUES", list);
        hash.put("USER_INDEX", Long.valueOf(0L));
        userList.add(hash);
        return userList;
    }

    private static void assignExtendedAttributesValues(Map amMap, Map bmMap, ArrayList<Hashtable> list, Hashtable domainVsIds, String domainName) {
        Set columnNameList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_COLUMN_NAME");
        Iterator it = columnNameList.iterator();
        ArrayList authorizedIdsList = (ArrayList)domainVsIds.get(domainName);
        while (it.hasNext()) {
            int diff;
            Object columnName = it.next();
            Hashtable h = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", columnName);
            if (columnName.toString().equals("ACCOUNT_STATUS")) {
                int postuac = (Integer)amMap.get("ACCOUNT_STATUS");
                int preuac = (Integer)bmMap.get("ACCOUNT_STATUS");
                diff = 0;
                int nandStatus = (Integer)amMap.get("NAND_ACCOUNT_STATUS");
                if (preuac > postuac) {
                    diff = preuac - postuac;
                } else if (postuac > preuac) {
                    diff = postuac - preuac;
                }
                if (diff != 0 && diff != 32) {
                    if (ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, columnName.toString(), diff, "MODIFY_ID")) {
                        String userAccountControl = amMap.get("ACCOUNT_STATUS").toString() + ";" + nandStatus;
                        h.put("ATTRIB_VALUE", userAccountControl);
                        list.add(h);
                    } else {
                        System.out.println("Unauthorized.. Diff : " + diff);
                    }
                }
            }
            if (!columnName.toString().equals("USER_FLAGS")) continue;
            int postuf = (Integer)amMap.get("USER_FLAGS");
            int preuf = (Integer)bmMap.get("USER_FLAGS");
            diff = 0;
            if (preuf > postuf) {
                diff = preuf - postuf;
            } else if (postuf > preuf) {
                diff = postuf - preuf;
            }
            int userFlags = (Integer)amMap.get("USER_FLAGS");
            if (diff == 0 || !ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, columnName.toString(), userFlags, "MODIFY_ID")) continue;
            h.put("ATTRIB_VALUE", amMap.get("USER_FLAGS").toString());
            list.add(h);
        }
    }

    public static void assignModifiedValues(String keyColumn, Map amMap, Map bmMap, ArrayList<Hashtable> list, String method, Hashtable domainVsIds, String domainName) {
        Hashtable h = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)keyColumn);
        Long modifyId = (Long)h.get("MODIFY_ID");
        boolean authorized = false;
        ArrayList idsList = (ArrayList)domainVsIds.get(domainName);
        if (idsList.contains(modifyId)) {
            authorized = true;
        }
        if (authorized) {
            if (keyColumn.equals("MEMBER_OF") || keyColumn.equals("REJECT_MESSAGES_FROM") || keyColumn.equals("ACCEPT_MESSAGES_FROM") || keyColumn.equals("SEND_ON_BEHALF")) {
                ArrayList bmList;
                ArrayList<String> bufList = new ArrayList<String>();
                ArrayList amList = (ArrayList)amMap.get(keyColumn);
                if (!amList.equals(bmList = (ArrayList)bmMap.get(keyColumn))) {
                    for (int i = 0; i < amList.size(); ++i) {
                        Properties p = (Properties)amList.get(i);
                        String dn = (String)p.get("Distinguished_Name");
                        if (keyColumn.equals("MEMBER_OF")) {
                            if (bmList.contains(p)) continue;
                            bufList.add(dn);
                            continue;
                        }
                        bufList.add(dn);
                    }
                    h.put("ATTRIB_VALUE", bufList);
                    list.add(h);
                }
            } else if (keyColumn.equals("PROTOCOL_SETTINGS") || keyColumn.equals("EMAIL_PROXY_ADDRESSES")) {
                ArrayList bmList;
                ArrayList<String> bufList = new ArrayList<String>();
                ArrayList amList = (ArrayList)amMap.get(keyColumn);
                if (!amList.equals(bmList = (ArrayList)bmMap.get(keyColumn))) {
                    for (int i = 0; i < amList.size(); ++i) {
                        String dn = (String)amList.get(i);
                        bufList.add(dn);
                    }
                    h.put("ATTRIB_VALUE", bufList);
                    list.add(h);
                }
            } else if (keyColumn.equals("PASSWORD")) {
                String password = (String)amMap.get(keyColumn);
                if (password != null && !password.equals("")) {
                    h.put("ATTRIB_VALUE", password);
                    list.add(h);
                }
            } else if (keyColumn.equalsIgnoreCase("HOME_DRIVE")) {
                String homeFolder = (String)amMap.get("homeFolder");
                String keyValue = (String)amMap.get(keyColumn);
                if (homeFolder.equals("local") && bmMap.get("homeFolder").toString().equals("connect")) {
                    h.put("ATTRIB_VALUE", keyValue);
                    list.add(h);
                } else if (homeFolder.equals("connect") && (keyValue.equalsIgnoreCase("Z:") && bmMap.get("homeFolder").toString().equals("local") || !keyValue.equals((String)bmMap.get(keyColumn)))) {
                    h.put("ATTRIB_VALUE", keyValue);
                    list.add(h);
                }
            } else if (keyColumn.equalsIgnoreCase("LOGON_NAME")) {
                String postLogon;
                String preLogon = (String)bmMap.get(keyColumn) + "@" + (String)bmMap.get("UPN_SUFFIX");
                if (!preLogon.equalsIgnoreCase(postLogon = (String)amMap.get(keyColumn))) {
                    h.put("ATTRIB_VALUE", postLogon);
                    list.add(h);
                }
            } else if (keyColumn.equals("ACCOUNT_EXPIRY_DATE")) {
                Long accountPostExpires = (Long)amMap.get(keyColumn);
                Long accountPreExpires = (Long)bmMap.get(keyColumn);
                if (accountPreExpires.equals(Long.MAX_VALUE)) {
                    accountPreExpires = 0L;
                }
                if (accountPostExpires.equals(Long.MAX_VALUE)) {
                    accountPostExpires = 0L;
                }
                if (!accountPostExpires.equals(accountPreExpires)) {
                    h.put("ATTRIB_VALUE", amMap.get(keyColumn).toString());
                    list.add(h);
                }
            } else if (keyColumn.equals("PASSWORD_LAST_SET")) {
                Long readPwdLast = (Long)bmMap.get(keyColumn);
                Long setPwdLast = (Long)amMap.get(keyColumn);
                if (!setPwdLast.equals(readPwdLast) && (!readPwdLast.equals(0L) && !setPwdLast.equals(-1L) || readPwdLast.equals(0L) && setPwdLast.equals(-1L))) {
                    h.put("ATTRIB_VALUE", amMap.get(keyColumn).toString());
                    list.add(h);
                }
            } else if (keyColumn.equals("OMA")) {
                String MAIL_SERVER = (String)bmMap.get("MAIL_SERVER");
                if (!amMap.get(keyColumn).equals(bmMap.get(keyColumn)) && !ExchangeUtil.checkExchange2007((String)MAIL_SERVER)) {
                    h.put("ATTRIB_VALUE", amMap.get(keyColumn).toString());
                    list.add(h);
                }
            } else if (!amMap.get(keyColumn).equals(bmMap.get(keyColumn))) {
                h.put("ATTRIB_VALUE", amMap.get(keyColumn).toString());
                list.add(h);
            }
        } else {
            System.out.println("UnAuthorized User to Modify the property : " + keyColumn);
        }
    }

    public static void dependentValues(String keyColumn, Map amMap, ArrayList<Hashtable> list) {
        Hashtable h = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)keyColumn);
        h.put("ATTRIB_VALUE", amMap.get(keyColumn).toString());
        list.add(h);
    }

    public static Properties getShareDetails(String domainName, UserBean bean, Hashtable permissionsTable, String folder, ArrayList customList) {
        Properties properties = new Properties();
        try {
            int index;
            String localPath = "";
            String serverName = "";
            String homePath = "";
            String sharePath = "";
            String shareName = "";
            if (folder.equalsIgnoreCase("homeFolder")) {
                localPath = (String)permissionsTable.get("SHARE_LOCAL_MASK");
                homePath = bean.get("HOME_DIRECTORY").toString();
            } else if (folder.equalsIgnoreCase("tsHomeFolder")) {
                localPath = (String)permissionsTable.get("TS_SHARE_LOCAL_MASK");
                homePath = bean.get("TS_HOME_DIRECTORY").toString();
            }
            if (!homePath.equalsIgnoreCase("")) {
                int newindx = homePath.indexOf("\\", 2);
                serverName = homePath.substring(2, newindx);
            }
            if ((index = (localPath = FormatClientUtil.getFormatValue(domainName, localPath, bean, customList, true)).indexOf(":")) == 1) {
                String localDriveLetter = localPath.substring(0, 1);
                localDriveLetter = localDriveLetter.toLowerCase();
                sharePath = "\\\\" + serverName + "\\" + localDriveLetter + "$" + localPath.substring(2);
            }
            homePath = FormatClientUtil.getFormatValue(domainName, homePath, bean, customList);
            int indx = homePath.lastIndexOf("\\");
            shareName = homePath.substring(indx + 1, homePath.length());
            properties.setProperty("localPath", localPath);
            properties.setProperty("serverName", serverName);
            properties.setProperty("shareName", shareName);
            properties.setProperty("shareRemotePath", sharePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Properties getShareDetails(String domainName, ArrayList<Hashtable> valuesList, Hashtable permissionsTable, String samAccountName, String userName, String folder, ArrayList customList) {
        Properties properties = new Properties();
        try {
            String localPath = "";
            String homePath = "";
            String serverName = "";
            String sharePath = "";
            String shareName = "";
            if (folder.equalsIgnoreCase("homeFolder")) {
                localPath = (String)permissionsTable.get("SHARE_LOCAL_MASK");
                for (Hashtable hashtable : valuesList) {
                    String string = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    if (!string.equalsIgnoreCase("homeDirectory")) continue;
                    homePath = hashtable.get("ATTRIB_VALUE").toString();
                }
            } else if (folder.equalsIgnoreCase("tsHomeFolder")) {
                localPath = (String)permissionsTable.get("TS_SHARE_LOCAL_MASK");
                for (Hashtable hashtable : valuesList) {
                    String string = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    if (!string.equalsIgnoreCase("tsHomeDir")) continue;
                    homePath = hashtable.get("ATTRIB_VALUE").toString();
                }
            }
            if (!homePath.equalsIgnoreCase("")) {
                int newindx = homePath.indexOf("\\", 2);
                serverName = homePath.substring(2, newindx);
            }
            homePath = FormatClientUtil.getFormatValue(domainName, homePath, valuesList, samAccountName, userName, customList);
            int index = (localPath = FormatClientUtil.getFormatValue(domainName, localPath, valuesList, samAccountName, userName, customList, true)).indexOf(":");
            if (index == 1) {
                String localDriveLetter = localPath.substring(0, 1);
                localDriveLetter = localDriveLetter.toLowerCase();
                sharePath = "\\\\" + serverName + "\\" + localDriveLetter + "$" + localPath.substring(2);
            }
            int indx = homePath.lastIndexOf("\\");
            shareName = homePath.substring(indx + 1, homePath.length());
            properties.setProperty("localPath", localPath);
            properties.setProperty("serverName", serverName);
            properties.setProperty("shareName", shareName);
            properties.setProperty("shareRemotePath", sharePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Hashtable getErrorMessages(String errorId, AdventNetResourceBundle rb) {
        Hashtable<String, String> errorTable = new Hashtable<String, String>();
        String id = "0";
        String message = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred");
        for (int i = 0; i < ids.length; ++i) {
            if (!errorId.contains(ids[i])) continue;
            message = rb.getString(errorMessages[i]);
            id = ids[i];
        }
        errorTable.put("ERROR_ID", id);
        errorTable.put("ERROR_MSG", message);
        return errorTable;
    }

    public static String getBulkUserCreationTSTID(ArrayList list) {
        Hashtable idsCount = new Hashtable();
        for (int j = 0; j < list.size(); ++j) {
            String message = (String)list.get(j);
            if (message == null) continue;
            for (int i = 0; i < ids.length; ++i) {
                if (message.contains(ids[i])) {
                    AddUserClientUtil.putIDCount(idsCount, ids[i]);
                    continue;
                }
                int index = message.indexOf(" Error Code : ");
                if (index <= 0 || (index = message.indexOf(":", index)) <= 0) continue;
                String str = message.substring(index + 2);
                AddUserClientUtil.putIDCount(idsCount, str);
            }
        }
        int maxCount = 0;
        String id = null;
        Enumeration e = idsCount.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            Integer c = (Integer)idsCount.get(s);
            if (c <= maxCount) continue;
            maxCount = c;
            id = s;
        }
        return id;
    }

    private static void putIDCount(Hashtable hash, String str) {
        Integer count = (Integer)hash.get(str);
        if (count == null) {
            count = new Integer(1);
            hash.put(str, count);
        } else {
            count = new Integer(count + 1);
            hash.put(str, count);
        }
    }

    public static boolean checkAuthorizationForCustomAttributes(HttpServletRequest request, String selectedDomainName, Object obj) {
        boolean ret = true;
        if (obj.toString().equalsIgnoreCase("templateName") && !ClientUtil.checkAuthorization(request, selectedDomainName, 1476L)) {
            ret = false;
        }
        return ret;
    }

    public static void setAccountExpires(UserBean bean) {
        try {
            Long ACCOUNT_EXPIRY_DATE = (Long)bean.get("ACCOUNT_EXPIRY_DATE");
            String accountExpiresStatus = "never";
            String dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(System.currentTimeMillis()));
            if (ACCOUNT_EXPIRY_DATE.equals(0L) || ACCOUNT_EXPIRY_DATE >= 5223372036854775807L) {
                accountExpiresStatus = "never";
            } else {
                accountExpiresStatus = "endOf";
                if (ACCOUNT_EXPIRY_DATE <= 36500L) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(5, calendar.get(5) + (int)ACCOUNT_EXPIRY_DATE.longValue());
                    dateString = new SimpleDateFormat("yyyy/MM/dd").format(calendar.getTime());
                    calendar.set(14, 0);
                    Long fileTime = DateTimeUtil.getFileTimeFromSystemTime((Long)calendar.getTimeInMillis());
                    bean.set("ACCOUNT_EXPIRY_DATE", fileTime);
                } else {
                    dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(DateTimeUtil.getSystemTimeFromFileTime((Long)ACCOUNT_EXPIRY_DATE)));
                }
            }
            System.out.println(" DATE STRING IN AddUserClientUtil :: " + dateString + ", accountExpiresStatus : " + accountExpiresStatus + " and the ACCOUNT_EXPIRY_DATE : " + ACCOUNT_EXPIRY_DATE);
            bean.set("accountExpiresStatus", accountExpiresStatus);
            bean.set("accountExpiresValue", dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setOrgAttribList(UserBean userBean, String ldapName, String attribName, String attribListName, AdventNetResourceBundle rb) {
        try {
            ArrayList<String> attribList = new ArrayList<String>();
            String attribVal = "";
            if (userBean.get(ldapName) != null) {
                attribVal = (String)userBean.get(ldapName);
            }
            DataObject dataObject = AdminUtil.comboAttribs(attribName);
            Iterator it = dataObject.getRows("ADSMOrgAttributes");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                attribList.add(rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
            if (attribVal != "" && !attribList.contains(attribVal)) {
                attribList.add(attribVal);
            }
            userBean.set(attribListName, attribList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

