/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AutoReplyMgmtController;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AutoReplyMgmtStatusUpdator;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;

public abstract class AutoReplyAbstractListener
implements NativeListener {
    protected boolean isCompleted;
    protected String objectClass;
    protected ObjectClass objClass;
    protected ArrayList attributeProps;
    protected AdventNetResourceBundle rb;
    protected Long queueRegID = null;
    protected String baseTableName;
    protected Integer reportId;
    protected String tableKey;
    protected Long loginId;
    protected String tenantId;
    protected String tenantPwd;
    protected ArrayList attributeList;
    protected Hashtable attributeListHash;
    protected boolean isCsvMgmt;
    protected ArrayList<String> informationStrings = new ArrayList();
    protected String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
    protected int licensedCount;

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public AutoReplyAbstractListener() {
        if (this.noOfObjects == null) {
            this.noOfObjects = "100";
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            this.licensedCount = Integer.parseInt(this.noOfObjects);
        }
    }

    public void addRow(Properties prop) {
        Properties uiProps = new Properties();
        Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)this.attributeProps, (String)"", (Properties)uiProps, (Hashtable)new Properties(), (AdventNetResourceBundle)this.rb);
        QueueHandler.getInstance().getQueue(this.objClass.getId()).updateData(this.queueRegID, tableStringMap);
    }

    protected ArrayList getObjIdList() {
        this.objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName("ADSMUserGeneralDetails");
        ArrayList<Integer> objectIds = new ArrayList<Integer>();
        objectIds.add(this.objClass.getId());
        return objectIds;
    }

    public void completedAction() {
        this.endQueue();
    }

    public void endQueue() {
        this.postNativeData();
        this.deRegister();
        this.queueRegID = null;
    }

    private void postNativeData() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
    }

    private void deRegister() {
        QueueHandler.getInstance().deRegister(this.queueRegID);
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public ArrayList getAttributeProps() {
        return this.attributeProps;
    }

    public void setAttributeProps(ArrayList attributeProps) {
        this.attributeProps = attributeProps;
    }

    public void setResourceBundle(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    protected void initAttributeList(int reportId) {
        this.reportId = reportId;
        ArrayList<Object> attribIdList = new ArrayList<Object>();
        this.attributeList = new ArrayList();
        try {
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(reportId));
            for (int i = 0; i < tableNames.size(); ++i) {
                ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(reportId));
                for (int j = 0; j < l.size(); ++j) {
                    Properties p = (Properties)l.get(j);
                    if (this.attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                    attribIdList.add(p.get("ATTRIB_ID"));
                    this.attributeList.add(p.get("ATTRIB_LDAP_NAME"));
                }
            }
            DataObject attributeDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribIdList.toArray(), 8));
            Iterator it = attributeDO.getRows("ADSMAttributeDetails");
            this.attributeProps = new ArrayList();
            this.attributeListHash = new Hashtable();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                this.attributeProps.add(MultiDCUtil.getProps((Row)r));
                String tableName = (String)r.get("TABLE_NAME");
                String columnName = (String)r.get("ATTRIB_COLUMN_NAME");
                ArrayList<String> columns = (ArrayList<String>)this.attributeListHash.get(tableName);
                if (columns == null) {
                    columns = new ArrayList<String>();
                    this.attributeListHash.put(tableName, columns);
                }
                columns.add(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties getSIDProps() {
        Properties sidProps = new Properties();
        sidProps.put("ATTRIB_ID", new Integer(1144));
        sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
        sidProps.put("TABLE_NAME", "ADSMUserGeneralDetails");
        sidProps.put("RELATIONAL_TYPE", new Integer(0));
        return sidProps;
    }

    public Properties addUserDNProps() {
        Properties sidProps = new Properties();
        sidProps.put("ATTRIB_ID", new Integer(1004));
        sidProps.put("ATTRIB_COLUMN_NAME", "DISTINGUISHED_NAME");
        sidProps.put("TABLE_NAME", this.baseTableName);
        sidProps.put("RELATIONAL_TYPE", new Integer(0));
        return sidProps;
    }

    public String getHelpLink(Integer reportId) {
        String helpLink = "";
        try {
            DataObject reportObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0));
            Row reportRow = reportObj.getFirstRow("ADSMReports");
            String hlpLink = (String)reportRow.get("HELP_LINK");
            if (hlpLink != null && hlpLink.length() > 0) {
                helpLink = hlpLink;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return helpLink;
    }

    public abstract String modifyUser(String var1, String var2, Hashtable var3, DataObject var4, Object var5, Properties var6, ArrayList var7, Hashtable var8);

    public abstract Properties updateStatus(Properties var1, String var2);

    protected class ModifyAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        boolean connectToOffice365 = false;
        String hostId;
        Integer reportId;
        Long loginId;
        String domainName;
        AdventNetResourceBundle rb;

        public ModifyAction(long generationId, JSONArray selectedUsersList, Long loginId, Integer reportId, String hostId, AdventNetResourceBundle rb, String domainName) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.hostId = hostId;
            this.loginId = loginId;
            this.reportId = reportId;
            this.rb = rb;
            this.domainName = domainName;
            AutoReplyAbstractListener.this.isCsvMgmt = false;
        }

        public Hashtable<String, Properties> getExchangeUserDetails(ArrayList columnList, String sortColumn, String[] objectIdArr) {
            Hashtable<String, Properties> userDetails = new Hashtable<String, Properties>();
            try {
                if (!columnList.contains("OBJECT_GUID")) {
                    columnList.add("OBJECT_GUID");
                }
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMMailBoxObjects"));
                for (int ind1 = 0; ind1 < columnList.size(); ++ind1) {
                    query.addSelectColumn(Column.getColumn((String)"ADSMMailBoxObjects", (String)((String)columnList.get(ind1))));
                }
                query.setCriteria(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"OBJECT_GUID"), (Object)objectIdArr, 8));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows("ADSMMailBoxObjects");
                    while (it.hasNext()) {
                        Properties userData = new Properties();
                        Row userRow = (Row)it.next();
                        String objectId = (String)userRow.get("OBJECT_GUID");
                        for (int ind2 = 0; ind2 < columnList.size(); ++ind2) {
                            String columnName = (String)columnList.get(ind2);
                            userData.put(columnName, userRow.get(columnName));
                        }
                        userDetails.put(objectId, userData);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return userDetails;
        }

        @Override
        public void run() {
            try {
                StatusUpdater statusUpdater = AutoReplyMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ArrayList<String> attribToSelect = new ArrayList<String>();
                attribToSelect.add("OBJECT_GUID");
                attribToSelect.add("NAME");
                attribToSelect.add("DOMAIN_NAME");
                attribToSelect.add("HOME_MDB");
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Hashtable<String, Properties> userDetails = this.getExchangeUserDetails(attribToSelect, null, objectIdArr);
                objectIdArr = null;
                AutoReplyAbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(AutoReplyAbstractListener.this.getObjIdList(), AutoReplyAbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
                boolean isAllObjectsSucceeded = true;
                ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns(this.reportId);
                attributeList.add(AutoReplyAbstractListener.this.getSIDProps());
                attributeList.add(AutoReplyAbstractListener.this.addUserDNProps());
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (int i = 0; !((AutoReplyMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length(); ++i) {
                    String message;
                    String objectId = this.selectedUsersList.getString(i);
                    Properties userProp = userDetails.get(objectId);
                    String objName = userProp.getProperty("NAME");
                    String domainname = userProp.getProperty("DOMAIN_NAME");
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)domainname, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String mailbox = userProp.getProperty("HOME_MDB");
                    String mailBoxServer = ExchangeUtil.getMailboxServer((String)mailbox, (String)domainname);
                    Properties exchangeServerDetails = null;
                    if (mailBoxServer.length() > 5) {
                        exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainname, (String)mailBoxServer);
                    }
                    ArrayList setAttributeList = new ArrayList();
                    Hashtable multipleValuesSids = new Hashtable();
                    Criteria crit = new Criteria(new Column("ADSMUserGeneralDetails", "OBJECT_GUID"), (Object)objectId, 0);
                    ArrayList list = DBObjectUtil.getObjects((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID", (ArrayList)attributeList, (Criteria)crit);
                    Hashtable r = (Hashtable)list.get(0);
                    String dnValue = (String)r.get(1004);
                    String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue);
                    if (!objectOUList.contains(ouName)) {
                        objectOUList.add(ouName);
                    }
                    if ((message = AutoReplyAbstractListener.this.modifyUser(objectId, objName, audit_info, auditDataObj, userProp, exchangeServerDetails, setAttributeList, r)) == null || message.trim().length() == 0) {
                        message = this.rb.getString("admp.mgmt.common.statmsg.successfully_modified");
                        auditObjectIdList.add(object_id);
                    } else if (!AutoReplyAbstractListener.this.informationStrings.contains(message)) {
                        isAllObjectsSucceeded = false;
                    }
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties resProp = AutoReplyAbstractListener.this.updateStatus(userProp, message);
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("ADSMModifyUserResult");
                    row.set("OBJECT_GUID", (Object)objectId);
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                AutoReplyAbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                AutoReplyAbstractListener.this.isCompleted = true;
                ((AutoReplyMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((AutoReplyMgmtStatusUpdator)statusUpdater).setHelpLink(AutoReplyAbstractListener.this.getHelpLink(this.reportId));
                }
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    ArrayList<Long> auditIdList = new ArrayList<Long>();
                    auditIdList.add(audit_id);
                    Integer objectId = 1;
                    notifyListener.triggerNotification(auditIdList, auditObjectIdList, objectId, new Hashtable(), this.loginId, this.reportId, this.domainName, this.rb, new ArrayList(), objectOUList);
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ModifyCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        boolean connectToOffice365 = false;
        Long userCreationID;
        String hostId;
        Integer reportId;
        Long loginId;
        AdventNetResourceBundle rb;
        String domainName;

        public ModifyCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, Long userCreationID, Long loginId, Integer reportId, String domainName, String hostId, AdventNetResourceBundle rb) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.connectToOffice365 = this.connectToOffice365;
            this.userCreationID = userCreationID;
            this.hostId = hostId;
            this.loginId = loginId;
            this.reportId = reportId;
            AutoReplyAbstractListener.this.isCsvMgmt = true;
            this.rb = rb;
            this.domainName = domainName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * WARNING - bad return control flow
         */
        public String[] getMailDetails(String colName, String uname) {
            String[] stringArray;
            DataSet dataSet = null;
            Connection connection = null;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                String[] value = new String[2];
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMMailBoxObjects"));
                Criteria c = new Criteria(new Column("ADSMUserGeneralDetails", colName), (Object)uname, 0);
                Join join = new Join("ADSMMailBoxObjects", "ADSMUserGeneralDetails", new String[]{"DISTINGUISHED_NAME"}, new String[]{"DISTINGUISHED_NAME"}, 2);
                sq.addJoin(join);
                sq.addSelectColumn(Column.getColumn(null, (String)"*"));
                sq.setCriteria(c);
                dataSet = relationalAPI.executeQuery((Query)sq, connection);
                long countVal = 0L;
                if (dataSet.next()) {
                    String home_mdb = (String)dataSet.getValue("HOME_MDB");
                    String domainname = (String)dataSet.getValue("DOMAIN_NAME");
                    value[0] = ExchangeUtil.getMailboxServer((String)home_mdb, (String)domainname);
                    value[1] = home_mdb;
                }
                stringArray = value;
            }
            catch (Exception e) {
                DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
                catch (Throwable throwable) {
                    DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
                    throw throwable;
                }
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
            return stringArray;
            return null;
        }

        @Override
        public void run() {
            try {
                String[] mandatoryLdapAttrNames = new String[]{"UserPrincipalName", "ObjectId"};
                String[] nativeParamNames = new String[]{"LOGON_NAME", "OBJECT_GUID"};
                StatusUpdater statusUpdater = AutoReplyMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((AutoReplyMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (attr.equalsIgnoreCase("ObjectId")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList userDetails = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit, true);
                AutoReplyAbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(AutoReplyAbstractListener.this.getObjIdList(), AutoReplyAbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
                boolean isAllObjectsSucceeded = true;
                ArrayList attributeListnaming = ReportAttributeHandler.getInstance().getModifiedColumns(this.reportId);
                attributeListnaming.add(AutoReplyAbstractListener.this.getSIDProps());
                attributeListnaming.add(AutoReplyAbstractListener.this.addUserDNProps());
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (int i = 0; !((AutoReplyMgmtStatusUpdator)statusUpdater).isStopped() && i < userDetails.size(); ++i) {
                    Hashtable hashtable = (Hashtable)userDetails.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    String mandatoryAttrVal = "";
                    String nativeParamName = "";
                    boolean foundReqVal = false;
                    block4: for (int m = 0; m < mandatoryLdapAttrNames.length && !foundReqVal; ++m) {
                        String reqLdapName = mandatoryLdapAttrNames[m];
                        for (Hashtable hashtable1 : valuesList) {
                            String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                            String ldapVal = (String)hashtable1.get("ATTRIB_VALUE");
                            if (!reqLdapName.equalsIgnoreCase(ldapName) || ldapVal == null || ldapVal.length() <= 0) continue;
                            mandatoryAttrVal = ldapVal;
                            nativeParamName = nativeParamNames[m];
                            foundReqVal = true;
                            continue block4;
                        }
                    }
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)mandatoryAttrVal, (String)this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String message = "";
                    String[] details = this.getMailDetails(nativeParamName, mandatoryAttrVal);
                    String mailBoxServer = details[0];
                    String mailbox = details[1];
                    Properties exchangeServerDetails = null;
                    if (details[0] != null && details[1] != null) {
                        exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailBoxServer);
                    }
                    ArrayList setAttributeList = new ArrayList();
                    Criteria crit1 = new Criteria(new Column("ADSMUserGeneralDetails", nativeParamName), (Object)mandatoryAttrVal, 0);
                    ArrayList list = DBObjectUtil.getObjects((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID", (ArrayList)attributeListnaming, (Criteria)crit1);
                    if (list != null && list.size() > 0) {
                        Hashtable r = (Hashtable)list.get(0);
                        String dnValue = (String)r.get(1004);
                        String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue);
                        if (!objectOUList.contains(ouName)) {
                            objectOUList.add(ouName);
                        }
                        Thread.sleep(1000L);
                        message = AutoReplyAbstractListener.this.modifyUser((String)r.get("OBJECT_GUID"), nativeParamName, audit_info, auditDataObj, null, exchangeServerDetails, setAttributeList, r);
                    } else {
                        Thread.sleep(1000L);
                        message = this.rb.getString("admp.mgmt.o365.errors.upn_or_objectid_is_must");
                    }
                    if (message == null || message.trim().length() == 0) {
                        message = this.rb.getString("admp.mgmt.common.statmsg.successfully_modified");
                        auditObjectIdList.add(object_id);
                    } else if (!AutoReplyAbstractListener.this.informationStrings.contains(message)) {
                        isAllObjectsSucceeded = false;
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", message);
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(this.rb, prop);
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((AutoReplyMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, this.rb.getString(message));
                    Thread.sleep(3000L);
                }
                AutoReplyAbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                AutoReplyAbstractListener.this.isCompleted = true;
                ((AutoReplyMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((AutoReplyMgmtStatusUpdator)statusUpdater).setHelpLink(AutoReplyAbstractListener.this.getHelpLink(this.reportId));
                }
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    ArrayList<Long> auditIdList = new ArrayList<Long>();
                    auditIdList.add(audit_id);
                    Integer objectId = 1;
                    notifyListener.triggerNotification(auditIdList, auditObjectIdList, objectId, new Hashtable(), this.loginId, this.reportId, this.domainName, this.rb, new ArrayList(), objectOUList);
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

