/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AutoReplyMgmtController;
import com.adventnet.sym.adsm.common.server.usermanagement.IAutoReplyMgmtListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AutoReplyAbstractListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class AutoReplyMgmtListener
extends AutoReplyAbstractListener
implements IAutoReplyMgmtListener {
    int operationId;
    boolean isAuthorised = false;
    String usageLocation = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    ArrayList<String> servicePlanNames = new ArrayList();
    String starttime = "";
    String endtime = "";
    String internalmessage = "";
    String externalmessage = "";
    String domainName = "";
    Boolean dontSend = false;
    Boolean setExternalMessage = false;
    Long loginId;
    AdventNetResourceBundle rb;
    public Hashtable domainVsIds = new Hashtable();
    public Hashtable authorizedDomainOUHash = null;
    protected boolean isLicenseExceeded = false;

    public AutoReplyMgmtListener() {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMWAADServicePlanDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"UNIQUE_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"SERVICE_NAME"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMWAADServicePlanDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    this.servicePlanNames.add((String)r.get("SERVICE_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject performMgmtAction(Integer reportId, JSONArray selectedUsers, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            this.domainVsIds = authObject.getDomainActionMap();
            this.authorizedDomainOUHash = authObject.getDomainOUsMap();
            Long generationId = Long.valueOf(request.getParameter("generationIdd"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)225, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            AutoReplyMgmtController.getInstance().addStatusUpdator(generationId, statusUpdater);
            this.starttime = request.getParameter("starttime");
            this.endtime = request.getParameter("endtime");
            this.internalmessage = URLDecoder.decode(request.getParameter("internalmessage"), "UTF-8");
            this.externalmessage = URLDecoder.decode(request.getParameter("externalmessage"), "UTF-8");
            this.domainName = request.getParameter("domainName");
            this.loginId = loginId;
            this.rb = rb;
            this.baseTableName = "ADSMUserGeneralDetails";
            this.dontSend = Boolean.valueOf(request.getParameter("dontsend"));
            this.setExternalMessage = Boolean.valueOf(request.getParameter("setExternalMessage"));
            this.initAttributeList(reportId);
            Properties p = new Properties();
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                AutoReplyAbstractListener.ModifyAction action = new AutoReplyAbstractListener.ModifyAction(generationId, selectedUsers, loginId, reportId, request.getRemoteHost(), rb, this.domainName);
                action.start();
            } else {
                String domainName = request.getParameter("domainName");
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                AutoReplyAbstractListener.ModifyCSVAction action = new AutoReplyAbstractListener.ModifyCSVAction(generationId, selectedUsers, headerJsonArray, userCreationID, loginId, reportId, domainName, request.getRemoteHost(), rb);
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)225, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", (Object)generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsers);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsers);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    public boolean checkAuthorization(String domainName, Long loginId, String guid) {
        boolean ret;
        block4: {
            ret = false;
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            try {
                if (ouList.size() != 0) {
                    ArrayList<String> attribList = new ArrayList<String>();
                    attribList.add("distinguishedName");
                    guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
                    Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)guid, attribList);
                    String dn = (String)((ArrayList)prop.get("distinguishedName")).get(0);
                    for (int i = 0; i < ouList.size(); ++i) {
                        String distinguishedName = (String)ouList.get(i);
                        String domainDN = DomainUtil.getDefaultNamingContext((String)domainName);
                        if (!distinguishedName.toLowerCase().endsWith(domainDN.toLowerCase()) || !dn.toLowerCase().endsWith(distinguishedName.toLowerCase())) continue;
                        ret = true;
                        break block4;
                    }
                    break block4;
                }
                ret = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Properties setPropperties(String name, String val) {
        Properties p = new Properties();
        p.put("ATTRIB_LDAP_NAME", name);
        p.put("ATTRIB_VALUE", val);
        return p;
    }

    @Override
    public String modifyUser(String guid, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail, Properties exchangeServerDetails, ArrayList setAttributeList, Hashtable r) {
        String result = this.rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.unable_to_load_dll");
        try {
            try {
                String objDN = (String)r.get(1004);
                this.isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
                if (this.isLicenseExceeded) {
                    result = this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.license_error");
                } else if (this.checkAuthorization(this.domainName, this.loginId, guid)) {
                    if (guid.charAt(0) == '{') {
                        guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    }
                    PowerShellCommand powerShellCommand = new PowerShellCommand("Set-MailboxAutoReplyConfiguration");
                    powerShellCommand.setIdentity(guid);
                    if (this.dontSend.booleanValue()) {
                        powerShellCommand.addParameter("AutoReplyState", "Disabled");
                        setAttributeList.add(this.setPropperties("AutoReplyState", "Disabled"));
                    } else {
                        if (this.starttime.length() > 0) {
                            powerShellCommand.addParameter("AutoReplyState", "Scheduled");
                            powerShellCommand.addParameter("StartTime", this.starttime);
                            powerShellCommand.addParameter("EndTime", this.endtime);
                            setAttributeList.add(this.setPropperties("StartTime", this.starttime));
                            setAttributeList.add(this.setPropperties("EndTime", this.endtime));
                            setAttributeList.add(this.setPropperties("AutoReplyState", "Scheduled"));
                        } else {
                            powerShellCommand.addParameter("AutoReplyState", "Enabled");
                            setAttributeList.add(this.setPropperties("AutoReplyState", "Enabled"));
                        }
                        this.internalmessage = this.internalmessage.replaceAll("(?i)%username%", "%name%");
                        String val = FormatClientUtil.getFormatValue(this.internalmessage, r, this.domainName, "");
                        setAttributeList.add(this.setPropperties("InternalMessage", val));
                        val = EscapeUtil.powershellEscape((String)val);
                        powerShellCommand.addParameter("InternalMessage", val);
                        if (this.setExternalMessage.booleanValue()) {
                            this.externalmessage = this.externalmessage.replaceAll("(?i)%username%", "%name%");
                            String val1 = FormatClientUtil.getFormatValue(this.externalmessage, r, this.domainName, "");
                            setAttributeList.add(this.setPropperties("ExternalMessage", val1));
                            powerShellCommand.addParameter("ExternalAudience", "All");
                            val1 = EscapeUtil.powershellEscape((String)val1);
                            powerShellCommand.addParameter("ExternalMessage", val1);
                        } else {
                            powerShellCommand.addParameter("ExternalAudience", "None");
                        }
                    }
                    if (exchangeServerDetails != null) {
                        result = this.rb.getString(ADHandler.executePowershellCMD((String)this.domainName, (Long)this.loginId, (String)objDN, (PowerShellCommand)powerShellCommand, (Properties)exchangeServerDetails));
                    }
                } else {
                    result = this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.not_authorised_user");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString("admp.mgmt.user_mgmt.mgmtname.auto_reply"), uniqueValueNativeParamName, this.tenantId, setAttributeList, new ArrayList(), new ArrayList(), result.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        resProp.put((Object)81, userProp.getProperty("NAME"));
        resProp.put((Object)82, userProp.getProperty("NAME"));
        resProp.put((Object)250, userProp.getProperty("HOME_MDB"));
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(int operationId, String tenantId, HttpServletRequest request) {
        Long actionId = 0L;
        switch (operationId) {
            case 1: {
                actionId = 41102L;
                break;
            }
            case 2: {
                actionId = 41103L;
                break;
            }
            case 3: {
                actionId = 41104L;
                break;
            }
            case 4: {
                actionId = 41105L;
            }
        }
        ArrayList linkedDomainNames = O365MgmtHandler.getLinkedDomainNames((String)tenantId, (int)3);
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, linkedDomainNames, actionId);
    }
}

