/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.RVColumnUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class AutoReplyMgmtUtil {
    public static synchronized long getNewGenerationId(Integer reportId, Long loginId) {
        long generationId = 0L;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row r = new Row("ADSMObjectGenerationDetails");
            r.set("LOGIN_ID", (Object)loginId);
            r.set("REPORT_ID", (Object)reportId);
            r.set("CREATION_TIME", (Object)new Long(System.currentTimeMillis()));
            r.set("STATUS", (Object)1L);
            r.set("REPORT_GENERATION_NAME", (Object)new Date().toString());
            r.set("DESCRIPTION", (Object)"");
            dataObj.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            generationId = (Long)r.get("REPORT_GENERATION_ID");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return generationId;
    }

    public static JSONObject getMgmtActionDetails(Integer reportId) {
        JSONObject mgmtActionDetails = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"O365BulkMgmtOperations", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("O365BulkMgmtOperations", crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("O365BulkMgmtOperations");
                mgmtActionDetails.put("REPORT_ID", (Object)reportId);
                mgmtActionDetails.put("SCRIPT_HANDLER", (Object)((String)r.get("SCRIPT_HANDLER")));
                mgmtActionDetails.put("ACTION_CLASS", (Object)((String)r.get("ACTION_CLASS")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mgmtActionDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportMgmtResult(HttpServletRequest request, HttpServletResponse response) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Locale locale = request.getLocale();
            Hashtable multipleValuesSids = new Hashtable();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            long generationId = Long.parseLong(request.getParameter("generationId"));
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String reportType = request.getParameter("reportType");
            String baseTableName = "ADSMMailBoxObjects";
            JSONObject customParams = new JSONObject(request.getParameter("customParams"));
            ArrayList<Integer> attributeIdList = new ArrayList<Integer>();
            ArrayList resultList = new ArrayList();
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            if (customParams.getBoolean("isCsvMgmt")) {
                baseTableName = "ADSMAUNamingAttributes";
                JSONArray headerJsonArray = customParams.getJSONArray("headerJsonArray");
                ArrayList columns = new ArrayList();
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"));
                for (int i = 0; i < headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String currentHeader = headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                    }
                    columns.add(attributesdetails.get("ATTRIB_COLUMN_NAME"));
                    selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)((String)attributesdetails.get("ATTRIB_COLUMN_NAME"))));
                    attributeIdList.add((Integer)attributesdetails.get("ATTRIB_ID"));
                }
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"));
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
                query.addSelectColumns(selectColumnList);
                Long userCreationID = customParams.getLong("userCreationID");
                Criteria userCreationCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0);
                JSONArray selectedUsersList = customParams.getJSONArray("userIndexes");
                String[] userIndexes = StrUtil.getStringArray((JSONArray)selectedUsersList);
                Criteria userIndexesCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                Criteria msgCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), null, 1);
                msgCrit.and(new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), (Object)"", 1));
                Criteria crit = userCreationCrit.and(userIndexesCrit);
                crit = crit.and(msgCrit);
                query.setCriteria(crit);
                query.addSortColumn(new SortColumn("ADSMAUNamingAttributes", "USER_INDEX", true));
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery((Query)query, connection);
                while (dataSet.next()) {
                    Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                    for (int i = 0; i < attributeIdList.size(); ++i) {
                        resultTable.put(attributeIdList.get(i), dataSet.getValue((String)columns.get(i)));
                    }
                    resultTable.put("MESSAGE", rb.getString((String)dataSet.getValue("CREATION_MESSAGE")));
                    resultList.add(resultTable);
                }
            } else {
                String joinTableName = "ADSMModifyUserResult";
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
                Join join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                query.addJoin(join);
                boolean relationalTypePresent = false;
                ArrayList attributeListProps = ReportAttributeHandler.getInstance().getViewColumn(reportId);
                for (int i = 0; i < attributeListProps.size(); ++i) {
                    Properties attributeProperties = (Properties)attributeListProps.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    attributeIdList.add((Integer)attributeProperties.get("ATTRIB_ID"));
                    if (relationalType.equals(new Integer(1))) {
                        relationalTypePresent = true;
                        continue;
                    }
                    String table = attributeProperties.getProperty("TABLE_NAME");
                    Column column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                    selectColumnList.add(column);
                }
                Column objIdColumn = Column.getColumn((String)baseTableName, (String)"OBJECT_GUID");
                if (!selectColumnList.contains(objIdColumn)) {
                    selectColumnList.add(objIdColumn);
                }
                selectColumnList.add(Column.getColumn((String)joinTableName, (String)"MESSAGE"));
                query.addSelectColumns(selectColumnList);
                query.addSortColumn(new SortColumn(baseTableName, "LOGON_NAME", true));
                Criteria criteria = new Criteria(Column.getColumn((String)joinTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                query.setCriteria(criteria);
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery((Query)query, connection);
                while (dataSet.next()) {
                    Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                    for (int i = 0; i < attributeListProps.size(); ++i) {
                        Properties attributeProperties = (Properties)attributeListProps.get(i);
                        Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                        if (relationalType.equals(new Integer(1))) continue;
                        String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                        if (dataSet.getValue(columnName) == null) continue;
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        HashMap<String, Object> colDetails = new HashMap<String, Object>();
                        colDetails.put("TRIM_SIZE", attributeProperties.get("TRIM_SIZE"));
                        Object columnValue = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), colDetails, new HashMap(), true);
                        resultTable.put(attributeId, columnValue);
                    }
                    String objId = (String)dataSet.getValue("OBJECT_GUID");
                    String message = (String)dataSet.getValue("MESSAGE");
                    if (objId != null) {
                        resultTable.put("OBJECT_GUID", objId);
                    }
                    if (message != null) {
                        resultTable.put("MESSAGE", rb.getString(message));
                    }
                    if (relationalTypePresent) {
                        multipleValuesSids.put(objId, new Hashtable());
                    }
                    resultList.add(resultTable);
                }
            }
            ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributeProps(attributeIdList);
            Properties props = new Properties();
            props.put("ATTRIB_COLUMN_NAME", "STATUS");
            props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
            props.put("ATTRIB_LDAP_NAME", "status");
            props.put("ATTRIB_ID", (Object)100000);
            props.put("RELATIONAL_TYPE", (Object)0);
            attributeList.add(props);
            ReportHandler.getMultipleValues((ArrayList)attributeList, multipleValuesSids);
            AutoReplyMgmtUtil.getCustomizedMultipleValues(multipleValuesSids, reportId, rb);
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "ModifyUser.xml";
            String reportName = request.getParameter("reportName");
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("loginId", loginId);
            inputParams.put("domainTxt", rb.getString("admp.mgmt.fc_layout_common.text_domain"));
            inputParams.put("domain", request.getParameter("domain"));
            inputParams.put("actionTxt", rb.getString("admp.deleg.hdt_deleg.cre_hdt.text_action"));
            inputParams.put("modifyType", rb.getString(reportName));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportFileName = "ADMPReport";
            ReportJRDataSource dataSource = new ReportJRDataSource(resultList, multipleValuesSids, reportType);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, resultList, multipleValuesSids, reportType, request, rb);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    private static void getCustomizedMultipleValues(Hashtable multipleValueSids, Integer reportId, AdventNetResourceBundle rb) {
        try {
            ArrayList attributeList = RVColumnUtil.getViewColumnList((Long)1L, (int)reportId);
            Enumeration e = multipleValueSids.keys();
            while (e.hasMoreElements()) {
                HashMap inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_ID", objectId);
                Hashtable attributeIds = (Hashtable)multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < attributeList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)attributeList.get(index);
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(1)) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

