/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ApplyTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserCreationScriptHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CustomScript;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CreateSingleUser {
    private static Logger out = Logger.getLogger("ADMangLogger");

    /*
     * WARNING - void declaration
     */
    public static Properties addSingleUser(UserBean userBean, HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String hostId = request.getRemoteHost();
        Properties statusProps = null;
        boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
        AddUserHandler userHandler = AddUserHandler.getInstance();
        ArrayList<String> toBeAddedAttributes = new ArrayList<String>();
        AddUserClientUtil.setTobeAddedAttributes(userBean, toBeAddedAttributes, request, false);
        ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
        for (String string : toBeAddedAttributes) {
            Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
            if (attributeList.contains(attributesdetails)) continue;
            attributeList.add(attributesdetails);
        }
        session.setAttribute("attributeList", attributeList);
        DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6001, (DataObject)auditDataObj, attributeList, (AdventNetResourceBundle)rb);
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        audit_info.put("audit_id", audit_id);
        if (isLicenseExceeded) {
            statusProps = new Properties();
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            Hashtable<String, Object> errorTable = new Hashtable<String, Object>();
            errorTable.put("ERROR_MESSAGE", MessageFormat.format(rb.getString("admp.mgmt.comp_mgmt.common.license_exceeded_message"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers")));
            errorTable.put("ERROR_CODE", -1L);
            ArrayList<Hashtable<String, Object>> errorList = new ArrayList<Hashtable<String, Object>>();
            errorList.add(errorTable);
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
        } else {
            Hashtable<String, Object> logProps;
            block194: {
                int i;
                Integer exchType;
                ArrayList userCreationGroupList = (ArrayList)session.getAttribute("userCreationGroupList");
                Long userCreationID = (Long)session.getAttribute("userCreationID");
                String domainName = (String)session.getAttribute("userCreationDomain");
                String container = (String)userBean.get("container");
                Hashtable<String, Object> userDetailsTable = new Hashtable<String, Object>();
                for (String string : toBeAddedAttributes) {
                    userDetailsTable.put(string, userBean.get(string));
                }
                String[] ldapNamesArray = (String[])userBean.get("CUSTOM_ATTRIB_NAME");
                String[] ldapValuesArray = (String[])userBean.get("CUSTOM_ATTRIB_VALUE");
                ArrayList<Properties> customAttribsList = new ArrayList<Properties>();
                if (ldapNamesArray != null && ldapValuesArray != null) {
                    for (int i2 = 0; i2 < ldapNamesArray.length; ++i2) {
                        if (ldapNamesArray[i2].equalsIgnoreCase("") || ldapValuesArray[i2].equalsIgnoreCase("")) continue;
                        Properties properties = new Properties();
                        properties.setProperty("CUSTOM_ATTRIB_NAME", ldapNamesArray[i2]);
                        properties.setProperty("CUSTOM_ATTRIB_VALUE", ldapValuesArray[i2]);
                        customAttribsList.add(properties);
                    }
                }
                String[] confCustomLdapNameArray = (String[])userBean.get("CUSTOM_ATTRIB_LDAP_NAME");
                String[] confCustomLdapValueArray = (String[])userBean.get("CUSTOM_ATTRIB_LDAP_VALUE");
                if (confCustomLdapNameArray != null && confCustomLdapValueArray != null) {
                    for (int i3 = 0; i3 < confCustomLdapNameArray.length; ++i3) {
                        if (confCustomLdapNameArray[i3].equalsIgnoreCase("") || confCustomLdapValueArray[i3].equalsIgnoreCase("")) continue;
                        Properties properties = new Properties();
                        properties.setProperty("CUSTOM_ATTRIB_NAME", confCustomLdapNameArray[i3]);
                        properties.setProperty("CUSTOM_ATTRIB_VALUE", confCustomLdapValueArray[i3]);
                        customAttribsList.add(properties);
                    }
                }
                AddUserHandler.getInstance().setContainer(userCreationID, container);
                Long userIndex = AddUserHandler.getInstance().addUserDetails(userCreationID, userDetailsTable, attributeList, customAttribsList);
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                String userName = "";
                String samAccountName = "";
                String password = "";
                String remoteHomeDir = "";
                String tsRemoteHomeDir = "";
                String profilePath = "";
                String tsProfilePath = "";
                String homeMDB = null;
                String dialIn = null;
                String mailAlias = "";
                String targetAddress = null;
                NativeError error = null;
                boolean usePowershell = false;
                ArrayList propList = new ArrayList();
                ArrayList nonExchPropList = new ArrayList();
                ArrayList<Hashtable> essentialPropList = new ArrayList<Hashtable>();
                ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                ArrayList<String> groupList = new ArrayList<String>();
                ArrayList<String> exProps = new ArrayList<String>();
                boolean iterateNames = AddUserHandler.getInstance().isIterationEnabled(userCreationID);
                if (iterateNames) {
                    AddUserClientUtil.setIteratedUserName(domainName, loginId, userBean, request);
                }
                String upn = (String)userBean.get("LOGON_NAME");
                if (toBeAddedAttributes.contains("ME_MAIL_ALIAS")) {
                    mailAlias = (String)userBean.get("ME_MAIL_ALIAS");
                } else if (toBeAddedAttributes.contains("MAIL_ALIAS")) {
                    mailAlias = (String)userBean.get("MAIL_ALIAS");
                }
                String sipAddress = (String)userBean.get("LCS_SIP_URI");
                String mailEnabled = (String)userBean.get("mailEnabled");
                if ("mailBox".equalsIgnoreCase(mailEnabled)) {
                    String mailServer = (String)userBean.get("MAIL_SERVER");
                    if (mailServer != null && (exchType = ExchangeUtil.getExchangeServerType((String)mailServer)) >= 2007) {
                        usePowershell = true;
                        for (String string : UserMgmtUtil.exchange2007MailBox) {
                            exProps.add(string);
                        }
                    }
                } else if ("mail".equalsIgnoreCase(mailEnabled)) {
                    String adminGroup = (String)userBean.get("MS_EXCH_ADMIN_GROUP");
                    if (userBean.get("TARGET_ADDRESS") != null) {
                        targetAddress = (String)userBean.get("TARGET_ADDRESS");
                    }
                    if (adminGroup != null && (exchType = ExchangeUtil.getAdminGroupType((String)adminGroup)) >= 2007) {
                        usePowershell = true;
                        for (String string : UserMgmtUtil.exchange2007MailEnabled) {
                            exProps.add(string);
                        }
                    }
                }
                String[] customLdapNames = (String[])userBean.get("CUSTOM_ATTRIB_NAME");
                String[] customLdapValues = (String[])userBean.get("CUSTOM_ATTRIB_VALUE");
                Hashtable customTable = new Hashtable();
                for (i = 0; i < customLdapNames.length; ++i) {
                    ArrayList<String> customList = (ArrayList<String>)customTable.get(customLdapNames[i]);
                    if (customList == null) {
                        customList = new ArrayList<String>();
                    }
                    customList.add(customLdapValues[i]);
                    customTable.put(customLdapNames[i], customList);
                }
                for (i = 0; i < confCustomLdapNameArray.length; ++i) {
                    ArrayList<String> customList = (ArrayList<String>)customTable.get(confCustomLdapNameArray[i]);
                    if (customList == null) {
                        customList = new ArrayList<String>();
                    }
                    if (!confCustomLdapValueArray[i].equals("")) {
                        customList.add(confCustomLdapValueArray[i]);
                    }
                    customTable.put(confCustomLdapNameArray[i], customList);
                }
                ArrayList customList = new ArrayList();
                Enumeration enumeration = customTable.keys();
                while (enumeration.hasMoreElements()) {
                    String attributeName = (String)enumeration.nextElement();
                    ArrayList values = (ArrayList)customTable.get(attributeName);
                    if (values == null || values.size() <= 0) continue;
                    ArrayList<String> values2 = new ArrayList<String>();
                    for (Object object : values) {
                        String format = (String)object;
                        format = FormatClientUtil.getFormatValue(domainName, format, userBean, new ArrayList());
                        values2.add(format);
                    }
                    int count = values2.size();
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    hash.put("ATTRIB_LDAP_NAME", attributeName);
                    hash.put("DATA_HANDLER_TYPE", 3L);
                    hash.put("ATTRIB_VALUE_COUNT", new Long(count));
                    if (count == 1) {
                        hash.put("ATTRIB_VALUE", values2.get(0));
                    } else {
                        hash.put("ATTRIB_VALUE", values2);
                    }
                    customList.add(hash);
                }
                Hashtable permissionsTable = UserPermissionsHandler.getInstance().getPermissions(userCreationID, domainName, rb);
                Boolean IS_HOME_DIR_SHARED = (Boolean)permissionsTable.get("IS_HOME_DIR_SHARED");
                Boolean TS_IS_HOME_DIR_SHARED = (Boolean)permissionsTable.get("TS_IS_HOME_DIR_SHARED");
                Properties homeDirShareProps = null;
                Properties tsHomeDirShareProps = null;
                if (IS_HOME_DIR_SHARED.booleanValue()) {
                    homeDirShareProps = AddUserClientUtil.getShareDetails(domainName, userBean, permissionsTable, "homeFolder", customList);
                }
                if (TS_IS_HOME_DIR_SHARED.booleanValue()) {
                    tsHomeDirShareProps = AddUserClientUtil.getShareDetails(domainName, userBean, permissionsTable, "tsHomeFolder", customList);
                }
                for (String string : toBeAddedAttributes) {
                    void var67_100;
                    ArrayList<String> list;
                    String objectClass;
                    String dn;
                    ArrayList list2;
                    String attribValue;
                    Hashtable attributesdetails;
                    if (string.equalsIgnoreCase("FULL_NAME")) {
                        userName = (String)userBean.get(string);
                        userName = CommonUtil.escapeString((String)userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
                        continue;
                    }
                    if (string.equalsIgnoreCase("SAM_ACCOUNT_NAME")) {
                        samAccountName = (String)userBean.get(string);
                        if (samAccountName.length() > 20) {
                            samAccountName = samAccountName.substring(0, 20);
                        }
                        samAccountName = CommonUtil.replaceSAMAccountSplChars((String)samAccountName);
                        userBean.set("SAM_ACCOUNT_NAME", samAccountName, false);
                        continue;
                    }
                    if (string.equalsIgnoreCase("ACCOUNT_STATUS")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        Integer userAccountControl = (Integer)userBean.get(string);
                        if ((userAccountControl & 2) == 2) {
                            attributesdetails.put("ATTRIB_AND_VALUE", new Integer(-33).toString());
                        } else {
                            attributesdetails.put("ATTRIB_AND_VALUE", new Integer(-35).toString());
                        }
                        attributesdetails.put("ATTRIB_VALUE", userAccountControl.toString());
                        modifyList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("MEMBER_OF")) {
                        ArrayList memberList = (ArrayList)userBean.get("MEMBER_OF");
                        if (memberList == null || memberList.isEmpty()) continue;
                        for (Properties properties : memberList) {
                            String dn2 = properties.getProperty("Distinguished_Name");
                            Properties properties2 = UserMgmtUtil.getPropertiesfromDN((String)dn2.trim(), (ArrayList)userCreationGroupList);
                            String rid = null;
                            if (properties2 != null) {
                                rid = (String)properties2.get("objectRID");
                            }
                            if (rid == null || rid.equalsIgnoreCase("513")) continue;
                            groupList.add(dn2);
                        }
                        continue;
                    }
                    if (string.startsWith("TS_")) {
                        if (string.equals("TS_HOME_DIRECTORY") || string.equals("TS_PROFILE_PATH") || string.equals("TS_WORKING_DIRECTORY")) {
                            attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                            attribValue = FormatClientUtil.getFormatValue(domainName, userBean.get(string).toString(), userBean, customList, true);
                            if (string.equalsIgnoreCase("TS_HOME_DIRECTORY")) {
                                tsRemoteHomeDir = attribValue;
                                if (TS_IS_HOME_DIR_SHARED.booleanValue()) {
                                    tsRemoteHomeDir = tsHomeDirShareProps.getProperty("shareRemotePath");
                                }
                            } else if (string.equalsIgnoreCase("TS_PROFILE_PATH")) {
                                tsProfilePath = attribValue;
                            }
                            attributesdetails.put("ATTRIB_VALUE", attribValue);
                            if (attribValue.equals("")) continue;
                            tsList.add(attributesdetails);
                            continue;
                        }
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString();
                        if (attribValue.equals("")) continue;
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        tsList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("PASSWORD_LAST_SET") || string.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attributesdetails.put("ATTRIB_VALUE", userBean.get(string));
                        propList.add(attributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("USER_FLAGS")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attributesdetails.put("ATTRIB_VALUE", userBean.get(string).toString());
                        attributesdetails.put("ATTRIB_AND_VALUE", new Integer(-1).toString());
                        winNTAttributeList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("PASSWORD")) continue;
                    if (string.equalsIgnoreCase("PASSWORD_TYPE")) {
                        String pType = (String)userBean.get(string);
                        if (pType.equalsIgnoreCase("sameasusername")) {
                            password = (String)userBean.get("SAM_ACCOUNT_NAME");
                        } else if (pType.equalsIgnoreCase("generatepassword")) {
                            PasswordPolicy pwdPolicy = new PasswordPolicy();
                            pwdPolicy.setPolicyDetails();
                            password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
                        } else {
                            password = (String)userBean.get("PASSWORD");
                        }
                        userBean.set("PASSWORD", password, false);
                        continue;
                    }
                    if (string.equalsIgnoreCase("REQUIRE_AUTH") || string.equalsIgnoreCase("ME_REQUIRE_AUTH") || string.equalsIgnoreCase("USE_DEFAULT_STORAGE") || string.equalsIgnoreCase("LCS_ENABLED") || string.equalsIgnoreCase("LCS_INTERNET_ACCESS") || string.equalsIgnoreCase("LCS_FEDERATION_ENABLED")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attributesdetails.put("ATTRIB_VALUE", userBean.get(string).toString().toUpperCase());
                        propList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString().toUpperCase();
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        if (!attribValue.equalsIgnoreCase("TRUE")) continue;
                        Hashtable<String, Object> showInAddressBook = new Hashtable<String, Object>();
                        showInAddressBook.put("ATTRIB_LDAP_NAME", "showInAddressBook");
                        showInAddressBook.put("ATTRIB_VALUE", "");
                        showInAddressBook.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        showInAddressBook.put("DW_CONTROL_CODE", new Long(1L));
                        showInAddressBook.put("DATA_HANDLER_TYPE", new Long(1L));
                        propList.add(showInAddressBook);
                        continue;
                    }
                    if (string.equalsIgnoreCase("SEND_ON_BEHALF")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        ArrayList list22 = (ArrayList)userBean.get(string);
                        ArrayList<String> toBeSetList = new ArrayList<String>();
                        if (!list22.isEmpty() && list22.size() == 1) {
                            attributesdetails.put("ATTRIB_VALUE_COUNT", 1);
                            Properties properties = (Properties)list22.get(0);
                            String string2 = properties.getProperty("Distinguished_Name").trim();
                            attributesdetails.put("ATTRIB_VALUE", string2);
                        } else if (!list22.isEmpty() && list22.size() > 1) {
                            for (Properties properties : list22) {
                                String dn4 = properties.getProperty("Distinguished_Name").trim();
                                toBeSetList.add(dn4);
                            }
                            attributesdetails.put("ATTRIB_VALUE_COUNT", toBeSetList.size());
                            attributesdetails.put("ATTRIB_VALUE", toBeSetList);
                        }
                        propList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        Hashtable dLMemRejectAttributesdetails = (Hashtable)attributesdetails.clone();
                        list2 = (ArrayList)userBean.get(string);
                        ArrayList<String> dLMemRejectList = new ArrayList<String>();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (!list2.isEmpty()) {
                            for (Properties properties3 : list2) {
                                dn = properties3.getProperty("Distinguished_Name").trim();
                                objectClass = UserMgmtUtil.getMailRecipientObjectClass((String)dn);
                                if (objectClass.equalsIgnoreCase("group")) {
                                    dLMemRejectList.add(dn);
                                    continue;
                                }
                                arrayList.add(dn);
                            }
                        }
                        if (!arrayList.isEmpty()) {
                            if (arrayList.size() == 1) {
                                attributesdetails.put("ATTRIB_VALUE_COUNT", 1);
                                attributesdetails.put("ATTRIB_VALUE", arrayList.get(0));
                            } else if (list2.size() > 1) {
                                attributesdetails.put("ATTRIB_VALUE_COUNT", arrayList.size());
                                attributesdetails.put("ATTRIB_VALUE", arrayList);
                            }
                            propList.add(attributesdetails);
                        }
                        if (dLMemRejectList.isEmpty()) continue;
                        dLMemRejectAttributesdetails.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
                        if (dLMemRejectList.size() == 1) {
                            dLMemRejectAttributesdetails.put("ATTRIB_VALUE_COUNT", 1);
                            dLMemRejectAttributesdetails.put("ATTRIB_VALUE", dLMemRejectList.get(0));
                        } else if (dLMemRejectList.size() > 1) {
                            dLMemRejectAttributesdetails.put("ATTRIB_VALUE_COUNT", dLMemRejectList.size());
                            dLMemRejectAttributesdetails.put("ATTRIB_VALUE", dLMemRejectList);
                        }
                        propList.add(dLMemRejectAttributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(dLMemRejectAttributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        Hashtable dLMemSubmitAttributesdetails = (Hashtable)attributesdetails.clone();
                        list2 = (ArrayList)userBean.get(string);
                        ArrayList<String> dLMemSubmitList = new ArrayList<String>();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (!list2.isEmpty()) {
                            for (Properties properties4 : list2) {
                                dn = properties4.getProperty("Distinguished_Name").trim();
                                objectClass = UserMgmtUtil.getMailRecipientObjectClass((String)dn);
                                if (objectClass.equalsIgnoreCase("group")) {
                                    dLMemSubmitList.add(dn);
                                    continue;
                                }
                                arrayList.add(dn);
                            }
                        }
                        if (!arrayList.isEmpty()) {
                            if (arrayList.size() == 1) {
                                attributesdetails.put("ATTRIB_VALUE_COUNT", 1);
                                attributesdetails.put("ATTRIB_VALUE", arrayList.get(0));
                            } else if (list2.size() > 1) {
                                attributesdetails.put("ATTRIB_VALUE_COUNT", arrayList.size());
                                attributesdetails.put("ATTRIB_VALUE", arrayList);
                            }
                            propList.add(attributesdetails);
                        }
                        if (dLMemSubmitList.isEmpty()) continue;
                        dLMemSubmitAttributesdetails.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
                        if (dLMemSubmitList.size() == 1) {
                            dLMemSubmitAttributesdetails.put("ATTRIB_VALUE_COUNT", 1);
                            dLMemSubmitAttributesdetails.put("ATTRIB_VALUE", dLMemSubmitList.get(0));
                        } else if (dLMemSubmitList.size() > 1) {
                            dLMemSubmitAttributesdetails.put("ATTRIB_VALUE_COUNT", dLMemSubmitList.size());
                            dLMemSubmitAttributesdetails.put("ATTRIB_VALUE", dLMemSubmitList);
                        }
                        propList.add(dLMemSubmitAttributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(dLMemSubmitAttributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("PROTOCOL_SETTINGS")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        list = (ArrayList<String>)userBean.get(string);
                        attributesdetails.put("ATTRIB_VALUE_COUNT", list.size());
                        attributesdetails.put("ATTRIB_VALUE", list);
                        propList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("PRIMARY_GROUP_ID")) {
                        ArrayList list3;
                        Properties properties;
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        String value = (String)userBean.get(string);
                        String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
                        if (value == null || value.equals("")) continue;
                        if (!value.equals("513") && (properties = UserMgmtUtil.getPropertiesfromRID((String)value, (ArrayList)(list3 = (ArrayList)session.getAttribute("userCreationGroupList")), (String)defaultNamingContext)) != null) {
                            String groupDN = properties.getProperty("Distinguished_Name");
                            groupList.add(groupDN);
                        }
                        attributesdetails.put("ATTRIB_VALUE", value);
                        propList.add(attributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equals("MAIL_BOX_STORE")) {
                        String mailBoxStore = (String)userBean.get(string);
                        if (mailEnabled.equalsIgnoreCase("mailBox") && mailBoxStore != null && !mailBoxStore.equals("")) {
                            homeMDB = mailBoxStore;
                        }
                        Hashtable attributesdetails2 = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        String attribValue2 = userBean.get(string).toString();
                        if (attribValue2.equals("")) continue;
                        attributesdetails2.put("ATTRIB_VALUE", attribValue2);
                        propList.add(attributesdetails2);
                        continue;
                    }
                    if (string.equals("HOME_DIRECTORY") || string.equals("PROFILE_PATH")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = FormatClientUtil.getFormatValue(domainName, userBean.get(string).toString(), userBean, customList, true);
                        if (string.equalsIgnoreCase("HOME_DIRECTORY")) {
                            remoteHomeDir = attribValue;
                            if (IS_HOME_DIR_SHARED.booleanValue()) {
                                remoteHomeDir = homeDirShareProps.getProperty("shareRemotePath");
                            }
                        } else if (string.equalsIgnoreCase("PROFILE_PATH")) {
                            profilePath = attribValue;
                        }
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        continue;
                    }
                    if (string.equals("MS_EXCH_ADMIN_GROUP")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString();
                        attribValue = attribValue + "/cn=Recipients/cn=" + mailAlias;
                        attributesdetails.put("ATTRIB_LDAP_NAME", "legacyExchangeDN");
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        if (usePowershell && !exProps.contains(string)) {
                            nonExchPropList.add(attributesdetails);
                        }
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)"INTERNET_ENCODING");
                        attributesdetails.put("ATTRIB_VALUE", "1310720");
                        propList.add(attributesdetails);
                        if (usePowershell && !exProps.contains(string)) {
                            nonExchPropList.add(attributesdetails);
                        }
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)"MAPI_RECIPIENT");
                        attributesdetails.put("ATTRIB_VALUE", "FALSE");
                        propList.add(attributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equals("MAIL_SERVER")) {
                        String legacyDN;
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString();
                        if (attribValue.equals("")) continue;
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        if (usePowershell && !exProps.contains(string)) {
                            nonExchPropList.add(attributesdetails);
                        }
                        if ((legacyDN = ExchangeUtil.getExchangeAdminGroup((String)domainName, (String)attribValue)).equalsIgnoreCase("")) continue;
                        legacyDN = legacyDN + "/cn=Recipients/cn=";
                        legacyDN = legacyDN + mailAlias;
                        Hashtable<String, Object> legacyTable = new Hashtable<String, Object>();
                        legacyTable.put("ATTRIB_LDAP_NAME", "legacyExchangeDN");
                        legacyTable.put("ATTRIB_VALUE", legacyDN);
                        legacyTable.put("DATA_HANDLER_TYPE", 3L);
                        legacyTable.put("ATTRIB_VALUE_COUNT", 1L);
                        propList.add(legacyTable);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("MANAGER") || string.equalsIgnoreCase("FORWARD_TO")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString();
                        if (attribValue.equals("")) continue;
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        if (!usePowershell || exProps.contains(string)) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("EMAIL_ADDRESS") || string.equalsIgnoreCase("SIMPLE_DISPLAY_NAME")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        attribValue = userBean.get(string).toString();
                        if ((attribValue = FormatClientUtil.getFormatValue(domainName, attribValue, userBean, customList)).equals("")) continue;
                        attributesdetails.put("ATTRIB_VALUE", attribValue);
                        propList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("ALLOW_DIALIN")) {
                        attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        Object object = userBean.get(string);
                        String value = object.toString();
                        if (value == null || value.equals("") || value.equals("-1")) continue;
                        if (value.equalsIgnoreCase("1")) {
                            value = "true";
                            dialIn = "allow";
                        } else if (value.equalsIgnoreCase("0")) {
                            value = "false";
                            dialIn = "deny";
                        }
                        attributesdetails.put("ATTRIB_VALUE", value.toUpperCase());
                        propList.add(attributesdetails);
                        if (!usePowershell) continue;
                        nonExchPropList.add(attributesdetails);
                        continue;
                    }
                    if (string.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES")) {
                        ArrayList EMAIL_PROXY_ADDRESSES = (ArrayList)userBean.get("EMAIL_PROXY_ADDRESSES");
                        if (!mailEnabled.equalsIgnoreCase("mailBox") && !mailEnabled.equalsIgnoreCase("mail")) continue;
                        list = new ArrayList<String>();
                        for (Object object : EMAIL_PROXY_ADDRESSES) {
                            String string4 = (String)object;
                            string4 = FormatClientUtil.getFormatValue(domainName, string4, userBean, customList);
                            list.add(string4);
                        }
                        if ("mail".equalsIgnoreCase(mailEnabled)) {
                            list.add((String)userBean.get("TARGET_ADDRESS"));
                        }
                        if (sipAddress != null && !sipAddress.equals("")) {
                            String sip = FormatClientUtil.getFormatValue(domainName, sipAddress, userBean, customList);
                            list.add(sip);
                        }
                        Hashtable proxyTable = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                        if (list.size() == 1) {
                            proxyTable.put("ATTRIB_VALUE_COUNT", 1L);
                            proxyTable.put("ATTRIB_VALUE", list.get(0).toString());
                        } else {
                            proxyTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            proxyTable.put("ATTRIB_VALUE", list);
                        }
                        if (!usePowershell || (String)userBean.get("MS_EXCH_EXCLUDE_POLICIES") != "") {
                            propList.add(proxyTable);
                        }
                        nonExchPropList.add(proxyTable);
                        continue;
                    }
                    attributesdetails = userHandler.getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                    attribValue = userBean.get(string).toString();
                    if ((attribValue = FormatClientUtil.getFormatValue(domainName, attribValue, userBean, customList)).equals("")) continue;
                    attributesdetails.put("ATTRIB_VALUE", attribValue);
                    String[] arr$ = UserMgmtUtil.essentialAttrib;
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var67_100 < len$) {
                        String attr = arr$[var67_100];
                        if (string.equals(attr)) {
                            essentialPropList.add(attributesdetails);
                            break;
                        }
                        ++var67_100;
                    }
                    if (essentialPropList.contains(attributesdetails)) continue;
                    propList.add(attributesdetails);
                    if (!usePowershell || exProps.contains(string)) continue;
                    nonExchPropList.add(attributesdetails);
                }
                String distinguishedName = "CN=" + userName + "," + container;
                if (!toBeAddedAttributes.contains("EMAIL_PROXY_ADDRESSES") && sipAddress != null && !sipAddress.equals("")) {
                    String sip = FormatClientUtil.getFormatValue(domainName, sipAddress, userBean, customList);
                    Hashtable<String, Object> proxyTable = new Hashtable<String, Object>();
                    proxyTable.put("ATTRIB_LDAP_NAME", "proxyAddresses");
                    proxyTable.put("DATA_HANDLER_TYPE", 3L);
                    proxyTable.put("ATTRIB_VALUE_COUNT", 1L);
                    proxyTable.put("ATTRIB_VALUE", sip);
                    proxyTable.put("DW_CONTROL_CODE", new Long(3L));
                    if (!usePowershell || (String)userBean.get("MS_EXCH_EXCLUDE_POLICIES") != "") {
                        propList.add(proxyTable);
                    }
                    nonExchPropList.add(proxyTable);
                }
                logProps = new Hashtable<String, Object>();
                logProps.put(rb.getString("admp.common.attrib_disp_name.dn_domain_name"), domainName);
                logProps.put(rb.getString("admp.common.attrib_disp_name.container_name"), container);
                logProps.put(rb.getString("admp.common.attrib_disp_name.user_name"), userName);
                logProps.put(rb.getString("admp.common.attrib_disp_name.sam_name"), samAccountName);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.properties"), propList);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.exchange_properties"), nonExchPropList);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.update_properties"), modifyList);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_properties"), tsList);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.winnt_properties"), winNTAttributeList);
                logProps.put(rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.groups"), groupList);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir"), remoteHomeDir);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir"), tsRemoteHomeDir);
                logProps.put(rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path"), profilePath);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path"), profilePath);
                logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.custom_properties"), customList);
                if (homeMDB != null) {
                    logProps.put("Home MDB", homeMDB);
                }
                if (dialIn != null && !dialIn.equals("")) {
                    logProps.put(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in"), dialIn);
                }
                Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (Long)userIndex, (String)samAccountName, (String)domainName, (DataObject)auditDataObj);
                audit_info.put("object_id", object_id);
                try {
                    NativeError nativeError;
                    String objectDN;
                    Properties properties;
                    NativeError nativeError2;
                    String localPath;
                    String shareName;
                    String serverName;
                    Long aceType;
                    String objectDN2;
                    Properties properties3;
                    ArrayList shareAceList;
                    ArrayList aceList;
                    String primaryGroupId;
                    ArrayList memberList;
                    Boolean lcsEnabled = (Boolean)userBean.get("LCS_ENABLED");
                    if (lcsEnabled.booleanValue()) {
                        for (int i4 = 0; i4 < propList.size(); ++i4) {
                            Hashtable hash = (Hashtable)propList.get(i4);
                            String string = (String)hash.get("ATTRIB_LDAP_NAME");
                            if (!string.startsWith("msRTCSIP")) continue;
                            propList.remove(i4);
                            --i4;
                        }
                    }
                    out.log(Level.INFO, "Create User Properties:" + logProps + " usePowershell :: " + usePowershell);
                    error = usePowershell ? ADHandler.addUser((String)domainName, (Long)loginId, (String)container, (String)userName, (String)samAccountName, (String)password, nonExchPropList, modifyList, tsList, winNTAttributeList, groupList, essentialPropList, null, (String)dialIn, (String)upn) : ADHandler.addUser((String)domainName, (Long)loginId, (String)container, (String)userName, (String)samAccountName, (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, essentialPropList, (String)homeMDB, (String)dialIn, (String)upn);
                    statusProps = AddUserErrorHandler.getSingleUserErrorMessage((AdventNetResourceBundle)rb, (String)domainName, (String)userName, (String)samAccountName, (String)CommonUtil.escapeDN((String)container), groupList, (NativeError)error, (String)rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.success_created_user"));
                    String CREATION_STATUS = statusProps.getProperty("CREATION_STATUS");
                    if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) break block194;
                    ArrayList mbrRights = (ArrayList)permissionsTable.get("MBR_ACL");
                    if (mbrRights != null && !mbrRights.isEmpty()) {
                        for (Object object : mbrRights) {
                            Properties properties4;
                            properties4 = (Properties)object;
                            String objectDN3 = properties4.getProperty("DN");
                            ArrayList list = UserPermissionsUtil.searchSIDs((String)"DN_STRING", (String)objectDN3, (String)domainName);
                            if (list.size() == 0) continue;
                            Properties sidProp = (Properties)list.get(0);
                            String objectSID = sidProp.getProperty("SID_STRING");
                            if (objectDN3.equalsIgnoreCase("%userName%")) {
                                if (!usePowershell) {
                                    properties4.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                    continue;
                                }
                                properties4.put("DN", objectSID);
                                continue;
                            }
                            if (!usePowershell) {
                                properties4.put("DN", CommonUtil.escapeDN((String)objectDN3));
                                continue;
                            }
                            properties4.put("DN", objectSID);
                        }
                        if (homeMDB != null && !usePowershell) {
                            NativeError nativeError3 = ADHandler.setMailBoxPermission((String)domainName, (Long)loginId, (ArrayList)mbrRights, (String)distinguishedName);
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError3, (String)"mailBoxRights");
                        }
                    }
                    String string = "(&(objectClass=user)(objectCategory=user)(sAMAccountName=" + samAccountName + "))";
                    if (!customList.isEmpty()) {
                        NativeError customError = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)container, (String)string, null, null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                        AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)rb, (Properties)statusProps, (NativeError)customError, (String)string);
                    }
                    if (usePowershell) {
                        String message;
                        Properties exchangeServerDetails;
                        if ("mailBox".equalsIgnoreCase(mailEnabled) && homeMDB != null) {
                            exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)((String)userBean.get("MAIL_SERVER")));
                            message = ADHandler.createMailBox2007((String)domainName, (long)loginId, (String)distinguishedName, (String)mailAlias, (String)homeMDB, (Properties)exchangeServerDetails, (ArrayList)mbrRights);
                            if (message.length() != 0) {
                                request.setAttribute("rusMessage", (Object)(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.legacy_mailbox_created"), rb.getString(message)) + rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot")));
                            }
                            MgmtUtil.updateMailServer(propList, exchangeServerDetails);
                        } else if ("mail".equalsIgnoreCase(mailEnabled) && targetAddress != null) {
                            exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)domainName, (String)((String)userBean.get("MS_EXCH_ADMIN_GROUP")), (Long)loginId);
                            message = ADHandler.createMailEnabled2007((String)domainName, (long)loginId, (String)distinguishedName, (String)mailAlias, (String)targetAddress, (Properties)exchangeServerDetails);
                            if (message.length() != 0) {
                                request.setAttribute("rusMessage", (Object)(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mail_enabled"), rb.getString(message)) + rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot")));
                            }
                        }
                        String string5 = "(&(objectClass=user)(objectCategory=user)(sAMAccountName=" + samAccountName + "))";
                        NativeError exchPropError = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)container, (String)string5, null, null, propList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                        AddUserErrorHandler.setSingleUserExchangeAttributesError((AdventNetResourceBundle)rb, (Properties)statusProps, (NativeError)exchPropError, (String)string5);
                        if (!customList.isEmpty()) {
                            NativeError customError = ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)container, (String)string5, null, null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                            AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)rb, (Properties)statusProps, (NativeError)customError, (String)string5);
                        }
                    }
                    if ((memberList = (ArrayList)userBean.get("MEMBER_OF")) == null) {
                        memberList = new ArrayList();
                    }
                    if ((primaryGroupId = (String)userBean.get("PRIMARY_GROUP_ID")) == null) {
                        primaryGroupId = "513";
                    }
                    boolean isDifferentPG = false;
                    if (!primaryGroupId.equals("513")) {
                        isDifferentPG = true;
                    }
                    boolean isDomainUserAvail = false;
                    for (Properties props : memberList) {
                        String objectRID = props.getProperty("objectRID");
                        if (!objectRID.equals("513")) continue;
                        isDomainUserAvail = true;
                    }
                    if (!isDomainUserAvail && isDifferentPG) {
                        ArrayList<Properties> list = new ArrayList<Properties>();
                        Properties p = new Properties();
                        p.put("ATTRIB_VALUE", distinguishedName);
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                        p.put("ATTRIB_LDAP_NAME", "member");
                        p.put("DW_CONTROL_CODE", new Long(4L));
                        list.add(p);
                        ArrayList list2 = (ArrayList)session.getAttribute("userCreationGroupList");
                        String groupSid = UserMgmtUtil.getGroupSIDfromRID((String)"513", (ArrayList)list2);
                        out.log(Level.INFO, "Removing Group Domain Users from the Member Of");
                        if (groupSid != null) {
                            try {
                                ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)groupSid, (String)distinguishedName, list, null);
                            }
                            catch (Exception e) {
                                out.log(Level.INFO, "Error in Removing Group : Domain Users");
                            }
                        }
                    }
                    if (!remoteHomeDir.equals("") && remoteHomeDir.startsWith("\\")) {
                        try {
                            aceList = (ArrayList)permissionsTable.get("HOME_DIR_ACL");
                            for (Object object : aceList) {
                                Properties properties2 = (Properties)object;
                                String objectDN22 = properties2.getProperty("DN");
                                if (!objectDN22.equalsIgnoreCase("%userName%")) continue;
                                properties2.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                            }
                            if (IS_HOME_DIR_SHARED.booleanValue() && remoteHomeDir.endsWith("$")) {
                                remoteHomeDir = remoteHomeDir.substring(0, remoteHomeDir.length() - 1);
                            }
                            Boolean HD_INHERIT_PERMISSIONS = (Boolean)permissionsTable.get("HD_INHERIT_PERMISSIONS");
                            long inheritLong = 0x20000000L;
                            if (!HD_INHERIT_PERMISSIONS.booleanValue()) {
                                inheritLong = 0x80000000L;
                            }
                            NativeError nativeError3 = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)remoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)aceList, (long)inheritLong);
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError3, (String)"homeDir");
                            if (IS_HOME_DIR_SHARED.booleanValue() && nativeError3.getError((Object)domainName) == null) {
                                shareAceList = (ArrayList)permissionsTable.get("SHARE_ACL");
                                for (Object object : shareAceList) {
                                    properties3 = (Properties)object;
                                    objectDN2 = properties3.getProperty("DN");
                                    if (objectDN2.equalsIgnoreCase("%userName%")) {
                                        properties3.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                    } else {
                                        properties3.put("DN", CommonUtil.escapeDN((String)objectDN2));
                                    }
                                    aceType = (Long)properties3.get("ACE_TYPE");
                                    if (aceType.equals(0L)) {
                                        properties3.put("ACCESS_TYPE", (Object)2L);
                                    } else {
                                        properties3.put("ACCESS_TYPE", (Object)3L);
                                    }
                                    properties3.remove("ACE_TYPE");
                                    properties3.remove("OBJECT_NAME");
                                    properties3.remove("ACE_TYPE_STRING");
                                    properties3.remove("ACCESS_MASK_STRING");
                                    properties3.put("TRUSTEE_TYPE", (Object)1L);
                                }
                                serverName = homeDirShareProps.getProperty("serverName");
                                shareName = homeDirShareProps.getProperty("shareName");
                                localPath = homeDirShareProps.getProperty("localPath");
                                nativeError2 = ADHandler.shareFolder((String)domainName, (Long)loginId, (String)serverName, (String)shareName, (String)localPath, (ArrayList)shareAceList);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError2, (String)"homeDirShare");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!tsRemoteHomeDir.equals("") && tsRemoteHomeDir.startsWith("\\\\")) {
                        try {
                            aceList = (ArrayList)permissionsTable.get("TS_HOME_DIR_ACL");
                            for (Object object : aceList) {
                                properties = (Properties)object;
                                objectDN = properties.getProperty("DN");
                                if (!objectDN.equalsIgnoreCase("%userName%")) continue;
                                properties.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                            }
                            if (TS_IS_HOME_DIR_SHARED.booleanValue() && tsRemoteHomeDir.endsWith("$")) {
                                tsRemoteHomeDir = tsRemoteHomeDir.substring(0, tsRemoteHomeDir.length() - 1);
                            }
                            Boolean TS_HD_INHERIT_PERMISSIONS = (Boolean)permissionsTable.get("TS_HD_INHERIT_PERMISSIONS");
                            long inheritLong = 0x20000000L;
                            if (!TS_HD_INHERIT_PERMISSIONS.booleanValue()) {
                                inheritLong = 0x80000000L;
                            }
                            NativeError nativeError4 = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)tsRemoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)aceList, (long)inheritLong);
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError4, (String)"tsHomeDir");
                            if (TS_IS_HOME_DIR_SHARED.booleanValue() && nativeError4.getError((Object)domainName) == null) {
                                shareAceList = (ArrayList)permissionsTable.get("TS_SHARE_ACL");
                                for (Object object : shareAceList) {
                                    properties3 = (Properties)object;
                                    objectDN2 = properties3.getProperty("DN");
                                    if (objectDN2.equalsIgnoreCase("%userName%")) {
                                        properties3.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                    } else {
                                        properties3.put("DN", CommonUtil.escapeDN((String)objectDN2));
                                    }
                                    aceType = (Long)properties3.get("ACE_TYPE");
                                    if (aceType.equals(0L)) {
                                        properties3.put("ACCESS_TYPE", (Object)2L);
                                    } else {
                                        properties3.put("ACCESS_TYPE", (Object)3L);
                                    }
                                    properties3.remove("ACE_TYPE");
                                    properties3.remove("OBJECT_NAME");
                                    properties3.remove("ACE_TYPE_STRING");
                                    properties3.remove("ACCESS_MASK_STRING");
                                    properties3.put("TRUSTEE_TYPE", (Object)1L);
                                }
                                serverName = tsHomeDirShareProps.getProperty("serverName");
                                shareName = tsHomeDirShareProps.getProperty("shareName");
                                localPath = tsHomeDirShareProps.getProperty("localPath");
                                nativeError2 = ADHandler.shareFolder((String)domainName, (Long)loginId, (String)serverName, (String)shareName, (String)localPath, (ArrayList)shareAceList);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError2, (String)"tsHomeDirShare");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!profilePath.equals("") && profilePath.startsWith("\\\\")) {
                        try {
                            aceList = (ArrayList)permissionsTable.get("PROF_DIR_ACL");
                            for (Object object : aceList) {
                                properties = (Properties)object;
                                objectDN = properties.getProperty("DN");
                                if (!objectDN.equalsIgnoreCase("%userName%")) continue;
                                properties.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                            }
                            if (profilePath.endsWith("$")) {
                                profilePath = profilePath.substring(0, profilePath.length() - 1);
                            }
                            Boolean CREATE_PROFILE = (Boolean)permissionsTable.get("CREATE_PROFILE");
                            Boolean PROF_INHERIT_PERMISSIONS = (Boolean)permissionsTable.get("PROF_INHERIT_PERMISSIONS");
                            long inheritLong = 0x20000000L;
                            if (!PROF_INHERIT_PERMISSIONS.booleanValue()) {
                                inheritLong = 0x80000000L;
                            }
                            if (CREATE_PROFILE.booleanValue()) {
                                nativeError = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)aceList, (long)inheritLong);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError, (String)"profilePath");
                                Boolean VISTA_PROFILE = (Boolean)permissionsTable.get("VISTA_PROFILE");
                                if (VISTA_PROFILE.booleanValue()) {
                                    profilePath = profilePath + ".v2";
                                    nativeError = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)aceList, (long)inheritLong);
                                    AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError, (String)"vistaprofilePath");
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!tsProfilePath.equals("") && tsProfilePath.startsWith("\\\\")) {
                        try {
                            aceList = (ArrayList)permissionsTable.get("TS_PROF_DIR_ACL");
                            for (Object object : aceList) {
                                properties = (Properties)object;
                                objectDN = properties.getProperty("DN");
                                if (!objectDN.equalsIgnoreCase("%userName%")) continue;
                                properties.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                            }
                            if (tsProfilePath.endsWith("$")) {
                                tsProfilePath = tsProfilePath.substring(0, tsProfilePath.length() - 1);
                            }
                            Boolean TS_CREATE_PROFILE = (Boolean)permissionsTable.get("TS_CREATE_PROFILE");
                            Boolean TS_PROF_INHERIT_PERMISSIONS = (Boolean)permissionsTable.get("TS_PROF_INHERIT_PERMISSIONS");
                            long inheritLong = 0x20000000L;
                            if (!TS_PROF_INHERIT_PERMISSIONS.booleanValue()) {
                                inheritLong = 0x80000000L;
                            }
                            if (TS_CREATE_PROFILE.booleanValue()) {
                                nativeError = ADHandlerForMgmt.createFolder((String)domainName, (Long)loginId, (String)tsProfilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)aceList, (long)inheritLong);
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)rb, (String)domainName, (Properties)statusProps, (NativeError)nativeError, (String)"tsProfilePath");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (homeMDB != null && !homeMDB.equalsIgnoreCase("") && !usePowershell) {
                        request.setAttribute("rusMessage", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mailboxes_get_reflected_according_update_interval_RUS"));
                    }
                    Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
                    Boolean isCustomScriptEnabled = UserCreationScriptHandler.isCustomScriptEnabled((Long)templateId);
                    String scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
                    if (!isCustomScriptEnabled.booleanValue()) break block194;
                    try {
                        CustomScript customScript;
                        Hashtable customScriptTable = UserCreationScriptHandler.getCustomScriptProps((Long)templateId);
                        String command = (String)customScriptTable.get("SCRIPT_COMMAND");
                        if (command != null && !command.equals("")) {
                            command = FormatClientUtil.getFormatValue(domainName, command, userBean, customList);
                        }
                        Boolean runScript = false;
                        Boolean ignoreWarning = (Boolean)customScriptTable.get("IGNORE_WARNING");
                        Long timeOut = 5L;
                        if (command != null && !command.equals("") && !statusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                            if (ignoreWarning.booleanValue()) {
                                runScript = true;
                            } else if (!statusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("WARNING")) {
                                runScript = true;
                            }
                        }
                        if (runScript.booleanValue() && (scriptResult = (customScript = new CustomScript(rb, timeOut, command)).runThread()).indexOf("All rights reserved.") != -1) {
                            scriptResult.substring(scriptResult.indexOf("All rights reserved.") + 20);
                        }
                    }
                    catch (Exception e) {
                        scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_script_execution");
                        e.printStackTrace();
                    }
                    statusProps.setProperty("SCRIPT_MESSAGE", MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.custom_script_result"), scriptResult));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String status = statusProps.getProperty("STATUS_MESSAGE");
            ArrayList message = (ArrayList)statusProps.get("CREATION_MESSAGE");
            if (status == null) {
                status = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_in_creating_user");
            }
            if (message != null && !message.isEmpty()) {
                for (int i = 0; i < message.size(); ++i) {
                    Hashtable hashtable = (Hashtable)message.get(i);
                    status = rb.getString((String)hashtable.get("ERROR_MESSAGE")) + hashtable.get("NATIVE_ERROR_MESSAGE") + rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + ":" + hashtable.get("ERROR_CODE");
                }
            }
            audit_info.put("error_msg", status);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            TechAuditAPI.getInstance().auditLogs(loginId, logProps, status, rb.getString("admp.workflow.requesters.modify_requester.user_creation"), rb);
            out.log(Level.INFO, "Single User - Created " + statusProps);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        return statusProps;
    }

    public static Long createAddSingleUserRequest(UserBean userBean, HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long requestId = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AddUserHandler userHandler = AddUserHandler.getInstance();
        ArrayList<String> toBeAddedAttributes = new ArrayList<String>();
        AddUserClientUtil.setTobeAddedAttributes(userBean, toBeAddedAttributes, request, false);
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        String domainName = (String)session.getAttribute("userCreationDomain");
        String container = (String)userBean.get("container");
        ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
        String attributeListString = "";
        for (String string : toBeAddedAttributes) {
            Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
            if (attributeList.contains(attributesdetails)) continue;
            attributeList.add(attributesdetails);
            attributeListString = attributeListString + attributesdetails.get("ATTRIB_ID") + ";";
        }
        session.setAttribute("attributeList", attributeList);
        Hashtable<String, Object> userDetailsTable = new Hashtable<String, Object>();
        for (String string : toBeAddedAttributes) {
            userDetailsTable.put(string, userBean.get(string));
        }
        String[] ldapNamesArray = (String[])userBean.get("CUSTOM_ATTRIB_NAME");
        String[] ldapValuesArray = (String[])userBean.get("CUSTOM_ATTRIB_VALUE");
        ArrayList<Properties> customAttribsList = new ArrayList<Properties>();
        if (ldapNamesArray != null) {
            for (int i = 0; i < ldapNamesArray.length; ++i) {
                if (ldapNamesArray[i].equalsIgnoreCase("") || ldapValuesArray[i].equalsIgnoreCase("")) continue;
                Properties properties = new Properties();
                properties.setProperty("CUSTOM_ATTRIB_NAME", ldapNamesArray[i]);
                properties.setProperty("CUSTOM_ATTRIB_VALUE", ldapValuesArray[i]);
                customAttribsList.add(properties);
            }
        }
        String[] confCustomLdapNameArray = (String[])userBean.get("CUSTOM_ATTRIB_LDAP_NAME");
        String[] confCustomLdapValueArray = (String[])userBean.get("CUSTOM_ATTRIB_LDAP_VALUE");
        if (confCustomLdapNameArray != null && confCustomLdapValueArray != null) {
            for (int i = 0; i < confCustomLdapNameArray.length; ++i) {
                if (confCustomLdapNameArray[i].equalsIgnoreCase("") || confCustomLdapValueArray[i].equalsIgnoreCase("")) continue;
                Properties properties = new Properties();
                properties.setProperty("CUSTOM_ATTRIB_NAME", confCustomLdapNameArray[i]);
                properties.setProperty("CUSTOM_ATTRIB_VALUE", confCustomLdapValueArray[i]);
                customAttribsList.add(properties);
            }
        }
        AddUserHandler.getInstance().setContainer(userCreationID, container);
        AddUserHandler.getInstance().addUserDetails(userCreationID, userDetailsTable, attributeList, customAttribsList);
        ArrayList actionDetails = new ArrayList();
        HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
        actionToPerform.put("RequestAction", Long.valueOf(21L));
        ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
        AdmpInput admpInput = new AdmpInput("attributeListString", attributeListString, false);
        multipleInputs.add(admpInput);
        actionToPerform.put("MultipleInputs", multipleInputs);
        actionDetails.add(actionToPerform);
        WorkFlowRequest wfRequest = new WorkFlowRequest();
        wfRequest.setRequestInputActions(actionDetails);
        wfRequest.setUserCreationId(userCreationID);
        wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
        requestId = wfRequest.createRequest(loginId, null, rb.getString("admp.workflow.viewrequest.subject_for_create_request"), rb.getString("admp.mgmt.user_mgmt.cre_single_user.requestdesc.create_user_request"), Integer.valueOf(1), Integer.valueOf(5));
        WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
        executeRule.start();
        return requestId;
    }
}

