/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class CustomScript {
    public AdventNetResourceBundle rb = null;
    public long timeOut = 1L;
    private String command = "";
    private String result = "Success";
    String encoding = "UTF-8";

    public CustomScript(AdventNetResourceBundle rb, Long timeOut, String command) {
        this.rb = rb;
        this.timeOut = timeOut;
        this.command = command;
    }

    public CustomScript() {
    }

    public String runThread() {
        try {
            if (CommonUtil.isDemo()) {
                return this.rb.getString("admp.common.text.custom_script_disabled_in_demo");
            }
            CustomScriptThread thread = new CustomScriptThread(this);
            this.encoding = I18NUtil.getDefaultCSVCharEncoding((Long)CommonUtil.ADMIN_LOGIN_ID);
            System.out.println("Starting CustomScriptThread ...");
            thread.start();
            long startTime = System.currentTimeMillis();
            try {
                thread.join(this.timeOut * 1000L, 1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("CustomScriptThread ::" + thread.getName());
            if ((thread.isAlive() || System.currentTimeMillis() - startTime > this.timeOut * 1000L) && thread.isAlive()) {
                System.out.println("Custom script Thread alive......");
                try {
                    this.result = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.custom_script_running_background");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            thread = null;
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.result;
    }

    private class CustomScriptThread
    extends Thread {
        CustomScript customScript = new CustomScript();
        String encoding = I18NUtil.getDefaultCSVCharEncoding((Long)CommonUtil.ADMIN_LOGIN_ID);

        public CustomScriptThread(CustomScript customScript2) {
            this.customScript = customScript2;
        }

        private ArrayList<String> getScriptCommandArray(String command) {
            Pattern regex = Pattern.compile("(?!\\B\"[^\"]*)\\s(?![^\"]*\"\\B)");
            String[] commandArr = command.split("\\s\"\"");
            ArrayList<String> cmdArr = new ArrayList<String>();
            for (String attr : commandArr) {
                String[] arr;
                for (String cmd : arr = regex.split(attr)) {
                    cmdArr.add(cmd);
                }
            }
            if (command.endsWith("\"\"")) {
                cmdArr.add("");
            }
            return cmdArr;
        }

        @Override
        public void run() {
            try {
                String output = "";
                Process process = null;
                ArrayList<String> commandList = new ArrayList<String>();
                System.out.println("Custom Script Command::" + CustomScript.this.command);
                if (CustomScript.this.command == null) {
                    return;
                }
                ArrayList<String> cmdArr = this.getScriptCommandArray(CustomScript.this.command);
                String fileType = "";
                for (int i = 0; i < cmdArr.size(); ++i) {
                    if (fileType.equalsIgnoreCase(".ps1")) {
                        commandList.add("\"" + this.psEscape(cmdArr.get(i)) + "\"");
                    } else {
                        commandList.add(cmdArr.get(i));
                    }
                    if (fileType != "") continue;
                    try {
                        File file;
                        String fileName = cmdArr.get(i);
                        if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                            fileName = fileName.substring(1, fileName.length() - 1);
                        }
                        if (!(file = new File(fileName)).exists() || (fileName = file.getName()).indexOf(".") == -1) continue;
                        fileType = fileName.substring(fileName.lastIndexOf("."), fileName.length());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                System.out.println("Custom Script Command Array::" + ((Object)commandList).toString());
                process = new ProcessBuilder(commandList).start();
                process.getOutputStream().close();
                BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream(), this.encoding));
                String str = null;
                if (!error.ready()) {
                    CustomScriptThread.sleep(1000L);
                }
                if (error.ready()) {
                    while ((str = error.readLine()) != null) {
                        output = output + str + "\n";
                    }
                }
                error.close();
                BufferedReader outputStream = new BufferedReader(new InputStreamReader(process.getInputStream(), this.encoding));
                while ((str = outputStream.readLine()) != null) {
                    output = output + str + "\n";
                }
                outputStream.close();
                if (!output.equalsIgnoreCase("")) {
                    CustomScript.this.result = output;
                }
                process.destroy();
            }
            catch (IOException e) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.ioexception_occured_execution_script");
                e.printStackTrace();
            }
            catch (SecurityException e) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.security_exception_occured_execution_script");
                e.printStackTrace();
            }
            catch (Exception e) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_occured_execution_script");
                e.printStackTrace();
            }
            System.out.println("CustomScript Execution finished...");
            System.out.println("Result:" + CustomScript.this.result);
        }

        private String psEscape(String value) {
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            String escapedValue = value.replace("\"", "`\\\"");
            return escapedValue;
        }
    }
}

