/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class DeleteUsersListener
extends ModifyUserListener {
    public DeleteUsersListener() {
        this.reportId = new Integer(1026);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, AdmpInput admpInput, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        return this.modifyUser(result, attributeList, domainName, loginId, audit_info, auditDataObj);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        return this.modifyUser(result, attributeList, domainName, loginId, audit_info, auditDataObj);
    }

    private String modifyUser(Hashtable result, ArrayList attributeList, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{DelegationUtil.DELETE_USER_ACTION_ID})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        StringBuffer policyMsg = new StringBuffer();
        try {
            logger.log(Level.INFO, "Calling Modify User in the DeleteUsersListener");
            try {
                Integer dnId;
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                String objGuid = this.getValue(result, 1145);
                String guid = objGuid.substring(objGuid.indexOf("{") + 1, objGuid.indexOf("}"));
                String ou = this.getValue(result, 1012);
                if (ou == null || ou.equals("")) {
                    ou = StrUtil.getContainerDNFromDN((String)dn);
                    result.put(1012, ou);
                }
                if ((dnId = UserMgmtUtil.getAttributeId((String)"distinguishedName")) != null) {
                    result.put(dnId, dn);
                }
                HashMap policyStatusMap = new HashMap();
                message = DeleteUtil.deleteUser(domainName, loginId, dn, guid, result, this.rb, policyStatusMap, policyMsg, (Long)audit_info.get("object_id"));
                this.modifiedGuidList.add(objGuid);
                if (policyStatusMap.size() > 0) {
                    this.guidVsPolicyStatusMap.put(objGuid, policyStatusMap);
                    audit_info.put("auditMessage", policyMsg);
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditDeleteUser(loginId, this.rb.getString("admp.mgmt.user_mgmt.del_users.mgmtname.delete_users"), this.getValue(result, 1010), domainName, message.toString() + policyMsg, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }
}

