/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class DeliveryRestrictionsListener
extends ModifyUserListener {
    public DeliveryRestrictionsListener() {
        this.cks = new String[]{"fromAuthenticated"};
        this.reportId = new Integer(1008);
    }

    private void setProps(ArrayList list, BeanMap props, String userLdapName, String groupLdapName) {
        String[] users = (String[])props.get("userValues");
        Hashtable hash = ClientUtil.getUserGroupList(users);
        ArrayList userList = (ArrayList)hash.get("users");
        ArrayList groupList = (ArrayList)hash.get("groups");
        Properties p1 = this.getProps(userList, userLdapName);
        Properties p2 = this.getProps(groupList, groupLdapName);
        if (p1 != null) {
            list.add(p1);
        }
        if (p2 != null) {
            list.add(p2);
        }
    }

    private Properties getProps(ArrayList list, String ldapName) {
        if (list == null || list.size() == 0 || ldapName == null) {
            return null;
        }
        int count = list.size();
        Properties p = new Properties();
        p.put("ATTRIB_VALUE_COUNT", new Long(count));
        p.put("DATA_HANDLER_TYPE", new Long(1L));
        p.put("DW_CONTROL_CODE", new Long(3L));
        if (count == 1) {
            p.put("ATTRIB_VALUE", list.get(0));
        } else {
            p.put("ATTRIB_VALUE", list);
        }
        p.put("ATTRIB_LDAP_NAME", ldapName);
        return p;
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1022L})) {
            return this.rb.getString("client.DomainAction.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p2;
                Properties p1;
                Properties p;
                Long value;
                String scale;
                Properties p3;
                if (selectedAttributes[j].equals("submissionContlength")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1240L)) continue;
                    p3 = new Properties();
                    p3.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p3.put("DATA_HANDLER_TYPE", new Long(3L));
                    p3.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                    String sendDefaultLimit = props.getProperty("sendDefaultLimit");
                    if (sendDefaultLimit.equals("true")) {
                        p3.put("DW_CONTROL_CODE", new Long(1L));
                        p3.put("ATTRIB_VALUE", props.getProperty(selectedAttributes[j]));
                    } else {
                        scale = props.getProperty("submissionContlengthScale");
                        value = new Long(props.getProperty(selectedAttributes[j]));
                        if (scale.equals("usermanagement.delivery_restrictions.MB")) {
                            value = new Long(props.getProperty(selectedAttributes[j])) * 1024L;
                        }
                        p3.put("ATTRIB_VALUE", value.toString());
                    }
                    setAttributeList.add(p3);
                    continue;
                }
                if (selectedAttributes[j].equals("delivContLength")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1241L)) continue;
                    p3 = new Properties();
                    p3.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p3.put("DATA_HANDLER_TYPE", new Long(3L));
                    p3.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                    String recvDefaultLimit = props.getProperty("recvDefaultLimit");
                    if (recvDefaultLimit.equals("true")) {
                        p3.put("DW_CONTROL_CODE", new Long(1L));
                        p3.put("ATTRIB_VALUE", props.getProperty(selectedAttributes[j]));
                    } else {
                        scale = props.getProperty("delivContLengthScale");
                        value = new Long(props.getProperty(selectedAttributes[j]));
                        if (scale.equals("usermanagement.delivery_restrictions.MB")) {
                            value = new Long(props.getProperty(selectedAttributes[j])) * 1024L;
                        }
                        p3.put("ATTRIB_VALUE", value.toString());
                    }
                    setAttributeList.add(p3);
                    continue;
                }
                if (!selectedAttributes[j].equals("messageRestrictions") || !ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1242L)) continue;
                String fromAuthenticated = props.getProperty("fromAuthenticated");
                if (fromAuthenticated.equals("true")) {
                    p = new Properties();
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_VALUE", "TRUE");
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "msExchRequireAuthToSendTo");
                    setAttributeList.add(p);
                } else {
                    p = new Properties();
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_VALUE", "FALSE");
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "msExchRequireAuthToSendTo");
                    setAttributeList.add(p);
                }
                String fromEveryOne = props.getProperty("fromEveryOne");
                if (fromEveryOne.equals("fromEveryOne")) {
                    Properties p4 = new Properties();
                    p4.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p4.put("DATA_HANDLER_TYPE", new Long(1L));
                    p4.put("ATTRIB_VALUE", "");
                    p4.put("DW_CONTROL_CODE", new Long(1L));
                    p4.put("ATTRIB_LDAP_NAME", "dlMemSubmitPerms");
                    Properties p12 = new Properties();
                    p12.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p12.put("DATA_HANDLER_TYPE", new Long(1L));
                    p12.put("ATTRIB_VALUE", "");
                    p12.put("DW_CONTROL_CODE", new Long(1L));
                    p12.put("ATTRIB_LDAP_NAME", "dlMemRejectPerms");
                    Properties p22 = new Properties();
                    p22.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p22.put("DATA_HANDLER_TYPE", new Long(1L));
                    p22.put("ATTRIB_VALUE", "");
                    p22.put("DW_CONTROL_CODE", new Long(1L));
                    p22.put("ATTRIB_LDAP_NAME", "authOrig");
                    Properties p32 = new Properties();
                    p32.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p32.put("DATA_HANDLER_TYPE", new Long(1L));
                    p32.put("ATTRIB_VALUE", "");
                    p32.put("DW_CONTROL_CODE", new Long(1L));
                    p32.put("ATTRIB_LDAP_NAME", "unauthOrig");
                    setAttributeList.add(p4);
                    setAttributeList.add(p12);
                    setAttributeList.add(p22);
                    setAttributeList.add(p32);
                    continue;
                }
                if (fromEveryOne.equals("onlyFrom")) {
                    p1 = new Properties();
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("DATA_HANDLER_TYPE", new Long(1L));
                    p1.put("ATTRIB_VALUE", "");
                    p1.put("DW_CONTROL_CODE", new Long(1L));
                    p1.put("ATTRIB_LDAP_NAME", "dlMemRejectPerms");
                    p2 = new Properties();
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("DATA_HANDLER_TYPE", new Long(1L));
                    p2.put("ATTRIB_VALUE", "");
                    p2.put("DW_CONTROL_CODE", new Long(1L));
                    p2.put("ATTRIB_LDAP_NAME", "unauthOrig");
                    setAttributeList.add(p1);
                    setAttributeList.add(p2);
                    this.setProps(setAttributeList, props, "authOrig", "dlMemSubmitPerms");
                    continue;
                }
                if (!fromEveryOne.equals("fromEveryOneExcept")) continue;
                p1 = new Properties();
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("DATA_HANDLER_TYPE", new Long(1L));
                p1.put("ATTRIB_VALUE", "");
                p1.put("DW_CONTROL_CODE", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "dlMemSubmitPerms");
                p2 = new Properties();
                p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p2.put("DATA_HANDLER_TYPE", new Long(1L));
                p2.put("ATTRIB_VALUE", "");
                p2.put("DW_CONTROL_CODE", new Long(1L));
                p2.put("ATTRIB_LDAP_NAME", "authOrig");
                setAttributeList.add(p1);
                setAttributeList.add(p1);
                setAttributeList.add(p2);
                this.setProps(setAttributeList, props, "unauthOrig", "dlMemRejectPerms");
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.deliv_restrics.mgmtname.exchange_delivery_restrictions"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

