/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class DisableDeleteMailboxListener
extends ModifyUserListener {
    public DisableDeleteMailboxListener() {
        this.reportId = new Integer(1030);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        ArrayList setAttributeList = new ArrayList();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1040L})) {
                return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
            }
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            String objectGUID = (String)result.get("OBJECT_GUID");
            String distinguishedName = this.getValue(result, 1004);
            String mailboxStore = this.getValue(result, 1081);
            String mailServer = this.getValue(result, 1101);
            if (mailServer == null || mailServer.equalsIgnoreCase("")) {
                return this.rb.getString("admp.mgmt.user_mgmt.mailbox_rights.statmsg.no_mailbox_exists");
            }
            boolean usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
            try {
                objectGUID = objectGUID.substring(objectGUID.indexOf("{") + 1, objectGUID.indexOf("}"));
                if (usePowershell) {
                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                    String option = props.getProperty("option");
                    if (option.equals("disable")) {
                        String statMessage = ADHandler.disableMailBox((String)domainName, (long)loginId, (String)objectGUID, (Properties)exchangeServerDetails, (String)distinguishedName);
                        message.append(this.rb.getString(statMessage));
                    } else if (option.equals("disconnect")) {
                        String statMessage = ADHandler.deleteMailBox((String)domainName, (long)loginId, (String)objectGUID, (Properties)exchangeServerDetails, (boolean)false, (String)distinguishedName);
                        message.append(this.rb.getString(statMessage));
                    } else if (option.equals("delete")) {
                        String statMessage = ADHandler.deleteMailBox((String)domainName, (long)loginId, (String)objectGUID, (Properties)exchangeServerDetails, (boolean)true, (String)distinguishedName);
                        message.append(this.rb.getString(statMessage));
                    }
                }
                if (!usePowershell) {
                    String sid = this.getValue(result, 1144);
                    ADHandler.deleteMailBox2003((String)domainName, (Long)loginId, (String)sid, (String)distinguishedName);
                    message.append(this.rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_2003_mailbox"));
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditDeleteUser(loginId, this.rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.mgmtname.disable_del_mailbox"), this.getValue(result, 1010), domainName, message.toString(), this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        BeanMap props = (BeanMap)bean.get("props");
        String mailboxStore = props.getProperty("mailBoxStoreValue");
        if (mailboxStore.equalsIgnoreCase("All databases")) {
            str.append("(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(|(homeMDB=*)(msExchHomeServerName=*))");
        } else {
            str.append("(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(homeMDB=" + mailboxStore + ")");
        }
        if (searchString != null && !searchString.equals("")) {
            this.getSearchString(searchString, str);
        }
        str.append(")");
        return str.toString();
    }
}

