/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ExchNamingAttributesListener
extends ModifyUserListener {
    public ExchNamingAttributesListener() {
        this.reportId = new Integer(1011);
    }

    @Override
    public ArrayList getModifiedViewColumns(Integer reportId) {
        ArrayList attribList = super.getModifiedViewColumns(reportId);
        Properties exchVersionProps = new Properties();
        exchVersionProps.put("ATTRIB_COLUMN_NAME", "EXCHANGE_SERVER_VERSION");
        exchVersionProps.put("ATTRIB_ID", new Integer(1194));
        exchVersionProps.put("ATTRIB_DISP_NAME", "admp.reports.common.attribname.exchange_server_version");
        exchVersionProps.put("TABLE_NAME", "ADSMUserExchangeDetails");
        exchVersionProps.put("ATTRIB_LDAP_NAME", "msExchVersion");
        exchVersionProps.put("RELATIONAL_TYPE", new Integer(0));
        attribList.add(exchVersionProps);
        return attribList;
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1025L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String sid = this.getValue(result, 1144);
            String firstName = this.getValue(result, 1001);
            String lastName = this.getValue(result, 1002);
            String initials = this.getValue(result, 1003);
            String identity = this.getValue(result, 1004);
            String mailServer = this.getValue(result, 1101);
            Long versionNumber = 0L;
            if (this.getValue(result, 1194) != "") {
                versionNumber = Long.parseLong(this.getValue(result, 1194));
            }
            String hideAddressBook = "";
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            String[] selectedAttributes = new String[]{"mailNickName", "displayNamePrintable", "msExchHideFromAddressLists"};
            long[] id = new long[]{1248L, 1249L, 1250L};
            BeanMap props = (BeanMap)bean.get("props");
            for (int i = 0; i < selectedAttributes.length; ++i) {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, id[i])) continue;
                String value = props.getProperty(selectedAttributes[i]);
                if (selectedAttributes[i].equals("msExchHideFromAddressLists")) {
                    if (value.equalsIgnoreCase("usermanagement.terminal_environment.yes")) {
                        value = "TRUE";
                        hideAddressBook = "true";
                    } else {
                        if (!value.equalsIgnoreCase("usermanagement.terminal_environment.no")) continue;
                        value = "FALSE";
                        hideAddressBook = "false";
                    }
                }
                if (value.equalsIgnoreCase("--")) continue;
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[i]);
                if (selectedAttributes[i].equals("mailNickName") || selectedAttributes[i].equals("displayNamePrintable")) {
                    if ((value = FormatClientUtil.getFormatValue(new Long(value), result, domainName, "")) == null || value.equalsIgnoreCase("") || value.equals(".") || value.equals("..")) {
                        if (message.length() > 0) {
                            message.append(", ");
                        }
                        String str = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.naming_attr.stat_msg_is_empty_string"), selectedAttributes[i]);
                        message.append(str);
                        continue;
                    }
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                } else if (selectedAttributes[i].equals("msExchHideFromAddressLists")) {
                    p.put("DATA_HANDLER_TYPE", new Long(6L));
                    if (value.equalsIgnoreCase("false")) {
                        p.put("DW_CONTROL_CODE", new Long(1L));
                    }
                }
                p.put("ATTRIB_VALUE", value);
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)identity, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (mailServer != null && ExchangeUtil.checkExchange2007((String)mailServer) && !hideAddressBook.equalsIgnoreCase("")) {
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                        ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)identity, (String)"mailBox", (String)hideAddressBook, (Properties)exchangeServerDetails);
                    } else if (!hideAddressBook.equalsIgnoreCase("") && versionNumber != 0L) {
                        String exchVersion = ExchangeUtil.getExchangeVersion((Long)versionNumber);
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetails((String)domainName, (String)exchVersion);
                        ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)identity, (String)"mail", (String)hideAddressBook, (Properties)exchangeServerDetails);
                    }
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error"));
                    }
                } else {
                    message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.ModifyComputersGroup.unable_to_modify_the_user_error") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.ModifyComputersGroup.unable_to_modify_the_user_error") + e.getMessage());
            }
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.mgmtname.exchange_naming_attributes"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

