/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.LyncServerHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;

public class LyncAttributesListener
extends ModifyUserListener {
    Hashtable policyDisplayValues = new Hashtable();

    public LyncAttributesListener() {
        this.reportId = new Integer(1035);
        this.policyDisplayValues.put("conferencing_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.conferencing_policy");
        this.policyDisplayValues.put("client_version_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.client_version_policy");
        this.policyDisplayValues.put("pin_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.pin_policy");
        this.policyDisplayValues.put("external_access_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.external_access_policy");
        this.policyDisplayValues.put("archiving_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.archiving_policy");
        this.policyDisplayValues.put("location_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.location_policy");
        this.policyDisplayValues.put("client_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.client_policy");
        this.policyDisplayValues.put("mobility_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.mobility_policy");
        this.policyDisplayValues.put("dial_plan", "admp.mgmt.user_mgmt.modify_lync_policy.text.dial_plan_policy");
        this.policyDisplayValues.put("voice_policy", "admp.mgmt.user_mgmt.modify_lync_policy.text.voice_policy");
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))");
        str.append("(|(msRTCSIP-UserEnabled=TRUE)(msRTCSIP-UserEnabled=FALSE))");
        if (searchString != null && !searchString.equals("")) {
            this.getSearchString(searchString, str);
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in Lync Users : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        ArrayList policyType = new ArrayList();
        ArrayList<Properties> auditList = new ArrayList<Properties>();
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{5319L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            BeanMap props = (BeanMap)bean.get("props");
            String pool = this.getValue(result, 1183);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMLCSServers", (String)"SERVER_DISTINGUISHED_NAME"), (Object)pool, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMLCSServers", crit);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getRow("ADSMLCSServers");
                String poolName = (String)r.get("DNS_HOST_NAME");
                ArrayList<Properties> telephoneList = new ArrayList<Properties>();
                String[] selectedAttributes = (String[])bean.get("selectedAttributes");
                ArrayList policyInfo = LyncServerHandler.getLyncPolicyInfoList();
                for (int i = 0; i < selectedAttributes.length; ++i) {
                    if (selectedAttributes[i].equals("telephone_policy")) {
                        String telephoneType = props.getProperty("telephone_policy");
                        String lineURIFormat = props.getProperty("Line_URI");
                        String lineURI = FormatClientUtil.getFormatValue(lineURIFormat, result, domainName, "");
                        String lineServerURIFormat = props.getProperty("Line_Server_URI");
                        String lineServerURI = FormatClientUtil.getFormatValue(lineServerURIFormat, result, domainName, "");
                        if (telephoneType.equalsIgnoreCase("AudioVideoDisabled")) {
                            this.setTelephonePolicy(telephoneType, telephoneList);
                        } else if (telephoneType.equalsIgnoreCase("RemoteCallControlTelephonyEnabled")) {
                            this.setTelephonePolicy(telephoneType, telephoneList);
                            this.setLineURI(telephoneList, auditList, lineURI);
                            this.setLineServerURI(telephoneList, auditList, lineServerURI);
                        } else if (telephoneType.equalsIgnoreCase("RemoteCallControlOnly")) {
                            Properties remoteCallProp = new Properties();
                            Properties audioVideoProp = new Properties();
                            Properties enterpriseProp = new Properties();
                            remoteCallProp.put("PARAMETER", "RemoteCallControlTelephonyEnabled");
                            remoteCallProp.put("VALUE", "$true");
                            telephoneList.add(remoteCallProp);
                            audioVideoProp.put("PARAMETER", "AudioVideoDisabled");
                            audioVideoProp.put("VALUE", "$true");
                            enterpriseProp.put("PARAMETER", "EnterpriseVoiceEnabled");
                            enterpriseProp.put("VALUE", "$false");
                            telephoneList.add(enterpriseProp);
                            telephoneList.add(audioVideoProp);
                            this.setLineURI(telephoneList, auditList, lineURI);
                            this.setLineServerURI(telephoneList, auditList, lineServerURI);
                        } else if (telephoneType.equalsIgnoreCase("EnterpriseVoiceEnabled")) {
                            String dialPlan = props.getProperty("dial_plan");
                            String voicePolicy = props.getProperty("voice_policy");
                            this.setTelephonePolicy(telephoneType, telephoneList);
                            this.setLineURI(telephoneList, auditList, lineURI);
                            this.setPolicy("dial_plan", dialPlan, policyType, auditList, policyInfo);
                            this.setPolicy("voice_policy", voicePolicy, policyType, auditList, policyInfo);
                        } else {
                            this.setTelephonePolicy(telephoneType, telephoneList);
                            this.setLineURI(telephoneList, auditList, lineURI);
                        }
                        Properties auditTelephonyType = new Properties();
                        auditTelephonyType.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.text.telephone_policy"));
                        auditTelephonyType.put("ATTRIB_VALUE", telephoneType);
                        auditList.add(auditTelephonyType);
                    } else {
                        String policySelected = selectedAttributes[i];
                        String policyName = props.getProperty(policySelected);
                        this.setPolicy(policySelected, policyName, policyType, auditList, policyInfo);
                    }
                    logger.log(Level.INFO, "telephoneList:" + telephoneList + "\npolicyType:" + policyType);
                }
                try {
                    String samAccountName = this.getValue(result, 1005);
                    String error = "";
                    ArrayList list = new ArrayList();
                    if (samAccountName != null && LyncServerHandler.isLyncServer((String)poolName).booleanValue()) {
                        String nativeDCFQDN = null;
                        nativeDCFQDN = !CommonUtil.isSiteBasedDCSelectionEnabled() ? this.getDcFqdn() : this.getOUBasedDcFqdn(StrUtil.getContainerDNFromDN((String)dn), loginId, domainName);
                        if (telephoneList.size() > 0) {
                            error = ADHandlerForMgmt.enableTelephonyOptions((String)samAccountName, telephoneList, (String)domainName, (Long)loginId, (String)poolName, (String)nativeDCFQDN);
                        }
                        if (!error.equals("")) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_set_telephony_policy") + " - ");
                            message.append(this.rb.getString(error));
                        }
                        if (!policyType.isEmpty()) {
                            boolean errorOccured = false;
                            list = ADHandlerForMgmt.grantPolicyforUser(policyType, (String)samAccountName, (String)domainName, (Long)loginId, (String)poolName, (String)nativeDCFQDN);
                            HashSet<String> messageList = new HashSet<String>();
                            for (int i = 0; i < list.size(); ++i) {
                                Properties p1 = (Properties)list.get(i);
                                String IsSuccess = (String)p1.get("IsSuccess");
                                if (IsSuccess.equalsIgnoreCase("true")) continue;
                                errorOccured = true;
                                messageList.add(this.rb.getString(IsSuccess));
                            }
                            if (!errorOccured) {
                                message.append(this.rb.getString("admp.mgmt.common.text.successfully_modified"));
                            } else {
                                message.append(this.rb.getString("admp.mgmt.user_mgmt.enab_dis_lync_users.statmsg.error_setting_policy") + " - ");
                                Iterator it = messageList.iterator();
                                while (it.hasNext()) {
                                    message.append((String)it.next());
                                }
                            }
                        }
                        ADHandlerForMgmt.updateUserProperties((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
                        if (message.length() > 950) {
                            message.setLength(950);
                            message.append("...");
                        }
                    } else {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.cannot_modify_legay_user"));
                    }
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user") + le.getMessage(this.rb));
                }
                catch (Exception e) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user") + e.getMessage());
                }
                if (message.length() == 0) {
                    message.append(this.rb.getString("admp.mgmt.common.text.successfully_modified"));
                }
            } else {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_non_lync_user"));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.attribModify_lync_user"), this.getValue(result, 1010), domainName, auditList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public void setLineURI(ArrayList telephoneList, ArrayList auditList, String lineURI) {
        Properties lineURIProp = new Properties();
        lineURIProp.put("PARAMETER", "LineURI");
        lineURIProp.put("VALUE", lineURI);
        telephoneList.add(lineURIProp);
        Properties auditLineURI = new Properties();
        auditLineURI.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.text.line_uri"));
        auditLineURI.put("ATTRIB_VALUE", lineURI);
        auditList.add(auditLineURI);
    }

    public void setLineServerURI(ArrayList telephoneList, ArrayList auditList, String lineServerURI) {
        Properties lineServerURIProp = new Properties();
        Properties auditLineServerURI = new Properties();
        lineServerURIProp.put("PARAMETER", "LineServerURI");
        lineServerURIProp.put("VALUE", lineServerURI);
        telephoneList.add(lineServerURIProp);
        auditLineServerURI.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.text.line_server_uri"));
        auditLineServerURI.put("ATTRIB_VALUE", lineServerURI);
        auditList.add(auditLineServerURI);
    }

    public void setTelephonePolicy(String selectedType, ArrayList telephoneList) {
        String[] telePolicies = new String[]{"EnterpriseVoiceEnabled", "RemoteCallControlTelephonyEnabled", "AudioVideoDisabled"};
        for (int i = 0; i < telePolicies.length; ++i) {
            String telePolicy = telePolicies[i];
            Properties telephonyProp = new Properties();
            telephonyProp.put("PARAMETER", telePolicy);
            if (telePolicy.equalsIgnoreCase(selectedType)) {
                telephonyProp.put("VALUE", "$true");
            } else {
                telephonyProp.put("VALUE", "$false");
            }
            telephoneList.add(telephonyProp);
        }
    }

    public void setPolicy(String policySelected, String policyName, ArrayList policyType, ArrayList auditList, ArrayList policyInfo) {
        for (int i = 0; i < policyInfo.size(); ++i) {
            Properties p = (Properties)policyInfo.get(i);
            String policy = (String)p.get("POLICY_TYPE");
            if (!policy.equalsIgnoreCase(policySelected)) continue;
            Properties policyProp = new Properties();
            String cmdlet = (String)p.get("SET_CMDLET");
            policyProp.put("POLICY_TYPE", policySelected);
            policyProp.put("SET_CMDLET", cmdlet);
            policyProp.put("POLICY_NAME", policyName);
            policyType.add(policyProp);
            if (policyName.equals("")) {
                policyName = this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.text.automatic");
            }
            Properties auditPolicyProp = new Properties();
            String auditDisplayName = (String)this.policyDisplayValues.get(policySelected);
            auditPolicyProp.put("ATTRIB_LDAP_NAME", auditDisplayName != null ? this.rb.getString(auditDisplayName) : policySelected);
            auditPolicyProp.put("ATTRIB_VALUE", policyName);
            auditList.add(auditPolicyProp);
        }
    }

    @Override
    public void setValidDC(String domainName, Long loginId) {
        this.dcFqdn = DomainUtil.getValidDC((String)domainName, (Long)loginId);
    }
}

