/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;

public class MailboxRightsAction
extends DispatchAction {
    public ActionForward addMailBoxRightAces(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        DynaValidatorForm bean = (DynaValidatorForm)form;
        Hashtable folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("folder");
        Hashtable folderInheritFlagMap = UserPermissionsHandler.getInstance().getInheritFlagMap("folder");
        try {
            String domainName = request.getParameter("domainName");
            String selectedSIDs = request.getParameter("selectedSID");
            String selectedPermissions = request.getParameter("selectedPermissions");
            String selectedFlag = request.getParameter("selectedFlag");
            folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("mailBox");
            folderInheritFlagMap = UserPermissionsHandler.getInstance().getInheritFlagMap("mailBox");
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> acList = (ArrayList<Properties>)props.get("MBR_ACL");
            if (acList == null) {
                acList = new ArrayList<Properties>();
            }
            StringTokenizer sidTokenizer = new StringTokenizer(selectedSIDs, ";;");
            StringTokenizer permissionTokenizer = new StringTokenizer(selectedPermissions, ";");
            int permsissionCount = permissionTokenizer.countTokens();
            String[] permissions = new String[permsissionCount];
            int i = 0;
            while (permissionTokenizer.hasMoreTokens()) {
                permissions[i] = permissionTokenizer.nextToken();
                ++i;
            }
            while (sidTokenizer.hasMoreTokens()) {
                String sidString = sidTokenizer.nextToken();
                String OBJECT_NAME = "";
                String DN = "";
                String SID = "";
                if (sidString.equalsIgnoreCase("%userName%")) {
                    OBJECT_NAME = "%userName%";
                    DN = sidString;
                } else {
                    Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
                    OBJECT_NAME = ClientUtil.htmlEscape(properties.getProperty("OBJECT_NAME"));
                    DN = properties.getProperty("DN");
                    SID = sidString;
                }
                for (int j = 0; j < permissions.length; ++j) {
                    int index = permissions[j].indexOf("x");
                    int length = permissions[j].length();
                    String accessMask = permissions[j].substring(0, index);
                    String aceType = permissions[j].substring(index + 1, length);
                    Long ACCESS_MASK = Long.valueOf(accessMask);
                    Long ACE_TYPE = Long.valueOf(aceType);
                    String ACE_TYPE_STRING = rb.getString("admp.mgmt.user_mgmt.mailbox_rights.attribvalue_allow");
                    if (ACE_TYPE.equals(1L)) {
                        ACE_TYPE_STRING = rb.getString("admp.mgmt.user_mgmt.mailbox_rights.attribvalue_deny");
                    }
                    Properties aceTable = new Properties();
                    aceTable.put("OBJECT_NAME", OBJECT_NAME);
                    aceTable.put("DN", DN);
                    aceTable.put("SID", SID);
                    aceTable.put("ACCESS_MASK", ACCESS_MASK);
                    aceTable.put("ACCESS_MASK_STRING", rb.getString((String)folderAccessMaskMap.get(ACCESS_MASK)));
                    aceTable.put("ACE_TYPE", ACE_TYPE);
                    aceTable.put("ACE_TYPE_STRING", rb.getString(ACE_TYPE_STRING));
                    Long INHERIT_TYPE_FLAG = Long.parseLong(selectedFlag);
                    String APPLIES_TO_STRING = (String)folderInheritFlagMap.get(INHERIT_TYPE_FLAG);
                    aceTable.put("INHERIT_TYPE_FLAG", INHERIT_TYPE_FLAG);
                    aceTable.put("APPLIES_TO_STRING", rb.getString(APPLIES_TO_STRING));
                    acList.add(aceTable);
                }
            }
            props.put("MBR_ACL", acList);
            ClientUtil.setACLXMLElement(response, acList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteMailBoxRightAces(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            String index = request.getParameter("index");
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList acList = (ArrayList)props.get("MBR_ACL");
            acList.remove(Integer.parseInt(index));
            ClientUtil.setACLXMLElement(response, acList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward changeMailBoxRightAceType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            String changeTo = request.getParameter("changeTo");
            String folderType = request.getParameter("folderType");
            String permissionType = request.getParameter("permissionType");
            String index = request.getParameter("index");
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList acList = (ArrayList)props.get("MBR_ACL");
            Properties properties = (Properties)acList.get(Integer.parseInt(index));
            if (changeTo.equals("0")) {
                properties.put("ACE_TYPE", (Object)0L);
                properties.put("ACE_TYPE_STRING", rb.getString("admp.mgmt.user_mgmt.mailbox_rights.attribvalue_allow"));
            } else if (changeTo.equals("1")) {
                properties.put("ACE_TYPE", (Object)1L);
                properties.put("ACE_TYPE_STRING", rb.getString("admp.mgmt.user_mgmt.mailbox_rights.attribvalue_deny"));
            }
            ClientUtil.setStatusXMLElement(response, "Success", "Changed ACE Type");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

