/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class MigrateMailBox
extends ModifyUserListener {
    public MigrateMailBox() {
        this.reportId = new Integer(1031);
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(mailnickname=*)(|(homeMDB=*)(msExchHomeServerName=*))");
        if (searchString != null && !searchString.equals("")) {
            StringTokenizer token = new StringTokenizer(searchString, ",");
            str.append("(|");
            while (token.hasMoreTokens()) {
                String s = (String)token.nextElement();
                if (this.searchAttributes != null) {
                    for (int i = 0; i < this.searchAttributes.size(); ++i) {
                        str.append("(" + this.searchAttributes.get(i) + "=*" + s + "*)");
                    }
                }
                str.append("(mailnickname=*" + s + "*)");
            }
            str.append(")");
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in MailboxRightsListener : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1069L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            BeanMap props = (BeanMap)bean.get("props");
            String mailBox = props.getProperty("mailBoxStoreValue");
            Properties p = new Properties();
            p.put("ATTRIB_LDAP_NAME", "homeMDB");
            p.put("ATTRIB_VALUE", mailBox);
            setAttributeList.add(p);
            String mailServer = props.getProperty("serverNameValue");
            Integer exchVersion = ExchangeUtil.getExchangeServerType((String)mailServer);
            try {
                String objectGUID = (String)result.get("OBJECT_GUID");
                String dn = this.getValue(result, 1004);
                objectGUID = objectGUID.substring(objectGUID.indexOf("{") + 1, objectGUID.indexOf("}"));
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                String statMessage = ADHandler.migrateMailbox((String)domainName, (long)loginId, (String)objectGUID, (String)dn, (String)mailBox, (Properties)exchangeServerDetails);
                message.append(this.rb.getString(statMessage));
                if (message.length() == 0) {
                    if (exchVersion == 2007) {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_successfull"));
                    } else {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.intiated_migration"));
                    }
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.mgmtname.migrate_mailbox"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

