/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ModifyCustomAttributesListener
extends ModifyUserListener {
    public ModifyCustomAttributesListener() {
        this.reportId = new Integer(1025);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message;
        block39: {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1044L})) {
                return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
            }
            message = new StringBuffer();
            try {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1044L)) break block39;
                logger.log(Level.INFO, "Calling Modify User in the ModifyCustomAtrributesListener");
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                try {
                    String sid = this.getValue(result, 1144);
                    String dn = this.getValue(result, 1004);
                    BeanMap props = (BeanMap)bean.get("props");
                    String displayName = (String)props.get("DISPLAY_NAME");
                    String LDAPName = (String)props.get("LDAP_NAME");
                    String dataType = (String)props.get("DATA_TYPE");
                    String value = (String)props.get("LDAP_VALUE");
                    Properties p = new Properties();
                    p.put("ATTRIB_LDAP_NAME", LDAPName);
                    p.put("ATTRIB_VALUE", value);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    if (dataType.equals("CHAR")) {
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                    } else if (dataType.equals("INTEGER")) {
                        p.put("DATA_HANDLER_TYPE", new Long(7L));
                    } else if (dataType.equals("BOOLEAN")) {
                        p.put("DATA_HANDLER_TYPE", new Long(6L));
                        value = (String)props.get("LDAP_VALUE_BOOL");
                        if (value.equals("1")) {
                            value = "TRUE";
                        } else if (value.equals("0")) {
                            value = "FALSE";
                        } else if (value.equals("-1")) {
                            value = "";
                        }
                        p.put("ATTRIB_VALUE", value);
                    } else if (dataType.equals("BIGINT")) {
                        p.put("DATA_HANDLER_TYPE", new Long(10L));
                        if (value.length() == 0) {
                            p.put("ATTRIB_VALUE", (Object)0L);
                        } else {
                            p.put("ATTRIB_VALUE", (Object)Long.parseLong(value));
                        }
                    } else if (dataType.equals("DATETIME")) {
                        value = (String)props.get("LDAP_DATE_VALUE");
                        p.put("DATA_HANDLER_TYPE", new Long(10L));
                        if (value.length() == 0) {
                            p.put("ATTRIB_VALUE", (Object)0L);
                        } else {
                            p.put("ATTRIB_VALUE", DateTimeUtil.getFileTimeFromDate((String)value, (int)0));
                        }
                    } else if (dataType.equals("UTCTIME")) {
                        value = (String)props.get("LDAP_DATE_VALUE");
                        p.put("DATA_HANDLER_TYPE", new Long(9L));
                        if (value.length() == 0) {
                            p.put("ATTRIB_VALUE", (Object)0L);
                        } else {
                            p.put("ATTRIB_VALUE", DateTimeUtil.getFileTimeFromDate((String)value, (int)0));
                        }
                    } else if (dataType.equalsIgnoreCase("MULTIVALUE")) {
                        boolean isAppendMultiValue;
                        boolean bl = isAppendMultiValue = props.get("appendValues").toString().equalsIgnoreCase("true");
                        if (isAppendMultiValue) {
                            p.put("DW_CONTROL_CODE", (Object)3L);
                        } else {
                            p.put("DW_CONTROL_CODE", (Object)2L);
                        }
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                        String[] ldapMultiValue = (String[])props.get("ldapMultiValue");
                        ArrayList<String> values = new ArrayList<String>(Arrays.asList(ldapMultiValue));
                        if (values != null && values.size() > 1) {
                            ArrayList<String> list = new ArrayList<String>();
                            for (String string : values) {
                                list.add(string.toString().trim());
                            }
                            p.put("ATTRIB_VALUE", list);
                            p.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                        } else if (values != null && values.size() == 1 && values.get(0).toString().length() != 0) {
                            p.put("ATTRIB_VALUE", values.get(0));
                        } else {
                            p.put("ATTRIB_VALUE", "");
                            p.put("DW_CONTROL_CODE", (Object)1L);
                        }
                    }
                    if (value.equals("") && !dataType.equalsIgnoreCase("MULTIVALUE")) {
                        p.put("DW_CONTROL_CODE", new Long(1L));
                    }
                    setAttributeList.add(p);
                    ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                    logger.log(Level.INFO, "Starts Modifying -> Sid: " + sid + "setList: " + setAttributeList + "attrList: " + attributeList);
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
                }
                catch (Exception e) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
                }
                for (int kk = 0; kk < setAttributeList.size(); ++kk) {
                    ((Hashtable)setAttributeList.get(kk)).put("ATTRIB_VALUE_COUNT", 1L);
                    if (((Hashtable)setAttributeList.get(kk)).get("DW_CONTROL_CODE") == null || !((Hashtable)setAttributeList.get(kk)).get("DW_CONTROL_CODE").equals(1L)) continue;
                    ((Hashtable)setAttributeList.get(kk)).put("ATTRIB_VALUE", "");
                }
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.custom_attribs.mgmtname.custom_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }
}

