/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;

public class ModifyInheritablePermissionsListener
extends ModifyUserListener {
    public ModifyInheritablePermissionsListener() {
        this.cks = new String[]{"allowInheritable"};
        this.reportId = new Integer(1023);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message;
        block8: {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1042L})) {
                return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
            }
            message = new StringBuffer();
            try {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1042L})) break block8;
                int inheritFlag = 0;
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                BeanMap props = (BeanMap)bean.get("props");
                String allowInheritance = props.getProperty("allowInheritable");
                inheritFlag = allowInheritance.equalsIgnoreCase("true") ? 0 : 4096;
                logger.log(Level.INFO, " MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " DNAME : " + dn + " Flag : " + inheritFlag);
                try {
                    ADHandlerForMgmt.modifyInheritanceFlag((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)CommonUtil.escapeDN((String)dn), (int)inheritFlag);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + " : ");
                    }
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
                }
                catch (Exception e) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
                }
                TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.inherit_perms.mgmtname.inherit_perms"), this.getValue(result, 1010), domainName, "inheritFlag", allowInheritance, message.toString(), this.rb.getString("admp.mgmt.user_mgmt.mgmtcategory.user_modification"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return message.toString();
    }
}

