/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ModifyLogonWorkstationsListener
extends ModifyUserListener {
    private boolean error = false;
    private boolean errorOnly = false;

    public ModifyLogonWorkstationsListener() {
        this.reportId = new Integer(1022);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message;
        block22: {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1041L})) {
                return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
            }
            this.error = false;
            this.errorOnly = false;
            message = new StringBuffer();
            try {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1041L)) break block22;
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                BeanMap props = (BeanMap)bean.get("props");
                String allComputers = props.getProperty("allComputers");
                String selectedComputers = props.getProperty("selectedComputers");
                Properties p = new Properties();
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                String workStations = this.getValue(result, 1028);
                if (allComputers.equals("true")) {
                    p.put("ATTRIB_LDAP_NAME", "userWorkstations");
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    p.put("ATTRIB_VALUE", "");
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DW_CONTROL_CODE", new Long(1L));
                } else if (allComputers.equals("false") && selectedComputers.equals("true")) {
                    String addWorkStations = this.checkToBeModified(props.getProperty("addWorkStations"), workStations, "add");
                    p.put("ATTRIB_LDAP_NAME", "userWorkstations");
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    p.put("ATTRIB_VALUE", addWorkStations);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                } else if (allComputers.equals("false") && selectedComputers.equals("false")) {
                    String removeWorkStations = this.checkToBeModified(props.getProperty("removeWorkStations"), workStations, "delete");
                    if (this.errorOnly) {
                        message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error_specified_obj_does_not_exist"));
                    } else if (this.error) {
                        message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error_one_more_workstation_does_not_exist"));
                    }
                    if (removeWorkStations.equals("")) {
                        p.put("DW_CONTROL_CODE", new Long(1L));
                        p.put("DATA_HANDLER_TYPE", new Long(1L));
                    } else {
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                    }
                    p.put("ATTRIB_LDAP_NAME", "userWorkstations");
                    p.put("ATTRIB_VALUE", removeWorkStations);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                }
                setAttributeList.add(p);
                logger.log(Level.INFO, " MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
                try {
                    if (setAttributeList.size() != 0) {
                        ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                        if (message.length() == 0) {
                            message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                        } else if (!this.errorOnly) {
                            message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                        }
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"));
                    }
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
                }
                catch (Exception e) {
                    message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
                }
                if (message.length() == 0) {
                    message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                }
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.user_workstats.mgmtname.user_workstats"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return message.toString();
    }

    public String checkToBeModified(String modifiedStations, String stations, String modify) {
        int errorSize = 0;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> modifyList = new ArrayList<String>();
        StringTokenizer mst = new StringTokenizer(modifiedStations, ",");
        StringTokenizer st = new StringTokenizer(stations, ",");
        while (mst.hasMoreTokens()) {
            modifyList.add(mst.nextToken());
        }
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        System.out.println("----------------------------------\n\n" + list + "\n\n---------------------------------------");
        if (list.contains(this.rb.getString("admp.reports.user.customized_column_values.logonto.all_workstations"))) {
            list.remove(this.rb.getString("admp.reports.user.customized_column_values.logonto.all_workstations"));
        }
        for (int j = 0; j < modifyList.size(); ++j) {
            String ms = (String)modifyList.get(j);
            if (modify.equals("delete")) {
                if (list.contains(ms)) {
                    list.remove(ms);
                    continue;
                }
                if (list.contains(ms)) continue;
                if (modifyList.size() == ++errorSize) {
                    this.errorOnly = true;
                    continue;
                }
                this.error = true;
                continue;
            }
            if (!modify.equals("add") || list.contains(ms)) continue;
            list.add(ms);
        }
        stations = "";
        for (int i = 0; i < list.size(); ++i) {
            stations = stations + (String)list.get(i);
            if (i == list.size() - 1) continue;
            stations = stations + ",";
        }
        return stations;
    }
}

