/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import net.sf.image4j.codec.ico.ICODecoder;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModifyPhotoListener
extends ModifyUserListener {
    private static int EXCH_SCALED_IMG_WIDTH = 64;
    private static int EXCH_SCALED_IMG_HEIGHT = 64;
    boolean isAuthorised;
    Long loginId;
    Integer reportId;
    AdventNetResourceBundle rb;
    protected static Logger logger = Logger.getLogger("ADMangLogger");
    public static Hashtable<String, String> operationStatusHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateSinglePhoto(String domainName, Long loginId, Integer reportId, String uniqueOperationId, HttpServletRequest request, String sidString, String objectGuid, String samAccountName, String photoAttribute, String fileExtn, int x, int y, int w, int h, AdventNetResourceBundle rb) throws Exception {
        JSONObject resultObj = new JSONObject();
        String resultStr = "";
        boolean isSuccess = false;
        boolean isThumbnailSuccess = false;
        String dn = "";
        try {
            String photoHex = "";
            String mailServer = null;
            String photoFilePath = "";
            if (fileExtn != null && fileExtn.length() > 0) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", crit);
                Row row = dataObject.getRow("ADSMPhotoMgmtTempTable");
                photoHex = (String)row.get("PHOTO_HEX");
                photoFilePath = (String)row.get("PHOTO_FILE_PATH");
            } else {
                String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
                photoHex = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, objectGuid);
                photoFilePath = photoFolder + objectGuid;
            }
            byte[] byteArrOfImg = null;
            if (!photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                int hexStrLen = photoHex.length();
                byteArrOfImg = new byte[hexStrLen / 2];
                for (int indx1 = 0; indx1 < hexStrLen; indx1 += 2) {
                    byteArrOfImg[indx1 / 2] = (byte)((Character.digit(photoHex.charAt(indx1), 16) << 4) + Character.digit(photoHex.charAt(indx1 + 1), 16));
                }
            } else {
                File file = new File(photoFilePath);
                FileInputStream fileInputStream = new FileInputStream(file);
                byteArrOfImg = new byte[(int)file.length()];
                fileInputStream.read(byteArrOfImg);
                fileInputStream.close();
                mailServer = ModifyPhotoListener.getMailServerForSingleUser(domainName, loginId, samAccountName);
            }
            if (w != 0 && h != 0) {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(byteArrOfImg);
                    BufferedImage fullImage = ImageIO.read(in);
                    if (fileExtn == null || fileExtn.length() == 0) {
                        fileExtn = ModifyPhotoListener.getFileExt(photoHex);
                    }
                    if (fullImage == null) {
                        List list = ICODecoder.read((InputStream)in);
                        fullImage = (BufferedImage)list.get(0);
                    }
                    if (fileExtn.equalsIgnoreCase("ico")) {
                        fileExtn = "png";
                    }
                    int fileWidth = fullImage.getWidth();
                    int fileHeight = fullImage.getHeight();
                    x = x * fileWidth / 315;
                    w = w * fileWidth / 315;
                    y = y * fileHeight / 297;
                    h = h * fileHeight / 297;
                    BufferedImage croppedImage = fullImage.getSubimage(x, y, w, h);
                    ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)croppedImage, fileExtn.toLowerCase(), byteOutStream);
                    byteArrOfImg = byteOutStream.toByteArray();
                    byteOutStream.close();
                    if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                        FileOutputStream fos = new FileOutputStream(photoFilePath);
                        fos.write(byteArrOfImg);
                        fos.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (CommonUtil.isDemo()) {
                resultStr = rb.getString("admp.common.text.this_option_disable_for_online_demo");
            } else {
                if (CommonUtil.isSiteBasedDCSelectionEnabled()) {
                    Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
                    dn = properties.getProperty("DN");
                }
                String status = "";
                if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                    if (mailServer != null) {
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                        status = ADHandler.setExchangePhoto((String)domainName, (long)loginId, (String)objectGuid, (String)photoFilePath, (Properties)exchangeServerDetails);
                        if (status.length() == 0) {
                            isSuccess = true;
                            UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (byte[])byteArrOfImg, (String)objectGuid);
                            File file = new File(photoFilePath);
                            String fileName = file.getName();
                            byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                            UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, "thumbnailPhoto"), (byte[])byteArrOfImg, (String)objectGuid);
                            resultStr = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
                        }
                    }
                    if (mailServer == null || status.length() > 0) {
                        resultStr = mailServer == null ? resultStr + rb.getString("admp.mgmt.user_mgmt.photo_mgmt.exchange_photo_cannot_be_set") : resultStr + rb.getString(status);
                        photoAttribute = "thumbnailPhoto";
                        File file = new File(photoFilePath);
                        String fileName = file.getName();
                        byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                        ADHandler.setUserPhoto((String)domainName, (Long)loginId, (String)sidString, (String)dn, (byte[])byteArrOfImg, (String)photoAttribute);
                        resultStr = resultStr + " " + rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully");
                        UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (byte[])byteArrOfImg, (String)objectGuid);
                        isThumbnailSuccess = true;
                    }
                } else {
                    ADHandler.setUserPhoto((String)domainName, (Long)loginId, (String)sidString, (String)dn, (byte[])byteArrOfImg, (String)photoAttribute);
                    UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (byte[])byteArrOfImg, (String)objectGuid);
                    resultStr = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
                    isSuccess = true;
                }
            }
        }
        catch (LocalizedException ex) {
            ex.printStackTrace();
            String key = "admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error";
            if (resultStr.length() > 0) {
                key = "admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_error";
                resultStr = resultStr + " ";
            }
            resultStr = resultStr + rb.getString(key) + ex.getMessage(rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            resultStr = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + rb.getString("admp.mgmt.gpo_mgmt_some_err_occ");
        }
        finally {
            resultObj.put("SID_STRING", (Object)sidString);
            resultObj.put("samAccountName", (Object)samAccountName);
            resultObj.put("OBJECT_GUID", (Object)objectGuid);
            resultObj.put("isSuccess", isSuccess);
            resultObj.put("isThumbnailSuccess", isThumbnailSuccess);
            resultObj.put("resultStr", (Object)resultStr);
        }
        ArrayList<Long> auditIdList = new ArrayList<Long>();
        ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
        ModifyPhotoListener.auditPhotoModification(domainName, loginId, samAccountName, request.getRemoteHost(), reportId, new ArrayList(), resultStr, rb, auditIdList, auditObjectIdList);
        if (dn.equalsIgnoreCase("")) {
            Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
            dn = properties.getProperty("DN");
        }
        ArrayList<String> objectOUList = new ArrayList<String>();
        String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
        objectOUList.add(ouName);
        this.triggerNotification(auditIdList, auditObjectIdList, domainName, loginId, rb, objectOUList);
        return resultObj;
    }

    private void triggerNotification(ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, String domainName, Long loginId, AdventNetResourceBundle rb, ArrayList objectOUList) {
        if (auditObjectIdList.size() > 0) {
            MgmtNotificationListener notifyListener = new MgmtNotificationListener();
            Integer userObjectId = 1;
            notifyListener.triggerNotification(auditIdList, auditObjectIdList, userObjectId, new Hashtable(), loginId, ReportsUtil.MODIFY_BULK_PHOTOS_REPORT_ID, domainName, rb, new ArrayList(), objectOUList);
        }
    }

    public static byte[] getCroppedImg(File file, String fileExtn) {
        byte[] byteArrOfImg = null;
        try {
            int height;
            int width;
            BufferedImage img = ImageIO.read(file);
            if (img == null) {
                List list = ICODecoder.read((File)file);
                img = (BufferedImage)list.get(0);
                fileExtn = "png";
            }
            if ((width = img.getWidth()) != (height = img.getHeight())) {
                int x = 0;
                int y = 0;
                if (width < height) {
                    y = (height - width) / 2;
                    height = width;
                } else {
                    x = (width - height) / 2;
                    width = height;
                }
                img = img.getSubimage(x, y, width, height);
            }
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, fileExtn.toLowerCase(), byteOutStream);
            byteArrOfImg = byteOutStream.toByteArray();
            byteOutStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArrOfImg;
    }

    public static byte[] getScaledImg(File file, String fileExtn, boolean isCrop) {
        byte[] byteArrOfImg = null;
        try {
            BufferedImage img = null;
            if (isCrop) {
                ByteArrayInputStream in = new ByteArrayInputStream(ModifyPhotoListener.getCroppedImg(file, fileExtn));
                img = ImageIO.read(in);
            } else {
                img = ImageIO.read(file);
                if (img == null) {
                    List list = ICODecoder.read((File)file);
                    img = (BufferedImage)list.get(0);
                    fileExtn = "png";
                }
            }
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            Image scaledImg = img.getScaledInstance(EXCH_SCALED_IMG_WIDTH, EXCH_SCALED_IMG_HEIGHT, 4);
            BufferedImage bufferedImage = new BufferedImage(EXCH_SCALED_IMG_WIDTH, EXCH_SCALED_IMG_HEIGHT, img.getType());
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.drawImage(scaledImg, 0, 0, null);
            g2d.dispose();
            ImageIO.write((RenderedImage)bufferedImage, fileExtn.toLowerCase(), byteOutStream);
            byteArrOfImg = byteOutStream.toByteArray();
            byteOutStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArrOfImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject removeUserPhoto(String domainName, Long loginId, Integer reportId, HttpServletRequest request, String sidString, String objectGuid, String samAccountName, String photoAttribute, AdventNetResourceBundle rb) throws Exception {
        JSONObject resultObj = new JSONObject();
        String resultStr = "";
        boolean isSuccess = false;
        String dn = "";
        try {
            if (CommonUtil.isDemo()) {
                resultStr = rb.getString("admp.common.text.this_option_disable_for_online_demo");
            } else {
                if (CommonUtil.isSiteBasedDCSelectionEnabled()) {
                    Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
                    dn = properties.getProperty("DN");
                }
                if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                    String mailServer = ModifyPhotoListener.getMailServerForSingleUser(domainName, loginId, samAccountName);
                    if (mailServer != null) {
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                        resultStr = ADHandler.setExchangePhoto((String)domainName, (long)loginId, (String)objectGuid, (String)"", (Properties)exchangeServerDetails);
                    }
                    if (resultStr.length() == 0) {
                        resultStr = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_successfully_deleted_photo");
                        UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (String)"", (String)objectGuid);
                        UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, "thumbnailPhoto"), (String)"", (String)objectGuid);
                        isSuccess = true;
                    }
                } else {
                    ADHandler.setUserPhoto((String)domainName, (Long)loginId, (String)sidString, (String)dn, (byte[])new byte[0], (String)photoAttribute);
                    resultStr = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_successfully_deleted_photo");
                    UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (String)"", (String)objectGuid);
                    isSuccess = true;
                }
            }
        }
        catch (LocalizedException ex) {
            ex.printStackTrace();
            resultStr = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + ex.getMessage(rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            resultStr = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + rb.getString("admp.mgmt.gpo_mgmt_some_err_occ");
        }
        finally {
            resultObj.put("SID_STRING", (Object)sidString);
            resultObj.put("isSuccess", isSuccess);
            resultObj.put("resultStr", (Object)rb.getString(resultStr));
        }
        ArrayList<Long> auditIdList = new ArrayList<Long>();
        ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
        ModifyPhotoListener.auditPhotoModification(domainName, loginId, samAccountName, request.getRemoteHost(), reportId, new ArrayList(), resultStr, rb, auditIdList, auditObjectIdList);
        if (dn.equalsIgnoreCase("")) {
            Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
            dn = properties.getProperty("DN");
        }
        ArrayList<String> objectOUList = new ArrayList<String>();
        String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
        objectOUList.add(ouName);
        this.triggerNotification(auditIdList, auditObjectIdList, domainName, loginId, rb, objectOUList);
        return resultObj;
    }

    public JSONObject doBulkMgmt(Integer reportId, Object selectedUsers, String uniqueOperationId, String photoAttributeLdapName, String photoAttribColumnName, HttpServletRequest request, String domainName, Long loginId, AdventNetResourceBundle rb) {
        JSONObject resultObj = new JSONObject();
        try {
            String[] selectedUsersList = ((String)selectedUsers).split(",");
            this.reportId = reportId;
            this.isAuthorised = true;
            this.loginId = loginId;
            this.rb = rb;
            operationStatusHash.put(uniqueOperationId, "RUNNING");
            JSONArray userDetails = new JSONArray();
            Properties mailboxEnabledUserProps = ModifyPhotoListener.getMailboxEnabledUsers(domainName, loginId);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMPhotoMgmtTempTable"));
            query.addJoin(new Join("ADSMPhotoMgmtTempTable", "ADSMUserGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
            query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"UNIQUE_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SID_STRING"));
            query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DISTINGUISHED_NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)selectedUsersList, 8));
            query.setCriteria(crit);
            Criteria deleteCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)selectedUsersList, 9);
            deleteCrit = deleteCrit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0));
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCrit);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject != null && !dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("ADSMPhotoMgmtTempTable");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    JSONObject userData = new JSONObject();
                    String guidStr = (String)row.get("OBJECT_GUID");
                    Row userDetRow = dataObject.getRow("ADSMUserGeneralDetails", new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), (Object)guidStr, 0));
                    if (userDetRow == null || userDetRow.get("SID_STRING") == null) continue;
                    userData.put("SID_STRING", (Object)((String)userDetRow.get("SID_STRING")));
                    userData.put("OBJECT_GUID", (Object)guidStr);
                    String mailServer = (String)mailboxEnabledUserProps.get(guidStr);
                    mailboxEnabledUserProps.remove(guidStr);
                    if (mailServer != null) {
                        userData.put("MAILBOX_SERVER", (Object)mailServer);
                    }
                    userData.put("SAM_ACCOUNT_NAME", (Object)((String)userDetRow.get("SAM_ACCOUNT_NAME")));
                    userData.put("DISTINGUISHED_NAME", (Object)((String)userDetRow.get("DISTINGUISHED_NAME")));
                    userDetails.put((Object)userData);
                }
            }
            String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttributeLdapName);
            Action modifyAction = new Action(domainName, loginId, reportId, request.getRemoteHost(), uniqueOperationId, photoAttributeLdapName, photoFolder, userDetails, this.rb);
            modifyAction.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultObj;
    }

    public static JSONObject getUsers(HttpServletRequest request, String domainName, int startIndex, int maxItems, ArrayList attribList, String photoAttribute, JSONObject searchCrit, String quickSearchCrit) {
        return ModifyPhotoListener.getUsers(request, domainName, null, null, startIndex, maxItems, attribList, photoAttribute, null, null, false, searchCrit, false, quickSearchCrit);
    }

    public static JSONObject getUsers(HttpServletRequest request, String domainName, Long loginId, ADMPAuthObject authObject, int startIndex, int maxItems, ArrayList attribList, String photoAttribute, JSONArray ouList, JSONArray unSelOUList, boolean excludeChildOU, JSONObject searchCrit) {
        return ModifyPhotoListener.getUsers(request, domainName, loginId, authObject, startIndex, maxItems, attribList, photoAttribute, ouList, unSelOUList, excludeChildOU, searchCrit, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject getUsers(HttpServletRequest request, String domainName, Long loginId, ADMPAuthObject authObject, int startIndex, int maxItems, ArrayList attribDetailsOrList, String photoAttribute, JSONArray ouList, JSONArray unSelOUList, boolean excludeChildOU, JSONObject searchCrit, boolean isForNamingFormat, String quickSearchTxt) {
        JSONObject result = new JSONObject();
        try {
            DataObject dataObject;
            String tableName = "ADSMUserGeneralDetails";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            String photoFolder = "";
            if (photoAttribute != null) {
                photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
            }
            ArrayList<String> attribList = null;
            ArrayList<String> attribDetailsList = null;
            if (attribDetailsOrList.size() > 0) {
                String listObj = attribDetailsOrList.get(0);
                if (listObj instanceof String) {
                    attribList = attribDetailsOrList;
                } else {
                    attribDetailsList = attribDetailsOrList;
                    attribList = new ArrayList();
                    for (Hashtable hashtable : attribDetailsList) {
                        attribList.add((String)hashtable.get("ATTRIB_COLUMN_NAME"));
                    }
                }
            }
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)1, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), null, 1));
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)"", 1));
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)"-", 1));
            if (searchCrit != null && searchCrit.has("OBJECT_GUID_LIST")) {
                JSONArray objectGuidList = (JSONArray)searchCrit.get("OBJECT_GUID_LIST");
                if (objectGuidList.length() > 0) {
                    void var22_28;
                    Criteria criteria2 = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)objectGuidList.get(0)), 0);
                    int guidListLen = objectGuidList.length();
                    for (int indx = 1; indx < guidListLen; ++indx) {
                        Criteria criteria3 = var22_28.or(new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)objectGuidList.get(indx)), 0));
                    }
                    criteria = criteria.and((Criteria)var22_28);
                }
            } else if (ouList != null && ouList.length() > 0) {
                void var22_32;
                Criteria ouCrit = null;
                boolean bl = false;
                while (var22_32 < ouList.length()) {
                    String ouDN = ouList.getString((int)var22_32);
                    ouDN = ouDN.replaceAll("\\\\", "\\\\\\\\");
                    Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                    ouCrit = ouCrit == null ? crit : ouCrit.or(crit);
                    ++var22_32;
                }
                criteria = criteria.and(ouCrit);
                if (excludeChildOU) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Criteria excludeOUCrit = null;
                    for (int indx2 = 0; indx2 < ouList.length(); ++indx2) {
                        String ouDN = ouList.getString(indx2);
                        ouDN = ouDN.replaceAll("\\\\", "\\\\\\\\");
                        Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                        excludeOUCrit = excludeOUCrit == null ? crit : excludeOUCrit.or(crit);
                    }
                    SelectQueryImpl excludeOUQuery = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
                    excludeOUQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
                    excludeOUQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"));
                    excludeOUQuery.setCriteria(excludeOUCrit);
                    DataObject excludeOUDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)excludeOUQuery);
                    if (excludeOUDO != null && !excludeOUDO.isEmpty()) {
                        Iterator exclIt = excludeOUDO.getRows("ADSMOUDetails");
                        while (exclIt.hasNext()) {
                            Row exclRow = (Row)exclIt.next();
                            String excludeOU = (String)exclRow.get("DISTINGUISHED_NAME");
                            arrayList.add(excludeOU);
                        }
                    }
                    int selectedOUListSize = ouList.length();
                    for (int indx2 = 0; indx2 < selectedOUListSize; ++indx2) {
                        arrayList.remove(ouList.getString(indx2));
                    }
                    for (String excludeOUDN : arrayList) {
                        excludeOUDN = excludeOUDN.replaceAll("\\\\", "\\\\\\\\");
                        criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)excludeOUDN, 13));
                    }
                } else if (unSelOUList != null && unSelOUList.length() > 0) {
                    void var22_35;
                    boolean bl2 = false;
                    while (var22_35 < unSelOUList.length()) {
                        String unSelOUDN = unSelOUList.getString((int)var22_35);
                        unSelOUDN = unSelOUDN.replaceAll("\\\\", "\\\\\\\\");
                        criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OU_DN_NAME"), (Object)unSelOUDN, 1));
                        ++var22_35;
                    }
                }
            } else if (ouList == null || ouList.length() == 0) {
                ArrayList authOUList = null;
                if (authObject != null) {
                    authOUList = (ArrayList)authObject.getDomainOUsMap().get(domainName);
                }
                if (authOUList != null && authOUList.size() > 0) {
                    void var22_37;
                    Object var22_36 = null;
                    for (int indx = 0; indx < authOUList.size(); ++indx) {
                        String ouDN = (String)authOUList.get(indx);
                        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                        if (var22_37 == null) {
                            Criteria criteria4 = crit;
                            continue;
                        }
                        Criteria criteria5 = var22_37.or(crit);
                    }
                    criteria = criteria.and((Criteria)var22_37);
                }
            }
            if (searchCrit != null) {
                boolean bl;
                boolean filterUserWithPhoto = true;
                boolean bl3 = true;
                if (searchCrit.has("showUsersWithPhoto")) {
                    filterUserWithPhoto = searchCrit.getBoolean("showUsersWithPhoto");
                }
                if (searchCrit.has("showUsersWithoutPhoto")) {
                    bl = searchCrit.getBoolean("showUsersWithoutPhoto");
                }
                if (!(!filterUserWithPhoto && !bl || filterUserWithPhoto && bl)) {
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                    String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
                    ArrayList<String> attributeList = new ArrayList<String>();
                    attributeList.add("objectGuid");
                    String tempPhotoAttribute = photoAttribute;
                    if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                        tempPhotoAttribute = "thumbnailPhoto";
                    }
                    String searchString = "";
                    searchString = filterUserWithPhoto ? "(&(objectCategory=person)(" + tempPhotoAttribute + "=*))" : "(&(objectCategory=person)(!" + tempPhotoAttribute + "=*))";
                    ArrayList userList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attributeList, (String)searchString);
                    ArrayList<String> userGuidList = new ArrayList<String>();
                    if (userList != null && userList.size() > 0) {
                        void var30_70;
                        boolean bl4 = false;
                        while (var30_70 < userList.size()) {
                            Properties userProp = (Properties)userList.get((int)var30_70);
                            String objectGuid = (String)((ArrayList)userProp.get("objectGuid")).get(0);
                            userGuidList.add(objectGuid);
                            ++var30_70;
                        }
                    }
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)userGuidList.toArray(), 8));
                }
                Criteria attribSearchCrit = null;
                boolean hasAdvancedFilter = false;
                if (searchCrit.has("hasAdvFilter")) {
                    hasAdvancedFilter = searchCrit.getBoolean("hasAdvFilter");
                }
                if (hasAdvancedFilter) {
                    JSONArray advFiltersArrJson = new JSONArray(searchCrit.getString("advFiltersArrJson"));
                    for (int indx1 = 0; indx1 < advFiltersArrJson.length(); ++indx1) {
                        void var30_74;
                        JSONObject filterObj = (JSONObject)advFiltersArrJson.get(indx1);
                        String logicalOperator = filterObj.getString("logicalOperator");
                        String attributeName = filterObj.getString("attributeName");
                        String string = filterObj.getString("comparator");
                        String conditionValue = filterObj.getString("conditionValue");
                        if (string.equalsIgnoreCase("5")) {
                            String string2 = "1";
                            conditionValue = "-";
                        } else if (string.equalsIgnoreCase("6")) {
                            String string3 = "2";
                            conditionValue = "-";
                        }
                        Criteria advCrit = ModifyPhotoListener.getCrit(Column.getColumn((String)tableName, (String)attributeName), conditionValue, Integer.parseInt((String)var30_74));
                        attribSearchCrit = attribSearchCrit == null ? advCrit : (logicalOperator.equalsIgnoreCase("and") ? attribSearchCrit.and(advCrit) : attribSearchCrit.or(advCrit));
                    }
                } else if (searchCrit.has("searchString") && searchCrit.has("searchStrAttrib")) {
                    String searchString = searchCrit.getString("searchString");
                    JSONArray searchStrAttribs = (JSONArray)searchCrit.get("searchStrAttrib");
                    if (searchString.length() > 0) {
                        if (searchStrAttribs.length() > 0) {
                            for (int indx1 = 0; indx1 < searchStrAttribs.length(); ++indx1) {
                                attribSearchCrit = attribSearchCrit == null ? new Criteria(Column.getColumn((String)tableName, (String)searchStrAttribs.getString(indx1)), (Object)("*" + searchString + "*"), 2) : attribSearchCrit.or(new Criteria(Column.getColumn((String)tableName, (String)searchStrAttribs.getString(indx1)), (Object)("*" + searchString + "*"), 2));
                            }
                        } else {
                            attribSearchCrit = new Criteria(Column.getColumn((String)tableName, (String)"DISPLAY_NAME"), (Object)("*" + searchString + "*"), 2);
                            attribSearchCrit = attribSearchCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)("*" + searchString + "*"), 2));
                        }
                    }
                }
                if (attribSearchCrit != null) {
                    criteria = criteria.and(attribSearchCrit);
                }
            }
            if (quickSearchTxt != null && quickSearchTxt.length() > 0) {
                Criteria quickSearchCrit = new Criteria(Column.getColumn((String)tableName, (String)"DISPLAY_NAME"), (Object)("*" + quickSearchTxt + "*"), 2);
                quickSearchCrit = quickSearchCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)("*" + quickSearchTxt + "*"), 2));
                quickSearchCrit = quickSearchCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"LOGON_NAME"), (Object)("*" + quickSearchTxt + "*"), 2));
                criteria = criteria.and(quickSearchCrit);
            }
            String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers");
            long l = -1L;
            if (noOfObjects == null) {
                noOfObjects = "100";
            }
            if (!noOfObjects.equalsIgnoreCase("unlimited")) {
                l = Long.parseLong(noOfObjects);
            }
            query.setCriteria(criteria);
            SelectQuery queryForCount = (SelectQuery)query.clone();
            queryForCount.addSelectColumn(Column.getColumn(null, (String)"*").count());
            long totalUsersCount = DBUtil.getCount((SelectQuery)queryForCount).intValue();
            boolean isCountRestricted = false;
            if (l != -1L && totalUsersCount > l) {
                totalUsersCount = l;
                isCountRestricted = true;
            }
            result.put("totalUsersCount", totalUsersCount);
            if (attribDetailsList != null) {
                ArrayList<String> tableList = new ArrayList<String>();
                tableList.add(tableName.toLowerCase());
                for (Hashtable hashtable : attribDetailsList) {
                    String attribColumnName = (String)hashtable.get("ATTRIB_COLUMN_NAME");
                    String attrTableName = (String)hashtable.get("TABLE_NAME");
                    if (attrTableName == null || attrTableName.length() <= 0) continue;
                    if (!tableList.contains(attrTableName.toLowerCase())) {
                        Join newTabJoin = new Join(tableName, attrTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                        query.addJoin(newTabJoin);
                        tableList.add(attrTableName.toLowerCase());
                        query.addSelectColumn(Column.getColumn((String)attrTableName, (String)"OBJECT_GUID"));
                    }
                    query.addSelectColumn(Column.getColumn((String)attrTableName, (String)attribColumnName));
                }
            } else {
                for (String attribColumnName : attribList) {
                    query.addSelectColumn(Column.getColumn((String)tableName, (String)attribColumnName));
                }
            }
            query.addSortColumn(new SortColumn(tableName, "DISPLAY_NAME", true));
            query.addSortColumn(new SortColumn(tableName, "SAM_ACCOUNT_NAME", true));
            if (startIndex > 0) {
                Range range = new Range(startIndex, maxItems);
                query.setRange(range);
            }
            if (!(dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query)).isEmpty()) {
                Row row;
                if (!isForNamingFormat) {
                    JSONArray userList = new JSONArray();
                    Iterator iterator = dataObject.getRows(tableName);
                    while (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        JSONObject object = new JSONObject();
                        for (String attribColumnName : attribList) {
                            void var35_89;
                            String string = (String)row.get(attribColumnName);
                            if (string == null || string.length() == 0) {
                                String string4 = "-";
                            }
                            object.put(attribColumnName, (Object)EscapeUtil.escSplCharsAsHTML((Object)var35_89));
                        }
                        if (photoAttribute != null) {
                            boolean hasPhotoFile = false;
                            boolean hasPhoto = false;
                            String string = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, (String)row.get("OBJECT_GUID"));
                            if (string != null) {
                                hasPhotoFile = true;
                                if (string.length() > 0) {
                                    hasPhoto = true;
                                }
                            }
                            object.put("HAS_PHOTO", hasPhoto);
                            object.put("HAS_PHOTO_FILE", hasPhotoFile);
                        }
                        userList.put((Object)object);
                    }
                    result.put("userDetails", (Object)userList);
                } else {
                    ArrayList<Properties> userVsAttribValsList = new ArrayList<Properties>();
                    Iterator iterator = dataObject.getRows(tableName);
                    while (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        Properties prop = new Properties();
                        String objectGuid = (String)row.get("OBJECT_GUID");
                        for (Hashtable hashtable : attribDetailsList) {
                            String attribTableName = (String)hashtable.get("TABLE_NAME");
                            String attribColumnName = (String)hashtable.get("ATTRIB_COLUMN_NAME");
                            String attribLdapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                            String value = null;
                            if (attribTableName.equalsIgnoreCase(tableName)) {
                                value = (String)row.get(attribColumnName);
                            } else {
                                Criteria attrValCrit = new Criteria(Column.getColumn((String)attribTableName, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                                Row attrRow = dataObject.getRow(attribTableName, attrValCrit);
                                if (attrRow != null) {
                                    if (attrRow.get(attribColumnName) instanceof String) {
                                        value = (String)attrRow.get(attribColumnName);
                                    } else if (attrRow.get(attribColumnName) instanceof Long) {
                                        value = attrRow.get(attribColumnName).toString();
                                    }
                                }
                            }
                            if (value == null || value.length() == 0 || value.equalsIgnoreCase("-")) {
                                value = "";
                            }
                            prop.put(attribLdapName, value);
                        }
                        userVsAttribValsList.add(prop);
                    }
                    result.put("userDetails", userVsAttribValsList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static void auditPhotoModification(String domainName, Long loginId, String samAccountName, String hostId, Integer reportId, ArrayList attributeList, String result, AdventNetResourceBundle rb) throws Exception {
        ModifyPhotoListener.auditPhotoModification(domainName, loginId, samAccountName, hostId, reportId, attributeList, result, rb, null, null);
    }

    private static void auditPhotoModification(String domainName, Long loginId, String samAccountName, String hostId, Integer reportId, ArrayList attributeList, String result, AdventNetResourceBundle rb, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList) throws Exception {
        DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)samAccountName, (String)domainName, (DataObject)auditDataObj);
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        audit_info.put("object_id", object_id);
        audit_info.put("error_msg", result);
        auditIdList.add(audit_id);
        if (result.toLowerCase().contains(rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase()) && auditObjectIdList != null && auditIdList != null) {
            auditObjectIdList.add(object_id);
        }
        HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.photo_attribute"), samAccountName, domainName, attributeList, new ArrayList(), new ArrayList(), result, (Long)audit_info.get("object_id"), auditDataObj, rb);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
    }

    private static Criteria getCrit(Column column, String value, int comparator) {
        switch (comparator) {
            case 1: {
                return new Criteria(column, (Object)value, 0);
            }
            case 2: {
                return new Criteria(column, (Object)value, 1);
            }
            case 3: {
                return new Criteria(column, (Object)value, 12);
            }
            case 4: {
                return new Criteria(column, (Object)value, 13);
            }
            case 5: {
                Criteria eqCrit = new Criteria(column, (Object)"", 0);
                eqCrit = eqCrit.or(new Criteria(column, null, 0));
                return eqCrit;
            }
            case 6: {
                Criteria neqCrit = new Criteria(column, (Object)"", 1);
                neqCrit = neqCrit.and(new Criteria(column, null, 1));
                return neqCrit;
            }
            case 7: {
                return new Criteria(column, (Object)value, 10);
            }
            case 8: {
                return new Criteria(column, (Object)value, 11);
            }
        }
        return new Criteria(column, (Object)value, 12);
    }

    public static ArrayList getUserInfoForExport(String uniqueOperationId, ArrayList attributeList, AdventNetResourceBundle rb) {
        ArrayList list = new ArrayList();
        try {
            String baseTableName = "ADSMUserGeneralDetails";
            String photoAttribResultTable = "ADSMPhotoMgmtTempTable";
            String successMessage = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
            Join join = new Join(baseTableName, photoAttribResultTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"));
            for (int indx = 0; indx < attributeList.size(); ++indx) {
                String attribColName = ((Properties)attributeList.get(indx)).getProperty("ATTRIB_COLUMN_NAME");
                query.addSelectColumn(Column.getColumn((String)baseTableName, (String)attribColName));
            }
            query.addSelectColumn(Column.getColumn((String)photoAttribResultTable, (String)"UNIQUE_ID"));
            query.addSelectColumn(Column.getColumn((String)photoAttribResultTable, (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)photoAttribResultTable, (String)"MGMT_UNIQUE_ID"));
            query.addSelectColumn(Column.getColumn((String)photoAttribResultTable, (String)"RESULT"));
            Criteria uniqueOpIdCrit = new Criteria(Column.getColumn((String)photoAttribResultTable, (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            Criteria crit = uniqueOpIdCrit.and(new Criteria(Column.getColumn((String)photoAttribResultTable, (String)"RESULT"), null, 1));
            query.setCriteria(crit);
            DataObject resultDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = resultDo.getRows(baseTableName);
            while (it.hasNext()) {
                Hashtable<Object, String> userInfo = new Hashtable<Object, String>();
                Row row = (Row)it.next();
                for (int indx1 = 0; indx1 < attributeList.size(); ++indx1) {
                    Integer attribId = (Integer)((Properties)attributeList.get(indx1)).get("ATTRIB_ID");
                    String attribColName = ((Properties)attributeList.get(indx1)).getProperty("ATTRIB_COLUMN_NAME");
                    userInfo.put(attribId, (String)row.get(attribColName));
                }
                Row resultRow = resultDo.getRow("ADSMPhotoMgmtTempTable", uniqueOpIdCrit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)((String)row.get("OBJECT_GUID")), 0)));
                String resultVal = (String)resultRow.get("RESULT");
                if (resultVal.equalsIgnoreCase("SUCCESS")) {
                    resultVal = successMessage;
                }
                userInfo.put("MESSAGE", resultVal);
                list.add(userInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static String getMailServerForSingleUser(String domainName, Long loginId, String sAMAccountName) {
        String mailServer = null;
        try {
            Properties userProp;
            ArrayList list;
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            String searchString = "(&(objectCategory=person)(sAMAccountName=" + CommonUtil.escapeSpecialCharacters((String)sAMAccountName) + "))";
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("objectGuid");
            attribList.add("msExchHomeServerName");
            ArrayList userList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attribList, (String)searchString);
            if (userList != null && userList.size() > 0 && (list = (ArrayList)(userProp = (Properties)userList.get(0)).get("msExchHomeServerName")) != null) {
                mailServer = (String)list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailServer;
    }

    public static String getPhotoFromAD(HttpServletRequest request, String domainName, Long loginId, String photoAttribute, String sAMAccountName) {
        ArrayList<String> samAccountNameList = new ArrayList<String>();
        samAccountNameList.add(sAMAccountName);
        return ModifyPhotoListener.getPhotoFromAD(request, domainName, loginId, photoAttribute, samAccountNameList);
    }

    public static String getPhotoFromAD(HttpServletRequest request, String domainName, Long loginId, String photoAttribute, ArrayList samAccountNameList) {
        String errMsg = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            String searchString = "(&(objectCategory=person)";
            if (samAccountNameList.size() > 1) {
                searchString = searchString + "(|";
                for (int indx1 = 0; indx1 < samAccountNameList.size(); ++indx1) {
                    String sAMAccountName = (String)samAccountNameList.get(indx1);
                    searchString = searchString + "(sAMAccountName=" + CommonUtil.escapeSpecialCharacters((String)sAMAccountName) + ")";
                }
                searchString = searchString + ")";
            } else {
                searchString = searchString + "(sAMAccountName=" + CommonUtil.escapeSpecialCharacters((String)((String)samAccountNameList.get(0))) + ")";
            }
            searchString = searchString + ")";
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add(photoAttribute);
            attribList.add("objectGuid");
            attribList.add("sAMAccountName");
            String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
            File file = new File(photoFolder);
            file.mkdirs();
            NativeError errHdlr = new NativeError();
            ArrayList userList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attribList, (String)searchString, (NativeError)errHdlr);
            JSONObject errObj = new JSONObject();
            if (userList != null && userList.size() > 0 && userList.size() == samAccountNameList.size()) {
                for (int indx = 0; indx < userList.size(); ++indx) {
                    Properties userProp = (Properties)userList.get(indx);
                    if (userProp.get(photoAttribute) != null) continue;
                    String objectGuid = (String)((ArrayList)userProp.get("objectGuid")).get(0);
                    UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (String)"", (String)objectGuid);
                }
            } else if (userList != null && userList.size() > 0) {
                for (int indx = 0; indx < userList.size(); ++indx) {
                    Properties userProp = (Properties)userList.get(indx);
                    if (!samAccountNameList.contains((String)userProp.get("sAMAccountName"))) {
                        String error;
                        Hashtable errTable = errHdlr.getError((Object)domainName);
                        if (errTable != null && !errTable.isEmpty()) {
                            error = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_AD_error") + " - " + rb.getString((String)errTable.get("ERROR_MESSAGE"));
                            errObj.put((String)userProp.get("objectGuid"), (Object)error);
                        } else {
                            error = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_AD_error") + " - " + rb.getString("admp.ad_explorer.favorites.text.unable_retrieve_props_for_object");
                            errObj.put((String)userProp.get("objectGuid"), (Object)error);
                        }
                    }
                    if (userProp.get(photoAttribute) != null) continue;
                    String objectGuid = (String)((ArrayList)userProp.get("objectGuid")).get(0);
                    UserPhotoMgmtUtil.writePhotoToFile((String)ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute), (String)"", (String)objectGuid);
                }
            } else {
                Hashtable errTable = errHdlr.getError((Object)domainName);
                if (errTable != null && !errTable.isEmpty()) {
                    String error = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_AD_error") + " - " + rb.getString((String)errTable.get("ERROR_MESSAGE"));
                    errObj.put("ALL", (Object)error);
                }
            }
            errMsg = errObj.length() > 0 ? errObj.toString() : errMsg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return errMsg;
    }

    public static Properties getMailboxEnabledUsers(String domainName, Long loginId) {
        Properties mailboxEnabledUserProps = new Properties();
        try {
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            String searchString = "(&(objectCategory=person)(objectClass=user)(mailnickname=*)(|(homeMDB=*)(msExchHomeServerName=*)))";
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("objectGuid");
            attribList.add("msExchHomeServerName");
            ArrayList userDetailsList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attribList, (String)searchString);
            for (Properties userProp : userDetailsList) {
                mailboxEnabledUserProps.put((String)((ArrayList)userProp.get("objectGuid")).get(0), (String)((ArrayList)userProp.get("msExchHomeServerName")).get(0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mailboxEnabledUserProps;
    }

    public static void deleteExchCacheFolder(String photoFolderPath, String uniqueOperationId) {
        try {
            photoFolderPath = photoFolderPath.replace("exchangePhoto", "cachedExchangePhotos");
            photoFolderPath = photoFolderPath + uniqueOperationId;
            File cacheFolder = new File(photoFolderPath);
            if (cacheFolder.exists()) {
                File[] cacheFiles = cacheFolder.listFiles();
                for (int i = 0; i < cacheFiles.length; ++i) {
                    cacheFiles[i].delete();
                }
                if (cacheFolder.delete()) {
                    logger.log(Level.INFO, "Exchange Cache Folder Deleted Successfully");
                } else {
                    logger.log(Level.INFO, "some Error Occured while deleting cached exchange photos");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPhotoFileAsHex(String photoFolder, String objectGuid) {
        FileInputStream fileInputStream = null;
        String hexValOfImage = null;
        try {
            File photoFile = new File(photoFolder + objectGuid);
            if (photoFile != null && photoFile.exists()) {
                long diffLastModified = new Date().getTime() - photoFile.lastModified();
                if (diffLastModified < new Long(604800000L)) {
                    fileInputStream = new FileInputStream(photoFile);
                    byte[] bFile = new byte[(int)photoFile.length()];
                    fileInputStream.read(bFile);
                    hexValOfImage = StrUtil.byteArrayToHexString((byte[])bFile);
                } else {
                    photoFile.delete();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return hexValOfImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPhotoFileAsHexForReport(String photo) {
        FileInputStream fileInputStream = null;
        String hexValOfImage = null;
        try {
            File photoFile = new File(photo);
            if (photoFile != null && photoFile.exists()) {
                fileInputStream = new FileInputStream(photoFile);
                byte[] bFile = new byte[(int)photoFile.length()];
                fileInputStream.read(bFile);
                hexValOfImage = StrUtil.byteArrayToHexString((byte[])bFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return hexValOfImage;
    }

    public static String getPhotoFolder(HttpServletRequest request, String domainName, String photoLdapName) {
        String photoFolder = request.getSession().getServletContext().getRealPath("/") + "temp\\userPhotos\\" + photoLdapName + "\\" + domainName + "\\";
        return photoFolder;
    }

    public static String getRelativeFilePath(HttpServletRequest request, File photoFile) {
        URI photoFileURI = photoFile.toURI();
        String baseFolder = request.getSession().getServletContext().getRealPath("/");
        File baseFolderFile = new File(baseFolder);
        URI baseURI = baseFolderFile.toURI();
        URI relativeURI = baseURI.relativize(photoFileURI);
        return relativeURI.toString();
    }

    public static String getCachedExchPhotoFolder(HttpServletRequest request, String domainName, String uniqueOperationId) {
        return ModifyPhotoListener.getPhotoFolder(request, domainName, "cachedExchangePhotos") + uniqueOperationId;
    }

    public static ArrayList<Hashtable> getAttributeInfo(ArrayList<String> attributeList) {
        ArrayList<Hashtable> attributeDetList = new ArrayList<Hashtable>();
        try {
            if (attributeList != null && attributeList.size() > 0) {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAttributeDetails"));
                query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
                Criteria normalAttrCrit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)1501, 7);
                normalAttrCrit = normalAttrCrit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attributeList.toArray(), 8));
                Criteria custAttrCrit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)new Integer[]{1501, 2000}, 14);
                custAttrCrit = custAttrCrit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attributeList.toArray(), 8));
                custAttrCrit = custAttrCrit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"), (Object)"ADSMUserCustomDetails", 0));
                normalAttrCrit = normalAttrCrit.or(custAttrCrit);
                query.setCriteria(normalAttrCrit);
                DataObject attribDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (!attribDO.isEmpty()) {
                    Iterator it = attribDO.getRows("ADSMAttributeDetails");
                    while (it.hasNext()) {
                        Hashtable<String, Object> attrInfo = new Hashtable<String, Object>();
                        Row row = (Row)it.next();
                        attrInfo.put("ATTRIB_ID", row.get("ATTRIB_ID"));
                        attrInfo.put("ATTRIB_COLUMN_NAME", row.get("ATTRIB_COLUMN_NAME"));
                        attrInfo.put("TABLE_NAME", row.get("TABLE_NAME"));
                        attrInfo.put("ATTRIB_LDAP_NAME", row.get("ATTRIB_LDAP_NAME"));
                        attributeDetList.add(attrInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return attributeDetList;
    }

    public static Properties getDefaultFormatForHDT(Long loginId) {
        String defaultFormatType = "%displayName%";
        String defaultFormat = "%displayName%";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtSettings", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtSettings", crit);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow("ADSMPhotoMgmtSettings");
                defaultFormatType = (String)row.get("FORMAT_TYPE");
                defaultFormat = (String)row.get("FORMAT_VALUE");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Properties formatProp = new Properties();
        formatProp.setProperty("defaultFormatType", defaultFormatType);
        formatProp.setProperty("defaultFormat", defaultFormat);
        return formatProp;
    }

    public static void setDefaultFormatForHDT(Long loginId, String formatType, String formatValue) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtSettings", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtSettings", crit);
            if (dataObj.isEmpty()) {
                Row row = new Row("ADSMPhotoMgmtSettings");
                row.set("LOGIN_ID", (Object)loginId);
                row.set("FORMAT_TYPE", (Object)formatType);
                row.set("FORMAT_VALUE", (Object)formatValue);
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                dataObj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            } else {
                Row row = dataObj.getRow("ADSMPhotoMgmtSettings");
                row.set("FORMAT_TYPE", (Object)formatType);
                row.set("FORMAT_VALUE", (Object)formatValue);
                dataObj.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getContentTypeFromFileExtn(String fileExtn) {
        String returnStr = "image/";
        if (fileExtn != null) {
            if (fileExtn.equals("jpg")) {
                fileExtn = "jpeg";
            } else if (fileExtn.equals("ico")) {
                fileExtn = "x-icon";
            }
            returnStr = returnStr + fileExtn;
        }
        return returnStr;
    }

    public static String getContentType(String photoHex) {
        String fileExtn = ModifyPhotoListener.getFileExt(photoHex);
        return ModifyPhotoListener.getContentTypeFromFileExtn(fileExtn);
    }

    public static String getFileExt(String photoHex) {
        String fileExtn = "jpg";
        String lowerCaseHex = photoHex.toLowerCase();
        fileExtn = lowerCaseHex.startsWith("ffd8ffe0") ? "jpg" : (lowerCaseHex.startsWith("47494638") ? "gif" : (lowerCaseHex.startsWith("89504e47") ? "png" : (lowerCaseHex.startsWith("424d") ? "bmp" : (lowerCaseHex.startsWith("00000100") ? "ico" : "jpg"))));
        return fileExtn;
    }

    private class Action
    extends Thread {
        private JSONArray userDetails = new JSONArray();
        private String uniqueOperationId;
        private String domainName;
        private Long loginId;
        private String hostId;
        private Integer reportId;
        private String photoAttribute;
        private String photoFolder;
        private AdventNetResourceBundle rb;

        public Action(String domainName, Long loginId, Integer reportId, String hostId, String uniqueOperationId, String photoAttributeLdapName, String photoFolder, JSONArray userDetails, AdventNetResourceBundle rb) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.reportId = reportId;
            this.hostId = hostId;
            this.uniqueOperationId = uniqueOperationId;
            this.userDetails = userDetails;
            this.rb = rb;
            this.photoAttribute = photoAttributeLdapName;
            this.photoFolder = photoFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList auditIdList = new ArrayList();
            ArrayList auditObjectIdList = new ArrayList();
            ArrayList<String> objectOUList = new ArrayList<String>();
            try {
                for (int indx = 0; indx < this.userDetails.length(); ++indx) {
                    String opStatus = operationStatusHash.get(this.uniqueOperationId);
                    if (opStatus != null && opStatus.equalsIgnoreCase("STOP")) {
                        break;
                    }
                    JSONObject userData = (JSONObject)this.userDetails.get(indx);
                    String objectGuid = userData.getString("OBJECT_GUID");
                    String mailServer = null;
                    if (userData.has("MAILBOX_SERVER")) {
                        mailServer = userData.getString("MAILBOX_SERVER");
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)this.uniqueOperationId, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                    DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", crit);
                    Row tmpRow = dataObject.getRow("ADSMPhotoMgmtTempTable");
                    String hexValOfImage = (String)tmpRow.get("PHOTO_HEX");
                    String filePath = (String)tmpRow.get("PHOTO_FILE_PATH");
                    byte[] byteArrOfImg = null;
                    String tempPhotoAttribute = this.photoAttribute;
                    String tempPhotoFolder = this.photoFolder;
                    String samAccountName = userData.getString("SAM_ACCOUNT_NAME");
                    String dn = userData.getString("DISTINGUISHED_NAME");
                    String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
                    if (!objectOUList.contains(ouName)) {
                        objectOUList.add(ouName);
                    }
                    if (this.photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                        File file = new File(filePath);
                        String fileName = file.getName();
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byteArrOfImg = new byte[(int)file.length()];
                        fileInputStream.read(byteArrOfImg);
                        fileInputStream.close();
                    } else {
                        int hexStrLen = hexValOfImage.length();
                        byteArrOfImg = new byte[hexStrLen / 2];
                        for (int indx1 = 0; indx1 < hexStrLen; indx1 += 2) {
                            byteArrOfImg[indx1 / 2] = (byte)((Character.digit(hexValOfImage.charAt(indx1), 16) << 4) + Character.digit(hexValOfImage.charAt(indx1 + 1), 16));
                        }
                    }
                    String status = "";
                    boolean isSuccess = false;
                    try {
                        if (CommonUtil.isDemo()) {
                            status = this.rb.getString("admp.common.text.this_option_disable_for_online_demo");
                        } else {
                            if (this.photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                                if (mailServer != null) {
                                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailServer);
                                    status = ADHandler.setExchangePhoto((String)this.domainName, (long)this.loginId, (String)objectGuid, (String)filePath, (Properties)exchangeServerDetails);
                                    if (status.length() == 0) {
                                        File file = new File(filePath);
                                        String fileName = file.getName();
                                        tempPhotoAttribute = "thumbnailPhoto";
                                        tempPhotoFolder = this.photoFolder.replace(this.photoAttribute, tempPhotoAttribute);
                                        byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                                        UserPhotoMgmtUtil.writePhotoToFile((String)tempPhotoFolder, (byte[])byteArrOfImg, (String)objectGuid);
                                    }
                                }
                                if (mailServer == null || !status.equals("")) {
                                    status = mailServer == null ? status + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.exchange_photo_cannot_be_set") : this.rb.getString(status);
                                    File file = new File(filePath);
                                    String fileName = file.getName();
                                    tempPhotoAttribute = "thumbnailPhoto";
                                    tempPhotoFolder = this.photoFolder.replace(this.photoAttribute, tempPhotoAttribute);
                                    byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                                    ADHandler.setUserPhoto((String)this.domainName, (Long)this.loginId, (String)userData.getString("SID_STRING"), (String)dn, (byte[])byteArrOfImg, (String)tempPhotoAttribute);
                                    UserPhotoMgmtUtil.writePhotoToFile((String)tempPhotoFolder, (byte[])byteArrOfImg, (String)userData.getString("OBJECT_GUID"));
                                    status = status + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully");
                                }
                            } else {
                                ADHandler.setUserPhoto((String)this.domainName, (Long)this.loginId, (String)userData.getString("SID_STRING"), (String)dn, (byte[])byteArrOfImg, (String)tempPhotoAttribute);
                            }
                            if (status.equals("")) {
                                status = this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
                                UserPhotoMgmtUtil.writePhotoToFile((String)this.photoFolder, (byte[])byteArrOfImg, (String)userData.getString("OBJECT_GUID"));
                                isSuccess = true;
                            }
                        }
                    }
                    catch (LocalizedException ex) {
                        ex.printStackTrace();
                        ex.printStackTrace();
                        String key = "admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error";
                        if (status.length() > 0) {
                            key = "admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_error";
                            status = status + " ";
                        }
                        status = status + this.rb.getString(key) + ex.getMessage(this.rb);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        status = this.rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + this.rb.getString("admp.mgmt.gpo_mgmt_some_err_occ");
                    }
                    Criteria updateResultCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)userData.getString("OBJECT_GUID"), 0);
                    updateResultCrit = updateResultCrit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)this.uniqueOperationId, 0));
                    DataObject resultDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", updateResultCrit);
                    if (resultDO != null && !resultDO.isEmpty()) {
                        Row row = resultDO.getRow("ADSMPhotoMgmtTempTable");
                        row.set("PHOTO_HEX", (Object)"");
                        row.set("RESULT", (Object)(isSuccess ? "SUCCESS" : status));
                        resultDO.updateRow(row);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update(resultDO);
                    }
                    ArrayList setAttributeList = new ArrayList();
                    ModifyPhotoListener.auditPhotoModification(this.domainName, this.loginId, samAccountName, this.hostId, this.reportId, setAttributeList, status, this.rb, auditIdList, auditObjectIdList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                operationStatusHash.remove(this.uniqueOperationId);
            }
            try {
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMPhotoMgmtTempTable");
                updateQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)this.uniqueOperationId, 0));
                updateQuery.setUpdateColumn("PHOTO_HEX", (Object)"");
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
                ModifyPhotoListener.this.triggerNotification(auditIdList, auditObjectIdList, this.domainName, this.loginId, this.rb, objectOUList);
                if (this.photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                    ModifyPhotoListener.deleteExchCacheFolder(this.photoFolder, this.uniqueOperationId);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

