/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ModifyProfileAttributeListener
extends ModifyUserListener {
    public ModifyProfileAttributeListener() {
        this.reportId = new Integer(1005);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1017L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            boolean homeFolderOptionSelected = false;
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p1;
                Properties p;
                Properties p2;
                if (selectedAttributes[j].equals("profilePath")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1220L)) continue;
                    p2 = new Properties();
                    String ppath = FormatClientUtil.getFormatValue(props.getProperty(selectedAttributes[j]), result, domainName, "");
                    if (ppath.equals("")) {
                        p2.put("DW_CONTROL_CODE", new Long(1L));
                    }
                    p2.put("ATTRIB_VALUE", ppath);
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("DATA_HANDLER_TYPE", new Long(3L));
                    p2.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                    setAttributeList.add(p2);
                    continue;
                }
                if (selectedAttributes[j].equals("scriptPath")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1221L)) continue;
                    p2 = new Properties();
                    String spath = FormatClientUtil.getFormatValue(props.getProperty(selectedAttributes[j]), result, domainName, "");
                    if (spath.equals("")) {
                        p2.put("DW_CONTROL_CODE", new Long(1L));
                    }
                    p2.put("ATTRIB_VALUE", spath);
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("DATA_HANDLER_TYPE", new Long(3L));
                    p2.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                    setAttributeList.add(p2);
                    continue;
                }
                if (!selectedAttributes[j].equals("homeFolderOption") || !ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1222L)) continue;
                String homeFolderOption = props.getProperty("homeFolderOption");
                if (homeFolderOption.equals("true")) {
                    p = new Properties();
                    String localPath = FormatClientUtil.getFormatValue(props.getProperty("localPathHomeDirectory"), result, domainName, "");
                    if (localPath.equals("")) {
                        p.put("DW_CONTROL_CODE", new Long(1L));
                    }
                    p.put("ATTRIB_LDAP_NAME", "homeDirectory");
                    p.put("ATTRIB_VALUE", localPath);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(p);
                    p1 = new Properties();
                    p1.put("ATTRIB_LDAP_NAME", "homeDrive");
                    p1.put("ATTRIB_VALUE", "");
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("DATA_HANDLER_TYPE", new Long(3L));
                    p1.put("DW_CONTROL_CODE", new Long(1L));
                    setAttributeList.add(p1);
                    continue;
                }
                homeFolderOptionSelected = true;
                p = new Properties();
                String connectPath = FormatClientUtil.getFormatValue(props.getProperty("connectHomeDirectory"), result, domainName, "");
                if (connectPath.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                p.put("ATTRIB_LDAP_NAME", "homeDirectory");
                p.put("ATTRIB_VALUE", connectPath);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                setAttributeList.add(p);
                p1 = new Properties();
                p1.put("ATTRIB_LDAP_NAME", "homeDrive");
                p1.put("ATTRIB_VALUE", props.getProperty("homeDrive"));
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("DATA_HANDLER_TYPE", new Long(3L));
                setAttributeList.add(p1);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    ArrayList aceList = new ArrayList();
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                    }
                    if (homeFolderOptionSelected) {
                        try {
                            aceList = UserPermissionsHandler.getInstance().getDefaultACEList(sid, null, domainName);
                            ADHandlerForMgmt.createFileFolder((String)domainName, (Long)loginId, (String)FormatClientUtil.getFormatValue(props.getProperty("connectHomeDirectory"), result, domainName, ""), (String)sid, null, (ArrayList)aceList);
                        }
                        catch (LocalizedException le) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.statmsg.error_in_creating_home_folder") + le.getMessage(this.rb));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.statmsg.error_in_creating_home_folder") + ex.getMessage());
                        }
                    }
                } else {
                    message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.mgmtname.profile_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        try {
            String beanValue;
            String emptyFields = "";
            Locale locale = request.getLocale();
            List<String> selectedAttributes = Arrays.asList((String[])bean.get("selectedAttributes"));
            BeanMap props = (BeanMap)bean.get("props");
            if (selectedAttributes.contains("homeFolderOption")) {
                String homeFolderOption = (String)props.get("homeFolderOption");
                String beanValue2 = null;
                beanValue2 = homeFolderOption.equals("true") ? props.getProperty("localPathHomeDirectory") : props.getProperty("connectHomeDirectory");
                if (beanValue2.equals("")) {
                    emptyFields = emptyFields.length() == 0 ? this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.homefolder") : emptyFields + "," + this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.homefolder");
                }
            }
            if (selectedAttributes.contains("profilePath") && (beanValue = props.getProperty("profilePath")).equals("")) {
                emptyFields = emptyFields.length() == 0 ? this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.profile_path") : emptyFields + "," + this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.profile_path");
            }
            if (selectedAttributes.contains("scriptPath") && (beanValue = props.getProperty("scriptPath")).equals("")) {
                emptyFields = emptyFields.length() == 0 ? this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.logon_script") : emptyFields + "," + this.rb.getString("admp.mgmt.user_mgmt.prof_attribs.input.logon_script");
            }
            if (emptyFields.length() != 0) {
                emptyFields = MessageFormat.format(this.rb.getString("admp.mgmt.common.confirm.blank_values_cleared_in_ad_want_to_continue"), emptyFields);
                request.setAttribute("emptyFields", (Object)emptyFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

