/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ModifySMTPAddressListener
extends ModifyUserListener {
    public ModifySMTPAddressListener() {
        this.reportId = new Integer(1014);
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        BeanMap props = (BeanMap)bean.get("props");
        String userType = (String)props.get("userType");
        logger.log(Level.INFO, "userType in ModifySMTPAddressListener : " + userType);
        str.append("(&(objectCategory=person)(objectClass=user)");
        if (userType.equals("mailEnabledUsers")) {
            str.append("(mailnickname=*)(targetAddress=*)");
        } else if (userType.equals("mailBoxEnabledUsers")) {
            str.append("(mailnickname=*)(|(homeMDB=*)(msExchHomeServerName=*))");
        }
        if (searchString != null && !searchString.equals("")) {
            this.getSearchString(searchString, str);
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in ModifySMTPAddressListener : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            BeanMap props = (BeanMap)bean.get("props");
            logger.log(Level.INFO, "Calling Modify User in the ModifySMTPAddressListener");
            String userType = (String)props.get("userType");
            String[] proxyAddress = (String[])props.get("proxyAddressValues");
            ArrayList<String> newProxyAddressList = new ArrayList<String>();
            String dn = this.getValue(result, 1004);
            for (int i = 0; proxyAddress != null && i < proxyAddress.length; ++i) {
                String value = FormatClientUtil.getFormatValue(proxyAddress[i], result, domainName, "");
                if (value.equals("")) continue;
                newProxyAddressList.add(value);
            }
            String OBJECT_GUID = (String)result.get("OBJECT_GUID");
            OBJECT_GUID = OBJECT_GUID.substring(OBJECT_GUID.indexOf("{") + 1, OBJECT_GUID.lastIndexOf("}"));
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add("proxyAddresses");
            attrList.add("targetAddress");
            Properties userDetails = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)OBJECT_GUID, attrList);
            ArrayList toBeUpdatedProxyAddressList = (ArrayList)userDetails.get("proxyAddresses");
            if (toBeUpdatedProxyAddressList == null) {
                toBeUpdatedProxyAddressList = new ArrayList();
            }
            if (newProxyAddressList.size() > 0) {
                this.updateProxyAddressList(toBeUpdatedProxyAddressList, newProxyAddressList);
            }
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            String sid = this.getValue(result, 1144);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            try {
                String newTargetAddress;
                if (userType.equals("mailEnabledUsers") && (newTargetAddress = (String)props.get("TARGET_ADDRESS")) != null && !newTargetAddress.equals("")) {
                    String targetValue = FormatClientUtil.getFormatValue(newTargetAddress, result, domainName, "");
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    p.put("ATTRIB_VALUE", targetValue);
                    p.put("ATTRIB_LDAP_NAME", "targetAddress");
                    setAttributeList.add(p);
                    ArrayList existingTargetAddressList = (ArrayList)userDetails.get("targetAddress");
                    String existingTargetAddressVal = (String)existingTargetAddressList.get(0);
                    this.addTargetAddress(toBeUpdatedProxyAddressList, existingTargetAddressVal, targetValue);
                }
                if (toBeUpdatedProxyAddressList.size() > 0) {
                    int count = 0;
                    count = toBeUpdatedProxyAddressList.size();
                    Properties p = new Properties();
                    p = new Properties();
                    p.put("ATTRIB_VALUE_COUNT", new Long(count));
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    if (count == 1) {
                        p.put("ATTRIB_VALUE", toBeUpdatedProxyAddressList.get(0));
                    } else {
                        p.put("ATTRIB_VALUE", toBeUpdatedProxyAddressList);
                    }
                    p.put("ATTRIB_LDAP_NAME", "proxyAddresses");
                    setAttributeList.add(p);
                }
                logger.log(Level.INFO, "Starts Modifying User bean: " + setAttributeList + " : domainName : " + domainName);
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                message.append(this.rb.getString("usermanagement.modify_SMTP_address_listener.successfully_modified"));
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.mod_smtp_address.error_occured"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.mod_smtp_address.mgmtname.modify_smtp_address"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }

    private void addTargetAddress(ArrayList existingProxyAddressList, String existingTargetAddressVal, String newTargetAddress) {
        existingProxyAddressList.remove(existingTargetAddressVal);
        if (newTargetAddress.startsWith("SMTP")) {
            this.changePrimary(existingProxyAddressList);
        }
        existingProxyAddressList.add(newTargetAddress);
    }

    private void updateProxyAddressList(ArrayList existingProxyAddressList, ArrayList newProxyAddressList) {
        for (int i = 0; i < newProxyAddressList.size(); ++i) {
            String proxyAddressVal = (String)newProxyAddressList.get(i);
            if (existingProxyAddressList.contains(proxyAddressVal)) continue;
            if (proxyAddressVal.startsWith("SMTP")) {
                this.changePrimary(existingProxyAddressList);
            }
            existingProxyAddressList.add(proxyAddressVal);
        }
    }

    private void changePrimary(ArrayList proxyAddresses) {
        for (int j = 0; j < proxyAddresses.size(); ++j) {
            String proxyAdd = (String)proxyAddresses.get(j);
            if (!proxyAdd.startsWith("SMTP")) continue;
            proxyAddresses.remove(j);
            proxyAdd = proxyAdd.replaceFirst("SMTP:", "smtp:");
            proxyAddresses.add(proxyAdd);
        }
    }
}

