/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRArrayList;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.validator.DynaValidatorForm;

public class SearchSIDsListener
implements NativeListener {
    private String[] columns = new String[]{"COMMON_NAME", "OBJECT_CLASS", "FQDN", "DOMAIN_NAME", "OBJECT_GUID"};
    private Long searchSidId = null;
    protected boolean isCompleted = true;
    protected boolean continueAction = true;
    private ArrayList list = new ArrayList();
    private long sleepMillis = 700L;
    private int count = 0;
    protected PrintWriter out = null;
    private String currentDomainName = null;
    protected boolean isExcludeChildOU = false;
    AdventNetResourceBundle rb = null;

    public void setWriter(PrintWriter o) {
        this.out = o;
    }

    public void setClientButtons(boolean flag) {
        if (this.out != null) {
            this.out.write("<script> setClientButtons(" + flag + "); </script>");
            this.out.flush();
        }
    }

    public boolean isExcludeChildOU() {
        return this.isExcludeChildOU;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
        this.isExcludeChildOU = isExcludeChildOU;
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public Long getSearchSidId() {
        return this.searchSidId;
    }

    public void setSearchSidId(Long searchId) {
        this.searchSidId = searchId;
    }

    public void setDomainName(String domain) {
        this.currentDomainName = domain;
    }

    public void stop(HttpServletRequest request) {
        System.out.println("Receiving Stop Action");
        this.continueAction = false;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCompleted() {
        return !this.continueAction;
    }

    public void controlUI() {
        if (this.isCompleted) {
            return;
        }
        boolean actionSet = false;
        while (!this.isCompleted && this.continueAction) {
            try {
                if (this.continueAction && !actionSet) {
                    this.setClientButtons(true);
                    actionSet = true;
                }
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.mgmt.security_mgmt.statmsg.error_occurred_message"), e.getMessage()));
            }
        }
        boolean check = true;
        try {
            if (this.out == null || this.out.checkError() || !this.isCompleted) {
                check = false;
            }
        }
        catch (Exception e) {
            check = false;
            e.printStackTrace();
        }
        if (check) {
            try {
                this.setClientButtons(false);
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.out = null;
    }

    public void updateDB() {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < this.list.size(); ++i) {
                dataObj.addRow((Row)this.list.get(i));
            }
            this.list = new ArrayList();
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addRow(Properties prop) {
        try {
            if (prop.get("objectGUID") == null) {
                System.out.println("Error Datas FROM NATIVE " + prop);
                return;
            }
            String[] parameters = new String[]{"cn", "objectClass", "distinguishedName", "objectSID", "objectGUID"};
            String[] params = new String[]{"COMMON_NAME", "OBJECT_CLASS", "FQDN", "SID_STRING", "OBJECT_GUID"};
            StringBuffer str = new StringBuffer();
            Row r = new Row("ADSMSearchSIDsResult");
            str.append("[");
            for (int i = 0; i < parameters.length; ++i) {
                Object obj = prop.get(parameters[i]);
                String s = null;
                if (obj != null) {
                    if (obj instanceof ArrayList) {
                        ArrayList l = (ArrayList)obj;
                        if (l.size() != 0) {
                            s = (String)l.get(l.size() - 1);
                        }
                    } else {
                        s = (String)obj;
                    }
                }
                if (i > 0) {
                    str.append(",");
                }
                if (s != null) {
                    str.append("'" + s + "'");
                    r.set(params[i], (Object)s);
                    continue;
                }
                str.append("'-'");
                r.set(params[i], (Object)"-");
            }
            str.append(",'" + this.currentDomainName + "'");
            str.append("]");
            r.set("SEARCH_SID_ID", (Object)this.searchSidId);
            r.set("DOMAIN_NAME", (Object)this.currentDomainName);
            this.list.add(r);
            if (this.list.size() > 50) {
                this.updateDB();
            }
            if (this.out != null) {
                if (this.count < 25) {
                    this.out.write("<script>updateUI(" + str + ")</script>");
                    this.out.flush();
                }
                ++this.count;
                this.out.write("<script> updateCount(" + this.count + ")</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable constructExcludeContainerHash(ArrayList containerList, Hashtable domainVsExcludeChildOU, Hashtable excludedOUHash, Hashtable dnDomainNameMap) {
        Hashtable<String, Boolean> excludeContainerHash = new Hashtable<String, Boolean>();
        for (int i = 0; i < containerList.size(); ++i) {
            String dn = (String)containerList.get(i);
            String domainName = (String)dnDomainNameMap.get(dn);
            Boolean isExcludeChildOU = Boolean.FALSE;
            if (domainVsExcludeChildOU != null && domainName != null && domainVsExcludeChildOU.containsKey(domainName)) {
                isExcludeChildOU = (Boolean)domainVsExcludeChildOU.get(domainName);
            }
            if (isExcludeChildOU.booleanValue()) {
                excludeContainerHash.put(dn, isExcludeChildOU);
                continue;
            }
            Boolean isParentOfExcludedOU = Boolean.FALSE;
            ArrayList excludedOUList = new ArrayList();
            if (excludedOUHash != null && excludedOUHash.containsKey(domainName)) {
                excludedOUList = (ArrayList)excludedOUHash.get(domainName);
            }
            for (int counter = 0; counter < excludedOUList.size(); ++counter) {
                String excludedOUDN = (String)excludedOUList.get(counter);
                if (!excludedOUDN.endsWith(dn)) continue;
                isParentOfExcludedOU = Boolean.TRUE;
                break;
            }
            excludeContainerHash.put(dn, isParentOfExcludedOU);
        }
        return excludeContainerHash;
    }

    public void completedAction() {
        System.out.println("Receiving Completed Action");
        this.updateDB();
        this.updateSearchStatus(this.searchSidId, 1);
        this.isCompleted = true;
    }

    public void search(HttpServletRequest request, Hashtable dnDomainNameMap, DynaValidatorForm bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            int i;
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            String searchString = request.getParameter("searchString");
            String searchType = request.getParameter("searchType");
            String parameterName = request.getParameter("parameterName");
            String dispParam = "";
            String dispSearchType = "";
            String[] parametersList = new String[]{"All", "cn", "description", "mailNickName", "displayName", "name", "physicalDeliveryOfficeName", "displayNamePrintable", "operatingSystem", "operatingSystemVersion", "l", "sAMAccountName", "company", "mail", "initials", "sn", "homeDrive", "userWorkstations", "userPrincipalName", "st", "streetAddress", "employeeID"};
            String[] parameterDisplay = new String[]{this.rb.getString("admp.common.text.all"), this.rb.getString("admp.common.attrib_disp_name.common_name"), this.rb.getString("admp.common.attrib_disp_name.desc"), this.rb.getString("admp.common.attrib_disp_name.mail_alias"), this.rb.getString("admp.common.attrib_disp_name.display_name"), this.rb.getString("admp.common.attrib_disp_name.name"), this.rb.getString("admp.common.attrib_disp_name.office"), this.rb.getString("admp.common.attrib_disp_name.simple_display_name"), this.rb.getString("admp.common.attrib_disp_name.os"), this.rb.getString("admp.common.attrib_disp_name.os_version"), this.rb.getString("admp.common.attrib_disp_name.city"), this.rb.getString("admp.common.attrib_disp_name.sam_name"), this.rb.getString("admp.common.attrib_disp_name.company"), this.rb.getString("admp.common.attrib_disp_name.e_mail_address"), this.rb.getString("admp.common.attrib_disp_name.initial"), this.rb.getString("admp.common.attrib_disp_name.last_name"), this.rb.getString("admp.common.attrib_disp_name.home_drive"), this.rb.getString("admp.common.attrib_disp_name.logon_to"), this.rb.getString("admp.common.attrib_disp_name.logon_name"), this.rb.getString("admp.common.attrib_disp_name.state_province"), this.rb.getString("admp.common.attrib_disp_name.street_address"), this.rb.getString("admp.common.attrib_disp_name.emp_id")};
            String[] searchTypes = (String[])bean.get("searchTypes");
            String[] searchDisplay = (String[])bean.get("searchTypesDisplay");
            for (i = 0; i < parametersList.length; ++i) {
                if (!parameterName.equalsIgnoreCase(parametersList[i])) continue;
                dispParam = parameterDisplay[i];
                break;
            }
            for (i = 0; i < searchTypes.length; ++i) {
                if (!searchType.equalsIgnoreCase(searchTypes[i])) continue;
                dispSearchType = searchDisplay[i];
                break;
            }
            String criteria = " " + dispParam + " " + dispSearchType + " " + searchString + ".";
            this.addSearchParams(parameterName, searchType, searchString);
            bean.set("searchSIDID", (Object)this.searchSidId);
            ArrayList containerList = ListenerUtil.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String[] ous = (String[])bean.get("ous");
            String[] domains = (String[])bean.get("domains");
            String domainName = "";
            for (int i2 = 0; domains != null && i2 < domains.length; ++i2) {
                String val = domains[i2];
                if (val.equalsIgnoreCase("")) continue;
                if (val.endsWith("disable")) {
                    val = val.substring(0, val.lastIndexOf("disable"));
                }
                domains[i2] = val;
                domainName = domainName + (String)dnDomainNameMap.get(val);
                if (i2 == domains.length - 1) continue;
                domainName = domainName + ", ";
            }
            bean.set("domains", (Object)domains);
            if (!parameterName.equals("All")) {
                searchString = searchType.equals("startsWith") ? (searchString.contains("*") ? "(" + parameterName + "=" + searchString + ")" : "(" + parameterName + "=" + searchString + "*)") : (searchType.equals("endsWith") ? (searchString.contains("*") ? "(" + parameterName + "=" + searchString + ")" : "(" + parameterName + "=*" + searchString + ")") : (searchType.equals("equals") ? "(" + parameterName + "=" + searchString + ")" : (searchType.equals("notEquals") ? (searchString != null && !searchString.equals("") ? "(!(" + parameterName + "=" + searchString + "))" : "(!(" + parameterName + "= * ))") : (searchString.equals("") || searchString.equals("*") ? "(" + parameterName + "=*)" : "(" + parameterName + "=*" + searchString + "*)"))));
            }
            StringBuffer str = new StringBuffer();
            str.append("(|");
            String[] categories = request.getParameterValues("categories");
            String categoryList = "";
            for (int i3 = 0; categories != null && i3 < categories.length; ++i3) {
                ObjectClass objectClass;
                if (categories[i3].equals("Users")) {
                    objectClass = DirectoryObjectAPI.getInstance().getObjectClass("user");
                    str.append(objectClass.getLdapCriteia().replace("(cn=", ""));
                    categoryList = categoryList + this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.objectclass.users") + ", ";
                } else if (categories[i3].equals("Groups")) {
                    objectClass = DirectoryObjectAPI.getInstance().getObjectClass("group");
                    str.append(objectClass.getLdapCriteia().replace("(cn=", ""));
                    categoryList = categoryList + this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.objectclass.groups") + ", ";
                } else if (categories[i3].equals("Computers")) {
                    objectClass = DirectoryObjectAPI.getInstance().getObjectClass("computer");
                    str.append(objectClass.getLdapCriteia().replace("(cn=", ""));
                    categoryList = categoryList + this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.objectclass.computers") + ", ";
                }
                str.append(searchString);
                str.append(")");
            }
            str.append(")");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            if (categoryList != null && !categoryList.equals("")) {
                categoryList = categoryList.substring(0, categoryList.length() - 2);
            }
            String domainContainer = "";
            for (int i4 = 0; i4 < containerList.size(); ++i4) {
                String dn = (String)containerList.get(i4);
                domainContainer = domainContainer + StrUtil.getNameFromDN((String)dn) + ", ";
            }
            if (domainContainer != null && !domainContainer.equals("")) {
                domainContainer = domainContainer.substring(0, domainContainer.length() - 2);
            }
            inputParams.put("domainList", domainName);
            inputParams.put("categoryList", categoryList);
            inputParams.put("criteria", criteria);
            inputParams.put("domainContainer", domainContainer);
            inputParams.put("COMMON_NAME", "COMMON_NAME");
            inputParams.put("OBJECT_CLASS", "OBJECT_CLASS");
            inputParams.put("FQDN", "FQDN");
            inputParams.put("DOMAIN_NAME", "DOMAIN_NAME");
            inputParams.put("domains", this.rb.getString("admp.mgmt.common.text.domains"));
            inputParams.put("categories", this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.text.search_for_catogeries"));
            inputParams.put("forCriteria", this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.text.for_the_criteria"));
            inputParams.put("domainsOU", this.rb.getString("admp.mgmt.security_mgmt.search_ad_objs.text.domain_ous"));
            inputParams.put("name", this.rb.getString("admp.common.attrib_disp_name.name"));
            inputParams.put("objectClass", this.rb.getString("admp.common.attrib_disp_name.object_class"));
            inputParams.put("fqdnValue", this.rb.getString("admp.common.attrib_disp_name.fqdn"));
            inputParams.put("domainName", this.rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
            bean.set("inputParams", inputParams);
            System.out.println("The categoryList : " + categoryList + " criteria : " + criteria);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(loginId, containerList, str.toString(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSearchParams(String parameterName, String searchType, String searchString) {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row r = new Row("ADSMSearchSIDs");
            r.set("PARAMETER_NAME", (Object)parameterName);
            r.set("SEARCH_TYPE", (Object)searchType);
            r.set("SEARCH_STRING", (Object)searchString);
            r.set("CREATION_TIME", (Object)new Long(System.currentTimeMillis()));
            r.set("STATUS", (Object)new Integer(0));
            dataObj.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            this.searchSidId = (Long)r.get("SEARCH_SID_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchResult(HttpServletRequest request, Integer range) {
        Integer count = this.getSearchResultCount();
        if (count != null && count != 0) {
            String columnName;
            long startIndex = 1L;
            long endIndex = range.intValue();
            if (request.getParameter("FROM_INDEX") != null) {
                startIndex = new Long(request.getParameter("FROM_INDEX"));
                endIndex = new Long(request.getParameter("TO_INDEX"));
            }
            if ((columnName = request.getParameter("columnName")) == null) {
                columnName = "COMMON_NAME";
            }
            String ascending = "true";
            if (request.getParameter("ascending") != null) {
                ascending = request.getParameter("ascending");
            }
            request.setAttribute("range", (Object)range);
            request.setAttribute("FROM_INDEX", (Object)String.valueOf(startIndex));
            request.setAttribute("TO_INDEX", (Object)String.valueOf(endIndex));
            request.setAttribute("columnName", (Object)columnName);
            request.setAttribute("ascending", (Object)ascending);
            ArrayList list = this.getRows(columnName, new Boolean(ascending), new Long(startIndex).intValue(), range);
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("result", (Object)list);
        } else {
            request.setAttribute("errorMsg", (Object)"No Result");
        }
    }

    public void updateSearchStatus(Long generationId, int status) {
        try {
            Column col = new Column("ADSMSearchSIDs", "SEARCH_SID_ID");
            Criteria criteria = new Criteria(col, (Object)this.searchSidId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMSearchSIDs", criteria);
            Row r = dataObj.getRow("ADSMSearchSIDs");
            r.set("STATUS", (Object)new Integer(status));
            dataObj.updateRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getRows(String columnName, boolean ascending, int startIndex, int numOfObjects) {
        return this.getRows(columnName, ascending, startIndex, numOfObjects, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRows(String columnName, boolean ascending, int startIndex, int numOfObjects, HashMap attribIdMapping) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = new Table("ADSMSearchSIDsResult");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            for (int i = 0; i < this.columns.length; ++i) {
                selectColumnList.add(new Column("ADSMSearchSIDsResult", this.columns[i]));
            }
            query.addSelectColumns(selectColumnList);
            Criteria generationCriteria = new Criteria(new Column("ADSMSearchSIDsResult", "SEARCH_SID_ID"), (Object)this.searchSidId, 0);
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            Column column1 = new Column("ADSMSearchSIDsResult", columnName);
            SortColumn sortcolumn = new SortColumn(column1, ascending);
            query.addSortColumn(sortcolumn);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                for (int i = 0; i < selectColumnList.size(); ++i) {
                    Column column = (Column)selectColumnList.get(i);
                    String colName = column.getColumnName();
                    Object fname = attribIdMapping.get(colName);
                    if (dataSet.getValue(i + 1) == null) continue;
                    if (fname != null) {
                        Integer attrId = (Integer)fname;
                        resultTable.put(attrId, dataSet.getValue(i + 1));
                        continue;
                    }
                    resultTable.put(colName, dataSet.getValue(i + 1));
                }
                resultList.add(resultTable);
            }
            dataSet.close();
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public Integer getSearchResultCount() {
        Integer ret = null;
        try {
            Column countColumn = new Column(null, "*");
            Criteria crit = new Criteria(new Column("ADSMSearchSIDsResult", "SEARCH_SID_ID"), (Object)this.searchSidId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMSearchSIDsResult"));
            sq.addSelectColumn(countColumn.count());
            sq.setCriteria(crit);
            ret = DBUtil.getCount((SelectQuery)sq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport(String reportFileName, String reportType, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        String columnName = request.getParameter("columnName");
        ArrayList list = new ArrayList();
        if (columnName == null || columnName.equals("")) {
            columnName = "COMMON_NAME";
        }
        String ascending = "true";
        if (request.getParameter("ascending") != null) {
            ascending = request.getParameter("ascending");
        }
        JRArrayList tempJRReportList = new JRArrayList();
        reportFileName = "SearchSIDs";
        Long loginId = null;
        HttpSession session = request.getSession();
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        try {
            int exportPerRowCount;
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName + ".xml";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            jasperDesign.setName(EscapeUtil.escSplCharsAsHTML((Object)reportFileName));
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            ArrayList<Properties> attributelist = new ArrayList<Properties>();
            Properties attributeProp1 = new Properties();
            attributeProp1.put("ATTRIB_ID", (Object)9001);
            attributeProp1.put("ATTRIB_LDAP_NAME", "cn");
            attributeProp1.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.name"));
            attributeProp1.put("TABLE_NAME", "EMPTY");
            attributeProp1.put("ATTRIB_COLUMN_NAME", "COMMON_NAME");
            attributelist.add(attributeProp1);
            Properties attributeProp2 = new Properties();
            attributeProp2.put("ATTRIB_ID", (Object)9002);
            attributeProp2.put("ATTRIB_LDAP_NAME", "objectClass");
            attributeProp2.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.obj_class"));
            attributeProp2.put("TABLE_NAME", "EMPTY");
            attributeProp2.put("ATTRIB_COLUMN_NAME", "OBJECT_CLASS");
            attributelist.add(attributeProp2);
            Properties attributeProp3 = new Properties();
            attributeProp3.put("ATTRIB_ID", (Object)9003);
            attributeProp3.put("ATTRIB_LDAP_NAME", "fqdn");
            attributeProp3.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.fqdn"));
            attributeProp3.put("TABLE_NAME", "EMPTY");
            attributeProp3.put("ATTRIB_COLUMN_NAME", "FQDN");
            attributelist.add(attributeProp3);
            Properties attributeProp4 = new Properties();
            attributeProp4.put("ATTRIB_ID", (Object)9004);
            attributeProp4.put("ATTRIB_LDAP_NAME", "domainName");
            attributeProp4.put("ATTRIB_DISP_NAME", rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
            attributeProp4.put("TABLE_NAME", "EMPTY");
            attributeProp4.put("ATTRIB_COLUMN_NAME", "DOMAIN_NAME");
            attributelist.add(attributeProp4);
            HashMap<String, Integer> columnAttribIdMapping = new HashMap<String, Integer>();
            columnAttribIdMapping.put("COMMON_NAME", 9001);
            columnAttribIdMapping.put("OBJECT_CLASS", 9002);
            columnAttribIdMapping.put("FQDN", 9003);
            columnAttribIdMapping.put("DOMAIN_NAME", 9004);
            Hashtable columnWidths = new Hashtable();
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int startIndex = 1;
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int noOfObjToFetch = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            list = this.getRows(columnName, new Boolean(ascending), startIndex, noOfObjToFetch, columnAttribIdMapping);
            columnWidths = JRDesignUtil.calculateWidth(attributelist, list, new Hashtable(), reportType, request, columnWidths, pageColumnWidth, true, showSerialNo, rb);
            Integer widthValue = (Integer)columnWidths.remove("maxColumnWidth");
            if (widthValue != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, JRFieldDesignUtil.getShowSerialNo(), locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            boolean isCSVExport = reportType.toLowerCase().indexOf("csv") != -1;
            JasperReport jasperReportBasedOnType = null;
            boolean isSingleSheet = false;
            if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            if (isCSVExport) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            } else {
                JRDesignBand titleBand = new JRDesignBand();
                titleBand.setHeight(0);
                jasperDesign.setTitle((JRBand)titleBand);
                if (isSingleSheet) {
                    jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
                }
                jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(list, new Hashtable(), true, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            int AddToPgNumber = 0;
            while (!list.isEmpty()) {
                AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, list, new Hashtable(), AddToPgNumber, jasperReportBasedOnType, jasperReport, dataSource, defaultHeaderBand, reportType, locale, isSingleSheet, JRFieldDesignUtil.getShowSerialNo(), startIndex, noOfObjToFetch);
                list = this.getRows(columnName, new Boolean(ascending), startIndex += noOfObjToFetch, noOfObjToFetch, columnAttribIdMapping);
                if (list.isEmpty()) continue;
                dataSource = new ReportJRDataSource(list, new Hashtable(), true, startIndex, reportType);
                columnWidths = JRDesignUtil.calculateWidth(attributelist, list, new Hashtable(), reportType, request, columnWidths, pageColumnWidth, false, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            tempJRReportList.deleteJRFiles();
            return;
        }
        reportFileName = "SearchResult";
        try {
            ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"jspf.create_admp_role.search", (String)"usermanagement.search_sids_mainpage.search_users_groups_computers", (Integer)1801, (String)"-", (Boolean)Boolean.FALSE, (String)(reportFileName + "." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)this.getSearchResultCount());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private NativeListener listener = null;
        private String searchString = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeChildOUHash = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, String s, NativeListener li, Hashtable d, Hashtable domainVsExcludeChildOU) {
            this.loginId = loginId;
            this.containerList = list;
            this.listener = li;
            this.searchString = s;
            this.dnDomainNameMap = d;
            this.excludeChildOUHash = domainVsExcludeChildOU;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    String domainName = (String)this.dnDomainNameMap.get(dn);
                    SearchSIDsListener.this.currentDomainName = domainName;
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    System.out.println("Searching the SIDs for the String " + this.searchString + " from the domain " + dn);
                    ADHandler.searchSIDs((String)domainName, (Long)this.loginId, (String)CommonUtil.escapeDN((String)dn), (String)this.searchString, (NativeListener)this.listener);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            SearchSIDsListener.this.count = 0;
            SearchSIDsListener.this.completedAction();
        }
    }
}

