/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class StorageLimitsListener
extends ModifyUserListener {
    public StorageLimitsListener() {
        this.reportId = new Integer(1010);
        this.cks = new String[]{"defaultStorageLimits", "warningOption", "prohibitSendOption", "prohibitSendAndRecvOption", "defaultDeletedItemRetention", "dontPermanentlyDelete"};
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1024L})) {
            return this.rb.getString("client.DomainAction.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p1;
                Properties p;
                if (selectedAttributes[j].equals("storageLimits")) {
                    Long value;
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1246L)) continue;
                    String defaultStorageLimits = props.getProperty("defaultStorageLimits");
                    p = new Properties();
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "mdbusedefaults");
                    p.put("ATTRIB_VALUE", defaultStorageLimits.toString().toUpperCase());
                    setAttributeList.add(p);
                    if (!defaultStorageLimits.equals("false")) continue;
                    String warningOption = props.getProperty("warningOption");
                    String prohibitSendOption = props.getProperty("prohibitSendOption");
                    String prohibitSendAndRecvOption = props.getProperty("prohibitSendAndRecvOption");
                    if (warningOption.equals("true")) {
                        p1 = new Properties();
                        p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p1.put("DATA_HANDLER_TYPE", new Long(7L));
                        p1.put("ATTRIB_LDAP_NAME", "mdbStorageQuota");
                        value = new Long(props.getProperty("warningSize")) * 1024L;
                        p1.put("ATTRIB_VALUE", value.toString());
                        setAttributeList.add(p1);
                    }
                    if (prohibitSendOption.equals("true")) {
                        p1 = new Properties();
                        p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p1.put("DATA_HANDLER_TYPE", new Long(7L));
                        p1.put("ATTRIB_LDAP_NAME", "mdbOverQuotaLimit");
                        value = new Long(props.getProperty("prohibitSendSize")) * 1024L;
                        p1.put("ATTRIB_VALUE", value.toString());
                        setAttributeList.add(p1);
                    }
                    if (!prohibitSendAndRecvOption.equals("true")) continue;
                    p1 = new Properties();
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("DATA_HANDLER_TYPE", new Long(7L));
                    p1.put("ATTRIB_LDAP_NAME", "mdbOverHardQuotaLimit");
                    value = new Long(props.getProperty("prohibitSendAndRecvSize")) * 1024L;
                    p1.put("ATTRIB_VALUE", value.toString());
                    setAttributeList.add(p1);
                    continue;
                }
                if (!selectedAttributes[j].equals("deletedItemRetention") || !ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1247L)) continue;
                String defaultDeletedItemRetention = props.getProperty("defaultDeletedItemRetention");
                if (defaultDeletedItemRetention.equals("true")) {
                    p = new Properties();
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "deletedItemFlags");
                    p.put("ATTRIB_VALUE", "3");
                    p.put("DW_CONTROL_CODE", new Long(1L));
                    Properties p12 = new Properties();
                    p12.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p12.put("DATA_HANDLER_TYPE", new Long(3L));
                    p12.put("ATTRIB_LDAP_NAME", "garbageCollPeriod");
                    p12.put("ATTRIB_VALUE", "3");
                    p12.put("DW_CONTROL_CODE", new Long(1L));
                    setAttributeList.add(p);
                    setAttributeList.add(p12);
                    continue;
                }
                String dontPermanentlyDelete = props.getProperty("dontPermanentlyDelete");
                Properties p2 = new Properties();
                p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p2.put("DATA_HANDLER_TYPE", new Long(3L));
                p2.put("ATTRIB_LDAP_NAME", "deletedItemFlags");
                if (dontPermanentlyDelete.equals("true")) {
                    p2.put("ATTRIB_VALUE", "3");
                } else {
                    p2.put("ATTRIB_VALUE", "5");
                }
                long garbageCollPeriod = 86400L;
                try {
                    int t = Integer.parseInt(props.getProperty("keepDeletedItems"));
                    garbageCollPeriod = (long)t * garbageCollPeriod;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p1 = new Properties();
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("DATA_HANDLER_TYPE", new Long(3L));
                p1.put("ATTRIB_LDAP_NAME", "garbageCollPeriod");
                p1.put("ATTRIB_VALUE", new Long(garbageCollPeriod).toString());
                setAttributeList.add(p2);
                setAttributeList.add(p1);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.storage_limits.mgmtname.exch_storage_limits"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

