/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class TerminalEnvironmentListener
extends ModifyUserListener {
    public TerminalEnvironmentListener() {
        this.reportId = new Integer(1016);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1030L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String userName = this.getValue(result, 1006);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1261L)) {
                String startProgramOption = (String)props.get("startProgramOption");
                if (startProgramOption.equals("usermanagement.terminal_environment.enable")) {
                    Properties p = new Properties();
                    String pgmFileName = props.getProperty("programFileName");
                    p.put("ATTRIB_LDAP_NAME", "tsIntialProgram");
                    if (pgmFileName.equals("")) {
                        pgmFileName = "";
                    }
                    p.put("ATTRIB_VALUE", pgmFileName);
                    Properties p1 = new Properties();
                    String startIn = props.getProperty("startIn");
                    if (startIn.equals("")) {
                        startIn = "";
                    }
                    p1.put("ATTRIB_LDAP_NAME", "tsWorkingDir");
                    p1.put("ATTRIB_VALUE", startIn);
                    Properties p2 = new Properties();
                    p2.put("ATTRIB_LDAP_NAME", "tsInheritInitialProgram");
                    p2.put("ATTRIB_VALUE", "0");
                    setAttributeList.add(p);
                    setAttributeList.add(p1);
                    setAttributeList.add(p2);
                } else if (startProgramOption.equals("usermanagement.terminal_environment.disable")) {
                    Properties p2 = new Properties();
                    p2.put("ATTRIB_LDAP_NAME", "tsInheritInitialProgram");
                    p2.put("ATTRIB_VALUE", "1");
                    setAttributeList.add(p2);
                }
            }
            ArrayList<String> selectedAttributesList = new ArrayList<String>();
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1294L)) {
                selectedAttributesList.add("tsDeviceClientDrives");
            }
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1295L)) {
                selectedAttributesList.add("tsDeviceClientPrinters");
            }
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1296L)) {
                selectedAttributesList.add("tsDeviceClientDefaultPrinter");
            }
            String[] selectedAttributes = new String[selectedAttributesList.size()];
            selectedAttributes = selectedAttributesList.toArray(selectedAttributes);
            for (int i = 0; i < selectedAttributes.length; ++i) {
                String value = props.getProperty(selectedAttributes[i]);
                if (value.equals("--")) continue;
                value = value.equalsIgnoreCase("usermanagement.terminal_environment.yes") ? "1" : "0";
                Properties p = new Properties();
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[i]);
                p.put("ATTRIB_VALUE", value);
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID/userName : " + userName + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)userName, setAttributeList, (String)sid, (String)dn);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.ts_env.mgmtname.terminal_service_env_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        try {
            String emptyFields = "";
            Locale locale = request.getLocale();
            BeanMap props = (BeanMap)bean.get("props");
            String startProgramOption = (String)props.get("startProgramOption");
            if (startProgramOption != null && startProgramOption.equals("usermanagement.terminal_environment.enable")) {
                String beanValue = props.getProperty("programFileName");
                if (beanValue.equals("")) {
                    emptyFields = emptyFields.length() == 0 ? this.rb.getString("usermanagement.terminal_environment.program_file_name") : emptyFields + "," + this.rb.getString("usermanagement.terminal_environment.program_file_name");
                }
                if ((beanValue = props.getProperty("startIn")).equals("")) {
                    emptyFields = emptyFields.length() == 0 ? this.rb.getString("usermanagement.terminal_environment.starting_program") : emptyFields + "," + this.rb.getString("usermanagement.terminal_environment.starting_program");
                }
            }
            if (emptyFields.length() != 0) {
                emptyFields = MessageFormat.format(this.rb.getString("admp.mgmt.common.confirm.blank_values_cleared_in_ad_want_to_continue"), emptyFields);
                request.setAttribute("emptyFields", (Object)emptyFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

