/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class TerminalRemoteControlListener
extends ModifyUserListener {
    public TerminalRemoteControlListener() {
        this.cks = new String[]{"enableRemoteControl", "requirePermissions"};
        this.reportId = new Integer(1018);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message;
        block10: {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1032L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            message = new StringBuffer();
            try {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1032L)) break block10;
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                String userName = this.getValue(result, 1006);
                long shadowSettings = 0L;
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                BeanMap props = (BeanMap)bean.get("props");
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                String enableRemoteControl = (String)props.get("enableRemoteControl");
                String requirePermissions = (String)props.get("requirePermissions");
                String levelOfControl = props.getProperty("levelOfControl");
                shadowSettings = enableRemoteControl.equalsIgnoreCase("true") ? (requirePermissions.equalsIgnoreCase("true") ? (levelOfControl.equalsIgnoreCase("true") ? 3L : 1L) : (levelOfControl.equalsIgnoreCase("true") ? 4L : 2L)) : 0L;
                Properties p = new Properties();
                p.put("ATTRIB_LDAP_NAME", "tsShadowSettings");
                p.put("ATTRIB_VALUE", String.valueOf(shadowSettings));
                setAttributeList.add(p);
                logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + userName + " ATTRIBUTELIST : " + setAttributeList);
                try {
                    if (setAttributeList.size() != 0) {
                        ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)userName, setAttributeList, (String)sid, (String)dn);
                        if (message.length() == 0) {
                            message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                        } else {
                            message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                        }
                    } else {
                        message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                    }
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
                }
                catch (Exception e) {
                    message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
                }
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.ts_remote.mgmtname.terminal_service_remote_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return message.toString();
    }
}

