/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class TerminalSessionsListener
extends ModifyUserListener {
    public TerminalSessionsListener() {
        this.reportId = new Integer(1017);
        this.actions = new String[]{"timeOutSettingsDisConnections", "timeOutSettingsConnections", "timeOutSettingsIdle", "brokenTimeOutSettings", "reConnectSettings"};
        this.actionIds = new long[]{1262L, 1263L, 1264L, 1265L, 1266L};
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1031L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String userName = this.getValue(result, 1006);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            String[] selectedAttributes = new String[]{"timeOutSettingsDisConnections", "timeOutSettingsConnections", "timeOutSettingsIdle", "brokenTimeOutSettings", "reConnectSettings"};
            long[] id = new long[]{1262L, 1263L, 1264L, 1265L, 1266L};
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            for (int j = 0; j < selectedAttributes.length; ++j) {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, this.getId(selectedAttributes[j]))) continue;
                String value = props.getProperty(selectedAttributes[j]);
                System.out.println("value : " + value);
                if (value.equals("--")) continue;
                Properties p = new Properties();
                if (selectedAttributes[j].equals("timeOutSettingsDisConnections")) {
                    p.put("ATTRIB_LDAP_NAME", "tsTimeOutSettingsDisConnections");
                    p.put("ATTRIB_VALUE", value);
                } else if (selectedAttributes[j].equals("timeOutSettingsConnections")) {
                    p.put("ATTRIB_LDAP_NAME", "tsTimeOutSettingsConnections");
                    p.put("ATTRIB_VALUE", value);
                } else if (selectedAttributes[j].equals("timeOutSettingsIdle")) {
                    p.put("ATTRIB_LDAP_NAME", "tsTimeOutSettingsIdle");
                    p.put("ATTRIB_VALUE", value);
                } else if (selectedAttributes[j].equals("brokenTimeOutSettings")) {
                    p.put("ATTRIB_LDAP_NAME", "tsBrokenTimeOutSettings");
                    if (value.equals("usermanagement.terminal_sessions.disconnect_from_session")) {
                        p.put("ATTRIB_VALUE", "0");
                    } else {
                        p.put("ATTRIB_VALUE", "1");
                    }
                } else if (selectedAttributes[j].equals("reConnectSettings")) {
                    p.put("ATTRIB_LDAP_NAME", "tsReConnectSettings");
                    if (value.equals("usermanagement.terminal_sessions.from_any_client")) {
                        p.put("ATTRIB_VALUE", "0");
                    } else {
                        p.put("ATTRIB_VALUE", "1");
                    }
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID/user Name : " + userName + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)userName, setAttributeList, (String)sid, (String)dn);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.ts_session.mgmtname.terminal_service_session_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message.toString();
    }
}

