/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class UserOperationsListener
extends ModifyUserListener {
    public UserOperationsListener() {
        this.reportId = new Integer(1007);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1020L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        String dn = this.getValue(result, 1004);
        String sid = this.getValue(result, 1144);
        BeanMap props = (BeanMap)bean.get("props");
        if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1020L)) {
            try {
                ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)props.getProperty("moveUsersDN"));
                ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                if (message.length() == 0) {
                    message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                } else {
                    message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String(le.getMessage(this.rb))));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String(e.getMessage())));
            }
            String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
            TechAuditAPI.getInstance().auditMoveUser(loginId, this.rb.getString("admp.mgmt.common.mgmtname.move_user"), this.getValue(result, 1010), domainName, sourceDN, props.getProperty("moveUsersDN"), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        return message.toString();
    }
}

