/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserAction;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserTemplateBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UserTemplateAction
extends UserAction {
    public ActionForward createUserTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserTemplateBean userTemplateBean = (UserTemplateBean)form;
        userTemplateBean.initialize(mapping);
        userTemplateBean.init(request);
        return mapping.findForward("create");
    }

    public ActionForward saveTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.successfully_saved_values");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            UserTemplateBean userTemplateBean = (UserTemplateBean)form;
            String templateName = (String)userTemplateBean.get("TEMPLATE_NAME");
            String templateId = request.getParameter("templateId");
            String oldtemplateName = "";
            if (templateId != null) {
                oldtemplateName = UserTemplateHandler.getTemplateName((Long)Long.parseLong(templateId));
                if (!UserTemplateHandler.isAuthorized((Long)loginId, (Long)Long.parseLong(templateId))) {
                    message = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.u_hav_no_permission_to_modify_user_templates");
                    request.setAttribute("saveMessage", (Object)message);
                    return mapping.findForward("create");
                }
            }
            if ((templateId == null || !templateName.equals(oldtemplateName)) && UserTemplateHandler.isExist((String)templateName)) {
                message = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.template_same_name_already_exists");
                request.setAttribute("saveMessage", (Object)message);
                request.setAttribute("sortColumn", (Object)"TEMPLATE_NAME");
                request.setAttribute("isAscending", (Object)true);
                request.setAttribute("defaultTemplate", (Object)UserTemplateUtil.getDefaultTemplate((Long)loginId));
                UserTemplateAction.setTemplateList(loginId, request, "TEMPLATE_NAME");
                return mapping.findForward("viewTemplateList");
            }
            String[] tobeCheckedFormatsArray = new String[]{"localHomeDirectory", "networkHomeDirectory", "PROFILE_PATH", "TS_PROFILE_PATH", "localTsHomeDirectory", "networkTsHomeDirectory", "TS_WORKING_DIRECTORY"};
            String[] displayNamesArray = new String[]{rb.getString("admp.mgmt.user_mgmt.cre_template.text.home_folder_local_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.home_folder_network_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.profile_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.terminal_profile_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.terminal_home_folder_local_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.terminal_home_folder_remote_path"), rb.getString("admp.mgmt.user_mgmt.cre_template.text.start_in_dir_env_settings")};
            String[] tabArray = new String[]{"AccountDetails", "AccountDetails", "AccountDetails", "TerminalServices", "TerminalServices", "TerminalServices", "TerminalServices"};
            for (int i = 0; i < tobeCheckedFormatsArray.length; ++i) {
                int index;
                String string = tobeCheckedFormatsArray[i];
                String attribValue = (String)userTemplateBean.get(string);
                if (attribValue == null || attribValue.equals("") || (index = attribValue.indexOf("%")) == -1) continue;
                if (index == attribValue.length()) {
                    message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.variable_incorrect_format"), displayNamesArray[i]);
                    request.setAttribute("saveMessage", (Object)message);
                    request.setAttribute("displayTab", (Object)tabArray[i]);
                    return mapping.findForward("create");
                }
                String str = this.getFormatCheck(request, attribValue);
                if (str == null) continue;
                message = str;
                request.setAttribute("saveMessage", (Object)message);
                request.setAttribute("displayTab", (Object)tabArray[i]);
                return mapping.findForward("create");
            }
            userTemplateBean.saveTemplate(request, loginId);
            this.out.log(Level.INFO, "Template Saved :: " + templateName + " -- old template Name :: " + oldtemplateName);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.save_error_template");
            request.setAttribute("saveMessage", (Object)message);
        }
        request.setAttribute("saveMessage", (Object)message);
        request.setAttribute("sortColumn", (Object)"TEMPLATE_NAME");
        request.setAttribute("isAscending", (Object)true);
        request.setAttribute("defaultTemplate", (Object)UserTemplateUtil.getDefaultTemplate((Long)loginId));
        UserTemplateAction.setTemplateList(loginId, request, "TEMPLATE_NAME");
        return mapping.findForward("viewTemplateList");
    }

    public ActionForward viewTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "viewTemplateList";
        Boolean isAscending = true;
        String sortColumn = "TEMPLATE_NAME";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (request.getParameter("isAscending") != null) {
                isAscending = new Boolean(request.getParameter("isAscending"));
            }
            if (request.getParameter("sortColumn") != null) {
                sortColumn = request.getParameter("sortColumn");
            }
            UserTemplateAction.setTemplateList(loginId, request, sortColumn);
            if (request.getParameter("defaultTemplate") != null) {
                Long defaultTemplate = new Long(request.getParameter("defaultTemplate"));
                UserTemplateUtil.setDefaultTemplate((Long)loginId, (Long)defaultTemplate);
            }
            request.setAttribute("sortColumn", (Object)sortColumn);
            request.setAttribute("defaultTemplate", (Object)UserTemplateUtil.getDefaultTemplate((Long)loginId));
            request.setAttribute("isAscending", (Object)isAscending);
        }
        catch (Exception e) {
            this.out.log(Level.WARNING, e.getMessage());
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward modifyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "create";
        try {
            UserTemplateBean userTemplateBean = (UserTemplateBean)form;
            userTemplateBean.initialize(mapping);
            userTemplateBean.modifyTemplate(request);
        }
        catch (Exception e) {
            this.out.log(Level.WARNING, e.getMessage());
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward copyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "viewTemplateList";
        String message = "";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String templateId = request.getParameter("templateId");
            String newTemplateName = request.getParameter("newTemplateName");
            if (!UserTemplateHandler.isExist((String)newTemplateName)) {
                UserTemplateHandler.copyTemplate((Long)loginId, (String)templateId, (String)newTemplateName);
            } else {
                message = rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.template_same_name_already_exists");
                request.setAttribute("saveMessage", (Object)message);
            }
            String sortColumn = "TEMPLATE_NAME";
            Boolean isAscending = true;
            if (request.getParameter("isAscending") != null) {
                isAscending = new Boolean(request.getParameter("isAscending"));
            }
            if (request.getParameter("sortColumn") != null) {
                sortColumn = request.getParameter("sortColumn");
            }
            request.setAttribute("defaultTemplate", (Object)UserTemplateUtil.getDefaultTemplate((Long)loginId));
            request.setAttribute("sortColumn", (Object)sortColumn);
            request.setAttribute("isAscending", (Object)isAscending);
            UserTemplateAction.setTemplateList(loginId, request, sortColumn);
        }
        catch (Exception e) {
            this.out.log(Level.WARNING, e.getMessage());
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward deleteTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String templateId = request.getParameter("templateId");
        String message = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String templateName = UserTemplateHandler.getTemplateName((Long)Long.parseLong(templateId));
        message = UserTemplateHandler.isAuthorized((Long)loginId, (Long)Long.parseLong(templateId)) ? UserTemplateHandler.deleteTemplate((AdventNetResourceBundle)rb, (Long)Long.parseLong(templateId)) : rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.u_not_authorized_to_del_template");
        this.out.log(Level.INFO, "Deleting Template " + templateName + " result is :: " + message);
        request.setAttribute("saveMessage", (Object)message);
        ArrayList list = new ArrayList();
        String sortColumn = "TEMPLATE_NAME";
        Boolean isAscending = true;
        if (request.getParameter("isAscending") != null) {
            isAscending = new Boolean(request.getParameter("isAscending"));
        }
        if (request.getParameter("sortColumn") != null) {
            sortColumn = request.getParameter("sortColumn");
        }
        request.setAttribute("sortColumn", (Object)sortColumn);
        request.setAttribute("isAscending", (Object)isAscending);
        request.setAttribute("defaultTemplate", (Object)UserTemplateUtil.getDefaultTemplate((Long)loginId));
        UserTemplateAction.setTemplateList(loginId, request, sortColumn);
        return mapping.findForward("viewTemplateList");
    }

    private static void setTemplateList(Long loginId, HttpServletRequest request, String sortColumn) {
        boolean isAscending = true;
        try {
            Long recordsCount = null;
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "UserTemplates", loginId);
            request.setAttribute("RANGE", (Object)range);
            Long startIndex = 1L;
            Long endIndex = (long)new Long(range.intValue());
            if (request.getParameter("FROM_INDEX") != null) {
                startIndex = (long)new Long(request.getParameter("FROM_INDEX"));
                endIndex = (long)new Long(request.getParameter("TO_INDEX"));
            }
            if (request.getParameter("isAscending") != null) {
                isAscending = new Boolean(request.getParameter("isAscending"));
            }
            request.setAttribute("FROM_INDEX", (Object)new Long(startIndex));
            request.setAttribute("TO_INDEX", (Object)new Long(endIndex));
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1123L);
            ArrayList templateList = UserTemplateHandler.getTemplates((Long)loginId, (String)sortColumn, (Boolean)isAscending, (String[])StrUtil.getStringArray(domainNameList));
            List resultantTemplateList = new ArrayList();
            resultantTemplateList = (long)templateList.size() >= endIndex ? templateList.subList(startIndex.intValue() - 1, endIndex.intValue()) : templateList;
            request.setAttribute("templateList", (Object)resultantTemplateList);
            recordsCount = new Long(templateList.size());
            request.setAttribute("TOTAL_RECORDS", (Object)recordsCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ActionForward getADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            UserTemplateBean userTemplateBean = (UserTemplateBean)form;
            String nodeClicked = request.getParameter("container");
            String domainName = request.getParameter("domainName");
            Properties selectedDomain = null;
            if (domainName == null) {
                selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            } else {
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            this.setDirectoryObject(selectedDomain, request);
            String domainPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            StringTokenizer domainTokenizer = new StringTokenizer(domainPath, ",");
            int domainTokenCount = domainTokenizer.countTokens();
            StringTokenizer nodeTokenizer = new StringTokenizer(nodeClicked, ",");
            int nodeTokenCount = nodeTokenizer.countTokens();
            int parentsCount = 0;
            if (domainTokenCount != nodeTokenCount) {
                parentsCount = nodeTokenCount - domainTokenCount - 1;
            }
            if (parentsCount > 0) {
                int i;
                String[] parentArray = new String[parentsCount];
                for (i = 0; i < parentsCount; ++i) {
                    parentArray[i] = i == 0 ? nodeClicked.substring(nodeClicked.indexOf(",") + 1, nodeClicked.length()) : parentArray[i - 1].substring(parentArray[i - 1].indexOf(",") + 1, parentArray[i - 1].length());
                }
                for (i = parentsCount; i > 0; --i) {
                    this.setDirectoryObject(selectedDomain, parentArray[i - 1], request);
                    request.setAttribute("selectedObject", (Object)parentArray[i - 1]);
                }
            }
            userTemplateBean.set("container", nodeClicked);
            request.setAttribute("selectedDomainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)e.getMessage());
        }
        return mapping.findForward("ado");
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request) throws Exception {
        try {
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = null;
            boolean isWorkflow = false;
            if (request.getParameter("isWorkFlow") != null) {
                isWorkflow = new Boolean(request.getParameter("isWorkFlow"));
            }
            ouList = !isWorkflow ? ClientAuthorizationUtil.getAuthorizedOUList(request, domainName) : WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList);
            DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
            request.setAttribute("rootPath", (Object)rootPath);
            session.setAttribute("TreeModel", (Object)model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request) {
        this.setDirectoryObject(selectedDomain, nodeClicked, request, "TreeModel");
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, String modelName) {
        try {
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(modelName);
            DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
            int index = nodeClicked.indexOf(rootPath);
            if (index > 0) {
                DirectoryObjectUtil.getDirectoryObject(object, nodeClicked, selectedDomain, loginId);
                DirectoryObjectTreeModel newModel = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute(modelName, (Object)newModel);
                String bookMarks = request.getParameter("bookmark");
                ArrayList<String> pathToOpen = (ArrayList<String>)session.getAttribute("TreeModel_showLines_showRootNode_OPENED-NODES");
                if (pathToOpen == null) {
                    pathToOpen = new ArrayList<String>();
                }
                pathToOpen.add(nodeClicked);
                session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", pathToOpen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ActionForward getMailBoxStores(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserTemplateBean userTemplateBean = (UserTemplateBean)form;
            String domainName = request.getParameter("domainName");
            this.out.log(Level.FINE, "getMailBoxStores domainName " + domainName);
            String mailServer = request.getParameter("mailServer");
            this.out.log(Level.FINE, "getMailBoxStores mailServer " + mailServer);
            ArrayList list = ExchangeHandler.getMailBoxStores((String)domainName, (String)mailServer);
            String mailBoxVersion = ExchangeUtil.getExchangeServerType((String)mailServer).toString();
            this.out.log(Level.FINE, "getMailBoxStores mailBoxVersion " + mailBoxVersion);
            ArrayList mailBoxStores = null;
            ArrayList mailBoxStoreDNs = null;
            if (list != null && !list.isEmpty()) {
                mailBoxStores = (ArrayList)list.get(0);
                mailBoxStoreDNs = (ArrayList)list.get(1);
            }
            this.out.log(Level.FINE, "getMailBoxStores mailBoxStores " + mailBoxStores);
            this.out.log(Level.FINE, "getMailBoxStores mailBoxStoreDNs " + mailBoxStoreDNs);
            userTemplateBean.set("mailBoxStores", mailBoxStores);
            userTemplateBean.set("mailBoxStoreDNs", mailBoxStoreDNs);
            userTemplateBean.set("mailVersion", mailBoxVersion);
            if (mailBoxStoreDNs != null && !mailBoxStoreDNs.isEmpty()) {
                UserMgmtUtil.getMailBoxHTMLElement((HttpServletResponse)response, (ArrayList)mailBoxStoreDNs, (ArrayList)mailBoxStores, (boolean)false, (String)mailBoxVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getFormatCheck(HttpServletRequest request, String format) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = null;
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            if (nextIndex != -1) {
                String noOfLetters = "";
                if (length > nextIndex + 1 && Character.isDigit(format.charAt(nextIndex + 1))) {
                    noOfLetters = new Character(format.charAt(nextIndex + 1)).toString();
                    if (length > nextIndex + 2 && Character.isDigit(format.charAt(nextIndex + 2))) {
                        noOfLetters = noOfLetters + new Character(format.charAt(nextIndex + 2)).toString();
                    }
                }
                String ldapName = format.substring(index + 1, nextIndex);
                Hashtable properties = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)ldapName);
                if (properties != null) {
                    nextIndex += noOfLetters.length();
                } else if (!(ldapName.equalsIgnoreCase("userName") || ldapName.equalsIgnoreCase("LogonName") || ldapName.equalsIgnoreCase("domainName"))) {
                    message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_template.statmsg.this_is_not_proper_ldapname"), ldapName);
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        return message;
    }

    public ActionForward addAces(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        UserTemplateBean bean = (UserTemplateBean)form;
        Hashtable folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("folder");
        Hashtable folderInheritFlagMap = UserPermissionsHandler.getInstance().getInheritFlagMap("folder");
        try {
            String folderType = request.getParameter("folderType");
            String permissionType = request.getParameter("permissionType");
            String domainName = request.getParameter("domainName");
            String selectedSIDs = request.getParameter("selectedSIDs");
            String selectedPermissions = request.getParameter("selectedPermissions");
            String selectedFlag = request.getParameter("selectedFlag");
            String beanProperty = "";
            if (folderType.equalsIgnoreCase("homeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "SHARE_ACL";
                    folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("share");
                }
            } else if (folderType.equalsIgnoreCase("tsHomeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "TS_HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "TS_SHARE_ACL";
                    folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("share");
                }
            } else if (folderType.equalsIgnoreCase("profilePath")) {
                beanProperty = "PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("tsProfilePath")) {
                beanProperty = "TS_PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("mailBoxRights")) {
                beanProperty = "MBR_ACL";
                folderAccessMaskMap = UserPermissionsHandler.getInstance().getAccessMaskMap("mailBox");
                folderInheritFlagMap = UserPermissionsHandler.getInstance().getInheritFlagMap("mailBox");
            }
            ArrayList<Properties> acList = (ArrayList<Properties>)bean.get(beanProperty);
            if (acList == null) {
                acList = new ArrayList<Properties>();
            }
            StringTokenizer sidTokenizer = new StringTokenizer(selectedSIDs, ";;");
            StringTokenizer permissionTokenizer = new StringTokenizer(selectedPermissions, ";");
            int permsissionCount = permissionTokenizer.countTokens();
            String[] permissions = new String[permsissionCount];
            int i = 0;
            while (permissionTokenizer.hasMoreTokens()) {
                permissions[i] = permissionTokenizer.nextToken();
                ++i;
            }
            while (sidTokenizer.hasMoreTokens()) {
                String sidString = sidTokenizer.nextToken();
                String OBJECT_NAME = "";
                String DN = "";
                if (sidString.equalsIgnoreCase("%userName%")) {
                    OBJECT_NAME = "%userName%";
                    DN = sidString;
                } else {
                    Properties properties = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)sidString);
                    OBJECT_NAME = properties.getProperty("OBJECT_NAME");
                    DN = properties.getProperty("DN");
                }
                for (int j = 0; j < permissions.length; ++j) {
                    int index = permissions[j].indexOf("x");
                    int length = permissions[j].length();
                    String accessMask = permissions[j].substring(0, index);
                    String aceType = permissions[j].substring(index + 1, length);
                    Long ACCESS_MASK = Long.valueOf(accessMask);
                    Long ACE_TYPE = Long.valueOf(aceType);
                    String ACE_TYPE_STRING = rb.getString("admp.common.permission.text_allow");
                    if (ACE_TYPE.equals(1L)) {
                        ACE_TYPE_STRING = rb.getString("admp.common.permission.text_deny");
                    }
                    Properties aceTable = new Properties();
                    aceTable.put("OBJECT_NAME", OBJECT_NAME);
                    aceTable.put("DN", DN);
                    aceTable.put("ACCESS_MASK", ACCESS_MASK);
                    aceTable.put("ACCESS_MASK_STRING", rb.getString((String)folderAccessMaskMap.get(ACCESS_MASK)));
                    aceTable.put("ACE_TYPE", ACE_TYPE);
                    aceTable.put("ACE_TYPE_STRING", ACE_TYPE_STRING);
                    if (beanProperty.equalsIgnoreCase("HOME_DIR_ACL") || beanProperty.equalsIgnoreCase("TS_HOME_DIR_ACL") || beanProperty.equalsIgnoreCase("PROF_DIR_ACL") || beanProperty.equalsIgnoreCase("TS_PROF_DIR_ACL") || beanProperty.equalsIgnoreCase("MBR_ACL")) {
                        Long INHERIT_TYPE_FLAG = Long.parseLong(selectedFlag);
                        String APPLIES_TO_STRING = (String)folderInheritFlagMap.get(INHERIT_TYPE_FLAG);
                        aceTable.put("INHERIT_TYPE_FLAG", INHERIT_TYPE_FLAG);
                        aceTable.put("APPLIES_TO_STRING", rb.getString(APPLIES_TO_STRING));
                    }
                    acList.add(aceTable);
                }
            }
            bean.set(beanProperty, acList);
            ClientUtil.setACLXMLElement(response, acList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteAces(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserTemplateBean bean = (UserTemplateBean)form;
        try {
            String index = request.getParameter("index");
            String folderType = request.getParameter("folderType");
            String permissionType = request.getParameter("permissionType");
            String beanProperty = "";
            if (folderType.equalsIgnoreCase("homeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "SHARE_ACL";
                }
            } else if (folderType.equalsIgnoreCase("tsHomeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "TS_HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "TS_SHARE_ACL";
                }
            } else if (folderType.equalsIgnoreCase("profilePath")) {
                beanProperty = "PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("tsProfilePath")) {
                beanProperty = "TS_PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("mailBoxRights")) {
                beanProperty = "MBR_ACL";
            }
            ArrayList acList = (ArrayList)bean.get(beanProperty);
            acList.remove(Integer.parseInt(index));
            bean.set(beanProperty, acList);
            ClientUtil.setACLXMLElement(response, acList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward changeAceType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        UserTemplateBean bean = (UserTemplateBean)form;
        try {
            String index = request.getParameter("index");
            String changeTo = request.getParameter("changeTo");
            String folderType = request.getParameter("folderType");
            String permissionType = request.getParameter("permissionType");
            String beanProperty = "";
            if (folderType.equalsIgnoreCase("homeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "SHARE_ACL";
                }
            } else if (folderType.equalsIgnoreCase("tsHomeFolder")) {
                if (permissionType.equalsIgnoreCase("folder")) {
                    beanProperty = "TS_HOME_DIR_ACL";
                } else if (permissionType.equalsIgnoreCase("share")) {
                    beanProperty = "TS_SHARE_ACL";
                }
            } else if (folderType.equalsIgnoreCase("profilePath")) {
                beanProperty = "PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("tsProfilePath")) {
                beanProperty = "TS_PROF_DIR_ACL";
            } else if (folderType.equalsIgnoreCase("mailBoxRights")) {
                beanProperty = "MBR_ACL";
            }
            ArrayList acList = (ArrayList)bean.get(beanProperty);
            Properties properties = (Properties)acList.get(Integer.parseInt(index));
            if (changeTo.equals("0")) {
                properties.put("ACE_TYPE", (Object)0L);
                properties.put("ACE_TYPE_STRING", rb.getString("admp.common.permission.text_allow"));
            } else if (changeTo.equals("1")) {
                properties.put("ACE_TYPE", (Object)1L);
                properties.put("ACE_TYPE_STRING", rb.getString("admp.common.permission.text_deny"));
            }
            bean.set(beanProperty, acList);
            ClientUtil.setStatusXMLElement(response, "Success", "Changed ACE Type");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward savePermissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "setFolderPermissions";
        try {
            UserTemplateBean templateBean = (UserTemplateBean)form;
            for (String string : UserPermissionsUtil.permsBooleanProps) {
                Boolean value = (Boolean)templateBean.get(string);
                if (templateBean.get(string) == null) {
                    templateBean.set(string, false);
                }
                templateBean.set(string, value);
            }
            String type = request.getParameter("type");
            request.setAttribute("valuesSaved", (Object)"yes");
            request.setAttribute("folderType", (Object)type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward getFormatExample(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String formatId = request.getParameter("formatId");
            Long formatIdLong = Long.parseLong(formatId);
            String domainName = request.getParameter("domainName");
            String logonNameFormat = request.getParameter("param1");
            Long logonNameFormatLong = Long.parseLong(logonNameFormat);
            String samNameFormat = request.getParameter("param2");
            Long samNameFormatLong = Long.parseLong(samNameFormat);
            String fullNameFormat = request.getParameter("param3");
            Long fullNameFormatLong = Long.parseLong(fullNameFormat);
            String formattedName = "";
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            hashtable.put(new Integer(1001), rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_first_name"));
            hashtable.put(new Integer(1003), rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_intial"));
            hashtable.put(new Integer(1002), rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_last_name"));
            hashtable.put(new Integer(1041), rb.getString("admp.mgmt.user_mgmt.cre_template.text.example_mail"));
            String logonName = "";
            logonName = FormatClientUtil.getFormattedName(logonNameFormatLong, hashtable, domainName, "", new ArrayList());
            hashtable.put(new Integer(1006), logonName);
            String samName = "";
            samName = samNameFormatLong.equals(0L) ? logonName : FormatClientUtil.getFormattedName(samNameFormatLong, hashtable, domainName, logonName, new ArrayList());
            hashtable.put(new Integer(1006), samName);
            String fullName = "";
            fullName = fullNameFormatLong.equals(0L) ? logonName : FormatClientUtil.getFormattedName(fullNameFormatLong, hashtable, domainName, logonName, new ArrayList());
            hashtable.put(new Integer(1013), fullName);
            if (formatIdLong.equals(0L)) {
                formatIdLong = logonNameFormatLong;
            }
            formattedName = FormatClientUtil.getFormattedName(formatIdLong, hashtable, domainName, logonName, new ArrayList());
            ClientUtil.setFormatXMLElement(response, formattedName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

