/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserCreationScriptHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserTemplateBean
extends UserBean {
    public void init(HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String operation = request.getParameter("operation");
            this.set("operation", operation);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList templates = UserTemplateHandler.getTemplates((Long)loginId, (String)"TEMPLATE_NAME", (Boolean)true);
            ArrayList nameList = new ArrayList();
            for (int i = 0; i < templates.size(); ++i) {
                nameList.add(((Hashtable)templates.get(i)).get("TEMPLATE_NAME"));
            }
            boolean isExists = false;
            String name = null;
            for (int i = 1; i < 1000; ++i) {
                isExists = false;
                name = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_template.text.templateuser"), i);
                for (int j = 0; j < nameList.size(); ++j) {
                    String tempName = (String)nameList.get(j);
                    if (!name.equalsIgnoreCase(tempName)) continue;
                    isExists = true;
                }
                if (!isExists) break;
            }
            this.set("TEMPLATE_NAME", name);
            this.set("TEMPLATE_DESCRIPTION", "");
            this.setNamingFormats(request);
            if (this.get("operation").equals("new")) {
                try {
                    Hashtable hash = FormatClientUtil.getDefaultNamingFormatSettings();
                    for (int i = 0; i < UserMgmtUtil.formatColumnNames.length; ++i) {
                        this.set(UserMgmtUtil.formatColumnNames[i], hash.get(UserMgmtUtil.formatColumnNames[i]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(System.currentTimeMillis()));
            this.set("accountExpiresValue", dateString);
            String[] ldapNameArray = new String[]{"TITLE", "COMPANY", "DEPARTMENT", "OFFICE"};
            String[] attribNameArray = new String[]{"TITLE", "COMPANY", "DEPT", "OFFICE"};
            String[] attribListNameArray = new String[]{"titleList", "companyList", "deptList", "officesList"};
            for (int i = 0; i < ldapNameArray.length; ++i) {
                this.setOrgAttribList(ldapNameArray[i], attribNameArray[i], attribListNameArray[i], rb);
            }
            this.set("homeDriveList", UserMgmtUtil.homeDriveList);
            this.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
            this.set("tsHomeDriveList", UserMgmtUtil.homeDriveList);
            this.set("disconnectionValues", UserMgmtUtil.sessionValuesList);
            ArrayList<String> sessionLabels = new ArrayList<String>();
            for (int i = 0; i < UserMgmtUtil.sessionLabelList.size(); ++i) {
                sessionLabels.add(i, rb.getString((String)UserMgmtUtil.sessionLabelList.get(i)));
            }
            this.set("disconnectionLabel", sessionLabels);
            this.set("activeSessionValues", UserMgmtUtil.sessionValuesList);
            this.set("activeSessionLabel", sessionLabels);
            this.set("idleSessionValues", UserMgmtUtil.sessionValuesList);
            this.set("idleSessionLabel", sessionLabels);
            this.set("accountExpiresOptions", UserTemplateUtil.accountExpiresOptions);
            String[] accountExpiresOptionValues = new String[]{rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_never"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_end_of"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_7_days"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_15_days"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_1_month"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_2_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_3_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_6_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_1_year"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_custom")};
            this.set("accountExpiresOptionValues", accountExpiresOptionValues);
            Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
            if (customAttribProp.size() > 0) {
                String[] customDisplayNames = (String[])customAttribProp.get("customAttribDisplayName");
                String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
                this.set("CUSTOM_ATTRIB_DISPLAY_NAME", customDisplayNames);
                this.set("CUSTOM_ATTRIB_LDAP_NAME", customLdapNames);
            }
            this.initDomainSpecificAttributes(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initDomainSpecificAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            String domainName = request.getParameter("templateDomainName");
            Properties domainProps = null;
            if (domainName == null) {
                String defaultDomain;
                ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1004L);
                if (domainNameList.contains(defaultDomain = DomainUtil.getDefaultDomain())) {
                    domainName = defaultDomain;
                } else if (!domainNameList.isEmpty()) {
                    domainName = domainNameList.get(0);
                }
            }
            domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String defaultNamingContext = domainProps.getProperty("DEFAULT_NAMING_CONTEXT");
            this.set("MAIL_SERVER_DOMAIN_NAME", domainProps.getProperty("DOMAIN_DNS_NAME"));
            ArrayList groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"));
            session.setAttribute("userCreationGroupList", (Object)groupList);
            ArrayList domainDetailsList = HDTDomainHandler.getConfiguredList((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            ArrayList<String> domainList = new ArrayList<String>();
            for (Object object : domainDetailsList) {
                Properties properties = (Properties)object;
                domainList.add(properties.getProperty("DOMAIN_NAME"));
            }
            this.set("domainList", domainList);
            this.set("TEMPLATE_DOMAIN_NAME", domainName);
            ArrayList<Properties> MEMBER_OF = new ArrayList<Properties>();
            if (groupList == null || groupList.isEmpty()) {
                GroupHandler.init((String)domainName, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"), (Integer)109);
                groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"));
            }
            Properties groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
            MEMBER_OF.add(groupProps);
            this.set("MEMBER_OF", MEMBER_OF);
            Properties PRIMARY_GROUP = new Properties();
            if (groupProps != null) {
                PRIMARY_GROUP = (Properties)groupProps.clone();
            }
            this.set("PRIMARY_GROUP", PRIMARY_GROUP);
            ArrayList mailServersList = new ArrayList();
            ArrayList mailBoxStoresList = new ArrayList();
            ArrayList mailServers = new ArrayList();
            ArrayList<String> mailServerDNs = new ArrayList<String>();
            ArrayList mailBoxStores = new ArrayList();
            ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
            String mailBoxVersion = "";
            ArrayList LCSServersList = new ArrayList();
            ArrayList<String> LCSServers = new ArrayList<String>();
            ArrayList<String> LCSServerDNs = new ArrayList<String>();
            LCSServersList = LCSServerHandler.getLCSServers((String)domainName);
            if (!LCSServersList.isEmpty()) {
                LCSServers = (ArrayList<String>)LCSServersList.get(0);
                LCSServerDNs = (ArrayList<String>)LCSServersList.get(1);
                if (LCSServerDNs.isEmpty()) {
                    LCSServers = new ArrayList<String>();
                    LCSServers.add(rb.getString("admp.mgmt.user_mgmt.cre_template.text.no_live_communication_servers_available"));
                    LCSServerDNs = new ArrayList<String>();
                    LCSServerDNs.add("0");
                }
            }
            this.set("LCSServers", LCSServers);
            this.set("LCSServerDNs", LCSServerDNs);
            mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
            if (mailServersList != null && !mailServersList.isEmpty()) {
                mailServers = (ArrayList)mailServersList.get(0);
                mailServerDNs = (ArrayList<String>)mailServersList.get(1);
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)((String)mailServerDNs.get(0)));
            } else {
                mailServers = new ArrayList();
                mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
                mailServerDNs = new ArrayList<String>();
                mailServerDNs.add("0");
            }
            if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
            }
            if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                mailBoxStores = new ArrayList();
                mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                mailBoxStoreDNs = new ArrayList<String>();
                mailBoxStoreDNs.add("0");
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                mailBoxVersion = ExchangeUtil.getExchangeServerType((String)((String)mailServerDNs.get(0))).toString();
            }
            ArrayList mailGroupsList = new ArrayList();
            ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
            ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
            mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
            if (!mailGroupsList.isEmpty()) {
                msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                if (msExchAdminGroupDNList.isEmpty()) {
                    msExchAdminGroupDisplayList = new ArrayList<String>();
                    msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_admin_group"));
                    msExchAdminGroupDNList = new ArrayList<String>();
                    msExchAdminGroupDNList.add("0");
                }
            }
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = UserMgmtUtil.getDefaultContainerName((String)defaultNamingContext, (ArrayList)ouList);
            this.set("container", containerName);
            this.set("mailEnabled", "no");
            this.set("mailServers", mailServers);
            this.set("mailServerDNs", mailServerDNs);
            this.set("mailBoxStores", mailBoxStores);
            this.set("mailBoxStoreDNs", mailBoxStoreDNs);
            this.set("mailVersion", mailBoxVersion);
            this.set("MAIL_SERVER", mailServerDNs.get(0));
            this.set("MAIL_BOX_STORE", mailBoxStoreDNs.get(0));
            this.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
            this.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
            this.set("MS_EXCH_ADMIN_GROUP", msExchAdminGroupDNList.get(0));
            this.set("UPN_SUFFIX", domainProps.getProperty("DOMAIN_DNS_NAME"));
            this.set("MANAGER", "");
            this.set("LOGON_TO", "");
            this.set("logonToPermission", "allComputers");
            this.set("logonSystems", "");
            this.set("managerText", "");
            this.initPermissions(domainName, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initPermissions(String domainName, AdventNetResourceBundle rb) {
        try {
            Hashtable permissionsTable = UserPermissionsUtil.getDefaultPermissions((String)domainName, (AdventNetResourceBundle)rb);
            for (String string : UserPermissionsUtil.permsListProps) {
                ArrayList list = (ArrayList)permissionsTable.get(string);
                if (list == null || list.isEmpty()) continue;
                this.set(string, list);
            }
            for (String string : UserPermissionsUtil.permsStringProps) {
                this.set(string, "");
            }
            for (int i = 0; i < UserPermissionsUtil.permsBooleanProps.length; ++i) {
                this.set(UserPermissionsUtil.permsBooleanProps[i], UserPermissionsUtil.permsBooleanPropsDefaultValues[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNamingFormats(HttpServletRequest request) {
        ArrayList ruleList;
        Hashtable<String, ArrayList> ruleListTable;
        ArrayList formatList;
        Hashtable<String, ArrayList> formatListTable;
        ArrayList list;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String[] namingFormats = new String[]{"logonNameFormat", "samNameFormat", "displayNameFormat", "fullNameFormat", "emailAddressFormat", "mailAliasFormat", "simpleDisplayNameFormat", "meMailAliasFormat", "meSimpleDisplayNameFormat", "targetAddressFormat"};
        String[] namingFormatValues = new String[]{"logonNameFormatValues", "samNameFormatValues", "displayNameFormatValues", "fullNameFormatValues", "emailAddressFormatValues", "mailAliasFormatValues", "simpleDisplayNameFormatValues", "meMailAliasFormatValues", "meSimpleDisplayNameFormatValues", "targetAddressFormatValues"};
        Hashtable<String, ArrayList> hashtable = FormatClientUtil.getNamingFormats(rb);
        ArrayList formatDisplayList = hashtable.get("displayList");
        ArrayList formatValueList = hashtable.get("valueList");
        Hashtable<String, ArrayList> ruleHashtable = FormatClientUtil.getNamingFormatRules(rb);
        ArrayList ruleDisplayList = ruleHashtable.get("displayList");
        ArrayList ruleValueList = ruleHashtable.get("valueList");
        for (String string : namingFormats) {
            list = new ArrayList();
            formatListTable = new Hashtable<String, ArrayList>();
            formatList = (ArrayList)formatDisplayList.clone();
            formatList.add(0, rb.getString("admp.common.text.Empty"));
            if (!string.equals("logonNameFormat")) {
                formatList.add(1, rb.getString("admp.mgmt.user_mgmt.cre_template.text.same_as_logonname"));
            }
            formatListTable.put("format", formatList);
            list.add(formatListTable);
            ruleListTable = new Hashtable<String, ArrayList>();
            ruleList = (ArrayList)ruleDisplayList.clone();
            ruleListTable.put("rule", ruleList);
            list.add(ruleListTable);
            this.set(string, list);
        }
        for (String string : namingFormatValues) {
            list = new ArrayList();
            formatListTable = new Hashtable();
            formatList = (ArrayList)formatValueList.clone();
            formatList.add(0, -1L);
            if (!string.equals("logonNameFormatValues")) {
                formatList.add(1, 0L);
            }
            formatListTable.put("format", formatList);
            list.add(formatListTable);
            ruleListTable = new Hashtable();
            ruleList = (ArrayList)ruleValueList.clone();
            ruleListTable.put("rule", ruleList);
            list.add(ruleListTable);
            this.set(string, list);
        }
    }

    public void setTemplatePasswordAttributes(HttpServletRequest request) throws Exception {
        String PASSWORD_TYPE = (String)this.get("PASSWORD_TYPE");
        String PASSWORD = "";
        PASSWORD = PASSWORD_TYPE.equalsIgnoreCase("ownpassword") ? request.getParameter("enterPassword") : "";
        this.set("PASSWORD", PASSWORD);
    }

    public void setEmailProxyAddressesFormats(HttpServletRequest request, String mailEnabled) throws Exception {
        try {
            String formats = "";
            Boolean policyInclude = true;
            if (mailEnabled.equalsIgnoreCase("mailBox")) {
                formats = request.getParameter("formatsForProxies");
                policyInclude = (Boolean)this.get("INCLUDE_POLICIES");
            } else if (mailEnabled.equalsIgnoreCase("mail")) {
                formats = request.getParameter("meFormatsForProxies");
                policyInclude = (Boolean)this.get("ME_INCLUDE_POLICIES");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(formats, "|**|");
            ArrayList<String> EMAIL_PROXY_ADDRESSES = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                EMAIL_PROXY_ADDRESSES.add(stringTokenizer.nextToken());
            }
            this.set("EMAIL_PROXY_ADDRESSES", EMAIL_PROXY_ADDRESSES);
            if (!policyInclude.booleanValue()) {
                this.set("MS_EXCH_EXCLUDE_POLICIES", "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveTemplate(HttpServletRequest request, Long loginId) throws Exception {
        Properties properties;
        void var12_32;
        int len$;
        String templateId = request.getParameter("templateId");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.setSecurityAttributes(request);
        this.setTerminalAttributes(request);
        String mailEnabled = (String)this.get("mailEnabled");
        if (mailEnabled.equalsIgnoreCase("mailBox")) {
            this.setExchangeAttributes(request);
            this.setEmailProxyAddressesFormats(request, mailEnabled);
        } else if (mailEnabled.equalsIgnoreCase("mail")) {
            this.setMailEnableAttributes(request);
            this.setEmailProxyAddressesFormats(request, mailEnabled);
        }
        this.setTemplatePasswordAttributes(request);
        String containerText = request.getParameter("containerText");
        if (containerText != null) {
            this.set("container", containerText);
        }
        ArrayList<Object> toBeAddedAttributes = new ArrayList<Object>();
        for (Object object : UserTemplateUtil.userTemplateAttribsCheckEmpty) {
            String[] stringArray;
            for (String string : stringArray = (String[])object) {
                String attributeValue2 = (String)this.get(string);
                if (attributeValue2 == null) continue;
                toBeAddedAttributes.add(string);
            }
        }
        for (Object object : UserTemplateUtil.userTemplateAttribsNoCheck) {
            String[] stringArray;
            for (String string : stringArray = (String[])object) {
                Object attributeValue = this.get(string);
                toBeAddedAttributes.add(string);
            }
        }
        if (mailEnabled.equalsIgnoreCase("MailBox")) {
            for (String string : UserTemplateUtil.userTemplateExchangePropCheckEmpty) {
                Object object = this.get(string);
                if (object == null) continue;
                toBeAddedAttributes.add(string);
            }
            for (String string : UserTemplateUtil.userTemplateExchangePropNoCheck) {
                Object object = this.get(string);
                if (object == null) continue;
                toBeAddedAttributes.add(string);
            }
        } else if (mailEnabled.equalsIgnoreCase("Mail")) {
            for (String string : UserTemplateUtil.userTemplateMailEnablePropCheckEmpty) {
                Object object = this.get(string);
                if (object == null) continue;
                toBeAddedAttributes.add(string);
            }
            for (String string : UserTemplateUtil.userTemplateMailEnablePropNoCheck) {
                toBeAddedAttributes.add(string);
            }
            toBeAddedAttributes.add("MAPI_RECIPIENT");
            toBeAddedAttributes.add("INTERNET_ENCODING");
        }
        Boolean LCSEnabled = (Boolean)this.get("LCS_ENABLED");
        toBeAddedAttributes.add("LCS_ENABLED");
        if (LCSEnabled.booleanValue()) {
            void var12_30;
            void var12_28;
            String[] arr$ = UserTemplateUtil.userTemplateLCSAttributesFormat;
            len$ = arr$.length;
            boolean bl = false;
            while (var12_28 < len$) {
                String string = arr$[var12_28];
                if (string.equalsIgnoreCase("LCS_DEVICE_LINE_URI_FORMAT")) {
                    toBeAddedAttributes.add(string);
                } else {
                    Object attributeValue3 = this.get(string);
                    if (attributeValue3 != null) {
                        toBeAddedAttributes.add(string);
                    }
                }
                ++var12_28;
            }
            arr$ = UserTemplateUtil.userTemplateLCSAttributes;
            len$ = arr$.length;
            boolean bl2 = false;
            while (var12_30 < len$) {
                String string = arr$[var12_30];
                if (string.equalsIgnoreCase("LCS_OPTION_FLAG")) {
                    toBeAddedAttributes.add("LCS_OPTION_FLAG");
                } else {
                    Object attributeValue = this.get(string);
                    if (attributeValue != null) {
                        toBeAddedAttributes.add(string);
                    }
                }
                ++var12_30;
            }
        }
        String[] arr$ = UserTemplateUtil.userTemplateMultiValuAttribs;
        len$ = arr$.length;
        boolean bl = false;
        while (var12_32 < len$) {
            String string = arr$[var12_32];
            ArrayList list = (ArrayList)this.get(string);
            if (list != null && !list.isEmpty()) {
                toBeAddedAttributes.add(string);
            }
            ++var12_32;
        }
        if (mailEnabled.equalsIgnoreCase("no")) {
            toBeAddedAttributes.remove("PROTOCOL_SETTINGS");
            toBeAddedAttributes.remove("EMAIL_ADDRESS_FORMAT");
            toBeAddedAttributes.remove("MAIL_ALIAS_FORMAT");
            toBeAddedAttributes.remove("SIMPLE_DISPLAY_NAME_FORMAT");
        }
        toBeAddedAttributes.add("mailEnabled");
        toBeAddedAttributes.add("PASSWORD_TYPE");
        toBeAddedAttributes.add("PASSWORD");
        Integer COUNTRY_CODE = (Integer)this.get("COUNTRY_CODE");
        this.out.log(Level.INFO, "COUNTRY_CODE : " + COUNTRY_CODE);
        if (templateId != null || !COUNTRY_CODE.equals(-1)) {
            toBeAddedAttributes.add("COUNTRY_CODE");
            toBeAddedAttributes.add("COUNTRY");
            toBeAddedAttributes.add("COUNRTY_TWO_DIGIT_CODE");
        }
        if (!toBeAddedAttributes.contains("EMAIL_ADDRESS_FORMAT")) {
            toBeAddedAttributes.add("EMAIL_ADDRESS_FORMAT");
        }
        Hashtable<String, Object> userDetailsTable = new Hashtable<String, Object>();
        userDetailsTable.put("TEMPLATE_NAME", this.get("TEMPLATE_NAME"));
        userDetailsTable.put("TEMPLATE_DESCRIPTION", this.get("TEMPLATE_DESCRIPTION"));
        userDetailsTable.put("ITERATE_NAMES", this.get("ITERATE_NAMES"));
        userDetailsTable.put("CUSTOM_SCRIPT", this.get("CUSTOM_SCRIPT"));
        userDetailsTable.put("MODIFIED_TIME", System.currentTimeMillis());
        for (String string : toBeAddedAttributes) {
            if (string.equalsIgnoreCase("INTERNET_ENCODING")) {
                userDetailsTable.put("INTERNET_ENCODING", "1310720");
                continue;
            }
            if (string.equalsIgnoreCase("MAPI_RECIPIENT")) {
                userDetailsTable.put("MAPI_RECIPIENT", "FALSE");
                continue;
            }
            if (string.equalsIgnoreCase("LCS_OPTION_FLAG")) {
                Boolean IMEnabled = (Boolean)this.get("LCS_IM_ENABLED");
                Boolean remoteEnabled = (Boolean)this.get("LCS_REMOTE_CONTROL");
                int value = 0;
                if (IMEnabled.booleanValue() && remoteEnabled.booleanValue()) {
                    value = 17;
                }
                if (!IMEnabled.booleanValue() && remoteEnabled.booleanValue()) {
                    value = 16;
                }
                if (IMEnabled.booleanValue() && !remoteEnabled.booleanValue()) {
                    value = 1;
                }
                userDetailsTable.put(string, value);
                continue;
            }
            if (string.equalsIgnoreCase("LCS_DEVICE_LINE_URI_FORMAT")) {
                Boolean deviceURI = (Boolean)this.get("LCS_DEVICE_URI");
                String value = "";
                value = deviceURI != false ? (String)this.get("LCS_DEVICE_TEL_URI") : (String)this.get("LCS_DEVICE_SIP_URI");
                userDetailsTable.put(string, value);
                continue;
            }
            userDetailsTable.put(string, this.get(string));
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (String string : UserPermissionsUtil.permsStringProps) {
            if (this.get(string) == null) {
                this.set(string, "");
            }
            hashtable.put(string, this.get(string));
        }
        for (String string : UserPermissionsUtil.permsBooleanProps) {
            Boolean value = (Boolean)this.get(string);
            if (this.get(string) == null) {
                this.set(string, false);
            }
            hashtable.put(string, value);
        }
        for (String string : UserPermissionsUtil.permsListProps) {
            if (this.get(string) == null) {
                this.set(string, new ArrayList());
            }
            hashtable.put(string, this.get(string));
        }
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
        if (customAttribProp.size() > 0) {
            String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
            for (int i = 0; i < customLdapNames.length; ++i) {
                String customLdapValue = request.getParameter(customLdapNames[i]);
                if (customLdapValue == null) continue;
                properties = new Properties();
                properties.setProperty("CUSTOM_ATTRIB_NAME", customLdapNames[i]);
                properties.setProperty("CUSTOM_ATTRIB_VALUE", customLdapValue);
                arrayList.add(properties);
            }
        }
        String[] ldapNamesArray = request.getParameterValues("ldapName");
        String[] ldapValuesArray = request.getParameterValues("ldapValue");
        if (ldapNamesArray != null) {
            for (int i = 0; i < ldapNamesArray.length; ++i) {
                if (ldapNamesArray[i].equalsIgnoreCase("") || ldapValuesArray[i].equalsIgnoreCase("")) continue;
                properties = new Properties();
                properties.setProperty("CUSTOM_ATTRIB_NAME", ldapNamesArray[i]);
                properties.setProperty("CUSTOM_ATTRIB_VALUE", ldapValuesArray[i]);
                arrayList.add(properties);
            }
        }
        Boolean customScript = (Boolean)this.get("CUSTOM_SCRIPT");
        Hashtable<String, Object> customScriptTable = new Hashtable<String, Object>();
        for (String string : UserMgmtUtil.customScriptProps) {
            if (this.get(string) == null) {
                this.set(string, "");
            }
            customScriptTable.put(string, this.get(string));
        }
        Hashtable<String, Object> iterationTable = new Hashtable<String, Object>();
        for (String string : UserTemplateUtil.TEMPLATE_ITERATION_SETTINGS) {
            if (string.equals("ITERATE_BEGIN_INDEX") || string.equals("ITERATION_FIXD_LEN") || string.equals("ITERATION_FILLED_CHAR")) {
                iterationTable.put(string, this.get(string));
                continue;
            }
            if (request.getParameter(string) != null && request.getParameter(string).equals("on")) {
                iterationTable.put(string, true);
                continue;
            }
            iterationTable.put(string, false);
        }
        if (templateId != null && !templateId.equals("")) {
            UserTemplateHandler.updateTemplate((Long)Long.parseLong(templateId), userDetailsTable, toBeAddedAttributes, hashtable, arrayList, iterationTable);
            UserCreationScriptHandler.updateCustomScriptProps((Long)Long.parseLong(templateId), (Boolean)customScript, customScriptTable);
        } else {
            userDetailsTable.put("CREATION_TIME", System.currentTimeMillis());
            UserTemplateHandler.saveTemplate((AdventNetResourceBundle)rb, (Long)loginId, userDetailsTable, toBeAddedAttributes, hashtable, arrayList, customScriptTable, iterationTable);
        }
    }

    public void modifyTemplate(HttpServletRequest request) throws Exception {
        Long templateId;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (!UserTemplateHandler.isAuthorized((Long)loginId, (Long)(templateId = Long.valueOf(Long.parseLong(request.getParameter("templateId")))))) {
            throw new Exception("You are not authorized to modify this template");
        }
        try {
            String templateDomainName;
            Boolean iterationEnabled;
            String templateMailEnabled;
            String upnSuffix;
            String TS_DC_DEFAULT_PRINTER;
            String TS_DC_PRINTERS;
            String TS_DC_DRIVES;
            String TS_ALLOW_LOGON;
            String forwardTo;
            Properties groupProps;
            String domainName;
            this.setNamingFormats(request);
            Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
            Boolean lcsEnabled = (Boolean)templateDetails.get("LCS_ENABLED");
            if (lcsEnabled != null && lcsEnabled.booleanValue()) {
                String deviceURI;
                Integer optionFlag = new Integer(0);
                optionFlag = (Integer)templateDetails.get("LCS_OPTION_FLAG");
                if (optionFlag != null) {
                    if (optionFlag == 0) {
                        this.set("LCS_IM_ENABLED", false);
                        this.set("LCS_REMOTE_CONTROL", false);
                    } else if (optionFlag == 1) {
                        this.set("LCS_IM_ENABLED", true);
                        this.set("LCS_REMOTE_CONTROL", false);
                    } else if (optionFlag == 16) {
                        this.set("LCS_IM_ENABLED", false);
                        this.set("LCS_REMOTE_CONTROL", true);
                    } else if (optionFlag == 17) {
                        this.set("LCS_IM_ENABLED", true);
                        this.set("LCS_REMOTE_CONTROL", true);
                    }
                }
                if ((deviceURI = (String)templateDetails.get("LCS_DEVICE_LINE_URI_FORMAT")).startsWith("sip:")) {
                    this.set("LCS_DEVICE_URI", false);
                    this.set("LCS_DEVICE_SIP_URI", deviceURI);
                } else if (deviceURI.startsWith("tel:")) {
                    this.set("LCS_DEVICE_URI", true);
                    this.set("LCS_DEVICE_TEL_URI", deviceURI);
                }
            }
            Enumeration enumeration = templateDetails.keys();
            String mailEnabled = "no";
            if (templateDetails.get("mailEnabled") != null) {
                mailEnabled = (String)templateDetails.get("mailEnabled");
            }
            if ((domainName = (String)templateDetails.get("TEMPLATE_DOMAIN_NAME")) == null) {
                Properties defaultDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = defaultDomain.getProperty("DOMAIN_NAME");
                this.initDomainSpecificAttributes(request);
            }
            Properties domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList domainDetailsList = HDTDomainHandler.getConfiguredList((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            ArrayList<String> domainList = new ArrayList<String>();
            for (Object object : domainDetailsList) {
                Properties properties = (Properties)object;
                domainList.add(properties.getProperty("DOMAIN_NAME"));
            }
            this.set("domainList", domainList);
            this.set("TEMPLATE_DOMAIN_NAME", domainName);
            String[] ldapNameArray = new String[]{"TITLE", "COMPANY", "DEPARTMENT", "OFFICE"};
            String[] attribNameArray = new String[]{"TITLE", "COMPANY", "DEPT", "OFFICE"};
            String[] attribListNameArray = new String[]{"titleList", "companyList", "deptList", "officesList"};
            for (int i = 0; i < ldapNameArray.length; ++i) {
                this.setOrgAttribList(templateDetails, ldapNameArray[i], attribNameArray[i], attribListNameArray[i], rb);
            }
            ArrayList groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"));
            while (enumeration.hasMoreElements()) {
                ArrayList list;
                String element = (String)enumeration.nextElement();
                if (element.equalsIgnoreCase("MEMBER_OF")) {
                    ArrayList<Properties> arrayList = new ArrayList<Properties>();
                    ArrayList list2 = (ArrayList)templateDetails.get(element);
                    for (String string : list2) {
                        Properties properties = UserMgmtUtil.getPropertiesfromDN((String)string, (ArrayList)groupList);
                        if (properties == null) continue;
                        arrayList.add(properties);
                    }
                    this.set(element, arrayList);
                    continue;
                }
                if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM") || element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                    list = (ArrayList)templateDetails.get(element);
                    if (list.isEmpty()) continue;
                    ArrayList<String> mRrecipientsDNList = new ArrayList<String>();
                    ArrayList<String> mRrecipientsDisplayList = new ArrayList<String>();
                    for (String string : list) {
                        mRrecipientsDNList.add(string);
                        mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                    }
                    if (mailEnabled.equalsIgnoreCase("MailBox")) {
                        this.set("mRrecipientsDNList", mRrecipientsDNList);
                        this.set("mRrecipientsDisplayList", mRrecipientsDisplayList);
                        this.set("mRrecipientsSelect", mRrecipientsDNList.get(0));
                        if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                            this.set("msgRestriction", "fromExcept");
                            continue;
                        }
                        if (element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                            this.set("msgRestriction", "onlyFrom");
                            continue;
                        }
                        this.set("msgRestriction", "all");
                        continue;
                    }
                    if (!mailEnabled.equalsIgnoreCase("Mail")) continue;
                    this.set("meMRrecipientsDNList", mRrecipientsDNList);
                    this.set("meMRrecipientsDisplayList", mRrecipientsDisplayList);
                    this.set("meMRrecipientsSelect", mRrecipientsDNList.get(0));
                    if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                        this.set("meMsgRestriction", "fromExcept");
                        continue;
                    }
                    if (element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                        this.set("meMsgRestriction", "onlyFrom");
                        continue;
                    }
                    this.set("meMsgRestriction", "all");
                    continue;
                }
                if (element.equalsIgnoreCase("SEND_ON_BEHALF")) {
                    list = (ArrayList)templateDetails.get(element);
                    if (list.isEmpty()) continue;
                    ArrayList<String> sobDNList = new ArrayList<String>();
                    ArrayList<String> sobDisplayList = new ArrayList<String>();
                    for (String string : list) {
                        sobDNList.add(string);
                        sobDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                    }
                    this.set("sobDNList", sobDNList);
                    this.set("sobDisplayList", sobDisplayList);
                    this.set("sobSelect", sobDNList.get(0));
                    continue;
                }
                if (element.equalsIgnoreCase("PROTOCOL_SETTINGS")) {
                    list = (ArrayList)templateDetails.get(element);
                    String encoding = "ISO-8859-1";
                    String owaccess = "owaEnable";
                    String pop = "popEnable";
                    String imap = "imapEnable";
                    String special = "\u00a7";
                    if (!list.isEmpty()) {
                        for (String string : list) {
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE)) {
                                owaccess = "owaEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE)) {
                                owaccess = "owaDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE)) {
                                pop = "popEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE)) {
                                pop = "popDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE)) {
                                imap = "imapEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE)) {
                                imap = "imapDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE_X07)) {
                                owaccess = "owaEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE_X07)) {
                                owaccess = "owaDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE_X07)) {
                                pop = "popEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE_X07)) {
                                pop = "popDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE_X07)) {
                                imap = "imapEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE_X07)) {
                                imap = "imapDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_ENABLE_X10)) {
                                owaccess = "owaEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.HTTP_DISABLE_X10)) {
                                owaccess = "owaDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_ENABLE_X10)) {
                                pop = "popEnable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.POP3_DISABLE_X10)) {
                                pop = "popDisable";
                                continue;
                            }
                            if (string.equalsIgnoreCase(UserMgmtUtil.IMAP4_ENABLE_X10)) {
                                imap = "imapEnable";
                                continue;
                            }
                            if (!string.equalsIgnoreCase(UserMgmtUtil.IMAP4_DISABLE_X10)) continue;
                            imap = "imapDisable";
                        }
                    }
                    this.set("owaccess", owaccess);
                    this.set("pop", pop);
                    this.set("imap", imap);
                    continue;
                }
                if (element.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES")) {
                    list = (ArrayList)templateDetails.get(element);
                    if (list.isEmpty()) continue;
                    if (mailEnabled.equalsIgnoreCase("MailBox")) {
                        this.set("proxyAddressFormat", list);
                        this.set("emailProxyAddresses", list.get(0));
                        continue;
                    }
                    if (!mailEnabled.equalsIgnoreCase("Mail")) continue;
                    this.set("meProxyAddressFormat", list);
                    this.set("meEmailProxyAddresses", list.get(0));
                    continue;
                }
                if (element.equalsIgnoreCase("LOGON_TO")) {
                    String string = (String)templateDetails.get(element);
                    if (string != null && !string.equalsIgnoreCase("")) {
                        this.set("logonToPermission", "followingComputers");
                        this.set("logonSystems", string);
                    }
                    this.set(element, string);
                    continue;
                }
                if (element.equalsIgnoreCase("PASSWORD_LAST_SET") || element.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || element.equalsIgnoreCase("KEEP_DELETED_ITEMS") || element.equalsIgnoreCase("TS_END_DISCONNECTION") || element.equalsIgnoreCase("TS_ACTIVE_SESSION") || element.equalsIgnoreCase("TS_IDLE_SESSION")) {
                    this.set(element, AddUserClientUtil.getLongValue(templateDetails.get(element).toString()));
                    continue;
                }
                if (element.equalsIgnoreCase("REQUIRE_AUTH") || element.equalsIgnoreCase("DELIVER_AND_REDIRECT") || element.equalsIgnoreCase("USE_DEFAULT_STORAGE") || element.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS") || element.equalsIgnoreCase("ME_HIDDEN_TO_ADDRESSLISTS") || element.equalsIgnoreCase("ME_REQUIRE_AUTH")) {
                    this.set(element, AddUserClientUtil.getBooleanValue(templateDetails.get(element).toString()));
                    continue;
                }
                if (element.equalsIgnoreCase("ACCOUNT_STATUS") || element.equalsIgnoreCase("USER_FLAGS") || element.equalsIgnoreCase("COUNTRY_CODE")) {
                    this.set(element, AddUserClientUtil.getIntegerValue(element, templateDetails.get(element).toString()));
                    continue;
                }
                if (element.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) {
                    if (templateDetails.get(element) == null || !((String)templateDetails.get(element)).equalsIgnoreCase("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) continue;
                    if (mailEnabled.equalsIgnoreCase("MailBox")) {
                        this.set("INCLUDE_POLICIES", false);
                        continue;
                    }
                    if (!mailEnabled.equalsIgnoreCase("mail")) continue;
                    this.set("ME_INCLUDE_POLICIES", false);
                    continue;
                }
                if (element.equalsIgnoreCase("TEMPLATE_NAME") || element.equalsIgnoreCase("TEMPLATE_DESCRIPTION")) {
                    this.set(element, rb.getString((String)templateDetails.get(element)));
                    continue;
                }
                if (element.equalsIgnoreCase("TEMPLATE_DOMAIN_NAME")) continue;
                this.set(element, templateDetails.get(element));
            }
            this.setAccountExpires();
            session.setAttribute("userCreationGroupList", (Object)groupList);
            String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
            String primaryGroupRID = (String)this.get("PRIMARY_GROUP_ID");
            Properties PRIMARY_GROUP = new Properties();
            ArrayList MEMBER_OF = (ArrayList)this.get("MEMBER_OF");
            if (primaryGroupRID != null && !primaryGroupRID.equals("")) {
                PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromRID((String)primaryGroupRID, (ArrayList)groupList, (String)defaultNamingContext);
                groupProps = (Properties)PRIMARY_GROUP.clone();
                MEMBER_OF.add(groupProps);
            } else {
                groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
                MEMBER_OF.add(groupProps);
                PRIMARY_GROUP = (Properties)groupProps.clone();
                this.set("PRIMARY_GROUP_ID", "513");
            }
            this.set("MEMBER_OF", MEMBER_OF);
            this.set("PRIMARY_GROUP", PRIMARY_GROUP);
            this.set("homeDriveList", UserMgmtUtil.homeDriveList);
            if (!((String)this.get("HOME_DRIVE")).equals("")) {
                this.set("homeFolder", "connect");
                this.set("networkHomeDirectory", (String)this.get("HOME_DIRECTORY"));
            } else {
                this.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
                this.set("localHomeDirectory", (String)this.get("HOME_DIRECTORY"));
            }
            String TS_REMOTE_HOME_DIRECTORY = (String)this.get("TS_REMOTE_HOME_DIRECTORY");
            if (TS_REMOTE_HOME_DIRECTORY.equals("1")) {
                this.set("networkTsHomeDirectory", (String)this.get("TS_HOME_DIRECTORY"));
            } else {
                this.set("TS_HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
                this.set("localTsHomeDirectory", (String)this.get("TS_HOME_DIRECTORY"));
            }
            String manager = (String)this.get("MANAGER");
            if (!manager.equals("")) {
                String managerText = UserMgmtUtil.getDisplayNameFromDN((String)domainName, (String)manager, (int)1);
                if (managerText != null) {
                    this.set("managerText", managerText);
                } else {
                    this.set("managerText", manager);
                }
            }
            if (!(forwardTo = (String)this.get("FORWARD_TO")).equals("")) {
                this.set("forwardToText", UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)forwardTo));
            }
            this.set("tsHomeDriveList", UserMgmtUtil.homeDriveList);
            ArrayList<String> sessionLabels = new ArrayList<String>();
            for (int i = 0; i < UserMgmtUtil.sessionLabelList.size(); ++i) {
                sessionLabels.add(i, rb.getString((String)UserMgmtUtil.sessionLabelList.get(i)));
            }
            this.set("disconnectionValues", UserMgmtUtil.sessionValuesList);
            this.set("disconnectionLabel", sessionLabels);
            this.set("activeSessionValues", UserMgmtUtil.sessionValuesList);
            this.set("activeSessionLabel", sessionLabels);
            this.set("idleSessionValues", UserMgmtUtil.sessionValuesList);
            this.set("idleSessionLabel", sessionLabels);
            this.set("accountExpiresOptions", UserTemplateUtil.accountExpiresOptions);
            String[] accountExpiresOptionValues = new String[]{rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_never"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_end_of"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_7_days"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_15_days"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_1_month"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_2_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_3_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_6_months"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_1_year"), rb.getString("admp.mgmt.user_mgmt.common.text.end_of_session_custom")};
            this.set("accountExpiresOptionValues", accountExpiresOptionValues);
            String TS_INHERIT_INITIAL_PROGRAM = (String)this.get("TS_INHERIT_INITIAL_PROGRAM");
            if (TS_INHERIT_INITIAL_PROGRAM.equals("0")) {
                this.set("tsInheritInitial", true);
            }
            if ((TS_ALLOW_LOGON = (String)this.get("TS_ALLOW_LOGON")).equals("0")) {
                this.set("tsAllowLogOn", false);
            }
            if ((TS_DC_DRIVES = (String)this.get("TS_DC_DRIVES")).equals("0")) {
                this.set("tsDcDrives", false);
            }
            if ((TS_DC_PRINTERS = (String)this.get("TS_DC_PRINTERS")).equals("0")) {
                this.set("tsDcPrinters", false);
            }
            if ((TS_DC_DEFAULT_PRINTER = (String)this.get("TS_DC_DEFAULT_PRINTER")).equals("0")) {
                this.set("tsDcDedaultPrinter", false);
            }
            Long KEEP_DELETED_ITEMS = (Long)this.get("KEEP_DELETED_ITEMS");
            Long days = KEEP_DELETED_ITEMS / 86400L;
            this.set("keepDelItemsDays", days.toString());
            String OMA = (String)this.get("OMA");
            String omaccess = "omaEnable";
            String uis = "uisEnable";
            String updNotify = "updNotifyEnable";
            if (OMA != null && !OMA.equals("")) {
                if (OMA.equals("0")) {
                    omaccess = "omaEnable";
                    uis = "uisEnable";
                    updNotify = "updNotifyEnable";
                } else if (OMA.equals("2")) {
                    omaccess = "omaDisable";
                    uis = "uisEnable";
                    updNotify = "updNotifyEnable";
                } else if (OMA.equals("4")) {
                    omaccess = "omaEnable";
                    uis = "uisDisable";
                    updNotify = "updNotifyDisable";
                } else if (OMA.equals("5")) {
                    omaccess = "omaEnable";
                    uis = "uisDisable";
                    updNotify = "updNotifyDisable";
                } else if (OMA.equals("1")) {
                    omaccess = "omaEnable";
                    uis = "uisEnable";
                    updNotify = "updNotifyDisable";
                } else if (OMA.equals("3")) {
                    omaccess = "omaDisable";
                    uis = "uisEnable";
                    updNotify = "updNotifyDisable";
                } else if (OMA.equals("7")) {
                    omaccess = "omaDisable";
                    uis = "uisDisable";
                    updNotify = "updNotifyDisable";
                }
            }
            this.set("omaccess", omaccess);
            this.set("uis", uis);
            this.set("updNotify", updNotify);
            String mailServerDnsName = (String)this.get("MAIL_SERVER_DOMAIN_NAME");
            if (mailServerDnsName == null || mailServerDnsName.equals("")) {
                this.out.log(Level.INFO, "As Mail Server DNS Name is empty, setting default domain DNS Name");
                this.set("MAIL_SERVER_DOMAIN_NAME", domainProps.getProperty("DOMAIN_DNS_NAME"));
            }
            if ((upnSuffix = (String)this.get("UPN_SUFFIX")) == null || upnSuffix.equals("")) {
                this.out.log(Level.INFO, "As UPN Suffix is empty, setting default domain DNS Name");
                this.set("UPN_SUFFIX", domainProps.getProperty("DOMAIN_DNS_NAME"));
            }
            ArrayList LCSServersList = new ArrayList();
            ArrayList<String> LCSServers = new ArrayList<String>();
            ArrayList<String> LCSServerDNs = new ArrayList<String>();
            LCSServersList = LCSServerHandler.getLCSServers((String)domainName);
            if (!LCSServersList.isEmpty()) {
                LCSServers = (ArrayList<String>)LCSServersList.get(0);
                LCSServerDNs = (ArrayList<String>)LCSServersList.get(1);
                if (LCSServerDNs.isEmpty()) {
                    LCSServers = new ArrayList<String>();
                    LCSServers.add(rb.getString("admp.mgmt.user_mgmt.cre_template.text.no_live_communication_servers_available"));
                    LCSServerDNs = new ArrayList<String>();
                    LCSServerDNs.add("0");
                }
            }
            this.set("LCSServers", LCSServers);
            this.set("LCSServerDNs", LCSServerDNs);
            ArrayList mailServersList = new ArrayList();
            ArrayList mailBoxStoresList = new ArrayList();
            ArrayList mailServers = new ArrayList();
            ArrayList<String> mailServerDNs = new ArrayList<String>();
            ArrayList mailBoxStores = new ArrayList();
            ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
            String mailBoxVersion = "";
            mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
            if (mailServersList != null && !mailServersList.isEmpty()) {
                mailServers = (ArrayList)mailServersList.get(0);
                mailServerDNs = (ArrayList<String>)mailServersList.get(1);
                this.set("mailEnabled", "MailBox");
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)((String)mailServerDNs.get(0)));
            } else {
                mailServers = new ArrayList();
                mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
                mailServerDNs = new ArrayList<String>();
                mailServerDNs.add("0");
                this.set("mailEnabled", "no");
            }
            String MAIL_SERVER = (String)this.get("MAIL_SERVER");
            if (MAIL_SERVER == null || MAIL_SERVER.equals("0") || MAIL_SERVER.equals("") || !mailServerDNs.contains(MAIL_SERVER)) {
                MAIL_SERVER = (String)mailServerDNs.get(0);
            }
            if (MAIL_SERVER.equals("0")) {
                mailBoxStores = new ArrayList();
                mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                mailBoxStoreDNs = new ArrayList();
                mailBoxStoreDNs.add("0");
            } else {
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
                if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                    mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                    mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
                }
                if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                    mailBoxStores = new ArrayList();
                    mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                    mailBoxStoreDNs = new ArrayList<String>();
                    mailBoxStoreDNs.add("0");
                }
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                mailBoxVersion = ExchangeUtil.getExchangeServerType((String)((String)mailServerDNs.get(0))).toString();
            }
            this.set("mailServers", mailServers);
            this.set("mailServerDNs", mailServerDNs);
            String MAIL_BOX_STORE = "0";
            if (mailBoxStoreDNs != null && !mailBoxStoreDNs.isEmpty()) {
                MAIL_BOX_STORE = (String)mailBoxStoreDNs.get(0);
            }
            this.set("mailBoxStores", mailBoxStores);
            this.set("mailBoxStoreDNs", mailBoxStoreDNs);
            this.set("mailVersion", mailBoxVersion);
            if (MAIL_SERVER.equals("0") || MAIL_BOX_STORE.equals("0")) {
                this.set("mailEnabled", "no");
            }
            ArrayList mailGroupsList = new ArrayList();
            ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
            ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
            mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
            if (!mailGroupsList.isEmpty()) {
                msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                if (msExchAdminGroupDNList.isEmpty()) {
                    msExchAdminGroupDisplayList = new ArrayList<String>();
                    msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_admin_group"));
                    msExchAdminGroupDNList = new ArrayList<String>();
                    msExchAdminGroupDNList.add("0");
                }
            }
            this.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
            this.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
            if (request.getParameter("templateDomainName") != null) {
                this.initDomainSpecificAttributes(request);
            }
            if ((templateMailEnabled = (String)templateDetails.get("mailEnabled")) != null) {
                this.set("mailEnabled", templateMailEnabled);
            }
            this.initPermissions(domainName, rb);
            Hashtable userPermsTable = UserPermissionsHandler.getInstance().getTemplatePermissions(templateId);
            if (!userPermsTable.isEmpty()) {
                for (String string : UserPermissionsUtil.permsStringProps) {
                    String string2 = (String)userPermsTable.get(string);
                    if (string2 == null || string2.equalsIgnoreCase("")) continue;
                    this.set(string, string2);
                }
                for (String string : UserPermissionsUtil.permsBooleanProps) {
                    Boolean bool = (Boolean)userPermsTable.get(string);
                    if (bool == null) continue;
                    this.set(string, bool);
                }
                for (String string : UserPermissionsUtil.permsListProps) {
                    ArrayList list = (ArrayList)userPermsTable.get(string);
                    if (list == null || list.isEmpty()) continue;
                    this.set(string, list);
                }
            }
            this.setCustomAttributeValues(templateId);
            if (((Boolean)templateDetails.get("CUSTOM_SCRIPT")).booleanValue()) {
                Hashtable customScriptTable = UserCreationScriptHandler.getCustomScriptProps((Long)templateId);
                for (String string : UserMgmtUtil.customScriptProps) {
                    this.set(string, customScriptTable.get(string));
                }
            }
            if ((iterationEnabled = (Boolean)templateDetails.get("ITERATE_NAMES")).booleanValue()) {
                Hashtable iterationTable = UserTemplateHandler.getIterationSettings((Long)templateId);
                for (String string : UserTemplateUtil.TEMPLATE_ITERATION_SETTINGS) {
                    if (string.equals("ITERATE_BEGIN_INDEX") || string.equals("ITERATION_FIXD_LEN") || string.equals("ITERATION_FILLED_CHAR")) {
                        this.set(string, iterationTable.get(string));
                        continue;
                    }
                    if (((Boolean)iterationTable.get(string)).booleanValue()) {
                        request.setAttribute(string, (Object)"checked");
                        continue;
                    }
                    request.setAttribute(string, (Object)"");
                }
            }
            if ((templateDomainName = request.getParameter("templateDomainName")) != null) {
                this.initDomainSpecificAttributes(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("templateId", (Object)templateId);
    }

    public void setAccountExpires() {
        Long ACCOUNT_EXPIRY_DATE = (Long)this.get("ACCOUNT_EXPIRY_DATE");
        String accountExpiresStatus = "never";
        String dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(System.currentTimeMillis()));
        if (ACCOUNT_EXPIRY_DATE.equals(0L) || ACCOUNT_EXPIRY_DATE >= 5223372036854775807L) {
            accountExpiresStatus = "never";
        } else if (ACCOUNT_EXPIRY_DATE <= 36500L) {
            int[] periods = UserTemplateUtil.accountExpiresPeriods;
            int period = -1;
            for (int z = 0; z < periods.length; ++z) {
                if ((long)periods[z] != ACCOUNT_EXPIRY_DATE) continue;
                period = periods[z];
                accountExpiresStatus = String.valueOf(period);
            }
            if (period == -1) {
                accountExpiresStatus = "Custom";
                this.set("customAccountExpiresDays", ACCOUNT_EXPIRY_DATE.toString());
            }
        } else {
            accountExpiresStatus = "endOf";
            dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(DateTimeUtil.getSystemTimeFromFileTime((Long)ACCOUNT_EXPIRY_DATE)));
        }
        this.out.log(Level.INFO, "DATE STRING:: " + dateString + ", accountExpiresStatus : " + accountExpiresStatus + " and the ACCOUNT_EXPIRY_DATE : " + ACCOUNT_EXPIRY_DATE);
        this.set("accountExpiresStatus", accountExpiresStatus);
        this.set("accountExpiresValue", dateString);
    }

    private void setOrgAttribList(String ldapName, String attribName, String attribListName, AdventNetResourceBundle rb) {
        try {
            ArrayList<String> attribList = new ArrayList<String>();
            DataObject dataObject = AdminUtil.comboAttribs(attribName);
            Iterator it = dataObject.getRows("ADSMOrgAttributes");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                attribList.add(rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
            this.set(attribListName, attribList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setOrgAttribList(Hashtable templateDetails, String ldapName, String attribName, String attribListName, AdventNetResourceBundle rb) {
        try {
            ArrayList<String> attribList = new ArrayList<String>();
            String attribVal = "";
            if (templateDetails.get(ldapName) != null) {
                attribVal = (String)templateDetails.get(ldapName);
            }
            DataObject dataObject = AdminUtil.comboAttribs(attribName);
            Iterator it = dataObject.getRows("ADSMOrgAttributes");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                attribList.add(rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
            if (!attribVal.equals("") && !attribList.contains(attribVal)) {
                attribList.add(attribVal);
            }
            this.set(attribListName, attribList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCustomAttributeValues(Long templateId) {
        ArrayList arrayList = UserTemplateHandler.getCustomAttributes((Long)templateId);
        Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
        ArrayList<String> configuredLdapNameList = new ArrayList<String>();
        if (customAttribProp.size() > 0) {
            String[] customLdapNames;
            for (String ldapName : customLdapNames = (String[])customAttribProp.get("customAttribLDAPName")) {
                configuredLdapNameList.add(ldapName);
            }
        }
        if (!arrayList.isEmpty()) {
            ArrayList<String> additionalLdapNamesList = new ArrayList<String>();
            ArrayList<String> additionalLdapValuesList = new ArrayList<String>();
            for (Properties properties : arrayList) {
                String ldapNameStr = properties.getProperty("CUSTOM_ATTRIB_NAME");
                String ldapValueStr = properties.getProperty("CUSTOM_ATTRIB_VALUE");
                if (configuredLdapNameList.contains(ldapNameStr)) continue;
                additionalLdapNamesList.add(ldapNameStr);
                additionalLdapValuesList.add(ldapValueStr);
            }
            String[] additionalLdapNamesArray = new String[additionalLdapNamesList.size()];
            additionalLdapNamesList.toArray(additionalLdapNamesArray);
            String[] additionalLdapValuesArray = new String[additionalLdapValuesList.size()];
            additionalLdapValuesList.toArray(additionalLdapValuesArray);
            this.set("CUSTOM_ATTRIB_NAME", additionalLdapNamesArray);
            this.set("CUSTOM_ATTRIB_VALUE", additionalLdapValuesArray);
        }
        if (customAttribProp.size() > 0) {
            String[] customDisplayNames = (String[])customAttribProp.get("customAttribDisplayName");
            String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
            ArrayList<String> configuredDisplayNamesList = new ArrayList<String>();
            ArrayList<String> configuredLdapNamesList = new ArrayList<String>();
            ArrayList<String> configuredLdapValuesList = new ArrayList<String>();
            for (int i = 0; i < customLdapNames.length; ++i) {
                String ldapValuesStr = "";
                for (Properties properties : arrayList) {
                    String ldapNameStr = properties.getProperty("CUSTOM_ATTRIB_NAME");
                    if (!customLdapNames[i].equals(ldapNameStr)) continue;
                    ldapValuesStr = properties.getProperty("CUSTOM_ATTRIB_VALUE");
                }
                configuredDisplayNamesList.add(customDisplayNames[i]);
                configuredLdapNamesList.add(customLdapNames[i]);
                configuredLdapValuesList.add(ldapValuesStr);
            }
            String[] configuredDisplayNamesArray = new String[configuredDisplayNamesList.size()];
            configuredDisplayNamesList.toArray(configuredDisplayNamesArray);
            String[] configuredLdapNamesArray = new String[configuredLdapNamesList.size()];
            configuredLdapNamesList.toArray(configuredLdapNamesArray);
            String[] configuredLdapValuesArray = new String[configuredLdapValuesList.size()];
            configuredLdapValuesList.toArray(configuredLdapValuesArray);
            this.set("CUSTOM_ATTRIB_DISPLAY_NAME", configuredDisplayNamesArray);
            this.set("CUSTOM_ATTRIB_LDAP_NAME", configuredLdapNamesArray);
            this.set("CUSTOM_ATTRIB_LDAP_VALUE", configuredLdapValuesArray);
        }
    }
}

