/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.DynaActionForm;

public class AuditUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getHelpDeskTechnicians(Long loginId) {
        ArrayList<Properties> techList = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQuery sq = AuditUtil.getHDTSelectQuery(loginId);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            ArrayList<String> keys = new ArrayList<String>();
            while (dataSet.next()) {
                String key = dataSet.getValue("NAME").toString() + dataSet.getValue("DOMAINNAME").toString();
                if (keys.contains(key)) continue;
                keys.add(key);
                Properties prop = new Properties();
                prop.put("LOGIN_ID", (Long)dataSet.getValue("LOGIN_ID"));
                prop.put("DOMAINNAME", (String)dataSet.getValue("DOMAINNAME"));
                prop.put("FULL_NAME", (String)dataSet.getValue("FULL_NAME"));
                techList.add(prop);
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeDataSetAndConnection(dataSet, connection);
                throw throwable;
            }
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        return techList;
    }

    public static SelectQuery getHDTSelectQuery(Long loginId) {
        SelectQuery sq = null;
        String[] authorizedDomains = null;
        try {
            ArrayList authDomainsList;
            Criteria crit = new Criteria(Column.getColumn((String)"AaaRole", (String)"NAME"), (Object)"Administrator", 0);
            sq = QueryConstructor.getForPersonality((String)"HelpDeskTechnician", (Criteria)crit);
            if (loginId != null && (authDomainsList = HDTDomainHandler.getDomainNamesList((Long)loginId)) != null && !authDomainsList.contains("All Domains") && loginId != 1L) {
                authorizedDomains = authDomainsList.toArray(new String[authDomainsList.size()]);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_DOMAIN_NAME"), (Object)authorizedDomains, 8));
            }
            sq.setCriteria(crit);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMgmtProps(Long objectId, AdventNetResourceBundle rb, Long loginId, boolean fetchArchiveData, Long archiveTime) {
        HashMap<String, String> mgmtProps = new HashMap<String, String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String objsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            String propsTable = fetchArchiveData ? "ADSMAuditObjProps_" + archiveTime : "ADSMAuditObjProps";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)objsTable));
            sq.addSelectColumn(Column.getColumn((String)propsTable, (String)"PROP_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)propsTable, (String)"PROP_VALUE"));
            Criteria crit = null;
            if (objectId != null) {
                crit = new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_ID"), (Object)objectId, 0);
            }
            Join join = new Join(Table.getTable((String)objsTable), Table.getTable((String)propsTable), new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2);
            sq.addJoin(join);
            sq.setCriteria(crit);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)propsTable, (String)"PROP_ID"), true));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String ldapName = (String)dataSet.getValue("PROP_LDAP_NAME");
                String propValue = (String)dataSet.getValue("PROP_VALUE");
                if (propValue == null) {
                    mgmtProps.put(ldapName, "-");
                    continue;
                }
                if (ldapName.equalsIgnoreCase("accountExpires")) {
                    propValue = !propValue.equals("0") ? DateTimeUtil.getAccountExpiresDateFromFileTime((Long)Long.parseLong(propValue), (AdventNetResourceBundle)rb, (Long)loginId) : rb.getString("admp.reports.user.account_exp_date.never_expires");
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                } else if (ldapName.equalsIgnoreCase("pwdLastSet")) {
                    propValue = DateTimeUtil.getDaysSincePasswordSetForAudi((String)propValue);
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                } else if (ldapName.equalsIgnoreCase("memberOf") || ldapName.equalsIgnoreCase("members")) {
                    if (mgmtProps.containsKey(ldapName)) {
                        String val = (String)mgmtProps.get(ldapName);
                        propValue = val + ", " + propValue;
                    }
                } else if (ldapName.equalsIgnoreCase("userWorkstations")) {
                    if (propValue.equalsIgnoreCase("") || propValue == null) {
                        propValue = rb.getString("admp.mgmt.user_mgmt.user_workstats.input.allow_all_computers");
                    }
                } else if (ldapName.equalsIgnoreCase("password")) {
                    EnDecryptImpl enDecrypt = new EnDecryptImpl();
                    propValue = enDecrypt.decrypt(propValue);
                    if (PasswordUtil.getShowPasswordValue()) {
                        propValue = propValue.replaceAll(".", "*");
                    }
                } else {
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                }
                mgmtProps.put(ldapName, propValue);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return mgmtProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getUserProps(Long userIndex, Long auditId, boolean fetchArchiveData, Long archiveTime, AdventNetResourceBundle rb) {
        HashMap<String, String> userProperties = new HashMap<String, String>();
        Connection connection = null;
        DataSet dataSet = null;
        SelectQueryImpl sq = null;
        try {
            ArrayList attributeList = AuditUtil.getAttributeDetails(auditId, fetchArchiveData, archiveTime);
            if (attributeList.isEmpty()) {
                HashMap<String, String> hashMap = userProperties;
                return hashMap;
            }
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> tableNameList = new ArrayList<String>();
            String baseTable = fetchArchiveData ? "ADSMAUNamingAttributes_" + archiveTime : "ADSMAUNamingAttributes";
            Criteria crit = new Criteria(Column.getColumn((String)baseTable, (String)"USER_INDEX"), (Object)userIndex, 0);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProps = (Properties)attributeList.get(i);
                String tableName = fetchArchiveData ? attributeProps.getProperty("AU_TABLE_NAME") + "_" + archiveTime : attributeProps.getProperty("AU_TABLE_NAME");
                String columnName = attributeProps.getProperty("ATTRIB_COLUMN_NAME");
                Integer relationalType = (Integer)attributeProps.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) continue;
                sq = new SelectQueryImpl(Table.getTable((String)tableName));
                Column column = Column.getColumn((String)tableName, (String)columnName);
                selectColumnList.add(column);
                if (tableNameList.contains(tableName)) continue;
                tableNameList.add(tableName);
            }
            sq.addSelectColumns(selectColumnList);
            sq.setCriteria(crit);
            for (int j = 0; tableNameList != null && tableNameList.size() > 1 && j < tableNameList.size(); ++j) {
                String joinTable = (String)tableNameList.get(j);
                if (tableNameList.contains(baseTable) && baseTable.equals(joinTable)) continue;
                Join join = new Join(baseTable, joinTable, new String[]{"USER_CREATION_ID"}, new String[]{"USER_CREATION_ID"}, 2);
                sq.addJoin(join);
            }
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery(sq, connection);
            while (dataSet.next()) {
                for (int i = 0; i < attributeList.size(); ++i) {
                    Properties props = (Properties)attributeList.get(i);
                    String displayName = props.getProperty("ATTRIB_DISP_NAME");
                    String columnName = props.getProperty("ATTRIB_COLUMN_NAME");
                    String mulTable = fetchArchiveData ? props.getProperty("AU_TABLE_NAME") + "_" + archiveTime : props.getProperty("AU_TABLE_NAME");
                    displayName = rb.getString(displayName);
                    Integer relType = (Integer)props.get("RELATIONAL_TYPE");
                    String value = "";
                    value = relType.equals(new Integer(1)) ? AuditUtil.getMultipleValues(mulTable, columnName, userIndex) : String.valueOf(dataSet.getValue(columnName));
                    if (value == null) continue;
                    userProperties.put(displayName, value);
                }
            }
            String customTable = fetchArchiveData ? "ADSMAUCustomAttributes_" + archiveTime : "ADSMAUCustomAttributes";
            crit = new Criteria(Column.getColumn((String)customTable, (String)"USER_INDEX"), (Object)userIndex, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(customTable, crit);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows(customTable);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String customAttribName = (String)r.get("CUSTOM_ATTRIB_NAME");
                    if (userProperties.get(customAttribName) == null) {
                        userProperties.put(customAttribName, (String)r.get("CUSTOM_ATTRIB_VALUE"));
                        continue;
                    }
                    userProperties.put(customAttribName, userProperties.get(customAttribName) + ", " + (String)r.get("CUSTOM_ATTRIB_VALUE"));
                }
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return userProperties;
    }

    public static String getMultipleValues(String tableName, String columnName, Long userIndex) {
        String addedValue = "";
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"USER_INDEX"));
            sq.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"USER_INDEX"), (Object)userIndex, 0));
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator it = dob.getRows(tableName);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String value = (String)row.get(columnName);
                if (!addedValue.equalsIgnoreCase("")) {
                    addedValue = addedValue + ", " + value;
                    continue;
                }
                addedValue = addedValue + value;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return addedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getAttributeDetails(Long auditId, boolean isArchive, Long archiveTime) {
        ArrayList<Properties> attributeList = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)"ADSMCustomFields"));
            subQuery.addSelectColumn(Column.getColumn((String)"ADSMCustomFields", (String)"LDAP_NAME"));
            DerivedColumn subQueryResCol = new DerivedColumn("ADSMCustomFields", (SelectQuery)subQuery);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMAttributeDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"AU_TABLE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), true));
            String auditAttribsTable = isArchive ? "ADSMAuditAttribs_" + archiveTime : "ADSMAuditAttribs";
            Criteria criteria = new Criteria(Column.getColumn((String)auditAttribsTable, (String)"AUDIT_ID"), (Object)auditId, 0);
            criteria = criteria.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)subQueryResCol, 9);
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)auditAttribsTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue("ATTRIB_ID"));
                prop.put("ATTRIB_DISP_NAME", dataSet.getValue("ATTRIB_DISP_NAME"));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue("ATTRIB_COLUMN_NAME"));
                prop.put("AU_TABLE_NAME", dataSet.getValue("AU_TABLE_NAME"));
                prop.put("RELATIONAL_TYPE", dataSet.getValue("RELATIONAL_TYPE"));
                attributeList.add(prop);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return attributeList;
    }

    public static Criteria getSearchCriteria(HttpServletRequest request, DynaActionForm bean, ArrayList attributeList, boolean isArchive, Long archiveTime, AdventNetResourceBundle rb) {
        Criteria crit = null;
        boolean search = false;
        String searchString = (String)bean.get("searchString");
        if (request.getParameter("search") != null) {
            search = true;
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties attributeProps = (Properties)attributeList.get(i);
            Integer attribId = (Integer)attributeProps.get("ATTRIB_ID");
            String val = null;
            String val1 = null;
            if (search) {
                if (request.getParameter("search" + attribId.toString()) != null) {
                    val = request.getParameter("search" + attribId.toString());
                    val1 = "*" + rb.getString(val) + "*";
                    String key = "search" + attribId;
                    searchString = !searchString.equalsIgnoreCase("") ? ReportResultUtil.setSearchString(searchString, attribId, val) : key + "=" + val;
                } else {
                    val = ReportResultUtil.getSearchString(searchString, attribId);
                }
            } else {
                System.out.println("not used");
                val = ReportResultUtil.getSearchString(searchString, attribId);
            }
            if (val == null || val.equalsIgnoreCase("")) continue;
            String tableName = isArchive ? attributeProps.getProperty("TABLE_NAME") + "_" + archiveTime : attributeProps.getProperty("TABLE_NAME");
            String columnName = attributeProps.getProperty("ATTRIB_COLUMN_NAME");
            Criteria c = null;
            if (attribId == 11145) {
                try {
                    DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, (Criteria)null);
                    Iterator itr = obj.getRows(tableName);
                    while (itr.hasNext()) {
                        Row row = (Row)itr.next();
                        String actionName = (String)row.get("ACTION_NAME");
                        if (!val1.equalsIgnoreCase("*" + rb.getString(actionName) + "*")) continue;
                        if (c == null) {
                            c = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)actionName, 2);
                            continue;
                        }
                        c = c.or(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)actionName, 2));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                int len = val.length();
                val = val.charAt(0) == '*' && val.charAt(len - 1) == '*' ? "*" + val + "*" : (val.charAt(len - 1) == '*' ? val + "*" : (val.charAt(0) == '*' ? "*" + val : "*" + val + "*"));
                val = EscapeUtil.getEscapedString((Object)val);
                c = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)val, 2);
                c = c.or(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)val1, 2));
            }
            if (columnName.equalsIgnoreCase("OBJECT_NAME")) {
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"FOLDER_INDEX"), null, 1);
                String value = val.replaceAll("\\\\", ":BACKSLASH:");
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)value, 2));
                c = c.or(criteria);
            }
            crit = crit == null ? c : crit.and(c);
        }
        if (search) {
            bean.set("searchString", (Object)searchString);
            bean.set("FROM_INDEX", (Object)"1");
        }
        System.out.println("Criteria for Search :" + crit);
        return crit;
    }
}

