/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.FileReaderModel;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Vector;
import java.util.logging.Logger;

public class CSVReader
implements FileReaderModel {
    private static Logger logger = Logger.getLogger(CSVReader.class.getName());
    private static final boolean DEBUGGING = true;
    private BufferedReader r;
    private final char separator;
    private final char quote;
    private final boolean allowMultiLineFields;
    private final boolean trim;
    private static final int EOL = 0;
    private static final int ORDINARY = 1;
    private static final int QUOTE = 2;
    private static final int SEPARATOR = 3;
    private static final int WHITESPACE = 4;
    private static final int SEMICOLON = 5;
    private AdventNetResourceBundle rb;
    static String lineSeparator = System.getProperty("line.separator");
    private static final int SEEKING_START = 0;
    private static final int IN_PLAIN = 1;
    private static final int IN_QUOTED = 2;
    private static final int AFTER_END_QUOTE = 3;
    private static final int SKIPPING_TAIL = 4;
    private String line = null;
    private int lineCount = 0;
    private int fieldCount = 0;
    private boolean allFieldsDone = true;

    public CSVReader(InputStream stream, char separator, char quote, boolean allowMultiLineFields, boolean trim, boolean checkBOMCharacters, String encoding, AdventNetResourceBundle rb) throws Exception {
        this.r = checkBOMCharacters ? this.getReaderWithoutBOM(stream, encoding) : new BufferedReader(new InputStreamReader(stream, encoding));
        if (this.r == null) {
            throw new IllegalArgumentException("invalid Reader");
        }
        this.separator = separator;
        this.quote = quote;
        this.allowMultiLineFields = allowMultiLineFields;
        this.trim = trim;
        this.rb = rb;
    }

    public CSVReader(InputStream stream, String encoding, AdventNetResourceBundle rb) throws Exception {
        this(stream, ',', '\"', false, true, true, encoding, rb);
    }

    public CSVReader(InputStream stream, AdventNetResourceBundle rb) throws Exception {
        this(stream, "UTF-8", rb);
    }

    public CSVReader() {
        this.separator = (char)44;
        this.quote = (char)34;
        this.allowMultiLineFields = false;
        this.trim = true;
    }

    private int categorise(char c) {
        switch (c) {
            case '\r': 
            case ' ': 
            case '\u00ff': {
                return 4;
            }
            case '\n': {
                return 0;
            }
        }
        if (c == this.quote) {
            return 2;
        }
        if (c == this.separator) {
            return 3;
        }
        if (c == ';') {
            return 5;
        }
        if ('!' <= c && c <= '~') {
            return 1;
        }
        if ('\u0000' <= c && c <= ' ') {
            return 4;
        }
        if ('\u3000' <= c && c <= '\u303f') {
            return 1;
        }
        if (Character.isWhitespace(c)) {
            return 4;
        }
        return 1;
    }

    public Vector getAllFieldsInLine() throws EOFException, IOException {
        String field;
        Vector<String> fields = new Vector<String>();
        this.fieldCount = 0;
        while ((field = this.get()) != null) {
            ++this.fieldCount;
            fields.add(field);
        }
        return fields;
    }

    public String get() throws EOFException, IOException {
        StringBuffer field = new StringBuffer(this.allowMultiLineFields ? 512 : 64);
        int state = 0;
        block41: while (true) {
            this.getLineIfNeeded();
            int i = 0;
            while (true) {
                if (i >= this.line.length()) continue block41;
                char c = this.line.charAt(i);
                int category = this.categorise(c);
                block0 : switch (state) {
                    case 0: {
                        switch (category) {
                            case 4: {
                                break;
                            }
                            case 2: {
                                state = 2;
                                break;
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return "";
                            }
                            case 0: {
                                if (this.allFieldsDone) {
                                    this.line = null;
                                    return null;
                                }
                                this.allFieldsDone = true;
                                this.line = this.line.substring(i);
                                return "";
                            }
                            case 1: 
                            case 5: {
                                field.append(c);
                                state = 1;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (category) {
                            case 2: {
                                this.line = null;
                                throw new IOException(this.rb.getString("admp.mgmt.csv_import.common.statmsg.missing_quote_at_start_of_field_reasons"));
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                field.append(' ');
                                break;
                            }
                            case 1: 
                            case 5: {
                                field.append(c);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (category) {
                            case 2: {
                                state = 3;
                                break;
                            }
                            case 0: {
                                if (this.allowMultiLineFields) {
                                    field.append(lineSeparator);
                                    this.line = null;
                                    continue block41;
                                }
                                this.allFieldsDone = true;
                                this.line = null;
                                throw new IOException(this.rb.getString("admp.mgmt.csv_import.common.statmsg.missing_quote_after_field_reasons"));
                            }
                            case 4: {
                                field.append(' ');
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: {
                                field.append(c);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (category) {
                            case 2: {
                                field.append(c);
                                state = 2;
                                break block0;
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                state = 4;
                                break block0;
                            }
                            case 5: {
                                field.append(c);
                                break block0;
                            }
                            case 1: {
                                this.line = null;
                                throw new IOException(this.rb.getString("admp.mgmt.csv_import.common.statmsg.missing_separator_after_field_reasons"));
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (category) {
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                break block0;
                            }
                            case 1: 
                            case 2: {
                                this.line = null;
                                throw new IOException(this.rb.getString("admp.mgmt.csv_import.common.statmsg.missing_separator_after_space_reasons"));
                            }
                        }
                    }
                }
                ++i;
            }
            break;
        }
    }

    private String maybeTrim(String s) {
        if (this.trim) {
            return s.trim();
        }
        return s;
    }

    public int getInt() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public long getLong() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0L;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public float getFloat() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0.0f;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    public double getDouble() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0.0;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    private void getLineIfNeeded() throws EOFException, IOException {
        if (this.line == null) {
            if (this.r == null) {
                throw new IllegalArgumentException("attempt to use a closed CSVReader");
            }
            this.allFieldsDone = false;
            this.line = this.r.readLine();
            if (this.line == null) {
                throw new EOFException();
            }
            this.line = this.line + '\n';
            ++this.lineCount;
        }
    }

    public void skip(int fields) throws EOFException, IOException {
        if (fields <= 0) {
            return;
        }
        for (int i = 0; i < fields; ++i) {
            this.get();
        }
    }

    public void skipToNextLine() throws EOFException, IOException {
        if (this.line == null) {
            this.getLineIfNeeded();
        }
        this.line = null;
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    public static void main(String[] args) {
    }

    public void initialize(String filePath) throws FileNotFoundException {
        BufferedReader reader;
        this.r = reader = new BufferedReader(new FileReader(filePath));
    }

    private BufferedReader getReaderWithoutBOM(InputStream stream, String encoding) {
        BufferedReader br = null;
        int offset = 0;
        int n = 4;
        byte[] bom = new byte[n];
        try {
            PushbackInputStream pushStream = new PushbackInputStream(stream, 4);
            pushStream.read(bom, 0, n);
            if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                encoding = "UTF-8";
                offset = 3;
            } else if (bom[0] == -2 && bom[1] == -1) {
                encoding = "UTF-16BE";
                offset = 2;
            } else if (bom[0] == -1 && bom[1] == -2) {
                encoding = "UTF-16LE";
                offset = 2;
            } else {
                offset = 0;
            }
            pushStream.unread(bom, offset, n - offset);
            br = new BufferedReader(new InputStreamReader((InputStream)pushStream, encoding));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return br;
    }

    public int getFieldIndex() {
        return this.fieldCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    static {
        if (lineSeparator == null) {
            lineSeparator = "\r012";
        }
    }
}

