/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.manageengine.o365.server.admin.PersonalizeHandler;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientUtil {
    public static final int OBJECTLIST_TRIM_SIZE = 6;
    public static final String inValidChar = "\uffff";
    private static String imageDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adp" + File.separator;

    public static String storeFile(FormFile formFile, String ... args) throws Exception {
        FileOutputStream fout = null;
        InputStream fileInput = null;
        try {
            File saveDir;
            fileInput = formFile.getInputStream();
            byte[] file = new byte[fileInput.available()];
            fileInput.read(file);
            String imageLocation = imageDir;
            if (!"".equals(args[1])) {
                imageLocation = imageDir + args[1];
            }
            if (!(saveDir = new File(imageLocation)).exists()) {
                saveDir.mkdirs();
            }
            File writeFile = new File(imageLocation + args[0]);
            fout = new FileOutputStream(writeFile);
            fout.write(file);
            String string = args[1] + args[0];
            return string;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Hashtable getUserGroupList(String[] ar) {
        Hashtable hash = new Hashtable();
        try {
            ArrayList<Object> userList = new ArrayList<Object>();
            ArrayList<Object> groupList = new ArrayList<Object>();
            Criteria crit = null;
            for (int i = 0; ar != null && i < ar.length; ++i) {
                crit = crit == null ? new Criteria(new Column("ADSMMailBoxObjects", "DISTINGUISHED_NAME"), (Object)ar[i], 0) : crit.or(new Criteria(new Column("ADSMMailBoxObjects", "DISTINGUISHED_NAME"), (Object)ar[i], 0));
            }
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMMailBoxObjects", crit);
            Iterator it = obj.getRows("ADSMMailBoxObjects");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String objClass = (String)r.get("OBJECT_CLASS");
                if (objClass.equalsIgnoreCase("group")) {
                    groupList.add(r.get("DISTINGUISHED_NAME"));
                    continue;
                }
                userList.add(r.get("DISTINGUISHED_NAME"));
            }
            hash.put("users", userList);
            hash.put("groups", groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static ArrayList getList(String[] ar) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; ar != null && i < ar.length; ++i) {
            l.add(ar[i]);
        }
        return l;
    }

    public static String getString(String[] ar) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; ar != null && i < ar.length; ++i) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(ar[i]);
        }
        return str.toString();
    }

    public static String getString(String[] ar, int limit) {
        StringBuilder trimString = new StringBuilder();
        if (ar.length <= limit) {
            limit = ar.length;
        }
        for (int counter = 0; counter < limit; ++counter) {
            if (counter != 0) {
                trimString.append(",");
            }
            trimString.append(ar[counter]);
        }
        return trimString.toString();
    }

    public static String getString(ArrayList list) {
        StringBuilder str = new StringBuilder();
        for (int index = 0; list != null && index < list.size(); ++index) {
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(list.get(index));
        }
        return str.toString();
    }

    public static String getSemicolonSepString(ArrayList list) {
        StringBuilder str = new StringBuilder();
        for (int index = 0; list != null && index < list.size(); ++index) {
            if (str.length() > 0) {
                str.append("; ");
            }
            str.append(list.get(index));
        }
        return str.toString();
    }

    public static String getSemicolonSepAttribString(ArrayList<Hashtable> list) {
        StringBuilder str = new StringBuilder();
        if (list != null) {
            for (Hashtable tempTable : list) {
                Integer attributeId = (Integer)tempTable.get("ATTRIB_ID");
                if (str.length() > 0) {
                    str.append(";");
                }
                str.append(attributeId);
            }
        }
        return str.toString();
    }

    public static int indexOf(Long[] ar, Long val) {
        int index = -1;
        if (ar == null || val == null) {
            return index;
        }
        for (int i = 0; i < ar.length; ++i) {
            if (!ar[i].equals(val)) continue;
            index = i;
        }
        return index;
    }

    public static String getOUName(String domainName, ArrayList ouList, String ouDNName) {
        String ouName = "";
        for (int k = 0; k < ouList.size(); ++k) {
            Properties ouProp = (Properties)ouList.get(k);
            String ouDN = ouProp.getProperty("DISTINGUISHED_NAME");
            if (!ouDNName.equalsIgnoreCase(ouDN)) continue;
            String ou = ReportAttributeHandler.getInstance().getLocation(domainName, ouDNName);
            ouName = ouProp.getProperty("OU_NAME") + "[" + ou + "]";
        }
        return ouName;
    }

    public static Properties getOUDetails(String domainName, String ouDNName, Long loginId) {
        Properties p = new Properties();
        try {
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add("name");
            attrList.add("managedBy");
            attrList.add("whenCreated");
            attrList.add("whenChanged");
            attrList.add("objectGUID");
            attrList.add("description");
            Properties ouDetails = ADHandler.getObjectProperties((String)domainName, (Long)loginId, (String)ouDNName, attrList);
            ArrayList ouNameList = (ArrayList)ouDetails.get("name");
            String ouFirstName = (String)ouNameList.get(0);
            p.put("OU_NAME", ouFirstName);
            p.put("DISTINGUISHED_NAME", ouDNName);
            ClientUtil.addOrUpdateDBWithOUDetails(ouDetails, domainName, ouDNName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    private static void addOrUpdateDBWithOUDetails(Properties ouDetails, String domainName, String ouDNName) {
        try {
            ArrayList objectGUIDList = (ArrayList)ouDetails.get("objectGUID");
            String objectGUID = (String)objectGUIDList.get(0);
            DataObject obj = null;
            Criteria crit = new Criteria(new Column("ADSMOUDetails", "OBJECT_GUID"), (Object)objectGUID, 0);
            obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMOUDetails", crit);
            if (obj.isEmpty()) {
                obj = null;
                Row row = new Row("ADSMOUDetails");
                row.set("DOMAIN_NAME", (Object)domainName);
                ArrayList ouNameList = (ArrayList)ouDetails.get("name");
                String ouName = (String)ouNameList.get(0);
                row.set("NAME", (Object)ouName);
                row.set("DISTINGUISHED_NAME", (Object)ouDNName);
                row.set("MANAGED_BY", ouDetails.get("managedBy"));
                ArrayList whenCreatedList = (ArrayList)ouDetails.get("whenCreated");
                Long whenCreated = Long.parseLong((String)whenCreatedList.get(0));
                row.set("WHEN_CREATED", (Object)whenCreated);
                ArrayList whenChangedList = (ArrayList)ouDetails.get("whenChanged");
                Long whenChanged = Long.parseLong((String)whenChangedList.get(0));
                row.set("WHEN_CHANGED", (Object)whenChanged);
                row.set("OBJECT_GUID", (Object)objectGUID);
                ArrayList descriptionList = (ArrayList)ouDetails.get("description");
                if (descriptionList != null) {
                    String description = (String)descriptionList.get(0);
                    row.set("DESCRIPTION", (Object)description);
                }
                obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                obj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSplitString(String s, int size) {
        StringBuffer buf = new StringBuffer();
        if (s != null) {
            int len = s.length();
            int l = 0;
            while (len > size) {
                String str = s.substring(l, l + size);
                int index = str.indexOf(" ");
                if (index == -1) {
                    buf.append(str + " ");
                    len -= size;
                    l += size;
                    continue;
                }
                buf.append(str.substring(0, index + 1));
                len -= index + 1;
                l += index + 1;
            }
            buf.append(s.substring(l));
        }
        return buf.toString();
    }

    public static String getTruncatedString(String str, int size) {
        if (str != null) {
            int len = str.length();
            if (len > size) {
                str = str.substring(0, size);
                str = str + "..";
            }
        } else {
            str = "-";
        }
        return str;
    }

    public static void setStatusXMLElement(HttpServletResponse response, String messageType, String message) {
        ClientUtil.setStatusXMLElement(response, messageType, message, new Properties());
    }

    public static void setStatusXMLElement(HttpServletResponse response, String messageType, String message, Properties prop) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element creationStatusElement = document.createElement("status");
            creationStatusElement.setAttribute("messageType", messageType);
            creationStatusElement.setAttribute("message", message);
            Enumeration<Object> e = prop.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                creationStatusElement.setAttribute(key, prop.getProperty(key));
            }
            data.appendChild(creationStatusElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setACLXMLElement(HttpServletResponse response, ArrayList acList) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element count = document.createElement("count");
            count.setAttribute("value", new Integer(acList.size()).toString());
            data.appendChild(count);
            for (Object object : acList) {
                Element aceElement = document.createElement("ACE");
                Properties properties = (Properties)object;
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    aceElement.setAttribute(key, properties.get(key).toString());
                }
                data.appendChild(aceElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFormatXMLElement(HttpServletResponse response, String formatValue) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element format = document.createElement("format");
            format.setAttribute("formatValue", formatValue);
            data.appendChild(format);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkAuthorization(HttpServletRequest request, long id) {
        return ClientAuthorizationUtil.isAuthorized(request, id);
    }

    public static boolean checkAuthorization(HttpServletRequest request, long[] id) {
        Boolean isAuthorized = false;
        for (int i = 0; i < id.length; ++i) {
            if (!ClientAuthorizationUtil.isAuthorized(request, id[i]).booleanValue()) continue;
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean checkAuthorization(HttpServletRequest request, Long id) {
        return ClientAuthorizationUtil.isAuthorized(request, id);
    }

    public static boolean checkAuthorization(HttpServletRequest request, String domainName, long id) {
        return ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)id);
    }

    public static boolean checkAuthorization(ADMPAuthObject authObject, String domainName, long id) {
        return ClientAuthorizationUtil.isAuthorized(authObject, domainName, (Long)id);
    }

    public static boolean checkAuthorization(ADMPAuthObject authObject, ArrayList<String> domainList, long id) {
        return ClientAuthorizationUtil.isAuthorized(authObject, domainList, (Long)id);
    }

    public static boolean checkAuthorization(HttpServletRequest request, String domainName, long[] id) {
        Boolean isAuthorized = false;
        for (int i = 0; i < id.length; ++i) {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)id[i]).booleanValue()) continue;
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean checkAuthorization(Hashtable domainVsIds, String domainName, long id, Long loginId) {
        return ClientUtil.checkAuthorization(domainVsIds, domainName, id);
    }

    public static boolean checkAuthorization(Hashtable domainActionMap, String domainName, long id) {
        return ClientAuthorizationUtil.isAuthorized(domainActionMap, domainName, (Long)id);
    }

    public static boolean checkAuthorization(Hashtable domainVsIds, String domainName, long[] id, Long loginId) {
        return ClientUtil.checkAuthorization(domainVsIds, domainName, id);
    }

    public static boolean checkAuthorization(Hashtable domainVsIds, String domainName, long[] id) {
        Boolean isAuthorized = false;
        for (int i = 0; i < id.length; ++i) {
            isAuthorized = ClientAuthorizationUtil.isAuthorized(domainVsIds, domainName, (Long)id[i]);
        }
        return isAuthorized;
    }

    public static boolean getModifyStatus(boolean checkStatus, String domainName, HttpServletRequest request, long id, String type) {
        boolean b = false;
        if (checkStatus && !ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)id).booleanValue()) {
            b = true;
        }
        return b;
    }

    public static Long getActionId(Integer reportId) {
        Long actionId = null;
        try {
            String tableName = "ADSMReports";
            Column col = new Column(tableName, "REPORT_ID");
            Criteria crit = new Criteria(col, (Object)reportId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow(tableName);
                actionId = (Long)r.get("ACTION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionId;
    }

    public static boolean getTextBoxStatusString(boolean checkStatus, HttpServletRequest request, long id) {
        boolean b = false;
        if (checkStatus && !ClientAuthorizationUtil.isAuthorized(request, id).booleanValue()) {
            b = true;
        }
        return b;
    }

    public static String getCheckBoxStatusString(boolean checkStatus, HttpServletRequest request, long id) {
        if (ClientUtil.getTextBoxStatusString(checkStatus, request, id)) {
            return "disabled";
        }
        return "";
    }

    public static String getRoleCheckStatus(DataObject roleObj, String[] actions, Long actionId) {
        String str;
        block8: {
            block9: {
                str = "";
                if (roleObj == null) break block9;
                try {
                    Row r;
                    Criteria crit = new Criteria(new Column("ADMPRolePermissions", "ACTION_ID"), (Object)actionId, 0);
                    if (actionId.equals(DelegationUtil.OFFICE365_TAB_ACTION_ID)) {
                        crit = new Criteria(new Column("ADMPRolePermissions", "ACTION_ID"), (Object)DelegationUtil.ADMP_O365_SUB_ACTION_IDS, 8);
                    }
                    if ((r = roleObj.getRow("ADMPRolePermissions", crit)) != null) {
                        str = "checked";
                    }
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break block8;
            }
            if (actions == null) break block8;
            if (!actionId.equals(DelegationUtil.OFFICE365_TAB_ACTION_ID)) {
                for (int i = 0; i < actions.length; ++i) {
                    if (!actions[i].equals(actionId.toString())) continue;
                    str = "checked";
                }
            } else {
                for (int i = 0; i < actions.length; ++i) {
                    if (!actions[i].equals(DelegationUtil.OMP_INT_MGMT_ACTION_ID.toString()) && !actions[i].equals(DelegationUtil.OMP_INT_REPORT_ACTION_ID.toString())) continue;
                    str = "checked";
                    break;
                }
            }
        }
        return str;
    }

    public static String scriptEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\\", "\"", "'", "\n", "\r", ":BACKSLASH:"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\\\\\") : (s.equalsIgnoreCase("\n") ? ret.replaceAll(s, "") : (s.equalsIgnoreCase("\r") ? ret.replaceAll(s, "\\\\r") : (s.equalsIgnoreCase(":BACKSLASH:") ? ret.replaceAll(s, "\\\\") : ret.replaceAll(s, "\\\\" + s))));
        }
        return ret;
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\"", "\r", "'"};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "<br/>", "&#39;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }

    public static String htmlEscapeForAuditReport(String str) {
        if (str != null) {
            str = ClientUtil.htmlEscape(str);
            str = str.replaceAll("(&lt;[bB]&gt;)(.*?)(&lt;/[bB]&gt;)", "<b>$2</b>");
            str = str.replaceAll("&lt;[bB][rR]/&gt;", "");
            str = str.replaceAll("&apos;", "'");
        }
        return str;
    }

    public static ArrayList getAuthorizedDomainList(HttpServletRequest request, Integer reportId) {
        ArrayList domainList = new ArrayList();
        try {
            HttpSession session = request.getSession();
            Long actionId = 0L;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
            if (!dataobj.isEmpty()) {
                Row r = dataobj.getFirstRow("ADSMReports");
                actionId = (Long)r.get("ACTION_ID");
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static String getStringFromList(ArrayList list, int limit) {
        StringBuilder trimString = new StringBuilder();
        if (list.size() <= limit) {
            limit = list.size();
        }
        for (int counter = 0; counter < limit; ++counter) {
            if (counter != 0) {
                trimString.append(",");
            }
            trimString.append(list.get(counter));
        }
        return trimString.toString();
    }

    public static void getXMLElement(HttpServletResponse response, ArrayList parentId, ArrayList childId) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element parent = document.createElement("PARENT");
            for (int i = 0; i < parentId.size(); ++i) {
                Element Values2 = document.createElement("parentId");
                Values2.setAttribute("idValue", ((Long)parentId.get(i)).toString());
                parent.appendChild(Values2);
            }
            data.appendChild(parent);
            Element child = document.createElement("CHILD");
            for (int i = 0; i < childId.size(); ++i) {
                Element Values3 = document.createElement("childId");
                Values3.setAttribute("idValue", ((Long)childId.get(i)).toString());
                child.appendChild(Values3);
            }
            data.appendChild(child);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getXMLElement(HttpServletResponse response, String[] loginIds, String message, String messageType) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element parent = document.createElement("AUTHIDS");
            for (int index = 0; loginIds != null && index < loginIds.length; ++index) {
                Element Values2 = document.createElement("loginId");
                Values2.setAttribute("idValue", loginIds[index].toString());
                parent.appendChild(Values2);
            }
            data.appendChild(parent);
            Element creationStatusElement = document.createElement("status");
            creationStatusElement.setAttribute("message", message);
            creationStatusElement.setAttribute("messageType", messageType);
            data.appendChild(creationStatusElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLocalizedString(HttpServletRequest request, String value) {
        String fmtString = "";
        Object locale = null;
        AdventNetResourceBundle rb = null;
        try {
            rb = request == null ? ResourceBundleMgr.getInstance().getBundle() : ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            fmtString = rb.getString(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fmtString.toString();
    }

    public static String getLocalizedString(AdventNetResourceBundle rb, String value) {
        String fmtString = "";
        try {
            fmtString = rb.getString(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fmtString.toString();
    }

    public static String getLocaledString(AdventNetResourceBundle rb, String value) {
        StringBuffer fmtString = new StringBuffer();
        try {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                fmtString.append(rb.getString(st.nextToken()));
                fmtString.append(" ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fmtString.toString();
    }

    public static boolean checkIsEmpty(ArrayList values) {
        boolean isEmpty = true;
        if (values != null) {
            for (int k = 0; k < values.size(); ++k) {
                String val = (String)values.get(k);
                if (val == null || val.equals("-")) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static void setAPCXMLElement(HttpServletResponse response, String[] paramsName, ArrayList list) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element creationStatusElement = document.createElement("status");
            for (int i = 0; i < list.size(); ++i) {
                creationStatusElement.setAttribute(paramsName[i], list.get(i).toString());
            }
            data.appendChild(creationStatusElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ByteArrayOutputStream seteXMLElement(ArrayList<Hashtable<String, Object>> opFiltersList, int totalRecordsCount) {
        return ClientUtil.seteXMLElement(opFiltersList, totalRecordsCount, true);
    }

    public static ByteArrayOutputStream seteXMLElement(ArrayList<Hashtable<String, Object>> opFiltersList, int totalRecordsCount, Boolean isMultipleSelection) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String filtersResultDiv = "";
            if (opFiltersList != null && !opFiltersList.isEmpty()) {
                filtersResultDiv = filtersResultDiv + "<table width='280' border='0' cellspacing='0' cellpadding='3' bgcolor='fbfbfb'> ";
                for (Hashtable<String, Object> filtersDetails : opFiltersList) {
                    Long inputID = (Long)filtersDetails.get("inputId");
                    String objectName = (String)filtersDetails.get("objectName");
                    String trimedObjectName = ClientUtil.htmlEscape(ClientUtil.getTrimedString(objectName, RVCConstants.RVC_OP_FILTERS_TEXT_TRIM_SIZE));
                    String htmlEscapedObjectName = ClientUtil.htmlEscape(objectName);
                    filtersResultDiv = filtersResultDiv + "<tr> <td>";
                    if (isMultipleSelection.booleanValue()) {
                        filtersResultDiv = filtersResultDiv + "<input type='checkbox' objectName=\"" + htmlEscapedObjectName + "\" id=opFilter_" + inputID + "  name='outputFilters' onclick='javascript:RVOutputFilter.addInputId(this)' value='" + inputID + "'>";
                    }
                    filtersResultDiv = filtersResultDiv + "<span class='blacktxt1' alt='" + objectName + "' title='" + objectName + "' value='" + inputID + "' onclick='" + (isMultipleSelection == false ? "RVOutputFilter.changeFilter(this);" : "") + "'>" + trimedObjectName + "</span></td><td>&nbsp;</td></tr>";
                }
                filtersResultDiv = filtersResultDiv + "</table>";
            }
            Element templateResultElt = document.createElement("filtersResultList");
            templateResultElt.setAttribute("filtersList", filtersResultDiv);
            data.appendChild(templateResultElt);
            Element templateSizeElt = document.createElement("filtersListSize");
            templateSizeElt.setAttribute("filtersCount", Integer.toString(totalRecordsCount));
            data.appendChild(templateSizeElt);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public static String getObjectImage(String objectClass) {
        String image = "";
        if (objectClass.equalsIgnoreCase("User")) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/user_ad.gif\"/>";
        } else if (objectClass.equalsIgnoreCase("Group")) {
            image = "<img border=\"0\" style=\"padding-right:3px;\" src=\"images/group_ad.gif\"/>";
        } else if (objectClass.equalsIgnoreCase("Computer")) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/computer_ad.gif\"/>";
        } else if (objectClass.equalsIgnoreCase("Contact")) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/contact_ad.gif\"/>";
        }
        return image;
    }

    public static String getObjectImage(Integer objectId) {
        String image = "";
        if (objectId.equals(1)) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/user_ad.gif\"/>";
        } else if (objectId.equals(2)) {
            image = "<img border=\"0\" style=\"padding-right:3px;\" src=\"images/group_ad.gif\"/>";
        } else if (objectId.equals(3)) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/computer_ad.gif\"/>";
        } else if (objectId.equals(4)) {
            image = "<img border=\"0\" style=\"padding-right:2px;\" src=\"images/contact_ad.gif\"/>";
        }
        return image;
    }

    public static String getTrimedString(String sourceString, int trimSize) {
        String resultString = "";
        resultString = sourceString.length() > trimSize ? resultString + sourceString.substring(0, trimSize) + "..." : resultString + sourceString;
        return resultString;
    }

    public static Integer getDefaultRange(String rangeStr, String isNavigate, String moduleName, Long loginId) {
        Integer range = 25;
        range = rangeStr != null ? Integer.valueOf(Integer.parseInt(rangeStr)) : NavigateRangeUtil.getDefaultRange((String)moduleName, (Long)loginId);
        if (isNavigate != null && isNavigate.equals("false")) {
            NavigateRangeUtil.setDefaultRange((String)moduleName, (int)range, (Long)loginId);
        }
        return range;
    }

    public static Hashtable getObjectClassRecipientType(String inputType) {
        Hashtable<String, String[]> resHash = new Hashtable<String, String[]>();
        if (inputType == null) {
            String[] objectClass = new String[]{"user", "contact", "group"};
            String[] recipientType = new String[]{"-", "1", "8", "128"};
            resHash.put("objectClass", objectClass);
            resHash.put("recipientType", recipientType);
        } else if (inputType.equals("forwardTo")) {
            String[] objectClass = new String[]{"user", "contact", "group", "publicFolder"};
            String[] recipientType = new String[]{"-", "1", "8", "64", "128", "256", "512", "1024", "2048", "4096"};
            resHash.put("objectClass", objectClass);
            resHash.put("recipientType", recipientType);
        } else if (inputType.equals("sendOnBehalf")) {
            String[] objectClass = new String[]{"user"};
            String[] recipientType = new String[]{"-", "1", "8", "128"};
            resHash.put("objectClass", objectClass);
            resHash.put("recipientType", recipientType);
        } else if (inputType.equals("accept_messages")) {
            String[] objectClass = new String[]{"user", "contact", "group"};
            String[] recipientType = new String[]{"-", "1", "8", "128", "4", "16", "32", "64", "2147483648", "8589934592", "17173869184", "34359738368"};
            resHash.put("objectClass", objectClass);
            resHash.put("recipientType", recipientType);
        } else {
            String[] objectClass = new String[]{"user", "contact", "group"};
            String[] recipientType = new String[]{"-", "1", "8", "128"};
            resHash.put("objectClass", objectClass);
            resHash.put("recipientType", recipientType);
        }
        return resHash;
    }

    public static String removeInvalidChars(String str) {
        str.replaceAll(inValidChar, "");
        str = str.replaceAll("\\p{C}", "");
        str = str.replaceAll("\\|", "\\\\|");
        return str;
    }

    public static String removeInvalidCharsWithCSVInj(String str) {
        str = ClientUtil.removeInvalidChars(str);
        str = CommonUtil.EscapeCSVInjection((String)str);
        return str;
    }

    public static ADMPAuthObject getAuthObject(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        if (authObject == null) {
            authObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        }
        return authObject;
    }

    public static Properties getImageDimension(String imagePath, int defaultWidth, int defaultHeight) {
        Properties p = new Properties();
        int imageWidth = -1;
        int imageHeight = -1;
        try {
            BufferedImage bufImg = ImageIO.read(new File(imagePath));
            imageWidth = bufImg.getWidth();
            imageHeight = bufImg.getHeight();
            if (defaultWidth != -1 && imageWidth > defaultWidth) {
                imageWidth = defaultWidth;
            }
            if (defaultHeight != -1 && imageHeight > defaultHeight) {
                imageHeight = defaultHeight;
            }
            p.put("ImageWidth", new Integer(imageWidth));
            p.put("ImageHeight", new Integer(imageHeight));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static void updateLogoImage(String ... pdtInfo) {
        try {
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemUtility", (Criteria)null);
            if (!dObj.isEmpty()) {
                JSONObject personalSettings = new JSONObject();
                Row r = dObj.getFirstRow("SystemUtility");
                if (pdtInfo[0] != null) {
                    r.set("LOGO_PATH", (Object)pdtInfo[0]);
                    r.set("LOGO_WIDTH", (Object)pdtInfo[1]);
                    r.set("LOGO_HEIGHT", (Object)pdtInfo[2]);
                    personalSettings.put("LOGO_PATH", (Object)("/../adsm/" + pdtInfo[0]));
                    personalSettings.put("LOGO_WIDTH", (Object)pdtInfo[1]);
                    personalSettings.put("LOGO_HEIGHT", (Object)pdtInfo[2]);
                }
                dObj.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
                if (personalSettings.has("LOGO_PATH")) {
                    PersonalizeHandler.updateSettings((Long)CommonUtil.getUserId((Long)CommonUtil.ADMIN_LOGIN_ID), (JSONObject)personalSettings);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getPageProps(HttpServletRequest request) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            String imageName = "images/logo.gif";
            String imageWidth = "-1";
            String imageHeight = "-1";
            DataObject dObj = CommonUtil.getCachedPersistence().get("SystemUtility", (Criteria)null);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("SystemUtility");
                imageName = (String)r.get("LOGO_PATH");
                imageWidth = (String)r.get("LOGO_WIDTH");
                imageHeight = (String)r.get("LOGO_HEIGHT");
            }
            hash.put("LOGO_PATH", imageName);
            hash.put("LOGO_WIDTH", new Integer(imageWidth));
            hash.put("LOGO_HEIGHT", new Integer(imageHeight));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }
}

