/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.computermanagement.ComputerMgmtHandler;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTApi;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ComputerUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.GroupUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.InputsUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CustomAttribUtil {
    public static String[] tableArray = new String[]{"ADSMUserCustomDetails", "ADSMPasswordCustomDetails", "ADSMGroupCustomDetails", "ADSMComputerCustomDetails", "ADSMExchangeCustomDetails", "ADSMPolicyCustomDetails", "ADSMContactCustomDetails"};
    public static String[] objectClass = new String[]{"user", "", "group", "computer", "MailRecipients", "", "contact"};
    public static Integer[] objectID = new Integer[]{1, 0, 2, 3, 9, 0, 4};
    public static String[] reportHeadings = new String[]{"admp.reports.heading.user_reports", "", "admp.reports.heading.group_reports", "admp.reports.heading.computer_reports", "admp.reports.heading.exch_reports", "", "admp.reports.heading.contact_reports"};
    public static String[] paramArray = new String[]{"userCreation", "userModification", "contactCreation", "contactModification", "groupCreation", "groupModification", "sharedMailboxCreation", "sharedMailboxModification", "linkedMailboxCreation", "rmMailboxCreation", "rmMailboxModification", "eqMailboxCreation", "eqMailboxModification", "computerCreation", "computerModification"};
    public static String[] reports = new String[]{"User Reports", "Password Reports", "Group Reports", "Computer Reports", "Exchange Reports", "Policy Reports", "Contact Reports"};
    private static String[] dataHandler = new String[]{"CHAR", "INTEGER", "BIGINT", "BOOLEAN", "DATETIME", "MULTIVALUE"};
    private static Long[] dataValue = new Long[]{3L, 7L, 10L, 6L, 10L, 3L};
    private static String[] baseTableArray = new String[]{"ADSMUserGeneralDetails", "*************", "ADSMGroupGeneralDetails", "ADSMComputerGeneralDetails", "ADSMMRGeneralDetails", "ADSMPwdPolicyDetails", "ADSMContactGeneralDetails", "ADSMSharedMailbox", "ADSMRoomMailbox", "ADSMEquipmentMailbox", "ADSMLinkedMailbox"};
    private static Integer[] charCrit = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static Integer[] integerCrit = new Integer[]{1, 3, 10, 11, 12, 13};
    private static Integer[] booleanCrit = new Integer[]{1};
    private static Integer[] dateCrit = new Integer[]{26, 10, 11, 12, 13, 15, 16, 17, 18, 19, 27, 20, 21};
    private static Integer[] multivalueCrit = new Integer[]{8};
    private static Long CUSTOM_ATTR_RF_GROUP_ID = 11L;

    public static ArrayList<Long> addCustomFields(Long loginId, HashMap fieldDetails) throws Exception {
        return CustomAttribUtil.addCustomFields(loginId, fieldDetails, null);
    }

    public static ArrayList<Long> addCustomFields(Long loginId, HashMap fieldDetails, String enablePII) throws Exception {
        ArrayList<Long> modifiedRoles = new ArrayList();
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row r = new Row("ADSMCustomFields");
        r.set("LDAP_NAME", (Object)((String)fieldDetails.get("ldapName")));
        r.set("DISPLAY_NAME", (Object)((String)fieldDetails.get("displayName")));
        r.set("DATA_TYPE", (Object)((String)fieldDetails.get("dataType")));
        r.set("FOR_REPORTS", (Object)((String)fieldDetails.get("forReports")));
        r.set("MGMT_ACTIONS", (Object)((String)fieldDetails.get("mgmtAction")));
        dObj.addRow(r);
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dObj);
        Long fieldId = (Long)r.get("FIELD_ID");
        CustomAttribUtil.updateReportsDetails(fieldId, fieldDetails, null, enablePII);
        modifiedRoles = CustomAttribUtil.updateMgmtDetails(loginId, fieldId, fieldDetails, null, true);
        ReportAttributeHandler.getInstance().resetAttributes();
        System.out.println("modifiedRoles :: " + modifiedRoles);
        return modifiedRoles;
    }

    private static ArrayList getColumnFilterDetails(String dataType) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (dataType.equalsIgnoreCase("CHAR")) {
            list.add(new Long(1L));
            list.add(charCrit);
        } else if (dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("BIGINT")) {
            list.add(new Long(153L));
            list.add(integerCrit);
        } else if (dataType.equalsIgnoreCase("BOOLEAN")) {
            list.add(new Long(3L));
            list.add(booleanCrit);
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            list.add(new Long(151L));
            list.add(dateCrit);
        } else if (dataType.equalsIgnoreCase("UTCTIME")) {
            list.add(new Long(151L));
            list.add(dateCrit);
        } else if (dataType.equalsIgnoreCase("MULTIVALUE")) {
            list.add(new Long(79L));
            list.add(multivalueCrit);
        }
        return list;
    }

    public static void updateCustomAttrColumnFilter(Long fieldId, String dataType, Hashtable<Long, Integer> categAttribMap) {
        try {
            ArrayList detailsList = CustomAttribUtil.getColumnFilterDetails(dataType);
            if (!detailsList.isEmpty()) {
                Long defaultComponentId = (Long)detailsList.get(0);
                Integer[] matchCrit = (Integer[])detailsList.get(1);
                DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                for (Map.Entry<Long, Integer> attr : categAttribMap.entrySet()) {
                    Row groupMappingrow = new Row("AdsmAttribToAttribGroupMapping");
                    groupMappingrow.set("ATTRIB_GROUP_ID", (Object)CUSTOM_ATTR_RF_GROUP_ID);
                    groupMappingrow.set("ATTRIB_ID", (Object)attr.getValue());
                    dObj.addRow(groupMappingrow);
                    for (Integer i : matchCrit) {
                        Row matchCriteriarow = new Row("AdsmAttribToCFMatchCriteria");
                        matchCriteriarow.set("ATTRIB_ID", (Object)attr.getValue());
                        matchCriteriarow.set("MATCH_CRITERIA_ID", (Object)i);
                        dObj.addRow(matchCriteriarow);
                    }
                    Row compMappingRow = new Row("AdsmAttribToComponentMapping");
                    compMappingRow.set("ATTRIB_ID", (Object)attr.getValue());
                    compMappingRow.set("DEFAULT_COMPONENT_ID", (Object)defaultComponentId);
                    if (dataType.equalsIgnoreCase("BOOLEAN")) {
                        compMappingRow.set("IS_DOMAIN_SPECIFIC_FIELD", (Object)true);
                        compMappingRow.set("DOMAIN_SPECIFIC_DP_CLASS", (Object)"com.adventnet.sym.adsm.common.webclient.layout.dataprovider.RFBoolean");
                    }
                    dObj.addRow(compMappingRow);
                    Integer attribId = attr.getValue();
                    Row customReportMappingRow = new Row("ADSMCRAttribFilterMapping");
                    customReportMappingRow.set("ATTRIB_ID", (Object)attribId);
                    if (attribId > 1000 && attribId <= 2000) {
                        customReportMappingRow.set("OBJECT_ID", (Object)1);
                        dObj.addRow(customReportMappingRow);
                        continue;
                    }
                    if (attribId > 2000 && attribId <= 3000) {
                        customReportMappingRow.set("OBJECT_ID", (Object)2);
                        dObj.addRow(customReportMappingRow);
                        continue;
                    }
                    if (attribId > 3000 && attribId <= 4000) {
                        customReportMappingRow.set("OBJECT_ID", (Object)3);
                        dObj.addRow(customReportMappingRow);
                        continue;
                    }
                    if (attribId <= 10000 || attribId > 11000) continue;
                    customReportMappingRow.set("OBJECT_ID", (Object)4);
                    dObj.addRow(customReportMappingRow);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteCustomColumnFilter(Integer attribId) {
        String[] filterTables = new String[]{"AdsmAttribToAttribGroupMapping", "AdsmAttribToCFMatchCriteria", "AdsmAttribToComponentMapping", "ADSMCRAttribFilterMapping", "ADSMCRFilterDetails"};
        try {
            for (String tableName : filterTables) {
                String columnName = "ATTRIB_ID";
                if (tableName.equals("ADSMCRFilterDetails")) {
                    columnName = "COLUMN_ID";
                }
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)attribId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Long> updateCustomFields(Long loginId, HashMap fieldDetails, Long fieldId, String enablePII) throws Exception {
        ArrayList<Long> modifiedRoles = new ArrayList();
        Properties fieldPreviousDetails = CustomAttribUtil.getFieldDetails(fieldId);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria);
        Row r = dObj.getFirstRow("ADSMCustomFields");
        fieldDetails.put("ldapName", (String)r.get("LDAP_NAME"));
        fieldDetails.put("dataType", (String)r.get("DATA_TYPE"));
        r.set("DISPLAY_NAME", (Object)((String)fieldDetails.get("displayName")));
        r.set("FOR_REPORTS", (Object)((String)fieldDetails.get("forReports")));
        r.set("MGMT_ACTIONS", (Object)((String)fieldDetails.get("mgmtAction")));
        dObj.updateRow(r);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
        CustomAttribUtil.updateReportsDetails(fieldId, fieldDetails, fieldPreviousDetails, enablePII);
        modifiedRoles = CustomAttribUtil.updateMgmtDetails(loginId, fieldId, fieldDetails, fieldPreviousDetails, false);
        ReportAttributeHandler.getInstance().resetAttributes();
        return modifiedRoles;
    }

    public static String deleteCustomFields(Long customAttribId) {
        String message = "";
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)customAttribId, 0);
        Criteria fieldCrit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)customAttribId, 0);
        try {
            if (customAttribId != null) {
                Integer attribId = null;
                DataObject customIDObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomIds", criteria);
                Iterator ite = customIDObj.getRows("ADSMCustomIds", criteria);
                Boolean isFirst = true;
                while (ite.hasNext()) {
                    Row r = (Row)ite.next();
                    attribId = (Integer)r.get("ATTRIB_ID");
                    Long categId = (Long)r.get("CATEGORY_ID");
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", crit);
                    Row row = dObj.getFirstRow("ADSMAttributeDetails");
                    String displayName = (String)row.get("ATTRIB_DISP_NAME");
                    String tableName = (String)row.get("TABLE_NAME");
                    String columnName = (String)dObj.getValue("ADSMAttributeDetails", "ATTRIB_COLUMN_NAME", crit);
                    CustomAttribUtil.deleteCustomColumnFilter(attribId);
                    boolean status = CustomAttribUtil.deleteCustomDetails(categId, columnName, fieldCrit, displayName, tableName, isFirst);
                    dObj.deleteRows("ADSMAttributeDetails", crit);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
                    isFirst = false;
                }
                Long[] templateCategoryIds = new Long[]{FcExecuteActionConstants.contactCreationTemplateCategoryId, FcExecuteActionConstants.contactModificationTemplateCategoryId, FcExecuteActionConstants.userCreationTemplateCategoryId, FcExecuteActionConstants.userModificationTemplateCategoryId, FcExecuteActionConstants.groupCreationTemplateCategoryId, FcExecuteActionConstants.groupModificationTemplateCategoryId, FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId, FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId, FcExecuteActionConstants.computerCreationTemplateCategoryId};
                Criteria crit = null;
                for (Long templateCategoryId : templateCategoryIds) {
                    HashMap map = FcLayoutViewHandler.getDetailsInCustomToAttribMapping((Long)templateCategoryId, (Long)customAttribId, null, null);
                    Long fieldId = (Long)map.get("FIELD_ID");
                    attribId = (Integer)map.get("ATTRIB_ID");
                    if (fieldId != null) {
                        FcExecuteFormFlow.deleteCustomField(templateCategoryId, fieldId);
                    }
                    if (attribId != null) {
                        crit = crit == null ? new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0) : crit.or(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0));
                    }
                    CustomAttribUtil.deleteActionIdDetails(attribId);
                }
                Integer attribIdOfCompMod = CustomAttribUtil.getAttribIdofCompMod(customAttribId);
                if (attribIdOfCompMod != null) {
                    crit = crit == null ? new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribIdOfCompMod, 0) : crit.or(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribIdOfCompMod, 0));
                }
                if (crit != null) {
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                }
                AddUserHandler.getInstance().updateHandler();
                ContactUserHandler.getInstance().updateHandler();
                ComputerUserHandler.getInstance().updateHandler();
                ComputerMgmtHandler.getInstance().updateHandler();
                GroupUserHandler.getInstance().updateHandler();
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", fieldCrit);
                Row r = dataObj.getFirstRow("ADSMCustomFields");
                String deletedField = (String)r.get("LDAP_NAME");
                dataObj.deleteRows("ADSMCustomFields", fieldCrit);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
                ReportAttributeHandler.getInstance().resetAttributes();
                HDTApi.getInstance().updateAuthObject();
                DBDataSourceUtil.deleteCustomAttribMappings(deletedField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message.length() == 0) {
            message = "admp.CustomFields.custom_fields.successfully_deleted";
        }
        return message;
    }

    public static ArrayList getFieldList() {
        ArrayList<Properties> fieldList = new ArrayList<Properties>();
        try {
            Criteria crit = null;
            String tableName = "ADSMCustomFields";
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", crit);
            Iterator ite = dataObj.getRows(tableName);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                Properties prop = new Properties();
                prop.put("FIELD_ID", (Long)r.get("FIELD_ID"));
                prop.put("LDAP_NAME", (String)r.get("LDAP_NAME"));
                prop.put("DISPLAY_NAME", (String)r.get("DISPLAY_NAME"));
                prop.put("DATA_TYPE", (String)r.get("DATA_TYPE"));
                prop.put("FOR_REPORTS", (String)r.get("FOR_REPORTS"));
                prop.put("MGMT_ACTIONS", (String)r.get("MGMT_ACTIONS"));
                prop.put("IS_PII_ENABLED", (Boolean)r.get("IS_PII_ENABLED"));
                fieldList.add(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldList;
    }

    public static DataObject getAttributes() {
        DataObject obj = null;
        try {
            Criteria criteria = null;
            obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Boolean isDuplicateAttribute(String str, String columnName) {
        return CustomAttribUtil.isDuplicateAttribute(str, columnName, null);
    }

    public static Boolean isDuplicateAttribute(String str, String columnName, Long fieldId) {
        Boolean isDuplicate = false;
        try {
            DataObject dataObj;
            Column col = Column.getColumn((String)"ADSMCustomFields", (String)columnName);
            Criteria criteria = new Criteria(col, (Object)str, 0);
            if (fieldId != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 1));
            }
            isDuplicate = !(dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria)).isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDuplicate;
    }

    public static String isAlreadyAssociatedLdap(HttpServletRequest request, String[] tableArray, String ldapName) {
        String associatedReport = "";
        try {
            for (int i = 0; i < tableArray.length; ++i) {
                if (request.getParameter(tableArray[i]) == null) continue;
                Properties rangeProps = InputsUtil.getObjectAttrRange((String)objectClass[i]);
                Integer minAttrRange = (Integer)rangeProps.get("MIN_RANGE");
                Integer maxAttrRange = (Integer)rangeProps.get("MAX_RANGE");
                Integer minCustomAttrRange = (Integer)rangeProps.get("CUSTOM_START_RANGE");
                if (minCustomAttrRange == 0) {
                    minCustomAttrRange = 1500 + i * 1000;
                }
                maxAttrRange = minCustomAttrRange;
                Column ldapCol = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME");
                Column idCol = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
                Criteria criteria = new Criteria(ldapCol, (Object)ldapName, 0);
                Criteria minCriteria = criteria.and(new Criteria(idCol, (Object)minAttrRange, 4));
                Criteria maxCriteria = minCriteria.and(new Criteria(idCol, (Object)maxAttrRange, 7));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", maxCriteria);
                if (dataObj.isEmpty()) continue;
                associatedReport = reportHeadings[i];
                return associatedReport;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return associatedReport;
    }

    public static ArrayList getCustomAttribForReport(ObjectClass objClass) {
        ArrayList attribDetails = new ArrayList();
        try {
            int gThan = objClass.getStartRange();
            if (objClass.getCustomAttribStartRange() != null) {
                gThan = objClass.getCustomAttribStartRange();
            }
            int lThan = objClass.getEndRange();
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)gThan, 4);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)lThan, 6));
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAttributeDetails"));
            query.addJoin(new Join("ADSMAttributeDetails", "ADSMCustomIds", new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator ite = dataObj.getRows("ADSMAttributeDetails");
            while (ite.hasNext()) {
                Hashtable<String, Object> customAttribDetails = new Hashtable<String, Object>();
                Row r = (Row)ite.next();
                customAttribDetails.put("ATTRIB_ID", r.get("ATTRIB_ID"));
                customAttribDetails.put("ATTRIB_COLUMN_NAME", r.get("ATTRIB_COLUMN_NAME"));
                customAttribDetails.put("ATTRIB_DISP_NAME", r.get("ATTRIB_DISP_NAME"));
                attribDetails.add(customAttribDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribDetails;
    }

    private static Properties getFieldDetails(Long fieldId) {
        Properties fieldProp = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", crit);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("ADSMCustomFields");
                fieldProp.put("FIELD_ID", (Long)row.get("FIELD_ID"));
                fieldProp.put("LDAP_NAME", (String)row.get("LDAP_NAME"));
                fieldProp.put("DISPLAY_NAME", (String)row.get("DISPLAY_NAME"));
                fieldProp.put("DATA_TYPE", (String)row.get("DATA_TYPE"));
                fieldProp.put("FOR_REPORTS", (String)row.get("FOR_REPORTS"));
                fieldProp.put("MGMT_ACTIONS", (String)row.get("MGMT_ACTIONS"));
                fieldProp.put("IS_PII_ENABLED", (Boolean)row.get("IS_PII_ENABLED"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldProp;
    }

    public static void updateReportsDetails(Long fieldId, HashMap fieldDetails, Properties fieldPreviousDetails, String enablePII) throws Exception {
        Hashtable<Long, Integer> resultantCategAttribMap = new Hashtable<Long, Integer>();
        Boolean isFirst = true;
        Boolean updateDirObj = false;
        ArrayList<String> piiTableList = new ArrayList<String>(Arrays.asList(tableArray));
        for (int i = 0; i < tableArray.length; ++i) {
            String dataType;
            Long reportCategoryId = new Long(i + 1);
            Hashtable<Long, Integer> categAttribMap = CustomAttribUtil.getCategAttribMap(fieldId);
            Boolean isNewAttribForReport = false;
            isNewAttribForReport = !categAttribMap.containsKey(reportCategoryId);
            Integer attribId = 0;
            String columnName = "";
            ArrayList associatedTables = (ArrayList)fieldDetails.get("associatedTables");
            if (isNewAttribForReport.booleanValue()) {
                columnName = CustomAttribUtil.getColumnName((String)fieldDetails.get("displayName"));
            } else {
                attribId = categAttribMap.get(reportCategoryId);
                Hashtable attributeDetails = ReportAttributeHandler.getInstance().getAttributeProps(attribId.toString());
                columnName = (String)attributeDetails.get("ATTRIB_COLUMN_NAME");
                if (!associatedTables.contains(tableArray[i])) {
                    String dataType2 = (String)fieldDetails.get("dataType");
                    if (dataType2.equalsIgnoreCase("MULTIVALUE")) {
                        if (associatedTables.size() == 0) {
                            CommonUtil.getPersistenceNT().dropTable((String)attributeDetails.get("TABLE_NAME"));
                            Criteria criteri = new Criteria(Column.getColumn((String)"ADMPObjectMultiValueTables", (String)"TABLE_NAME"), (Object)((String)attributeDetails.get("TABLE_NAME")), 0);
                            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteri);
                            updateDirObj = true;
                        }
                    } else {
                        CustomAttribUtil.deleteColumnDetails(reportCategoryId, tableArray[i], columnName);
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                }
                CustomAttribUtil.deleteCustomColumnFilter(attribId);
            }
            if (associatedTables == null || !associatedTables.contains(tableArray[i])) continue;
            String modDataType = dataType = (String)fieldDetails.get("dataType");
            String ldapName = (String)fieldDetails.get("ldapName");
            String displayName = (String)fieldDetails.get("displayName");
            Map attribDetailsMap = CustomAttribUtil.getDefaultAttribMap(ldapName, displayName, CustomAttribUtil.getColumnName(displayName), tableArray[i], null, null);
            attribDetailsMap.put("ATTRIB_ID", attribId);
            if (dataType.equalsIgnoreCase("DATETIME") || dataType.equalsIgnoreCase("UTCTIME")) {
                attribDetailsMap.put("TRANSFORMER_CLASS", "com.adventnet.sym.adsm.common.webclient.transformers.CustomFieldsTransformers");
                modDataType = "BIGINT";
                attribDetailsMap.put("SHOW_SEARCH", false);
            }
            if (dataType.equalsIgnoreCase("MULTIVALUE")) {
                attribDetailsMap.put("RELATIONAL_TYPE", 1);
                attribDetailsMap.put("IS_SORT", false);
                attribDetailsMap.put("SHOW_SEARCH", false);
                attribDetailsMap.put("TABLE_NAME", CustomAttribUtil.getTableName(ldapName));
                attribDetailsMap.put("TRIM_SIZE", new Integer(5));
                attribDetailsMap.put("TRANSFORMER_CLASS", "com.adventnet.sym.adsm.common.webclient.transformers.MultipleValueTransformer");
                attribId = ReportAttributeHandler.getInstance().updateAttributeDetails(attribDetailsMap, tableArray[i], dataType, isNewAttribForReport);
                CustomAttribUtil.alterCMATable(attribId, tableArray[i], displayName, ldapName, columnName, isNewAttribForReport, fieldPreviousDetails, isFirst, i, piiTableList);
                isFirst = false;
                updateDirObj = true;
            } else {
                attribId = ReportAttributeHandler.getInstance().updateAttributeDetails(attribDetailsMap, tableArray[i], dataType, isNewAttribForReport);
                CustomAttribUtil.alterTables(attribId, tableArray[i], modDataType, columnName, ldapName, displayName, reportCategoryId, isNewAttribForReport, fieldPreviousDetails);
            }
            resultantCategAttribMap.put(reportCategoryId, attribId);
        }
        String colName = CustomAttribUtil.getColumnName((String)fieldDetails.get("displayName"));
        if (enablePII != null && CommonUtil.isGDPRComplianceEnabled()) {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria);
            Row r = dObj.getFirstRow("ADSMCustomFields");
            boolean piiStatus = false;
            String piiLevel = "NONE";
            String[] tableList = new String[piiTableList.size()];
            tableList = piiTableList.toArray(tableList);
            if (!enablePII.equals("") && enablePII.equals("true")) {
                piiLevel = "MASK";
            }
            if ((piiStatus = CustomAttribUtil.definePIIforColumn(tableList, colName, piiLevel)) && !piiLevel.equals("NONE")) {
                r.set("IS_PII_ENABLED", (Object)true);
            } else {
                r.set("IS_PII_ENABLED", (Object)false);
            }
            dObj.updateRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
        }
        if (updateDirObj.booleanValue()) {
            DirectoryObjectAPI.getInstance().updateDirectoryObject();
            QueueHandler.getInstance().updateMultivalueDBTableObjects();
        }
        CustomAttribUtil.updateCategAttribMap(fieldId, resultantCategAttribMap);
        CustomAttribUtil.updateCustomAttrColumnFilter(fieldId, (String)fieldDetails.get("dataType"), resultantCategAttribMap);
    }

    public static Hashtable<Long, Integer> getCategAttribMap(Long fieldId) {
        Hashtable<Long, Integer> categAttribMap = new Hashtable<Long, Integer>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomIds", criteria);
            Iterator it = dataObj.getRows("ADSMCustomIds", criteria);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Integer attribId = (Integer)r.get("ATTRIB_ID");
                Long categId = (Long)r.get("CATEGORY_ID");
                categAttribMap.put(categId, attribId);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return categAttribMap;
    }

    private static boolean deleteColumnDetails(Long categId, String tableName, String columnName) {
        boolean status = true;
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, columnName, 3);
        try {
            CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    private static void alterTables(Integer attribId, String tableName, String dataType, String columnName, String ldapName, String displayName, Long reportCategoryId, Boolean isNewAttrib, Properties fieldPreviousDetails) throws Exception {
        Integer defaultValue = null;
        int operationType = 2;
        if (isNewAttrib.booleanValue()) {
            operationType = 1;
        }
        if (!isNewAttrib.booleanValue() && !columnName.equalsIgnoreCase(CustomAttribUtil.getColumnName(displayName))) {
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            atq.renameColumn(columnName, CustomAttribUtil.getColumnName(displayName));
            DataAccess.alterTable((AlterTableQuery)atq);
            columnName = CustomAttribUtil.getColumnName(displayName);
        }
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, operationType);
        alt.setColumnName(columnName);
        alt.setDataType(dataType);
        if ("CHAR".equals(dataType)) {
            alt.setMaxLength(1024);
        } else {
            alt.setMaxLength(250);
        }
        alt.setNullable(true);
        if ("INTEGER".equals(dataType) || "BIGINT".equals(dataType)) {
            defaultValue = 0;
        }
        alt.setDefaultValue((Object)defaultValue);
        CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alt);
        if (isNewAttrib.booleanValue()) {
            CustomAttribUtil.updateTotalTable(attribId, tableName);
        }
        if (tableName.equalsIgnoreCase("ADSMUserCustomDetails")) {
            CustomAttribUtil.updateEmptyAttribTable(attribId, ldapName, displayName);
        }
    }

    private static void alterCMATable(Integer attribId, String reportTableName, String displayName, String ldapName, String columnName, Boolean isNewAttrib, Properties fieldPreviousDetails, Boolean isFirst, Integer i, ArrayList<String> piiTableList) throws Exception {
        String tableName = CustomAttribUtil.getTableName(ldapName);
        boolean changeColumnName = false;
        if (isNewAttrib.booleanValue()) {
            if (isFirst.booleanValue()) {
                TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tableName);
                if (td == null) {
                    TableDefinition tableDef = new TableDefinition(false);
                    tableDef.setTableName(tableName);
                    ColumnDefinition colDef = new ColumnDefinition();
                    colDef.setTableName(tableName);
                    colDef.setColumnName("INDEX");
                    colDef.setDataType("BIGINT");
                    UniqueValueGeneration uvg = new UniqueValueGeneration();
                    uvg.setGeneratorName(tableName + '.' + CustomAttribUtil.getColumnName(displayName));
                    colDef.setUniqueValueGeneration(uvg);
                    colDef.setNullable(false);
                    colDef.setKey(true);
                    tableDef.addColumnDefinition(colDef);
                    colDef = new ColumnDefinition();
                    colDef.setTableName(tableName);
                    colDef.setColumnName("OBJECT_GUID");
                    colDef.setDataType("CHAR");
                    colDef.setMaxLength(50);
                    colDef.setNullable(false);
                    tableDef.addColumnDefinition(colDef);
                    colDef = new ColumnDefinition();
                    colDef.setTableName(tableName);
                    colDef.setColumnName(CustomAttribUtil.getColumnName(displayName));
                    colDef.setDataType("CHAR");
                    colDef.setMaxLength(1024);
                    colDef.setNullable(true);
                    tableDef.addColumnDefinition(colDef);
                    PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                    pkDef.setName(tableName + "_PK");
                    pkDef.setTableName(tableName);
                    pkDef.addColumnName("INDEX");
                    tableDef.setPrimaryKey(pkDef);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).createTable("adsm", tableDef);
                } else {
                    List colNames = td.getColumnNames();
                    colNames.remove("INDEX");
                    colNames.remove("OBJECT_GUID");
                    columnName = colNames.get(0).toString();
                    changeColumnName = !columnName.equalsIgnoreCase(CustomAttribUtil.getColumnName(displayName));
                }
            }
            CustomAttribUtil.updateTotalTable(attribId, reportTableName);
        }
        if (changeColumnName || !isNewAttrib.booleanValue() && isFirst.booleanValue() && !columnName.equalsIgnoreCase(CustomAttribUtil.getColumnName(displayName))) {
            AlterTableQueryImpl atq = new AlterTableQueryImpl(tableName);
            atq.renameColumn(columnName, CustomAttribUtil.getColumnName(displayName));
            CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)atq);
        }
        if (isFirst.booleanValue()) {
            Criteria criteri = new Criteria(Column.getColumn((String)"ADMPObjectMultiValueTables", (String)"TABLE_NAME"), (Object)tableName, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteri);
        }
        if (objectID[i] != 0) {
            Row r = new Row("ADMPObjectMultiValueTables");
            r.set("TABLE_NAME", (Object)tableName);
            r.set("OBJECT_ID", (Object)new Integer(objectID[i]));
            WritableDataObject wdo = new WritableDataObject();
            wdo.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add((DataObject)wdo);
        }
        if (reportTableName.equalsIgnoreCase("ADSMUserCustomDetails")) {
            CustomAttribUtil.updateEmptyAttribTable(attribId, ldapName, displayName);
        }
        if (!piiTableList.contains(tableName)) {
            piiTableList.add(tableName);
        }
    }

    private static void updateTotalTable(int attribId, String tableName) throws Exception {
        String baseTableName = null;
        for (int i = 0; i < tableArray.length; ++i) {
            if (!tableArray[i].equalsIgnoreCase(tableName)) continue;
            baseTableName = baseTableArray[i];
        }
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMReports", (String)"BASE_TABLE_NAME"), baseTableName, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)1000, 6));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", crit);
        Iterator ite = dataObj.getRows("ADSMReports");
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        while (ite.hasNext()) {
            Row r = (Row)ite.next();
            int reportId = (Integer)r.get("REPORT_ID");
            Row row = new Row("ADSMTotalReports");
            row.set("REPORT_ID", (Object)reportId);
            row.set("ATTRIB_ID", (Object)attribId);
            dObj.addRow(row);
        }
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
    }

    private static void updateEmptyAttribTable(int attribId, String ldapName, String displayName) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMEmptyAttributeList", (String)"EMPTY_ATTRIB_ID"), (Object)attribId, 0);
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMEmptyAttributeList", crit);
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("ADSMEmptyAttributeList");
            row.set("ATTRIB_LDAP_NAME", (Object)ldapName);
            row.set("ATTRIB_DISP_NAME", (Object)displayName);
            dObj.updateRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
        } else {
            Row row = new Row("ADSMEmptyAttributeList");
            row.set("EMPTY_ATTRIB_ID", (Object)attribId);
            row.set("ATTRIB_LDAP_NAME", (Object)ldapName);
            row.set("ATTRIB_DISP_NAME", (Object)displayName);
            row.set("STATUS", (Object)new Integer(0));
            dObj.addRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dObj);
        }
    }

    private static void updateCategAttribMap(Long fieldId, Hashtable<Long, Integer> hashIds) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Enumeration<Long> enumer = hashIds.keys();
        while (enumer.hasMoreElements()) {
            Long cateId = enumer.nextElement();
            Row row = new Row("ADSMCustomIds");
            row.set("FIELD_ID", (Object)fieldId);
            row.set("CATEGORY_ID", (Object)cateId);
            row.set("ATTRIB_ID", (Object)hashIds.get(cateId));
            dataObj.addRow(row);
        }
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
    }

    public static ArrayList<Long> updateMgmtDetails(Long loginId, Long customAttributeId, HashMap fieldDetails, Properties fieldPreviousDetails, Boolean isNewField) throws Exception {
        Long[] templateCategoryIds;
        ArrayList<Long> modifiedRoles = new ArrayList<Long>();
        String dataType = (String)fieldDetails.get("dataType");
        ArrayList mgmtArray = (ArrayList)fieldDetails.get("mgmtArray");
        String columnName = CustomAttribUtil.getColumnName((String)fieldDetails.get("displayName"));
        Properties prop = CustomAttribUtil.initAttributesDetails();
        for (Long templateCategoryId : templateCategoryIds = new Long[]{FcExecuteActionConstants.contactCreationTemplateCategoryId, FcExecuteActionConstants.userCreationTemplateCategoryId, FcExecuteActionConstants.groupCreationTemplateCategoryId, FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, FcExecuteActionConstants.computerCreationTemplateCategoryId}) {
            HashMap previousMgmtAttribMap = new HashMap();
            Hashtable hash = (Hashtable)prop.get(templateCategoryId);
            String creationString = (String)hash.get("creationString");
            String modificationString = (String)hash.get("modificationString");
            Long modificationCategoryId = (Long)hash.get("modificationCategoryId");
            String tableName = (String)hash.get("generalTable");
            String utTable = (String)hash.get("utTable");
            String auTable = (String)hash.get("auTable");
            Long minActionId = (Long)hash.get("minActionId");
            Long maxActionId = (Long)hash.get("maxActionId");
            if (!isNewField.booleanValue()) {
                CustomAttribUtil.getMgmtAttribDetails(templateCategoryId, customAttributeId, previousMgmtAttribMap);
                if (previousMgmtAttribMap.isEmpty()) {
                    CustomAttribUtil.getMgmtAttribDetails(modificationCategoryId, customAttributeId, previousMgmtAttribMap);
                }
                if (!previousMgmtAttribMap.isEmpty() && previousMgmtAttribMap.get("ATTRIB_COLUMN_NAME") != null) {
                    columnName = (String)previousMgmtAttribMap.get("ATTRIB_COLUMN_NAME");
                }
            }
            if ((isNewField.booleanValue() || previousMgmtAttribMap.isEmpty()) && !mgmtArray.contains(creationString) && !mgmtArray.contains(modificationString)) continue;
            Long actionId = null;
            Long modifyId = null;
            Boolean isNewAttrib = true;
            Long previousActionId = null;
            Long previousModifyId = null;
            Map mgmtHashMap = CustomAttribUtil.getDefaultAttribMap((String)fieldDetails.get("ldapName"), (String)fieldDetails.get("displayName"), CustomAttribUtil.getColumnName((String)fieldDetails.get("displayName")), tableName, utTable, auTable);
            if (dataType.equalsIgnoreCase("MULTIVALUE")) {
                mgmtHashMap.put("RELATIONAL_TYPE", 1);
                mgmtHashMap.put("IS_SORT", false);
                mgmtHashMap.put("SHOW_SEARCH", false);
            }
            if (!previousMgmtAttribMap.isEmpty()) {
                isNewAttrib = false;
                mgmtHashMap.put("ATTRIB_ID", (Integer)previousMgmtAttribMap.get("ATTRIB_ID"));
                previousActionId = (Long)previousMgmtAttribMap.get("ACTION_ID");
                previousModifyId = (Long)previousMgmtAttribMap.get("MODIFY_ID");
            }
            Long lastActionId = CustomAttribUtil.getLastGeneratedCustomActionId(minActionId, maxActionId);
            if (mgmtArray.contains(creationString) && previousActionId != null) {
                actionId = previousActionId;
            } else if (mgmtArray.contains(creationString)) {
                actionId = lastActionId = Long.valueOf(lastActionId + 1L);
            } else if (previousActionId != null) {
                CustomAttribUtil.deleteActionId(previousActionId);
            }
            if (templateCategoryId != FcExecuteActionConstants.computerCreationTemplateCategoryId) {
                if (mgmtArray.contains(modificationString) && previousModifyId != null) {
                    modifyId = previousModifyId;
                } else if (mgmtArray.contains(modificationString)) {
                    modifyId = lastActionId = Long.valueOf(lastActionId + 1L);
                } else if (previousModifyId != null) {
                    CustomAttribUtil.deleteActionId(previousModifyId);
                }
            }
            mgmtHashMap.put("ACTION_ID", actionId);
            if (templateCategoryId.compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
                mgmtHashMap.put("MODIFY_ID", modifyId);
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
                mgmtHashMap.put("MODIFY_ID", modifyId);
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
                mgmtHashMap.put("MODIFY_ID", modifyId);
            } else if (templateCategoryId.compareTo(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId) == 0 || templateCategoryId.compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0) {
                mgmtHashMap.put("MODIFY_ID", null);
                modifyId = null;
            }
            Integer attribId = ReportAttributeHandler.getInstance().updateAttributeDetails(mgmtHashMap, tableName, dataType, isNewAttrib);
            CustomAttribUtil.addActionDetails(loginId, templateCategoryId, (String)fieldDetails.get("displayName"), actionId, modifyId, previousMgmtAttribMap, modifiedRoles);
            String greyText = CustomAttribUtil.getGreyText((String)fieldDetails.get("dataType"), loginId);
            int componentId = CustomAttribUtil.getComponentId((String)fieldDetails.get("dataType"));
            ArrayList<Long> supportedComponents = CustomAttribUtil.getSupportedComponents((String)fieldDetails.get("dataType"));
            if (isNewAttrib.booleanValue()) {
                if (mgmtArray.contains(creationString)) {
                    FcExecuteFormFlow.addCustomField(templateCategoryId, attribId, customAttributeId, (String)fieldDetails.get("displayName"), greyText, new Integer(componentId).longValue(), supportedComponents, (String)fieldDetails.get("dataType"));
                }
                if (mgmtArray.contains(modificationString) && !modificationString.equalsIgnoreCase("computerModification")) {
                    FcExecuteFormFlow.addCustomField(modificationCategoryId, attribId, customAttributeId, (String)fieldDetails.get("displayName"), greyText, new Integer(componentId).longValue(), supportedComponents, (String)fieldDetails.get("dataType"));
                }
            } else {
                Long fieldId;
                HashMap map;
                String fieldPrevMgmtActions = (String)fieldPreviousDetails.get("MGMT_ACTIONS");
                if (mgmtArray.contains(creationString) && !fieldPrevMgmtActions.contains(creationString)) {
                    FcExecuteFormFlow.addCustomField(templateCategoryId, attribId, customAttributeId, (String)fieldDetails.get("displayName"), greyText, new Integer(componentId).longValue(), supportedComponents, (String)fieldDetails.get("dataType"));
                } else if (mgmtArray.contains(creationString) && fieldPrevMgmtActions.contains(creationString)) {
                    FcExecuteFormFlow.updateCustomFieldName(templateCategoryId, customAttributeId, (String)fieldDetails.get("displayName"));
                } else if (!mgmtArray.contains(creationString) && fieldPrevMgmtActions.contains(creationString)) {
                    map = FcLayoutViewHandler.getDetailsInCustomToAttribMapping((Long)templateCategoryId, (Long)customAttributeId, null, null);
                    fieldId = (Long)map.get("FIELD_ID");
                    FcExecuteFormFlow.deleteCustomField(templateCategoryId, fieldId);
                }
                if (!modificationString.equalsIgnoreCase("computerModification")) {
                    if (mgmtArray.contains(modificationString) && !fieldPrevMgmtActions.contains(modificationString)) {
                        FcExecuteFormFlow.addCustomField(modificationCategoryId, attribId, customAttributeId, (String)fieldDetails.get("displayName"), greyText, new Integer(componentId).longValue(), supportedComponents, (String)fieldDetails.get("dataType"));
                    } else if (mgmtArray.contains(modificationString) && fieldPrevMgmtActions.contains(modificationString)) {
                        FcExecuteFormFlow.updateCustomFieldName(modificationCategoryId, customAttributeId, (String)fieldDetails.get("displayName"));
                    } else if (!mgmtArray.contains(modificationString) && fieldPrevMgmtActions.contains(modificationString)) {
                        map = FcLayoutViewHandler.getDetailsInCustomToAttribMapping((Long)modificationCategoryId, (Long)customAttributeId, null, null);
                        fieldId = (Long)map.get("FIELD_ID");
                        FcExecuteFormFlow.deleteCustomField(modificationCategoryId, fieldId);
                    }
                }
                if (!mgmtArray.contains(modificationString) && !mgmtArray.contains(creationString)) {
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                }
            }
            if (templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
                AddUserHandler.getInstance().updateHandler();
            }
            if (templateCategoryId.compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
                ContactUserHandler.getInstance().updateHandler();
            }
            if (templateCategoryId.compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0) {
                ComputerUserHandler.getInstance().updateHandler();
                ComputerMgmtHandler.getInstance().updateHandler();
            }
            if (templateCategoryId.compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) != 0) continue;
            GroupUserHandler.getInstance().updateHandler();
        }
        return modifiedRoles;
    }

    private static Properties initAttributesDetails() {
        Properties prop = new Properties();
        String[] attribNameArray = new String[]{"creationString", "modificationString", "modificationCategoryId", "generalTable", "utTable", "auTable", "minActionId", "maxActionId"};
        Hashtable<String, Object> attribHashtable = new Hashtable<String, Object>();
        Object[] userCreationValueArray = new Object[]{"userCreation", "userModification", FcExecuteActionConstants.userModificationTemplateCategoryId, "ADSMUserGeneralDetails", "ADSMUTCustomAttributes", "ADSMAUNamingAttributes", FcExecuteActionConstants.minUserCustomFieldActionId, FcExecuteActionConstants.maxUserCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], userCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.userCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] contactCreationValueArray = new Object[]{"contactCreation", "contactModification", FcExecuteActionConstants.contactModificationTemplateCategoryId, "ADSMContactGeneralDetails", "ADSMContactTemplates", "ADSMAUNamingAttributes", FcExecuteActionConstants.minContactCustomFieldActionId, FcExecuteActionConstants.maxContactCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], contactCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.contactCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] groupCreationValueArray = new Object[]{"groupCreation", "groupModification", FcExecuteActionConstants.groupModificationTemplateCategoryId, "ADSMGroupGeneralDetails", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minGroupCustomFieldActionId, FcExecuteActionConstants.maxGroupCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], groupCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.groupCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] sharedMBCreationValueArray = new Object[]{"sharedMailboxCreation", "sharedMailboxModification", FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, "ADSMSharedMailbox", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minSharedMBCustomFieldActionId, FcExecuteActionConstants.maxSharedMBCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], sharedMBCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] linkedMBCreationValueArray = new Object[]{"linkedMailboxCreation", "linkedMailboxModification", -1L, "ADSMLinkedMailbox", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minLinkedMBCustomFieldActionId, FcExecuteActionConstants.maxLinkedMBCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], linkedMBCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] roomMBCreationValueArray = new Object[]{"rmMailboxCreation", "rmMailboxModification", FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId, "ADSMRoomMailbox", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minResourceMBCustomFieldActionId, FcExecuteActionConstants.maxResourceMBCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], roomMBCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] equipmentMBCreationValueArray = new Object[]{"eqMailboxCreation", "eqMailboxModification", FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId, "ADSMEquipmentMailbox", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minResourceMBCustomFieldActionId, FcExecuteActionConstants.maxResourceMBCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], equipmentMBCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, attribHashtable);
        attribHashtable = new Hashtable();
        Object[] computerCreationValueArray = new Object[]{"computerCreation", "computerModification", FcExecuteActionConstants.computerModificationTemplateCategoryId, "ADSMComputerGeneralDetails", "FcLayouts", "ADSMAUNamingAttributes", FcExecuteActionConstants.minComputerCustomFieldActionId, FcExecuteActionConstants.maxComputerCustomFieldActionId};
        for (int i = 0; i < attribNameArray.length; ++i) {
            attribHashtable.put(attribNameArray[i], computerCreationValueArray[i]);
        }
        prop.put(FcExecuteActionConstants.computerCreationTemplateCategoryId, attribHashtable);
        return prop;
    }

    private static Integer getAttribIdofCompMod(Long customId) {
        Integer attribId = null;
        try {
            Integer reportAttribId = null;
            String attrib_ldap_name = null;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)customId, 0);
            criteria = criteria.and(Column.getColumn((String)"ADSMCustomIds", (String)"ATTRIB_ID"), (Object)3500, 4);
            criteria = criteria.and(Column.getColumn((String)"ADSMCustomIds", (String)"ATTRIB_ID"), (Object)4000, 7);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomIds", criteria);
            if (!dataObject.isEmpty()) {
                reportAttribId = (Integer)dataObject.getFirstRow("ADSMCustomIds").get("ATTRIB_ID");
            }
            criteria = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)customId, 0);
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria);
            if (!dataObject.isEmpty()) {
                attrib_ldap_name = (String)dataObject.getFirstRow("ADSMCustomFields").get("LDAP_NAME");
            }
            if (attrib_ldap_name != null && !attrib_ldap_name.equalsIgnoreCase("")) {
                criteria = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)reportAttribId, 1);
                criteria = criteria.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attrib_ldap_name, 0);
                criteria = criteria.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)3500, 4);
                criteria = criteria.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)4000, 7);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", criteria);
                if (!dataObject.isEmpty()) {
                    attribId = (Integer)dataObject.getFirstRow("ADSMAttributeDetails").get("ATTRIB_ID");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribId;
    }

    private static void getMgmtAttribDetails(Long templateCategoryId, Long customId, HashMap attribMap) throws Exception {
        Integer attribId = null;
        if (templateCategoryId != FcExecuteActionConstants.computerModificationTemplateCategoryId) {
            HashMap map = FcLayoutViewHandler.getDetailsInCustomToAttribMapping((Long)templateCategoryId, (Long)customId, null, null);
            attribId = (Integer)map.get("ATTRIB_ID");
        } else {
            attribId = CustomAttribUtil.getAttribIdofCompMod(customId);
        }
        if (attribId != null) {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", c);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("ADSMAttributeDetails");
                attribMap.put("ATTRIB_ID", attribId);
                attribMap.put("ACTION_ID", (Long)row.get("ACTION_ID"));
                attribMap.put("MODIFY_ID", (Long)row.get("MODIFY_ID"));
                attribMap.put("ATTRIB_COLUMN_NAME", (String)row.get("ATTRIB_COLUMN_NAME"));
            } else {
                System.out.println("Attribute is not found in Attribute Table.. Id : " + attribId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLastGeneratedCustomActionId(Long gThan, Long lThan) {
        String actionTable = "ADMPActionDetails";
        Long actionId = 0L;
        Connection connection = null;
        DataSet dataSet = null;
        Criteria crit = new Criteria(Column.getColumn((String)actionTable, (String)"ACTION_ID"), (Object)gThan, 4);
        crit = crit.and(new Criteria(Column.getColumn((String)actionTable, (String)"ACTION_ID"), (Object)lThan, 6));
        try {
            Table table = Table.getTable((String)actionTable);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Column col = Column.getColumn((String)actionTable, (String)"ACTION_ID").maximum();
            sq.addSelectColumn(col);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                if (dataSet.getValue(1) != null) {
                    actionId = (Long)dataSet.getValue(1);
                    continue;
                }
                actionId = gThan;
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return actionId;
    }

    private static void deleteActionId(Long actionId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private static void addActionDetails(Long loginId, Long templateCategoryId, String actionName, Long actionId, Long modifyId, HashMap previousMgmtAttribMap, ArrayList<Long> modifiedRoles) throws Exception {
        HashMap<String, Object> hashMap;
        Long creationParentId = null;
        Long modificationParentId = null;
        if (templateCategoryId.compareTo(FcExecuteActionConstants.contactCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.CONTACT_CREATION_CUSTOM_FIELD_PARENT_ID;
            modificationParentId = DelegationUtil.CONTACT_MODIFICATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.USER_CREATION_CUSTOM_FIELD_PARENT_ID;
            modificationParentId = DelegationUtil.USER_MODIFICATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.GROUP_CREATION_CUSTOM_FIELD_PARENT_ID;
            modificationParentId = DelegationUtil.GROUP_MODIFICATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.SHARED_MAILBOX_CREATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.LINKED_MAILBOX_CREATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.RESOURCE_MAILBOX_CREATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.RESOURCE_MAILBOX_CREATION_CUSTOM_FIELD_PARENT_ID;
        } else if (templateCategoryId.compareTo(FcExecuteActionConstants.computerCreationTemplateCategoryId) == 0) {
            creationParentId = DelegationUtil.COMPUTER_CREATION_CUSTOM_FIELD_PARENT_ID;
        }
        ArrayList<HashMap> actionDetails = new ArrayList<HashMap>();
        Long previousActionId = null;
        Long previousModifyId = null;
        if (!previousMgmtAttribMap.isEmpty()) {
            previousActionId = (Long)previousMgmtAttribMap.get("ACTION_ID");
            previousModifyId = (Long)previousMgmtAttribMap.get("MODIFY_ID");
        }
        if (actionId != null) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("ACTION_ID", actionId);
            hashMap.put("ACTION_NAME", actionName);
            hashMap.put("PARENT_ID", creationParentId);
            hashMap.put("PRIORITY", 1);
            if (previousActionId == null) {
                actionDetails.add(hashMap);
            } else {
                CustomAttribUtil.updateActionDetails(actionId, hashMap);
            }
        }
        if (modifyId != null) {
            hashMap = new HashMap();
            hashMap.put("ACTION_ID", modifyId);
            hashMap.put("ACTION_NAME", actionName);
            hashMap.put("PARENT_ID", modificationParentId);
            hashMap.put("PRIORITY", 1);
            if (previousModifyId == null) {
                actionDetails.add(hashMap);
            } else {
                CustomAttribUtil.updateActionDetails(modifyId, hashMap);
            }
        }
        if (!actionDetails.isEmpty()) {
            CustomAttribUtil.addActionDetails(actionDetails);
        }
        ArrayList roleids = HelpdeskUtil.getHelpdeskRoleList((Long)loginId);
        ArrayList<HashMap> rolePermissionList = new ArrayList<HashMap>();
        if (!roleids.contains(CommonUtil.SUPER_ADMIN_ROLE_ID)) {
            roleids.add(CommonUtil.SUPER_ADMIN_ROLE_ID);
        }
        if (!roleids.contains(DelegationUtil.SDP_ADDON_ROLE_ID)) {
            roleids.add(DelegationUtil.SDP_ADDON_ROLE_ID);
        }
        if (!roleids.contains(DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID)) {
            roleids.add(DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID);
        }
        for (Long roleId : roleids) {
            HashMap<String, Long> hashMap2;
            ArrayList actionList = new ArrayList();
            actionList = ADMPRoleHandler.getRoleActions((Long)roleId);
            if (actionList.contains(creationParentId) && actionId != null && previousActionId == null) {
                hashMap2 = new HashMap<String, Long>();
                hashMap2.put("ADMP_ROLE_ID", roleId);
                hashMap2.put("ACTION_ID", actionId);
                rolePermissionList.add(hashMap2);
                if (!(modifiedRoles.contains(roleId) || roleId.equals(CommonUtil.SUPER_ADMIN_ROLE_ID) || roleId.equals(DelegationUtil.SDP_ADDON_ROLE_ID) || roleId.equals(DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID))) {
                    modifiedRoles.add(roleId);
                }
            }
            if (!actionList.contains(modificationParentId) || modifyId == null || previousModifyId != null) continue;
            hashMap2 = new HashMap();
            hashMap2.put("ADMP_ROLE_ID", roleId);
            hashMap2.put("ACTION_ID", modifyId);
            rolePermissionList.add(hashMap2);
            if (modifiedRoles.contains(roleId) || roleId.equals(CommonUtil.SUPER_ADMIN_ROLE_ID) || roleId.equals(DelegationUtil.SDP_ADDON_ROLE_ID) || roleId.equals(DelegationUtil.SDP_SUPER_ADMIN_ROLE_ID)) continue;
            modifiedRoles.add(roleId);
        }
        CustomAttribUtil.addRoleDetails(rolePermissionList);
        HDTApi.getInstance().updateAuthObject();
    }

    private static void updateActionDetails(Long actionId, HashMap actionMap) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPActionDetails", crit);
            Iterator it = dataObj.getRows("ADMPActionDetails");
            if (it.hasNext()) {
                Row row = (Row)it.next();
                row.setAll((Map)actionMap);
                dataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addActionDetails(ArrayList<HashMap> actionDetails) throws Exception {
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        for (HashMap map : actionDetails) {
            Row row = new Row("ADMPActionDetails");
            row.setAll((Map)map);
            dataObj.addRow(row);
        }
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
    }

    private static void addRoleDetails(ArrayList<HashMap> roleActionList) throws Exception {
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        for (HashMap map : roleActionList) {
            Row row = new Row("ADMPRolePermissions");
            row.setAll((Map)map);
            dataObj.addRow(row);
        }
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
    }

    public static String getGreyText(String dataType, Long loginId) {
        String greyText = "";
        if ("BOOLEAN".equals(dataType)) {
            greyText = "admp.mgmt.fc_layout.grey_text_enter_true_or_false";
        } else if ("INTEGER".equals(dataType)) {
            greyText = "admp.mgmt.fc_layout.grey_text_enter_integer_values";
        } else if ("BIGINT".equals(dataType)) {
            greyText = "admp.mgmt.fc_layout.grey_text_enter_large_integer_values";
        }
        return greyText;
    }

    public static int getComponentId(String dataType) {
        int componentId = 1;
        if ("BOOLEAN".equals(dataType)) {
            componentId = 17;
        } else if ("DATETIME".equals(dataType) || "UTCTIME".equals(dataType)) {
            componentId = 74;
        } else if (dataType.equalsIgnoreCase("MULTIVALUE")) {
            componentId = 79;
        }
        return componentId;
    }

    public static ArrayList<Long> getSupportedComponents(String dataType) {
        ArrayList<Long> componentList = new ArrayList<Long>();
        if ("BOOLEAN".equals(dataType)) {
            componentList.add(new Integer(17).longValue());
        } else if (dataType.equalsIgnoreCase("MULTIVALUE")) {
            componentList.add(new Integer(79).longValue());
        } else {
            componentList.add(new Integer(1).longValue());
            componentList.add(new Integer(18).longValue());
            componentList.add(new Integer(3).longValue());
            componentList.add(new Integer(74).longValue());
        }
        return componentList;
    }

    private static String getFieldLDAPName(Long fieldId) {
        String ldapName = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", criteria);
            Iterator ite = dataObj.getRows("ADSMCustomFields");
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                ldapName = (String)r.get("LDAP_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapName;
    }

    private static boolean deleteCustomDetails(Long categId, String columnName, Criteria fieldCrit, String displayName, String tableName, Boolean isFirst) {
        boolean status = true;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCustomFields", fieldCrit);
            Row row = dataObj.getFirstRow("ADSMCustomFields");
            if ("MULTIVALUE".equalsIgnoreCase(row.get("DATA_TYPE").toString())) {
                if (isFirst.booleanValue()) {
                    CommonUtil.getPersistence((boolean[])new boolean[0]).dropTable(tableName);
                    Criteria criteri = new Criteria(Column.getColumn((String)"ADMPObjectMultiValueTables", (String)"TABLE_NAME"), (Object)tableName, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteri);
                    DirectoryObjectAPI.getInstance().updateDirectoryObject();
                }
            } else {
                tableName = tableArray[(int)categId.longValue() - 1];
                AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, columnName, 3);
                CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public static String getColumnName(String displayName) {
        String columnName = displayName.toUpperCase();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < columnName.length(); ++i) {
            char ch = columnName.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                buffer.append("_");
                continue;
            }
            buffer.append(ch);
        }
        columnName = buffer.toString();
        return columnName;
    }

    public static String getTableName(String tableName) {
        StringBuffer buffer = new StringBuffer("CMA");
        for (int i = 0; i < tableName.length(); ++i) {
            char ch = tableName.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                buffer.append("_");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static Map getDefaultAttribMap(String ldapName, String displayName, String columnName, String tableName, String utTableName, String auTableName) {
        String[] KeyName = new String[]{"ATTRIB_LDAP_NAME", "ATTRIB_DISP_NAME", "ATTRIB_COLUMN_NAME", "TABLE_NAME", "RELATIONAL_TYPE", "ATTRIB_DATA_TYPE", "AJAX_SUPPORT", "BULK_EDIT", "ON_MOUSE_HELP", "ATTRIB_VALUE_COUNT", "HELP_TEXT", "UT_TABLE_NAME", "AU_TABLE_NAME"};
        Object[] KeyValue = new Object[]{ldapName, displayName, columnName, tableName, 0, 1, 0, 0, 0, 1L, null, utTableName, auTableName};
        HashMap<String, Object> attribDetailsMap = new HashMap<String, Object>();
        for (int i = 0; i < KeyName.length; ++i) {
            attribDetailsMap.put(KeyName[i], KeyValue[i]);
        }
        return attribDetailsMap;
    }

    private static void deleteActionIdDetails(Integer attribId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", crit);
            if (!dataObj.isEmpty()) {
                Criteria criter;
                Row r = dataObj.getFirstRow("ADSMAttributeDetails");
                Long actionId = (Long)r.get("ACTION_ID");
                Long modifyId = (Long)r.get("MODIFY_ID");
                if (actionId != null) {
                    criter = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criter);
                }
                if (modifyId != null) {
                    criter = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)modifyId, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getFieldLdapNames(String dataType) {
        ArrayList<Object> fieldList = new ArrayList<Object>();
        try {
            String tableName = "ADSMCustomFields";
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"FIELD_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"LDAP_NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"DATA_TYPE"), (Object)dataType, 0);
            query.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator ite = dataObj.getRows(tableName);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                fieldList.add(r.get("LDAP_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldList;
    }

    public static boolean definePIIforColumn(String[] tableList, String colName, String piiType) {
        boolean piiStatus = false;
        try {
            if (piiType == null || piiType.equals("")) {
                piiType = "NONE";
            }
            Criteria criteria1 = new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)tableList, 8);
            DataObject dataObj1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("TableDetails", criteria1);
            Iterator itr1 = dataObj1.getRows("TableDetails");
            while (itr1.hasNext()) {
                Row r = (Row)itr1.next();
                String tName = (String)r.get("TABLE_NAME");
                TableDefinition tDef = MetaDataUtil.getTableDefinitionByName((String)tName);
                int index = tDef.getColumnIndex(colName, true);
                if (index == -1) continue;
                piiStatus = MetaDataUtil.setAttribute((String)tName, (String)colName, (String)"pii", (String)piiType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return piiStatus;
    }
}

