/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.iam.GAppsUtil;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.gapps.GappsMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CustomScript;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.waad.O365BulkLicenseMgmtListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteUtil {
    protected static Logger logger = Logger.getLogger("ADMangLogger");

    public static StringBuffer deleteUser(String domainName, Long loginId, String dn, String guid, Hashtable result, AdventNetResourceBundle rb) throws LocalizedException, Exception {
        StringBuffer policyMsg = new StringBuffer("");
        StringBuffer message = DeleteUtil.deleteUser(domainName, loginId, dn, guid, result, rb, new HashMap(), policyMsg);
        if (message.toString() != "") {
            message.append(" ");
        }
        return message.append(policyMsg.toString());
    }

    public static StringBuffer deleteUser(String domainName, Long loginId, String dn, String guid, Hashtable result, AdventNetResourceBundle rb, HashMap policyStatusMap, StringBuffer policyMsg) throws LocalizedException, Exception {
        return DeleteUtil.deleteUser(domainName, loginId, dn, guid, result, rb, policyStatusMap, policyMsg, null);
    }

    public static StringBuffer deleteUser(String domainName, Long loginId, String dn, String guid, Hashtable result, AdventNetResourceBundle rb, HashMap policyStatusMap, StringBuffer policyMsg, Long auditObjectId) throws LocalizedException, Exception {
        StringBuffer message = new StringBuffer("");
        boolean usePowershell = false;
        boolean isExportMailbox = false;
        String msg = "";
        String mailServer = "";
        Properties userObjectProperties = new Properties();
        Properties exchangeServerProp = new Properties();
        String homeMDB = null;
        String samAccountName = (String)result.get(1006);
        result.put("loginId", loginId);
        result.put("rb", rb);
        HashMap policyMap = DeprovisionUtil.getDeletePolicyMap((String)domainName);
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("TerminalService");
        optionList.add("Profile");
        optionList.add("ExchangeServer");
        logger.log(Level.INFO, "Starts deleting the user,dn: " + dn);
        if (Boolean.valueOf((String)policyMap.get("override_prevent_accidental_deletion")).booleanValue()) {
            ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
            everyOneTrusteeList.add("S-1-1-0");
            ArrayList aceList = new ArrayList();
            Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
            aceHash.put("ACCESS_MASK", 65600L);
            aceHash.put("PERMISSION_STRING", "Delete,Delete Subtree");
            aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
            aceHash.put("ACE_TYPE", 1L);
            aceHash.put("ACE_ID", new Long(1L));
            aceHash.put("operation", "delete");
            aceList.add(aceHash);
            ADHandler.delegateTemplate((String)domainName, (Long)loginId, aceList, everyOneTrusteeList, (String)dn);
        }
        if (!((String)policyMap.get("delete_move_home_folder")).equals("-1")) {
            userObjectProperties = ADHandler.getUserObjectProperties((String)domainName, (long)loginId, (String)guid, optionList);
            exchangeServerProp = (Properties)userObjectProperties.get("ExchangeServer");
            String string = homeMDB = exchangeServerProp != null ? (String)exchangeServerProp.get("homeMDB") : null;
        }
        if (homeMDB != null) {
            mailServer = DeleteUtil.getMailServer(domainName, homeMDB);
            usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
        }
        if (Boolean.valueOf((String)policyMap.get("run_custom_script")).booleanValue()) {
            String scriptCommand = (String)policyMap.get("script_command");
            scriptCommand = FormatClientUtil.getFormatValue(scriptCommand, result, domainName, "");
            policyMap.put("script_command", scriptCommand);
        }
        if (Boolean.valueOf((String)policyMap.get("export_user_mailbox")).booleanValue() && usePowershell) {
            String batchName;
            optionList = new ArrayList();
            optionList.add("General");
            optionList.add("Account");
            userObjectProperties = ADHandler.getUserObjectProperties((String)domainName, (long)loginId, (String)guid, optionList);
            Properties ladpProperties = new Properties();
            ladpProperties.setProperty("sAMAccountName", samAccountName);
            ladpProperties.setProperty("userName", samAccountName);
            ladpProperties.setProperty("username", samAccountName);
            ladpProperties.setProperty("LogonName", samAccountName);
            ladpProperties.setProperty("logonName", samAccountName);
            ladpProperties.putAll((Map<?, ?>)((Properties)userObjectProperties.get("General")));
            ladpProperties.putAll((Map<?, ?>)((Properties)userObjectProperties.get("Account")));
            String filePath = (String)policyMap.get("export_user_mailbox_path");
            boolean folderExists = true;
            if (filePath.contains("%")) {
                filePath = FcExecuteNamingFormat.getFormatValue(filePath, null, ladpProperties);
                try {
                    File folder = new File(filePath);
                    if (!folder.exists()) {
                        folderExists = ADHandler.createFolder((String)domainName, (Long)loginId, (String)filePath);
                    }
                }
                catch (LocalizedException le) {
                    folderExists = false;
                    le.printStackTrace();
                }
            }
            if ((batchName = (String)result.get("batchName")) == null || batchName.isEmpty()) {
                batchName = "ADMP_EXPORT_" + System.currentTimeMillis();
            }
            Properties exportProps = new Properties();
            exportProps.put("filePath", filePath);
            exportProps.put("batchName", batchName);
            if (policyMap.get("delete_user_mailbox") != null) {
                exportProps.put("isMailboxDelete", (String)policyMap.get("delete_user_mailbox"));
            }
            if (policyMap.get("disable_user_mailbox") != null) {
                exportProps.put("isMailboxDisable", (String)policyMap.get("disable_user_mailbox"));
            }
            exportProps.put("requestName", samAccountName + "_" + domainName.replace(".", "_"));
            if (auditObjectId != null) {
                exportProps.put("AUDIT_OBJECT_ID", auditObjectId);
            }
            if (folderExists) {
                msg = DeleteUtil.exportMailbox(mailServer, domainName, homeMDB, loginId, guid, CommonUtil.escapeDN((String)dn), exportProps, usePowershell, rb, Boolean.FALSE);
            }
            if (msg.isEmpty() && folderExists) {
                DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox", msg, "admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_started_export_mailbox", rb);
                message.append(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_started_export_mailbox"));
                SchedulerUtil.enableDisableTaskByName((String)"MailboxExportTask", (Boolean)true);
                logger.log(Level.INFO, "Successfully enabled the Mailbox export task");
            } else {
                DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox", msg, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox_failed", rb);
                message.append(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox_failed"));
            }
            policyMap.put("delete_user_mailbox", "false");
            isExportMailbox = true;
        }
        userObjectProperties.put("usePowershell", (Object)usePowershell);
        userObjectProperties.put("mailServer", mailServer);
        if (Boolean.valueOf((String)policyMap.get("delete_user_mailbox")).booleanValue() && usePowershell && !isExportMailbox) {
            msg = DeleteUtil.deleteMailBox(mailServer, guid, dn, domainName, loginId, usePowershell, rb);
            DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_del_user_mailbox", msg, "admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_mailbox", rb);
        }
        if (!(isExportMailbox || Boolean.valueOf((String)policyMap.get("delete_user_mailbox")).booleanValue() && usePowershell && msg.equals("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_mailbox"))) {
            ADHandlerForMgmt.deleteUser((String)domainName, (Long)loginId, (String)CommonUtil.escapeDN((String)dn));
            if (message.toString() != "") {
                message.append(" ");
            }
            message.append(rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.successfully_deleted_user"));
        }
        if (!isExportMailbox) {
            UserHandler.deleteUser((String)domainName, (Long)loginId, (String)dn);
        }
        AdminUtil.setRefValue("IS_FIRST_DELETE", false);
        if (message.toString() != "") {
            message.append(" ");
        }
        message.append(rb.getString(msg));
        if (!((String)policyMap.get("delete_move_home_folder")).equals("-1")) {
            policyMsg.append(DeleteUtil.executeDeletePolicyTasks(userObjectProperties, domainName, loginId, guid, result, rb, policyStatusMap, policyMap));
        }
        return message;
    }

    public static String executeDeletePolicyTasks(Properties userObjectProperties, String domainName, Long loginId, String guid, Hashtable result, AdventNetResourceBundle rb, HashMap policyStatusMap, HashMap<String, String> policyMap) {
        StringBuffer message = new StringBuffer("");
        String folderPath = new String();
        StringBuffer profile = new StringBuffer("");
        StringBuffer vistaProfile = new StringBuffer("");
        StringBuffer v5profile = new StringBuffer("");
        StringBuffer v6profile = new StringBuffer("");
        try {
            String objectId;
            CharSequence removeMsg;
            Properties terminalProp = (Properties)userObjectProperties.get("TerminalService");
            Properties profileProp = (Properties)userObjectProperties.get("Profile");
            Properties exchangeServerProp = (Properties)userObjectProperties.get("ExchangeServer");
            logger.log(Level.INFO, "Executing delete policy tasks for user : " + guid);
            if (Boolean.valueOf(policyMap.get("delete_move_home_folder")).booleanValue()) {
                folderPath = (String)profileProp.get("homeDirectory");
                if (Boolean.valueOf(policyMap.get("delete_home_folder")).booleanValue() && folderPath != null) {
                    removeMsg = new StringBuffer();
                    DeleteUtil.removeFolder(folderPath, "homeFolder", domainName, loginId, rb, removeMsg);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_home_folders", removeMsg.toString(), "usermanagement.message.successfully_deleted_the", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(removeMsg.toString());
                } else if (Boolean.valueOf(policyMap.get("move_home_folder")).booleanValue() && folderPath != null) {
                    String moveTo = policyMap.get("move_home_folder_location");
                    String moveMsg = DeleteUtil.moveFolder(result, folderPath, moveTo, "homeFolder", domainName, loginId, rb, "", "", false);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.move_remote_home_folders", moveMsg, "admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(moveMsg);
                } else {
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_delete_move_remote_home_folders", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                }
            }
            if (Boolean.valueOf(policyMap.get("delete_user_profile")).booleanValue()) {
                folderPath = (String)profileProp.get("profilePath");
                if (folderPath != null) {
                    DeleteUtil.removeFolder(folderPath, "profile", domainName, loginId, rb, profile);
                    DeleteUtil.removeFolder(folderPath.concat(".V2"), "Vista profile", domainName, loginId, rb, vistaProfile);
                    DeleteUtil.removeFolder(folderPath.concat(".V5"), "V5 profile", domainName, loginId, rb, v5profile);
                    DeleteUtil.removeFolder(folderPath.concat(".V6"), "V6 profile", domainName, loginId, rb, v6profile);
                    removeMsg = DeleteUtil.constructProfileFolderMessage(profile.toString(), vistaProfile.toString(), v5profile.toString(), v6profile.toString(), rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_profiles", (String)removeMsg, "usermanagement.message.successfully_deleted_the", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append((String)removeMsg);
                } else {
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_profiles", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                }
            }
            if (Boolean.valueOf(policyMap.get("delete_ts_home_folder")).booleanValue()) {
                folderPath = (String)terminalProp.get("tsHomeDir");
                if (folderPath != null) {
                    removeMsg = new StringBuffer();
                    DeleteUtil.removeFolder(folderPath, "Terminal HomeFolder", domainName, loginId, rb, removeMsg);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_terminal_service_home_folder", removeMsg.toString(), "usermanagement.message.successfully_deleted_the", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(removeMsg.toString());
                } else {
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_terminal_service_home_folder", "admp.mgmt.common.statmsg.folder_not_exist_access_denied", "usermanagement.message.successfully_deleted_the", rb);
                }
            }
            if (Boolean.valueOf(policyMap.get("delete_ts_profile")).booleanValue()) {
                folderPath = (String)terminalProp.get("tsProfilePath");
                if (folderPath != null) {
                    DeleteUtil.removeFolder(folderPath, "Terminal Profile", domainName, loginId, rb, profile);
                    DeleteUtil.removeFolder(folderPath.concat(".V2"), "Terminal Vista profile", domainName, loginId, rb, vistaProfile);
                    removeMsg = DeleteUtil.constructProfileFolderMessage(profile.toString(), vistaProfile.toString(), rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_terminal_service_profiles", (String)removeMsg, "usermanagement.message.successfully_deleted_the", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append((String)removeMsg);
                } else {
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_terminal_service_profiles", "admp.mgmt.common.statmsg.folder_not_exist_access_denied", "usermanagement.message.successfully_deleted_the", rb);
                }
            }
            if (Boolean.valueOf(policyMap.get("run_custom_script")).booleanValue()) {
                String scriptCommand = policyMap.get("script_command");
                Boolean ignoreWarnings = Boolean.valueOf(policyMap.get("ignore_warnings"));
                String errorMsg = DeleteUtil.runCustomScript(scriptCommand, result, domainName, rb);
                DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_run_custom_script", errorMsg, "admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script", rb);
                if (message.toString() != "") {
                    message.append(" ");
                }
                message.append(errorMsg);
            }
            if (Boolean.valueOf(policyMap.get("delete_google_apps")).booleanValue() && (objectId = GAppsUtil.getObjectId((String)guid)) != null && objectId != "") {
                logger.log(Level.INFO, "Start: Delete the user in Google Apps");
                if (GappsMgmtUtil.deleteUser(domainName, loginId, objectId)) {
                    logger.log(Level.INFO, "Successfully deleted the user in Google Apps");
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_google_apps", rb.getString("admp.mgmt.user_mgmt.delete_google_apps.statmsg_deleted_user"), "admp.mgmt.user_mgmt.delete_google_apps.statmsg_deleted_user", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(rb.getString("admp.mgmt.user_mgmt.delete_google_apps.statmsg_deleted_user"));
                } else {
                    logger.log(Level.INFO, "Could not delete the user in Google Apps");
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_google_apps", rb.getString("admp.mgmt.user_mgmt.delete_google_apps.statmsg_unable_to_delete_user"), "admp.mgmt.user_mgmt.delete_google_apps.statmsg_deleted_user", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(rb.getString("admp.mgmt.user_mgmt.delete_google_apps.statmsg_unable_to_delete_user"));
                }
            }
            if (Boolean.valueOf(policyMap.get("delete_O365_user_account")).booleanValue()) {
                String errorMsg = DeleteUtil.deleteO365UserAccount(domainName, loginId, guid, rb);
                DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.input_delete_o365_account", errorMsg, "admp.admin.custom_settgs.del_policy.delete_o365_account_success", rb);
                if (message.toString() != "") {
                    message.append(" ");
                }
                message.append(errorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public static String deleteO365UserAccount(String domainName, Long loginId, String guid, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            ArrayList existingLicenseList = O365MgmtHandler.getExistingLicensesForUser((String)guid);
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error") + ":" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error");
            }
            String message = ADHandler.deleteO365User((String)tenantId, (String)tenantPass, (String)guid, (String)sourceAnchorValue, (String)moduleName);
            try {
                JSONObject jsonMessage = new JSONObject(message);
                errorString = jsonMessage.getString("errorString");
                String result = jsonMessage.getString("result");
                if (errorString != null && errorString.length() > 0) {
                    O365BulkLicenseMgmtListener listener = new O365BulkLicenseMgmtListener();
                    errorString = listener.getResultString(errorString);
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_error") + ":" + rb.getString(errorString);
                } else if (result != null && result.length() > 0) {
                    O365InfoCache.getInstance().updateLicenseConsumptionData(existingLicenseList, "remove");
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.del_policy.delete_o365_account_success");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return errorString;
    }

    public static String constructProfileFolderMessage(String normalMessage, String vistaMessage, AdventNetResourceBundle rb) {
        return DeleteUtil.constructProfileFolderMessage(normalMessage, vistaMessage, null, null, rb);
    }

    public static String constructProfileFolderMessage(String normalMessage, String vistaMessage, String v5Message, String v6Message, AdventNetResourceBundle rb) {
        boolean VistaFolderExists;
        boolean V5FolderExists = false;
        boolean V6FolderExists = false;
        String error = rb.getString("admp.common.native.error_text.error_code");
        boolean NormalFolderExists = normalMessage.indexOf(error + " : 2") == -1 && normalMessage.indexOf(error + " : 906") == -1;
        boolean bl = VistaFolderExists = vistaMessage.indexOf(error + " : 2") == -1 && vistaMessage.indexOf(error + " : 906") == -1;
        if (v5Message != null) {
            boolean bl2 = V5FolderExists = v5Message.indexOf(error + " : 2") == -1 && v5Message.indexOf(error + " : 906") == -1;
        }
        if (v6Message != null) {
            boolean bl3 = V6FolderExists = v6Message.indexOf(error + " : 2") == -1 && v6Message.indexOf(error + " : 906") == -1;
        }
        if (!NormalFolderExists && VistaFolderExists) {
            normalMessage = "";
        } else if (!VistaFolderExists && NormalFolderExists) {
            vistaMessage = "";
        }
        if (!V5FolderExists) {
            v5Message = "";
        }
        if (!V6FolderExists) {
            v6Message = "";
        }
        return normalMessage + vistaMessage + v5Message + v6Message;
    }

    public static String moveFolder(Hashtable result, String moveFrom, String moveTo, String parameter, String domainName, Long loginId, AdventNetResourceBundle rb, String distinguishedName, String sid, boolean isDisableUser) {
        String message = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder");
        try {
            String value2;
            String value = moveTo;
            if (!moveTo.endsWith("\\")) {
                value = moveTo.concat("\\");
            }
            if ((value2 = value.concat(moveFrom.substring(moveFrom.lastIndexOf(92) + 1))).endsWith("$")) {
                value2 = value2.substring(0, value2.length() - 1);
            }
            value2 = FormatClientUtil.getFormatValue(value2, result, domainName, "");
            ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)moveFrom, (String)value2);
            if (isDisableUser) {
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                Properties p = new Properties();
                p.put("ATTRIB_LDAP_NAME", "homeDirectory");
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_VALUE", value2);
                setAttributeList.add(p);
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)distinguishedName, setAttributeList, new ArrayList(), new ArrayList(), null);
            }
            try {
                boolean isDeleted = DeleteUtil.deleteFolder(moveFrom, domainName, loginId);
            }
            catch (Exception e) {
                e.printStackTrace();
                message = message + rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_delete");
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), new String(exception.getMessage()));
        }
        return message;
    }

    public static String getFormattedValue(Hashtable result, String moveFrom, String moveTo, String domainName) {
        String value2 = "";
        try {
            String value = moveTo;
            if (!moveTo.endsWith("\\")) {
                value = moveTo.concat("\\");
            }
            if ((value2 = value.concat(moveFrom.substring(moveFrom.lastIndexOf(92) + 1))).endsWith("$")) {
                value2 = value2.substring(0, value2.length() - 1);
            }
            value2 = FormatClientUtil.getFormatValue(value2, result, domainName, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return value2;
    }

    public static boolean removeFolder(String directoryPath, String parameter, String domainName, Long loginId, AdventNetResourceBundle rb, StringBuffer msg) {
        String message = "";
        Boolean isDeleted = false;
        try {
            isDeleted = DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            if (isDeleted.booleanValue()) {
                message = MessageFormat.format(rb.getString("usermanagement.message.successfully_deleted_the"), new String(parameter));
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("usermanagement.message.unable_deleted_the"), new String(parameter), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("usermanagement.message.unable_deleted_the"), new String(parameter), new String(exception.getMessage()));
        }
        msg.append(message);
        return isDeleted;
    }

    public static Boolean deleteFolder(String directoryPath, String domainName, Long loginId) throws Exception {
        Boolean isDeleted = false;
        if (directoryPath.startsWith("\\\\")) {
            if (DeleteUtil.isSharedFolder(directoryPath).booleanValue()) {
                DeleteUtil.deleteShare(domainName, loginId, directoryPath);
            } else {
                ADHandlerForMgmt.removeFolder((String)domainName, (Long)loginId, (String)directoryPath);
            }
            isDeleted = true;
        }
        return isDeleted;
    }

    private static Boolean isSharedFolder(String directoryPath) {
        int nextIndex;
        Boolean isShared = false;
        if (directoryPath.startsWith("\\\\") && (nextIndex = directoryPath.indexOf("\\", 2)) != -1 && directoryPath.lastIndexOf("\\") == nextIndex) {
            isShared = true;
        }
        return isShared;
    }

    private static void deleteShare(String domainName, Long loginId, String directoryPath) throws Exception {
        Properties shareProp;
        String localPath;
        int index;
        int nextIndex = directoryPath.indexOf("\\", 2);
        String serverName = directoryPath.substring(2, nextIndex);
        String shareName = directoryPath.substring(nextIndex + 1);
        if (serverName != "" && shareName != "" && (index = (localPath = (shareProp = ADHandler.getShareFolderInfo((String)serverName, (String)shareName, (String)domainName, (Long)loginId)).getProperty("localPath")).indexOf(":")) == 1) {
            String localDriveLetter = localPath.substring(0, 1);
            localDriveLetter = localDriveLetter.toLowerCase();
            String sharePath = "\\\\" + serverName + "\\" + localDriveLetter + "$" + localPath.substring(2);
            ADHandlerForMgmt.removeSharedFolder((String)domainName, (Long)loginId, (String)serverName, (String)shareName, (String)sharePath);
        }
    }

    private static String deleteMailBox(String mailServer, String guid, String dn, String domainName, Long loginId, Boolean usePowershell, AdventNetResourceBundle rb) {
        String message = "";
        try {
            if (mailServer != null && usePowershell.booleanValue()) {
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                message = ADHandler.deleteMailBox((String)domainName, (long)loginId, (String)guid, (Properties)exchangeServerDetails, (boolean)true, (String)dn);
                if (!message.equals("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_mailbox")) {
                    message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), rb.getString(message));
                }
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), new String(exception.getMessage()));
        }
        return message;
    }

    public static void deleteFile(ArrayList pdfFiles) {
        for (int index = 0; index < pdfFiles.size(); ++index) {
            String fileName = (String)pdfFiles.get(index);
            try {
                if (fileName == null) continue;
                File tmpFile = new File(fileName);
                boolean del = tmpFile.delete();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String executeDisablePolicyTasks(String domainName, Long loginId, String guid, String distinguishedName, String sid, Hashtable resultHash, AdventNetResourceBundle rb) {
        return DeleteUtil.executeDisablePolicyTasks(domainName, loginId, guid, distinguishedName, sid, resultHash, rb, new HashMap());
    }

    public static String executeDisablePolicyTasks(String domainName, Long loginId, String guid, String distinguishedName, String sid, Hashtable resultHash, AdventNetResourceBundle rb, HashMap policyStatusMap) {
        StringBuffer message = new StringBuffer("");
        String folderPath = new String();
        StringBuffer profile = new StringBuffer("");
        StringBuffer vistaProfile = new StringBuffer("");
        StringBuffer v5profile = new StringBuffer("");
        StringBuffer v6profile = new StringBuffer("");
        resultHash.put("loginId", loginId);
        resultHash.put("rb", rb);
        try {
            HashMap policyMap = DeprovisionUtil.getDisablePolicyMap((String)domainName);
            if (!((String)policyMap.get("delete_move_home_folder")).equals("-1")) {
                String objectId;
                String errorMsg;
                String errorMsg2;
                String errorMsg3;
                String samAccountName;
                StringBuffer removeMsg;
                StringBuffer removeMsg2;
                boolean usePowershell = false;
                String mailServer = "";
                logger.log(Level.INFO, "Executing disable policy tasks for user : " + distinguishedName);
                ArrayList<String> optionList = new ArrayList<String>();
                optionList.add("TerminalService");
                optionList.add("Profile");
                optionList.add("ExchangeServer");
                Properties userObjectProperties = ADHandler.getUserObjectProperties((String)domainName, (long)loginId, (String)guid, optionList);
                Properties terminalProp = (Properties)userObjectProperties.get("TerminalService");
                Properties profileProp = (Properties)userObjectProperties.get("Profile");
                Properties exchangeServerProp = (Properties)userObjectProperties.get("ExchangeServer");
                String homeMDB = (String)exchangeServerProp.get("homeMDB");
                boolean isFolderDeleted = false;
                boolean isVistaFolderDeleted = false;
                if (homeMDB != null) {
                    mailServer = DeleteUtil.getMailServer(domainName, homeMDB);
                    usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
                }
                userObjectProperties.put("usePowershell", (Object)usePowershell);
                userObjectProperties.put("mailServer", mailServer);
                if (Boolean.valueOf((String)policyMap.get("export_user_mailbox")).booleanValue() && usePowershell) {
                    String msg;
                    String samAccountName2 = (String)resultHash.get(new Integer(1006));
                    String batchName = (String)resultHash.get("batchName");
                    if (batchName == null || batchName.isEmpty()) {
                        batchName = "ADMP_EXPORT_" + System.currentTimeMillis();
                    }
                    Properties exportProps = new Properties();
                    exportProps.put("filePath", (String)policyMap.get("export_user_mailbox_path"));
                    exportProps.put("batchName", batchName);
                    exportProps.put("requestName", samAccountName2 + "_" + domainName.replace(".", "_"));
                    if (policyMap.get("disable_user_mailbox") != null) {
                        exportProps.put("isMailboxDisable", (String)policyMap.get("disable_user_mailbox"));
                    }
                    if ((msg = DeleteUtil.exportMailbox(mailServer, domainName, homeMDB, loginId, guid, CommonUtil.escapeDN((String)distinguishedName), exportProps, usePowershell, rb, Boolean.TRUE)).isEmpty()) {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox", msg, "admp.mgmt.user_mgmt.disable_mailbox.statmsg_successfully_started_export_mailbox", rb);
                        message.append(rb.getString("admp.mgmt.user_mgmt.disable_mailbox.statmsg_successfully_started_export_mailbox"));
                        SchedulerUtil.enableDisableTaskByName((String)"MailboxExportTask", (Boolean)true);
                        logger.log(Level.INFO, "Successfully enabled the Mailbox export task");
                    } else {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox", msg, "admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox_failed", rb);
                        message.append(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.input_export_mailbox_failed"));
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("delete_move_home_folder")).booleanValue()) {
                    folderPath = (String)profileProp.get("homeDirectory");
                    if (Boolean.valueOf((String)policyMap.get("delete_home_folder")).booleanValue() && folderPath != null) {
                        removeMsg2 = new StringBuffer();
                        isFolderDeleted = DeleteUtil.removeFolder(folderPath, "homeFolder", domainName, loginId, rb, removeMsg2);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(removeMsg2.toString());
                        if (isFolderDeleted) {
                            DeleteUtil.clearADAttribute(domainName, loginId, sid, distinguishedName, new ArrayList(), true, false, null, message, rb);
                        }
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_home_folders", message.toString().toString(), "usermanagement.message.successfully_deleted_the", rb);
                    } else if (Boolean.valueOf((String)policyMap.get("move_home_folder")).booleanValue() && folderPath != null) {
                        String moveTo = (String)policyMap.get("move_home_folder_location");
                        String moveMsg = DeleteUtil.moveFolder(resultHash, folderPath, moveTo, "homeFolder", domainName, loginId, rb, distinguishedName, sid, true);
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.move_remote_home_folders", moveMsg, "admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(moveMsg);
                    } else {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_delete_move_remote_home_folders", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("delete_user_profile")).booleanValue()) {
                    folderPath = (String)profileProp.get("profilePath");
                    isFolderDeleted = false;
                    isVistaFolderDeleted = false;
                    removeMsg2 = new StringBuffer();
                    if (folderPath != null) {
                        isFolderDeleted = DeleteUtil.removeFolder(folderPath, "profile", domainName, loginId, rb, profile);
                        isVistaFolderDeleted = DeleteUtil.removeFolder(folderPath.concat(".V2"), "Vista profile", domainName, loginId, rb, vistaProfile);
                        if (!isVistaFolderDeleted) {
                            isVistaFolderDeleted = DeleteUtil.removeFolder(folderPath.concat(".V5"), "V5 profile", domainName, loginId, rb, v5profile);
                        }
                        if (!isVistaFolderDeleted) {
                            isVistaFolderDeleted = DeleteUtil.removeFolder(folderPath.concat(".V6"), "V6 profile", domainName, loginId, rb, v6profile);
                        }
                        removeMsg2.append(DeleteUtil.constructProfileFolderMessage(profile.toString(), vistaProfile.toString(), v5profile.toString(), v6profile.toString(), rb));
                        if (isFolderDeleted) {
                            DeleteUtil.clearADAttribute(domainName, loginId, sid, distinguishedName, new ArrayList(), false, true, null, removeMsg2, rb);
                        }
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(removeMsg2);
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_profiles", removeMsg2.toString(), "usermanagement.message.successfully_deleted_the", rb);
                    } else {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_profiles", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                    }
                }
                HashMap userValMap = null;
                if (Boolean.valueOf((String)policyMap.get("delete_ts_home_folder")).booleanValue()) {
                    folderPath = (String)terminalProp.get("tsHomeDir");
                    isFolderDeleted = false;
                    if (folderPath != null) {
                        removeMsg = new StringBuffer();
                        isFolderDeleted = DeleteUtil.removeFolder(folderPath, "Terminal HomeFolder", domainName, loginId, rb, removeMsg);
                        if (isFolderDeleted) {
                            samAccountName = (String)resultHash.get(new Integer(1006));
                            if (samAccountName == null) {
                                userValMap = UserMgmtUtil.getObjPropsFromDN((String)"ADSMUserGeneralDetails", (String[])new String[]{"SAM_ACCOUNT_NAME"}, (String)distinguishedName);
                                samAccountName = (String)userValMap.get("SAM_ACCOUNT_NAME");
                            }
                            if (samAccountName != null) {
                                DeleteUtil.clearADTSAttribute(domainName, loginId, samAccountName, distinguishedName, null, true, false, null, removeMsg, rb);
                            }
                        }
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_terminal_service_home_folder", removeMsg.toString(), "usermanagement.message.successfully_deleted_the", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(removeMsg.toString());
                    } else {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_remote_terminal_service_home_folder", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("delete_ts_profile")).booleanValue()) {
                    folderPath = (String)terminalProp.get("tsProfilePath");
                    isFolderDeleted = false;
                    if (folderPath != null) {
                        removeMsg = new StringBuffer();
                        profile = new StringBuffer();
                        vistaProfile = new StringBuffer();
                        if (!isFolderDeleted) {
                            isFolderDeleted = DeleteUtil.removeFolder(folderPath, "Terminal Profile", domainName, loginId, rb, profile);
                        }
                        if (!isFolderDeleted) {
                            isFolderDeleted = DeleteUtil.removeFolder(folderPath.concat(".V2"), "Terminal Vista profile", domainName, loginId, rb, vistaProfile);
                        }
                        removeMsg.append(DeleteUtil.constructProfileFolderMessage(profile.toString(), vistaProfile.toString(), rb));
                        if (isFolderDeleted) {
                            samAccountName = (String)resultHash.get(new Integer(1006));
                            if (samAccountName == null) {
                                if (userValMap == null) {
                                    userValMap = UserMgmtUtil.getObjPropsFromDN((String)"ADSMUserGeneralDetails", (String[])new String[]{"SAM_ACCOUNT_NAME"}, (String)distinguishedName);
                                }
                                samAccountName = (String)userValMap.get("SAM_ACCOUNT_NAME");
                            }
                            if (samAccountName != null) {
                                DeleteUtil.clearADTSAttribute(domainName, loginId, samAccountName, distinguishedName, null, false, true, null, removeMsg, rb);
                            }
                        }
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_terminal_service_profiles", removeMsg.toString(), "usermanagement.message.successfully_deleted_the", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(removeMsg);
                    } else {
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.delete_roaming_terminal_service_profiles", rb.getString("admp.mgmt.common.statmsg.folder_not_exist_access_denied"), "usermanagement.message.successfully_deleted_the", rb);
                    }
                }
                if (!(!Boolean.valueOf((String)policyMap.get("disable_user_mailbox")).booleanValue() || Boolean.valueOf((String)policyMap.get("export_user_mailbox")).booleanValue() && usePowershell || homeMDB == null)) {
                    errorMsg3 = DeleteUtil.disableMailBox(mailServer, guid, distinguishedName, domainName, loginId, usePowershell, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.disable_del_mailbox.input_disable_user_mailbox", errorMsg3, "admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_disabled_mailbox", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg3);
                }
                if (Boolean.valueOf((String)policyMap.get("hide_from_address_lists")).booleanValue()) {
                    String exchVersion = (String)exchangeServerProp.get("msExchVersion");
                    String exchRecipientType = (String)exchangeServerProp.get("msExchRecipientTypeDetails");
                    if (exchVersion != null) {
                        errorMsg2 = DeleteUtil.hideFromAddressLists(mailServer, guid, distinguishedName, sid, exchVersion, exchRecipientType, domainName, loginId, usePowershell, rb);
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.input_hide_from_address_lists", errorMsg2, "admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.successfully_hidden_from_address_lists", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg2);
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("disable_lync")).booleanValue()) {
                    String objectGUID = (String)resultHash.get("OBJECT_GUID");
                    String poolName = UserHandler.getPoolName((String)objectGUID);
                    System.out.println("\n poolName:" + poolName + "\n objectGUID:" + objectGUID);
                    if (poolName != null && !poolName.equals("-")) {
                        String serverName = LCSServerHandler.getLCSServer((String)poolName);
                        String errorMsg4 = DeleteUtil.disableLync(objectGUID, serverName, domainName, loginId, rb);
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.disable_lync_user", errorMsg4, "admp.admin.custom_settgs.del_policy.disable_lync_user_success", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg4);
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("remove_direct_reports")).booleanValue()) {
                    errorMsg3 = DeleteUtil.removeDirectReports(distinguishedName, domainName, loginId, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.remove_direct_reports", errorMsg3, "admp.admin.custom_settgs.del_policy.remove_direct_reports_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg3);
                }
                if (Boolean.valueOf((String)policyMap.get("remove_eum_address")).booleanValue()) {
                    String searchString = "(&(objectCategory=person)(objectClass=user)(distinguishedName=" + distinguishedName + "))";
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                    ArrayList<String> attributeList = new ArrayList<String>();
                    attributeList.add("proxyAddresses");
                    ArrayList usersList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, (String)searchString);
                    Properties props = (Properties)usersList.get(0);
                    ArrayList proxyAddresses = (ArrayList)props.get("proxyAddresses");
                    if (proxyAddresses != null) {
                        int count = 0;
                        ArrayList<String> eumProxy = new ArrayList<String>();
                        for (int i = 0; i < proxyAddresses.size(); ++i) {
                            String proxy = (String)proxyAddresses.get(i);
                            if (!proxy.toLowerCase().startsWith("eum:")) continue;
                            eumProxy.add(proxy);
                            ++count;
                        }
                        if (count > 0) {
                            String errorMsg5 = DeleteUtil.removeEUMAddress(eumProxy, sid, distinguishedName, count, domainName, loginId, rb);
                            DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.remove_eum_address", errorMsg5, "admp.admin.custom_settgs.del_policy.remove_eum_address_success", rb);
                            if (message.toString() != "") {
                                message.append(" ");
                            }
                            message.append(errorMsg5);
                        }
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("remove_from_groups")).booleanValue()) {
                    errorMsg3 = DeleteUtil.removeFromAllGroups(distinguishedName, sid, "", domainName, loginId, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_remove_from_all_groups", errorMsg3, "admp.mgmt.mod_grp_attribs.statmsg.removegroup_operation_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg3);
                }
                if (Boolean.valueOf((String)policyMap.get("move_users")).booleanValue()) {
                    String moveUserTo = (String)policyMap.get("move_users_to_ou");
                    errorMsg = DeleteUtil.moveUser(domainName, loginId, rb, distinguishedName, moveUserTo);
                    if (errorMsg.equals(rb.getString("admp.mgmt.user_mgmt.move_user.statmsg.successfully_moved_the_user"))) {
                        resultHash.put(1012, moveUserTo);
                    }
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_move_users_to_container", errorMsg, "admp.mgmt.user_mgmt.move_user.statmsg.successfully_moved_the_user", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg);
                }
                if (Boolean.valueOf((String)policyMap.get("run_custom_script")).booleanValue()) {
                    String scriptCommand = (String)policyMap.get("script_command");
                    Boolean ignoreWarnings = Boolean.valueOf((String)policyMap.get("ignore_warnings"));
                    errorMsg2 = DeleteUtil.runCustomScript(scriptCommand, resultHash, domainName, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.text_run_custom_script", errorMsg2, "admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg2);
                }
                if (Boolean.valueOf((String)policyMap.get("disable_google_apps")).booleanValue() && (objectId = GAppsUtil.getObjectId((String)guid)) != null && objectId != "") {
                    logger.log(Level.INFO, "Start: Suspend(Disable) the user in Google Apps");
                    if (GappsMgmtUtil.suspendUser(domainName, loginId, objectId)) {
                        logger.log(Level.INFO, "Successfully suspended the user in Google Apps");
                        errorMsg = rb.getString("admp.mgmt.user_mgmt.disable_google_apps.statmsg_disabled_user");
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.disable_google_apps", errorMsg, "admp.mgmt.user_mgmt.disable_google_apps.statmsg_disabled_user", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg);
                    } else {
                        logger.log(Level.INFO, "Could not suspend the user in Google Apps");
                        errorMsg = rb.getString("admp.mgmt.user_mgmt.disable_google_apps.statmsg_unable_to_disable_user");
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.del_policy.disable_google_apps", errorMsg, "admp.mgmt.user_mgmt.disable_google_apps.statmsg_disabled_user", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg);
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("disable_litigation_hold")).booleanValue()) {
                    errorMsg3 = DeleteUtil.disableLitigationHold(domainName, loginId, guid, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.dis_policy.disable_litigation_hold", errorMsg3, "admp.admin.custom_settgs.dis_policy.disable_litigation_hold_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    if (!message.toString().contains(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"))) {
                        message.append(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"));
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("convert_O365_mailbox_to_shared_mailbox")).booleanValue()) {
                    errorMsg3 = DeleteUtil.convertO365MailboxToSharedMailbox(domainName, loginId, guid, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.dis_policy.convert_O365_mailbox_to_shared_mailbox", errorMsg3, "admp.admin.custom_settgs.dis_policy.convert_O365_mailbox_to_shared_mailbox_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    if (!message.toString().contains(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"))) {
                        message.append(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"));
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("remove_from_all_o365_groups")).booleanValue()) {
                    errorMsg3 = DeleteUtil.removeFromAllO365Groups(domainName, loginId, guid, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.dis_policy.remove_from_all_o365_groups", errorMsg3, "admp.admin.custom_settgs.dis_policy.remove_from_all_o365_groups_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    if (!message.toString().contains(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"))) {
                        message.append(rb.getString("admp.admin.custom_settgs.dis_policy.applied_disable_policy"));
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("revoke_O365_user_license")).booleanValue()) {
                    errorMsg3 = DeleteUtil.revokeLicense(domainName, loginId, guid, rb);
                    DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.admin.custom_settgs.dis_policy.input_revoke_o365_license", errorMsg3, "admp.admin.custom_settgs.dis_policy.revoke_o365_license_success", rb);
                    if (message.toString() != "") {
                        message.append(" ");
                    }
                    message.append(errorMsg3);
                }
                if (Boolean.valueOf((String)policyMap.get("reset_password")).booleanValue()) {
                    String password = null;
                    errorMsg = null;
                    if (Boolean.valueOf((String)policyMap.get("generate_password")).booleanValue()) {
                        PasswordPolicy pwdPolicy = new PasswordPolicy();
                        pwdPolicy.setPolicyDetails();
                        password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
                    } else if (Boolean.valueOf((String)policyMap.get("type_password")).booleanValue()) {
                        password = (String)policyMap.get("enter_password");
                    }
                    try {
                        UserHandler.updatePassword((String)domainName, (String)sid, (String)password);
                        ADHandlerForMgmt.setPassword((String)domainName, (Long)loginId, (String)sid, (String)distinguishedName, (String)password);
                        errorMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd");
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.mgmtname.reset_pwd", errorMsg, "admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg);
                    }
                    catch (LocalizedException le) {
                        errorMsg = " " + rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.error_while_changing_pwd") + le.getMessage(rb);
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.mgmtname.reset_pwd", errorMsg, "admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg);
                    }
                    catch (Exception ex) {
                        errorMsg = " " + rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.error_while_changing_pwd") + ex.getMessage();
                        DeleteUtil.fillPolicyStatus(policyStatusMap, "admp.mgmt.user_mgmt.mgmtname.reset_pwd", errorMsg, "admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd", rb);
                        if (message.toString() != "") {
                            message.append(" ");
                        }
                        message.append(errorMsg);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public static String getSourceAnchorValue(String guid, String tenantId) {
        String sourceAnchorValue = guid;
        try {
            Long waadDomainId = O365MgmtHandler.getWaadDomainId((String)tenantId);
            Properties sourceAnchorDetails = O365InfoCache.getInstance().getSourceAnchorDetails(waadDomainId);
            Properties sourceAnchorProps = (Properties)sourceAnchorDetails.get("user");
            String columnName = (String)sourceAnchorProps.get("COLUMN_NAME");
            if (!columnName.equalsIgnoreCase("OBJECT_GUID")) {
                String tableName = (String)sourceAnchorProps.get("TABLE_NAME");
                Table table = Table.getTable((String)tableName);
                Column column = new Column(tableName, "OBJECT_GUID");
                if (guid.indexOf("{") == -1) {
                    guid = "{" + guid + "}";
                }
                Criteria criteria = new Criteria(column, (Object)guid, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
                if (dataObj.isEmpty()) {
                    return null;
                }
                Row userValuesRow = dataObj.getRow(tableName);
                sourceAnchorValue = (String)userValuesRow.get(columnName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sourceAnchorValue;
    }

    public static String disableLitigationHold(String domainName, Long loginId, String guid, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            ArrayList<String> ldapattribs = new ArrayList<String>();
            ldapattribs.add("Guid");
            ldapattribs.add("DisplayName");
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString(rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error"));
            }
            Properties ident = ADHandler.getO365UserAttributeValue((String)tenantId, (String)tenantPass, (String)guid, (String)sourceAnchorValue, (String)moduleName, (String)"ObjectId");
            if (ident.getProperty("attributeValue") == null || ident.getProperty("attributeValue").isEmpty()) {
                return "";
            }
            PowerShellCommand checkCmdlet = new PowerShellCommand("Get-mailbox");
            checkCmdlet.addParameter("Identity", ident.getProperty("attributeValue"));
            String checkMessage = ADHandler.executeo365PowershellCMD((String)tenantId, (String)tenantPass, (PowerShellCommand)checkCmdlet, (String)moduleName);
            if (!checkMessage.isEmpty()) {
                if (checkMessage.equals("admp.reports.common.text.no_data_exchange_online_found")) {
                    return "\n" + rb.getString(checkMessage);
                }
                return "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.cannot_find_o365_mailbox_for_user");
            }
            PowerShellCommand cmdlet = new PowerShellCommand("Set-mailbox");
            cmdlet.addParameter("Identity", ident.getProperty("attributeValue"));
            cmdlet.addParameter("LitigationHoldEnabled", false);
            String message = ADHandler.executeo365PowershellCMD((String)tenantId, (String)tenantPass, (PowerShellCommand)cmdlet, (String)moduleName);
            errorString = message.isEmpty() ? "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.disable_litigation_hold_success") : "\n" + rb.getString(message);
        }
        return errorString;
    }

    public static String convertO365MailboxToSharedMailbox(String domainName, Long loginId, String guid, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            ArrayList<String> ldapattribs = new ArrayList<String>();
            ldapattribs.add("Guid");
            ldapattribs.add("DisplayName");
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString(rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error"));
            }
            Properties ident = ADHandler.getO365UserAttributeValue((String)tenantId, (String)tenantPass, (String)guid, (String)sourceAnchorValue, (String)moduleName, (String)"ObjectId");
            if (ident.getProperty("attributeValue") == null || ident.getProperty("attributeValue").isEmpty()) {
                return "";
            }
            PowerShellCommand checkCmdlet = new PowerShellCommand("Get-mailbox");
            checkCmdlet.addParameter("Identity", ident.getProperty("attributeValue"));
            String checkMessage = ADHandler.executeo365PowershellCMD((String)tenantId, (String)tenantPass, (PowerShellCommand)checkCmdlet, (String)moduleName);
            if (!checkMessage.isEmpty()) {
                if (checkMessage.equals("admp.reports.common.text.no_data_exchange_online_found")) {
                    return "\n" + rb.getString(checkMessage);
                }
                return "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.cannot_find_o365_mailbox_for_user");
            }
            PowerShellCommand cmdlet = new PowerShellCommand("Set-mailbox");
            cmdlet.addParameter("Identity", ident.getProperty("attributeValue"));
            cmdlet.addParameter("Type", "Shared");
            String message = ADHandler.executeo365PowershellCMD((String)tenantId, (String)tenantPass, (PowerShellCommand)cmdlet, (String)moduleName);
            errorString = message.isEmpty() ? "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.convert_O365_mailbox_to_shared_mailbox_success") : "\n" + rb.getString(message);
        }
        return errorString;
    }

    public static String removeFromAllO365Groups(String domainName, Long loginId, String guid, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            PowerShellCommand cmdlet = new PowerShellCommand("Set-mailbox");
            ArrayList<String> ldapattribs = new ArrayList<String>();
            ldapattribs.add("Guid");
            ldapattribs.add("DisplayName");
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString(rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error"));
            }
            Properties ident = ADHandler.getO365UserAttributeValue((String)tenantId, (String)tenantPass, (String)guid, (String)sourceAnchorValue, (String)moduleName, (String)"ObjectId");
            if (ident.getProperty("attributeValue") == null || ident.getProperty("attributeValue").isEmpty()) {
                return "";
            }
            cmdlet.addParameter("Identity", ident.getProperty("attributeValue"));
            cmdlet.addParameter("Type", "Shared");
            String script = "$dn=Get-User " + ident.getProperty("attributeValue") + " | select-object -ExpandProperty DistinguishedName;";
            O365InfoCache.getInstance();
            if (O365InfoCache.getInstalledModule().equalsIgnoreCase("azuread")) {
                script = script + "$dms= Get-DistributionGroup -ResultSize Unlimited -RecipientTypeDetails MailUniversalDistributionGroup,MailUniversalSecurityGroup -Filter \"Members -eq '$dn'\" | Select-object -ExpandProperty ExternalDirectoryObjectId;";
                script = script + "foreach($dm in $dms){Remove-DistributionGroupMember -Identity $dm -Member $dn -BypassSecurityGroupManagerCheck -Confirm:$false;}";
                script = script + "$ags=Get-AzureADUserMembership -All $true -objectid " + ident.getProperty("attributeValue") + "|select objectid;foreach($ag in $ags){$ag;Remove-AzureADGroupMember -objectid $ag.objectid -memberid " + ident.getProperty("attributeValue") + ";}";
            } else {
                script = script + "$dgs= Get-DistributionGroup -ResultSize Unlimited -Filter \"Members -eq '$dn'\" | Select-object -ExpandProperty ExternalDirectoryObjectId;foreach($dg in $dgs){Remove-DistributionGroupMember -Identity $dg -Member $dn -BypassSecurityGroupManagerCheck -Confirm:$false;}";
                script = script + "$ugs=Get-unifiedgroup -ResultSize Unlimited -Filter \"Members -eq '$dn'\" | Select-object -ExpandProperty ExternalDirectoryObjectId;foreach($ug in $ugs){Remove-unifiedGrouplinks -Identity $ug -links $dn -linktype members -Confirm:$false;}";
                script = script + "$sgs=get-msolgroup -All -grouptype security;foreach($sg in $sgs){$sgm=Get-MsolGroupMember -All -GroupObjectId $sg.objectid|select-object -expandproperty objectid |where-object { $_ -eq \"" + ident.getProperty("attributeValue") + "\"};if($sgm){Remove-MsolGroupMember -GroupObjectId $sg.objectid -GroupMemberObjectId $sgm;}}";
            }
            String message = ADHandler.runCustomExchOnlineScript((String)tenantId, (String)tenantPass, (String)script);
            if (message.equals("admp.reports.common.text.no_data_exchange_online_found")) {
                return "\n" + rb.getString(message);
            }
            if (message.isEmpty() || message.contains("Request_BadRequest")) {
                errorString = "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.remove_from_all_o365_groups_success");
            } else {
                try {
                    JSONObject jsonMessage = new JSONObject(message);
                    errorString = "\n" + jsonMessage.getString("Message");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return errorString;
    }

    public static String revokeLicense(String domainName, Long loginId, String guid, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            ArrayList existingLicenseList = O365MgmtHandler.getExistingLicensesForUser((String)guid);
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error") + ":" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error");
            }
            String message = ADHandler.revokeO365UserLicence((String)tenantId, (String)tenantPass, (String)guid, (String)sourceAnchorValue, (String)moduleName);
            try {
                JSONObject jsonMessage = new JSONObject(message);
                errorString = jsonMessage.getString("errorString");
                String result = jsonMessage.getString("result");
                if (errorString != null && errorString.length() > 0) {
                    O365BulkLicenseMgmtListener listener = new O365BulkLicenseMgmtListener();
                    errorString = listener.getResultString(errorString);
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_error") + ":" + rb.getString(errorString);
                } else if (result != null && result.length() > 0) {
                    O365InfoCache.getInstance().updateLicenseConsumptionData(existingLicenseList, "remove");
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.dis_policy.revoke_o365_license_success");
                    logger.log(Level.INFO, "Removed all licenses associated with the Office365 user account :: " + result);
                    try {
                        DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        String hostId = "";
                        Integer reportId = 8052;
                        Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)result, (String)domainName, (DataObject)auditDataObj);
                        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                        audit_info.put("object_id", object_id);
                        audit_info.put("error_msg", rb.getString("admp.mgmt.user_mgmt.modify_single_user.status_msg.success"));
                        ArrayList<Properties> propsList = new ArrayList<Properties>();
                        Properties probs = new Properties();
                        probs.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_revoke_all"));
                        probs.put("ATTRIB_VALUE", rb.getString("admp.admin.custom_settgs.dis_policy.revoke_o365_license.removed_licenses"));
                        propsList.add(probs);
                        HDTAuditUtil.fillAuditObjectProperties((Long)object_id, propsList, (DataObject)auditDataObj);
                        HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return errorString;
    }

    private static String disableMailBox(String mailServer, String guid, String distinguishedName, String domainName, Long loginId, Boolean usePowershell, AdventNetResourceBundle rb) {
        String message = "";
        try {
            if (mailServer != null && usePowershell.booleanValue()) {
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                message = ADHandler.disableMailBox((String)domainName, (long)loginId, (String)guid, (Properties)exchangeServerDetails, (String)distinguishedName);
                message = !message.equals("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_disabled_mailbox") ? MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_to_disable_mailbox"), rb.getString(message)) : rb.getString(message);
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_to_disable_mailbox"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_to_disable_mailbox"), new String(exception.getMessage()));
        }
        return message;
    }

    public static String disableLync(String guid, String serverName, String domainName, Long loginId, AdventNetResourceBundle rb) {
        String message = "";
        try {
            message = ADHandlerForMgmt.modifyLyncUser((String)guid, (String)serverName, (String)"", (String)domainName, (Long)loginId, (String)"", (String)"Disable", (String)"");
            if (message.equals("")) {
                message = rb.getString("admp.admin.custom_settgs.del_policy.disable_lync_user_success");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user"), new String(exception.getMessage()));
        }
        return message;
    }

    public static String removeDirectReports(String distinguishedName, String domainName, Long loginId, AdventNetResourceBundle rb) {
        String message = "";
        long val = 0L;
        try {
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "manager");
            p.put("DW_CONTROL_CODE", new Long(1L));
            p.put("DATA_HANDLER_TYPE", new Long(3L));
            p.put("ATTRIB_VALUE", "");
            setAttributeList.add(p);
            String searchString = "(&(objectCategory=person)(|(objectClass=user)(objectClass=contact))(manager=" + distinguishedName + "))";
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("objectGUID");
            attributeList.add("distinguishedName");
            ArrayList usersList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, (String)searchString);
            for (int index = 0; index < usersList.size(); ++index) {
                Properties props = (Properties)usersList.get(index);
                if (props == null) continue;
                ArrayList guidList = (ArrayList)props.get("objectGUID");
                ArrayList dnList = (ArrayList)props.get("distinguishedName");
                for (int i = 0; i < guidList.size(); ++i) {
                    String guid = (String)guidList.get(i);
                    String dn = (String)dnList.get(i);
                    val = ADHandler.modifyContact((String)domainName, (Long)loginId, (String)guid, (String)dn, setAttributeList, new ArrayList(), null);
                }
                if (val != 0L) continue;
                message = rb.getString("admp.admin.custom_settgs.del_policy.remove_direct_reports_success");
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("client.usermanagement.ModifyOrganizationAttributeListener.unable_to_modify_the_user"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("client.usermanagement.ModifyOrganizationAttributeListener.unable_to_modify_the_user"), new String(exception.getMessage()));
        }
        return message;
    }

    private static String removeEUMAddress(ArrayList eumProxy, String sid, String dn, int count, String domainName, Long loginId, AdventNetResourceBundle rb) {
        String message = "";
        try {
            long val = 0L;
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE_COUNT", new Long(count));
            p.put("ATTRIB_LDAP_NAME", "proxyAddresses");
            p.put("DW_CONTROL_CODE", new Long(4L));
            p.put("DATA_HANDLER_TYPE", new Long(1L));
            if (count == 1) {
                p.put("ATTRIB_VALUE", eumProxy.get(0));
            } else {
                p.put("ATTRIB_VALUE", eumProxy);
            }
            setAttributeList.add(p);
            val = ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), new ArrayList(), null);
            if (val == 0L) {
                message = rb.getString("admp.admin.custom_settgs.del_policy.remove_eum_address_success");
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.unable_to_remove_eum_address"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.unable_to_remove_eum_address"), new String(exception.getMessage()));
        }
        return message;
    }

    private static String hideFromAddressLists(String mailServer, String guid, String distinguishedName, String sid, String versionNumber, String exchRecipientType, String domainName, Long loginId, Boolean usePowershell, AdventNetResourceBundle rb) {
        String message = rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.successfully_hidden_from_address_lists");
        try {
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "msExchHideFromAddressLists");
            p.put("DATA_HANDLER_TYPE", new Long(6L));
            p.put("ATTRIB_VALUE", "TRUE");
            setAttributeList.add(p);
            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)distinguishedName, setAttributeList, new ArrayList(), new ArrayList(), null);
            if (mailServer != null && usePowershell.booleanValue()) {
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)distinguishedName, (String)"mailBox", (String)"true", (Properties)exchangeServerDetails);
            } else if (versionNumber != null && !versionNumber.equals("")) {
                String exchVersion = ExchangeUtil.getExchangeVersion((Long)Long.parseLong(versionNumber));
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetails((String)domainName, (String)exchVersion);
                if (exchRecipientType.equalsIgnoreCase("2147483648")) {
                    ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)distinguishedName, (String)"remoteMailbox", (String)"true", (Properties)exchangeServerDetails);
                } else {
                    ADHandler.setExchangeAttribute((String)domainName, (long)loginId, (String)distinguishedName, (String)"mail", (String)"true", (Properties)exchangeServerDetails);
                }
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.unable_to_hide_from_address_lists"), new String(localeException.getMessage(rb)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.exch_naming_attribs.statmsg.unable_to_hide_from_address_lists"), new String(exception.getMessage()));
        }
        return message;
    }

    private static String moveUser(String domainName, Long loginId, AdventNetResourceBundle rb, String distinguishedName, String moveTo) {
        String message = rb.getString("admp.mgmt.user_mgmt.move_user.statmsg.successfully_moved_the_user");
        try {
            ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)distinguishedName, (String)moveTo);
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_user.statmsg.unable_to_move_user_error"), new String(localeException.getMessage(rb)));
            return message;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_user.statmsg.unable_to_move_user_error"), new String(exception.getMessage()));
            return message;
        }
        return message;
    }

    private static String getMailServer(String domainName, String homeMDB) {
        String mailServer = "";
        try {
            ArrayList serverList = ExchangeHandler.getExchangeServers((String)domainName);
            if (serverList.size() > 0) {
                ArrayList serverNameValues = (ArrayList)serverList.get(1);
                for (int i = 0; i < serverNameValues.size(); ++i) {
                    mailServer = (String)serverNameValues.get(i);
                    ArrayList mailBoxStores = ExchangeHandler.getMailBoxStores((String)domainName, (String)mailServer);
                    ArrayList mailBoxStoresNames = (ArrayList)mailBoxStores.get(1);
                    for (int j = 0; j < mailBoxStoresNames.size(); ++j) {
                        if (!homeMDB.equals(mailBoxStoresNames.get(j))) continue;
                        return mailServer;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mailServer;
    }

    private static String removeFromAllGroups(String distinguishedName, String sid, String primaryGroup, String domainName, Long loginId, AdventNetResourceBundle rb) {
        String message = "";
        try {
            String escapedDN = CommonUtil.escapeSpecialCharacters((String)distinguishedName);
            String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + escapedDN + "))";
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList<String> groupAttributeList = new ArrayList<String>();
            groupAttributeList.add("cn");
            groupAttributeList.add("distinguishedName");
            groupAttributeList.add("objectSid");
            ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
            ArrayList removeFromGroupSidList = new ArrayList();
            ArrayList removeFromGroupNameList = new ArrayList();
            for (int index = 0; index < grouplistProps.size(); ++index) {
                Properties props = (Properties)grouplistProps.get(index);
                if (props == null) continue;
                ArrayList groupObjectSid = (ArrayList)props.get("objectSid");
                removeFromGroupSidList.add(groupObjectSid.get(0));
                ArrayList groupObjectName = (ArrayList)props.get("cn");
                removeFromGroupNameList.add(groupObjectName.get(0));
            }
            logger.log(Level.INFO, "Removing user from groups : " + removeFromGroupNameList);
            if (removeFromGroupSidList != null && !removeFromGroupSidList.isEmpty()) {
                int removeFailCount = 0;
                StringBuffer errorMsg = new StringBuffer();
                ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
                ArrayList<Properties> list = new ArrayList<Properties>();
                Properties p = new Properties();
                p.put("ATTRIB_VALUE", distinguishedName);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_LDAP_NAME", "member");
                p.put("DW_CONTROL_CODE", new Long(4L));
                list.add(p);
                for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                    try {
                        ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)((String)removeFromGroupSidList.get(index)), (String)distinguishedName, list, null, (boolean)true);
                        continue;
                    }
                    catch (LocalizedException le) {
                        DeleteUtil.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                        ++removeFailCount;
                        continue;
                    }
                    catch (Exception ex) {
                        errorMsg.append(ex.getMessage());
                        ++removeFailCount;
                    }
                }
                message = GroupErrorHandler.handleModifyGroupError(handleErrorList, removeFromGroupSidList.size(), rb, removeFromGroupNameList, primaryGroup, "remove", removeFailCount);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return message;
    }

    private static void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }

    public static String runCustomScript(String command, Hashtable resultHash, String domainName, AdventNetResourceBundle rb) {
        String scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
        String message = "";
        try {
            CustomScript customScript;
            if (command != null && !command.equals("")) {
                command = FormatClientUtil.getFormatValueForCustomScript(command, resultHash, domainName, "");
            }
            Long timeOut = 5L;
            if (command != null && !command.equals("") && (scriptResult = (customScript = new CustomScript(rb, timeOut, command)).runThread()).indexOf("Microsoft (R)") != -1) {
                int k = scriptResult.indexOf("Microsoft (R)");
                scriptResult = scriptResult.substring(0, k);
            }
        }
        catch (Exception e) {
            scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_script_execution");
            e.printStackTrace();
        }
        if (scriptResult.length() == 0) {
            scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
        }
        message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.custom_script_result"), scriptResult);
        return message;
    }

    public static String resetO365UserPwd(String domainName, Long loginId, String guid, String newPassword, Boolean mustChangePwd, int pwdNeverExpires, AdventNetResourceBundle rb) {
        String errorString = new String();
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)domainName, (Long)loginId);
        if (o365ConfigProp != null) {
            String tenantId = o365ConfigProp.getProperty("username");
            String tenantPass = o365ConfigProp.getProperty("password");
            String moduleName = o365ConfigProp.getProperty("moduleName");
            String sourceAnchorValue = DeleteUtil.getSourceAnchorValue(guid, tenantId);
            if (sourceAnchorValue == null) {
                return "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error") + ":" + rb.getString("admp.admin.custom_settgs.del_policy.o365_dirsync_error");
            }
            String message = ADHandler.resetO365UserPassword((String)tenantId, (String)tenantPass, (String)guid, (String)newPassword, (Boolean)mustChangePwd, (int)pwdNeverExpires, (String)sourceAnchorValue, (String)moduleName);
            try {
                JSONObject jsonMessage = new JSONObject(message);
                errorString = jsonMessage.getString("errorString");
                String result = jsonMessage.getString("result");
                if (errorString != null && errorString.length() > 0) {
                    O365BulkLicenseMgmtListener listener = new O365BulkLicenseMgmtListener();
                    errorString = listener.getResultString(errorString);
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.del_policy.o365_error") + ":" + rb.getString(errorString);
                } else if (result != null && result.length() > 0) {
                    errorString = "\n" + rb.getString("admp.admin.custom_settgs.del_policy.reset_o365_pwd_success");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return errorString;
    }

    private static void fillPolicyStatus(HashMap policyStatusMap, String key, String message, String successMsg, AdventNetResourceBundle rb) {
        if (message.contains(rb.getString(successMsg)) || message.contains(successMsg)) {
            policyStatusMap.put(rb.getString(key), rb.getString("admp.common.text.success"));
        } else if (!message.equals("")) {
            policyStatusMap.put(rb.getString(key), rb.getString(message));
        }
    }

    public static void clearADTSAttribute(String domainName, Long loginId, String samAccountName, String dn, ArrayList attributeList, boolean isDeleteTSHomeFolder, boolean isDeleteTSProfile, ModifyUserListener listener, StringBuffer message, AdventNetResourceBundle rb) {
        try {
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties profileAttrib = new Properties();
            if (isDeleteTSHomeFolder) {
                profileAttrib.put("ATTRIB_LDAP_NAME", "tsHomeDir");
            } else if (isDeleteTSProfile) {
                profileAttrib.put("ATTRIB_LDAP_NAME", "tsProfilePath");
            }
            profileAttrib.put("ATTRIB_VALUE", "");
            setAttributeList.add(profileAttrib);
            logger.log(Level.INFO, "deleteHomeFolder starts clearing the TS AD attribute: " + setAttributeList);
            ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)samAccountName, setAttributeList, null, (String)dn);
            if (isDeleteTSHomeFolder) {
                message.append(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.success_clear_attrib_ts_homefolder"));
            }
            if (isDeleteTSProfile) {
                message.append(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.success_clear_attrib_ts_profile"));
            }
        }
        catch (LocalizedException le) {
            if (isDeleteTSHomeFolder) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_clear_attrib_ts_homefolder"), le.getMessage(rb)));
            }
            if (isDeleteTSProfile) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_clear_attrib_ts_profile"), le.getMessage(rb)));
            }
            le.printStackTrace();
        }
        catch (Exception e) {
            if (isDeleteTSHomeFolder) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_clear_attrib_ts_homefolder"), e.getMessage()));
            }
            if (isDeleteTSProfile) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_clear_attrib_ts_profile"), e.getMessage()));
            }
            e.printStackTrace();
        }
    }

    public static void clearADAttribute(String domainName, Long loginId, String sid, String dn, ArrayList attributeList, boolean isDeleteHomeFolder, boolean isDeleteProfile, ModifyUserListener listener, StringBuffer message, AdventNetResourceBundle rb) {
        try {
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties profileAttrib = new Properties();
            if (isDeleteHomeFolder) {
                profileAttrib.put("ATTRIB_LDAP_NAME", "homeDirectory");
            } else if (isDeleteProfile) {
                profileAttrib.put("ATTRIB_LDAP_NAME", "profilePath");
            }
            profileAttrib.put("ATTRIB_VALUE", "");
            profileAttrib.put("ATTRIB_VALUE_COUNT", new Long(1L));
            profileAttrib.put("DATA_HANDLER_TYPE", new Long(3L));
            profileAttrib.put("DW_CONTROL_CODE", new Long(1L));
            setAttributeList.add(profileAttrib);
            if (isDeleteHomeFolder) {
                Properties driveAttrib = new Properties();
                driveAttrib.put("ATTRIB_LDAP_NAME", "homeDrive");
                driveAttrib.put("ATTRIB_VALUE", "");
                driveAttrib.put("ATTRIB_VALUE_COUNT", new Long(1L));
                driveAttrib.put("DATA_HANDLER_TYPE", new Long(3L));
                driveAttrib.put("DW_CONTROL_CODE", new Long(1L));
                setAttributeList.add(driveAttrib);
            }
            logger.log(Level.INFO, "deleteHomeFolder starts clearing the AD attribute: " + setAttributeList);
            if (listener == null) {
                String searchString = "(&(objectClass=user)(objectCategory=user)(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)dn) + "))";
                ADHandler.searchAndModifyUser((String)domainName, (Long)loginId, (String)DomainUtil.getDefaultNamingContext((String)domainName), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)dn), null, setAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
            } else {
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
            }
            if (isDeleteHomeFolder) {
                message.append(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.success_clear_attrib_homefolder"));
            }
            if (isDeleteProfile) {
                message.append(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.success_clear_attrib_profile"));
            }
        }
        catch (LocalizedException le) {
            if (isDeleteHomeFolder) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_clear_attrib_homefolder"), le.getMessage(rb)));
            }
            if (isDeleteProfile) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_clear_attrib_profile"), le.getMessage(rb)));
            }
            le.printStackTrace();
        }
        catch (Exception e) {
            if (isDeleteHomeFolder) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_clear_attrib_homefolder"), e.getMessage()));
            }
            if (isDeleteProfile) {
                message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_clear_attrib_profile"), e.getMessage()));
            }
            e.printStackTrace();
        }
    }

    private static String exportMailbox(String mailServer, String domainName, String homeMDB, Long loginId, String guid, String distinguishedName, Properties exportProps, Boolean usePowerShell, AdventNetResourceBundle rb, Boolean isDisablePolicy) {
        String message = "";
        try {
            if (mailServer != null && usePowerShell.booleanValue()) {
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                exchangeServerDetails.put("homeMDB", homeMDB);
                message = ADHandler.exportMailbox((String)domainName, (long)loginId, (String)guid, (String)distinguishedName, (Properties)exchangeServerDetails, (Properties)exportProps, (Boolean)isDisablePolicy);
            }
        }
        catch (LocalizedException localeException) {
            localeException.printStackTrace();
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), new String(localeException.getMessage(rb)));
        }
        catch (Exception e) {
            message = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), new String(e.getMessage()));
            e.printStackTrace();
        }
        return message;
    }
}

