/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPAuthUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportInputsAPI;
import com.adventnet.sym.adsm.common.server.reports.filter.ColumnFilter;
import com.adventnet.sym.adsm.common.server.util.AdvancedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerInputsHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SchedulerBean;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchedulerInputsUtil {
    public static String setOUSForScheduler(SchedulerBean bean, String sch_id) {
        System.out.println("sch_id : " + sch_id);
        String[] domainNames = (String[])bean.get("domainNames");
        ArrayList SchedulerDetails = new ArrayList();
        if (!sch_id.equalsIgnoreCase("null")) {
            SchedulerDetails = SchedulerUtil.getSchedulerDetails((Long)Long.parseLong(sch_id));
        } else {
            SchedulerDetails = SchedulerUtil.getSchedulerDetails(null);
            for (int k = 0; k < SchedulerDetails.size(); ++k) {
                Hashtable schedulers = (Hashtable)SchedulerDetails.get(k);
                schedulers.put("DESCRIPTION", (String)bean.get("DESCRITION"));
                schedulers.put("SCHEDULE_ID", "null");
                schedulers.put("SCHEDULER_NAME", (String)bean.get("SCHEDULER_NAME"));
                ArrayList<String> mails = new ArrayList<String>();
                mails.add((String)bean.get("NOTIFICATION_MAIL_ID"));
                schedulers.put("NOTIFICATION_EMAIL_ADDRESS", mails);
                schedulers.put("FILE_SERVER_PATH", (String)bean.get("FILE_SERVER_PATH"));
                schedulers.put("OVERWRITE_FILES", (Boolean)bean.get("OVERWRITE_FILES"));
                schedulers.put("DISABLE_MAIL_NOTIFICATION", (Boolean)bean.get("DISABLE_MAIL_NOTIFICATION"));
                schedulers.put("STATUS", "admp.reports.schedule_reports.scheduler_creation.save");
            }
        }
        bean.set("domains", domainNames);
        bean.set("SchedulerDetails", SchedulerDetails);
        return "CreateScheduler";
    }

    public static void addSchedulerDetails(SchedulerBean bean, HttpServletRequest request, Long loginId, boolean update) {
        HttpSession session = request.getSession();
        String sch_id = (String)bean.get("scheduleId");
        String mail_ids = (String)bean.get("NOTIFICATION_MAIL_ID");
        String[] domainName = (String[])bean.get("domainNames");
        Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
        Hashtable excludedOUListMap = (Hashtable)bean.get("excludedOUList");
        Hashtable exclChildOUListMap = (Hashtable)bean.get("domainVsExcludeChildOU");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domains = authObject.getDomainAndOUs();
        Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
        try {
            if (update) {
                Criteria deleteCriteria = new Criteria(Column.getColumn((String)"ADSMSchedulersExclChildMapping", (String)"SCHEDULE_ID"), (Object)sch_id, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria);
                deleteCriteria = new Criteria(Column.getColumn((String)"ADSMSchedulersExcludeOUMapping", (String)"SCHEDULE_ID"), (Object)sch_id, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria);
                deleteCriteria = new Criteria(Column.getColumn((String)"ADSMSchedulersOUMapping", (String)"SCHEDULE_ID"), (Object)sch_id, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria);
            }
            for (int i = 0; i < domainName.length; ++i) {
                ArrayList selectedOUList = (ArrayList)domainOUList.get(domainName[i]);
                domainName[i] = DomainUtil.getDomainName((String)domainName[i]);
                ArrayList excludedOUList = (ArrayList)excludedOUListMap.get(domainName[i]);
                Boolean exclChildOU = (Boolean)exclChildOUListMap.get(domainName[i]);
                if (selectedOUList == null) continue;
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Hashtable<String, Boolean> exclChildOUMap = new Hashtable<String, Boolean>();
                exclChildOUMap.put(domainName[i], exclChildOU);
                SchedulerInputsUtil.addExcludeChildOUListInScheduler(exclChildOUMap, Long.valueOf(sch_id), dataObj, false);
                Hashtable<String, ArrayList> excludedOUMap = new Hashtable<String, ArrayList>();
                excludedOUMap.put(domainName[i], excludedOUList);
                SchedulerInputsUtil.addExcludedOUListInScheduler(excludedOUMap, Long.valueOf(sch_id), dataObj, false);
                Hashtable<String, ArrayList> selectedOUMap = new Hashtable<String, ArrayList>();
                selectedOUMap.put(domainName[i], selectedOUList);
                SchedulerInputsUtil.addOUListInScheduler(selectedOUMap, Long.valueOf(sch_id), dataObj, false);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean isCustom = false;
        if (((String)bean.get("repSchedule")).equalsIgnoreCase("Custom")) {
            isCustom = true;
        }
        try {
            Hashtable<String, Object> schedulerValues = new Hashtable<String, Object>();
            schedulerValues.put("SCHEDULER_NAME", bean.get("SCHEDULER_NAME"));
            schedulerValues.put("DESCRIPTION", bean.get("DESCRITION"));
            schedulerValues.put("TIME", bean.get("time"));
            schedulerValues.put("MAILING_FORMAT", bean.get("formats"));
            schedulerValues.put("FILE_SERVER_PATH", bean.get("FILE_SERVER_PATH"));
            schedulerValues.put("ATTACHMENT_TYPE", bean.get("mailType"));
            schedulerValues.put("MAIL_SUBJECT", bean.get("MAIL_SUBJECT"));
            schedulerValues.put("MAIL_CONTENT", bean.get("MAIL_CONTENT"));
            schedulerValues.put("OVERWRITE_FILES", bean.get("OVERWRITE_FILES"));
            schedulerValues.put("DISABLE_MAIL_NOTIFICATION", bean.get("DISABLE_MAIL_NOTIFICATION"));
            schedulerValues.put("CUSTOM_SCHEDULER", isCustom);
            if (update) {
                Row row1;
                Criteria criteria = new Criteria(new Column("ADSMScheduler", "SCHEDULE_ID"), (Object)sch_id, 0);
                DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMScheduler", criteria);
                if (!dob.isEmpty() && !TechnicianHandler.isLoginIdAvailable((Long)(loginId = (Long)(row1 = dob.getFirstRow("ADSMScheduler")).get("LOGIN_ID")))) {
                    loginId = ADMPAuthUtil.ADMIN_LOGIN_ID;
                }
            }
            schedulerValues.put("LOGIN_ID", loginId);
            SchedulerInputsHandler.addSchedulerInputDetails((String)sch_id, schedulerValues, (boolean)update);
            JSONObject reportsObj = new JSONObject(request.getParameter("selected_reports_detail"));
            JSONArray reports = reportsObj.getJSONArray("selectedReports");
            ArrayList<ReportFilterConfig> selectedReportsDetail = new ArrayList<ReportFilterConfig>();
            for (int i = 0; i < reports.length(); ++i) {
                JSONObject report = reports.getJSONObject(i);
                ReportFilterConfig rfConfig = new ReportFilterConfig(report.toString());
                rfConfig.init();
                selectedReportsDetail.add(rfConfig);
            }
            SchedulerInputsHandler.addSelectedReportDetails((Long)Long.valueOf(sch_id), selectedReportsDetail);
            SchedulerInputsHandler.addIDs((String)mail_ids, (Long)Long.valueOf(sch_id));
            SchedulerInputsHandler.setSchedulerDomains((String[])domainName, (Long)Long.valueOf(sch_id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getTimeString(String repeatType, int interval, String startingDate, int hours, int minutes, String selectedDays, String monthdaydate, Integer monthsel2, Integer weekofmonth, Integer weeklysel2, String selectedMonths, AdventNetResourceBundle rb) {
        JSONObject time = new JSONObject();
        JSONArray timeArray = new JSONArray();
        try {
            if (repeatType.equalsIgnoreCase("repnone")) {
                timeArray.put((Object)startingDate);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_none", (Object)timeArray);
            } else if (repeatType.equalsIgnoreCase("repdays")) {
                timeArray.put(interval);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_days", (Object)timeArray);
            } else if (repeatType.equalsIgnoreCase("repweeks")) {
                String[] days = new String[]{"admp.common.days.text.sun", "admp.common.days.text.mon", "admp.common.days.text.tue", "admp.common.days.text.wed", "admp.common.days.text.thu", "admp.common.days.text.fri", "admp.common.days.text.sat"};
                String msgString = "";
                String[] splitStr = selectedDays.split(",");
                if (splitStr.length == 7) {
                    msgString = "admp.reports.sched_reports.sch_view.info.all_days";
                    timeArray.put((Object)msgString);
                } else {
                    JSONArray daysArr = new JSONArray();
                    for (int i = 0; i < splitStr.length; ++i) {
                        int pos = Integer.parseInt(splitStr[i]);
                        daysArr.put((Object)days[pos - 1]);
                    }
                    timeArray.put((Object)daysArr);
                }
                timeArray.put(interval);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_weeks", (Object)timeArray);
            } else if (repeatType.equalsIgnoreCase("repmonths")) {
                JSONObject type = new JSONObject();
                if (monthdaydate.equalsIgnoreCase("date")) {
                    type.put("admp.reports.sched_reports.sch_view.info.day", (Object)monthsel2);
                } else {
                    String[] weekString = new String[]{"admp.reports.sched_reports.sch_view.info.first_week", "admp.reports.sched_reports.sch_view.info.second_week", "admp.reports.sched_reports.sch_view.info.third_week", "admp.reports.sched_reports.sch_view.info.fourth_week", "admp.reports.sched_reports.sch_view.info.last_week"};
                    String[] day = new String[]{"admp.common.days.text.sun", "admp.common.days.text.mon", "admp.common.days.text.tue", "admp.common.days.text.wed", "admp.common.days.text.thu", "admp.common.days.text.fri", "admp.common.days.text.sat"};
                    type.put(weekString[weekofmonth - 1], (Object)day[weeklysel2 - 1]);
                }
                timeArray.put((Object)type);
                timeArray.put(interval);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_months", (Object)timeArray);
            } else if (repeatType.equalsIgnoreCase("repyears")) {
                JSONObject type = new JSONObject();
                if (monthdaydate.equalsIgnoreCase("date")) {
                    type.put("admp.reports.sched_reports.sch_view.info.day", (Object)monthsel2);
                } else {
                    String[] weekString = new String[]{"admp.reports.sched_reports.sch_view.info.first_week", "admp.reports.sched_reports.sch_view.info.second_week", "admp.reports.sched_reports.sch_view.info.third_week", "admp.reports.sched_reports.sch_view.info.fourth_week", "admp.reports.sched_reports.sch_view.info.last_week"};
                    String[] day = new String[]{"admp.common.days.text.sun", "admp.common.days.text.mon", "admp.common.days.text.tue", "admp.common.days.text.wed", "admp.common.days.text.thu", "admp.common.days.text.fri", "admp.common.days.text.sat"};
                    type.put(weekString[weekofmonth - 1], (Object)day[weeklysel2 - 1]);
                }
                timeArray.put((Object)type);
                String[] months = new String[]{"admp.common.months.text.jan", "admp.common.months.text.feb", "admp.common.months.text.mar", "admp.common.months.text.apr", "admp.common.months.text.may", "admp.common.months.text.jun", "admp.common.months.text.jul", "admp.common.months.text.aug", "admp.common.months.text.sep", "admp.common.months.text.oct", "admp.common.months.text.nov", "admp.common.months.text.dec"};
                String msgString = "";
                String[] splitStr = selectedMonths.split(",");
                if (splitStr.length == 12) {
                    msgString = "admp.reports.sched_reports.sch_view.info.all_months";
                    timeArray.put((Object)msgString);
                } else {
                    JSONArray monthArr = new JSONArray();
                    for (int i = 0; i < splitStr.length; ++i) {
                        int pos = Integer.parseInt(splitStr[i]);
                        monthArr.put((Object)months[pos - 1]);
                    }
                    timeArray.put((Object)monthArr);
                }
                timeArray.put(interval);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_years", (Object)timeArray);
            } else if (repeatType.equalsIgnoreCase("repminutes")) {
                timeArray.put(interval);
                timeArray.put((Object)startingDate);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("admp.reports.sched_reports.sch_view.info.repeat_type_minutes", (Object)timeArray);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static String getTimeStringFromJson(String timeJson, AdventNetResourceBundle rb) {
        String time = null;
        try {
            JSONObject timeObj = new JSONObject(timeJson);
            Iterator keys = timeObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray array = (JSONArray)timeObj.get(key);
                Object[] value = new Object[array.length()];
                for (int i = 0; i < array.length(); ++i) {
                    Object object = array.get(i);
                    String str = new String();
                    if (object instanceof JSONObject) {
                        JSONObject jsonObj = new JSONObject(array.get(i).toString());
                        Iterator jsonObjKeys = jsonObj.keys();
                        while (jsonObjKeys.hasNext()) {
                            String jsonObjKey = (String)jsonObjKeys.next();
                            str = str + rb.getString(jsonObjKey);
                            str = str + " " + rb.getString(jsonObj.get(jsonObjKey).toString());
                        }
                    } else if (object instanceof JSONArray) {
                        JSONArray jsonArray = new JSONArray(array.get(i).toString());
                        Object[] strArray = new String[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            strArray[j] = rb.getString(jsonArray.get(j).toString());
                        }
                        str = Arrays.toString(strArray);
                    } else {
                        str = rb.getString(array.get(i).toString());
                    }
                    value[i] = str;
                }
                time = MessageFormat.format(rb.getString(key), value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static void addNotificationIDs(String IDS, Long admpScheduleId) {
        try {
            String ids = IDS;
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer token = new StringTokenizer(ids, ",");
            while (token.hasMoreElements()) {
                String s = (String)token.nextElement();
                v.add(s);
            }
            Column col = Column.getColumn((String)"AdvancedSchedulerNotifyIds", (String)"ADMP_SCHEDULE_ID");
            Criteria crit = new Criteria(col, (Object)admpScheduleId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AdvancedSchedulerNotifyIds", crit);
            if (!dataObj.isEmpty()) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
            }
            for (int i = 0; i < v.size(); ++i) {
                String id = (String)v.get(i);
                Row row = new Row("AdvancedSchedulerNotifyIds");
                row.set("ADMP_SCHEDULE_ID", (Object)admpScheduleId);
                row.set("MAIL_ID", (Object)id);
                dataObj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getSchedulers(Long loginId, String tableName) {
        ArrayList<Properties> schedulerList = new ArrayList<Properties>();
        try {
            Column col = new Column(tableName, "LOGIN_ID");
            Criteria criteria = null;
            if (loginId == 1L) {
                criteria = new Criteria(col, null, 1);
            } else {
                criteria = new Criteria(col, (Object)loginId, 0);
                ArrayList sharedSheduleList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                Long[] sharedSheduleArray = new Long[sharedSheduleList.size()];
                sharedSheduleArray = sharedSheduleList.toArray(sharedSheduleArray);
                criteria = criteria.or(new Criteria(Column.getColumn((String)tableName, (String)"SCHEDULE_ID"), (Object)sharedSheduleArray, 8));
            }
            ArrayList domains = null;
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows(tableName);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Properties prop = new Properties();
                    prop.put("SCHEDULE_ID", row.get("SCHEDULE_ID"));
                    prop.put("NOTIFICATION_EMAIL_ADDRESS", MailServerUtil.getMailIds((Long)((Long)row.get("SCHEDULE_ID"))));
                    if (tableName.equalsIgnoreCase("ADSMScheduler")) {
                        domains = SchedulerUtil.getSchedulerDomains((Long)((Long)row.get("SCHEDULE_ID")));
                        if (domains != null) {
                            prop.put("DOMAIN_NAME", domains);
                        }
                    } else if (tableName.equalsIgnoreCase("ADSMAdvancedScheduler")) {
                        domains = new ArrayList();
                        domains = CVCDataUtil.getCVCSelectedDomain((Long)((Long)row.get("CVC_DATA_ID")));
                        System.out.println("CVC DAtai id " + row.get("CVC_DATA_ID") + " for domain name is " + domains);
                        prop.put("DOMAIN_NAME", domains);
                        prop.put("NOTIFICATION_EMAIL_ADDRESS", AdvancedSchedulerUtil.getAdvancedSchedulerMailIds((Long)((Long)row.get("ADMP_SCHEDULE_ID"))));
                    }
                    prop.put("DESCRIPTION", row.get("DESCRIPTION"));
                    prop.put("SCHEDULER_NAME", row.get("SCHEDULER_NAME"));
                    prop.put("TIME", row.get("TIME").toString());
                    prop.put("Status", SchedulerUtil.getStatus((String)row.get("SCHEDULER_NAME").toString()));
                    schedulerList.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schedulerList;
    }

    public static void addSchedulerDetails(Long scheduleId, Long loginId, HttpServletRequest request, boolean isUpdate) throws Exception {
        UniqueValueHolder admpScheduleUniqueId = null;
        Long admpScheduleId = null;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject cvcDataJsonObject = new JSONObject(request.getParameter("CVCData"));
            JSONObject notifyDataJsonObject = new JSONObject(request.getParameter("NotificationData"));
            JSONObject timeFreqDataJsonObject = new JSONObject(request.getParameter("TimeFrequencyData"));
            JSONObject schedulerDataJsonObject = new JSONObject(request.getParameter("schedulerData"));
            if (isUpdate) {
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAdvancedScheduler", new Criteria(Column.getColumn((String)"ADSMAdvancedScheduler", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                Row row = dataObj.getRow("ADSMAdvancedScheduler");
                Long cvcDataId = (Long)row.get("CVC_DATA_ID");
                Criteria deleteCriteria = new Criteria(Column.getColumn((String)"CVConfigurationData", (String)"CVC_DATA_ID"), (Object)cvcDataId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria);
                System.out.println("We need to detail the cvcdataid related entries " + cvcDataId);
            }
            DataObject cvcDataDO = CVCDataUtil.saveCVCData((JSONObject)cvcDataJsonObject);
            Row cvcDataRow = cvcDataDO.getFirstRow("CVConfigurationData");
            Long dataModelId = (Long)cvcDataRow.get("CVC_DATA_ID");
            System.out.println("cvcdatamodel id " + dataModelId);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row = new Row("ADSMAdvancedScheduler");
            row.set("LOGIN_ID", (Object)loginId);
            if (isUpdate) {
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMAdvancedScheduler", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAdvancedScheduler", criteria);
                if (!dob.isEmpty()) {
                    row = dob.getFirstRow("ADSMAdvancedScheduler");
                    loginId = (Long)row.get("LOGIN_ID");
                    row.set("LOGIN_ID", (Object)loginId);
                    admpScheduleId = (Long)row.get("ADMP_SCHEDULE_ID");
                }
            }
            row.set("SCHEDULE_ID", (Object)scheduleId);
            row.set("CVC_DATA_ID", (Object)dataModelId);
            row.set("SCHEDULER_NAME", (Object)schedulerDataJsonObject.getString("schedulerName"));
            row.set("DESCRIPTION", (Object)schedulerDataJsonObject.getString("description"));
            row.set("TIME", (Object)SchedulerInputsUtil.getTimeFreqString(timeFreqDataJsonObject, rb));
            row.set("REPORT_ID", (Object)schedulerDataJsonObject.getInt("reportId"));
            row.set("MAILING_FORMAT", (Object)schedulerDataJsonObject.getString("mailingFormat"));
            row.set("FILE_SERVER_PATH", (Object)schedulerDataJsonObject.getString("storagePath"));
            row.set("ATTACHMENT_TYPE", (Object)notifyDataJsonObject.getString("attachmentType"));
            row.set("IS_ATTACHMENT", (Object)notifyDataJsonObject.getBoolean("isEnableAttachment"));
            row.set("IS_SEND_LINK", (Object)notifyDataJsonObject.getBoolean("isSendLink"));
            row.set("MAIL_SUBJECT", (Object)notifyDataJsonObject.getString("subject"));
            row.set("MAIL_CONTENT", (Object)notifyDataJsonObject.getString("mailContent"));
            row.set("OVERWRITE_FILES", (Object)schedulerDataJsonObject.getBoolean("isOverwrite"));
            row.set("CUSTOM_SCHEDULER", (Object)schedulerDataJsonObject.getBoolean("isCustom"));
            row.set("CREATED_TIME", (Object)new Timestamp(System.currentTimeMillis()));
            System.out.println("ADSMSAdvancedScheduler row " + row + " admpscheduler id " + admpScheduleId);
            if (isUpdate) {
                dob.updateRow(row);
                System.out.println("Update the existing scheduler admpscheduler id " + admpScheduleId + " UPDATE DO " + dob);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dob);
            } else {
                admpScheduleUniqueId = (UniqueValueHolder)row.get("ADMP_SCHEDULE_ID");
                System.out.println("Creating new scheduler " + admpScheduleUniqueId);
                dob.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dob);
                admpScheduleId = (Long)admpScheduleUniqueId.getValue();
            }
            System.out.println("ADMP SChedule di " + admpScheduleId);
            SchedulerInputsUtil.addNotificationIDs(notifyDataJsonObject.getString("emailIds"), admpScheduleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String getTimeFreqString(JSONObject notifyDataJsonObject, AdventNetResourceBundle rb) {
        JSONObject time = new JSONObject();
        JSONArray timeArray = new JSONArray();
        try {
            String scheduleType = notifyDataJsonObject.getString("scheduleType");
            int day = 0;
            int date = 0;
            int hours = 0;
            int minutes = 0;
            if (scheduleType.equalsIgnoreCase("daily")) {
                hours = notifyDataJsonObject.getInt("hours");
                minutes = notifyDataJsonObject.getInt("minutes");
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.daily", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("weekly")) {
                String[] weekDays = new String[]{"admp.common.days.sunday", "admp.common.days.monday", "admp.common.days.tuesday", "admp.common.days.wednesday", "admp.common.days.thursday", "admp.common.days.friday", "admp.common.days.saturday"};
                day = notifyDataJsonObject.getInt("day");
                hours = notifyDataJsonObject.getInt("hours");
                minutes = notifyDataJsonObject.getInt("minutes");
                timeArray.put((Object)weekDays[day - 1]);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.weekly_on", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("monthly")) {
                date = notifyDataJsonObject.getInt("date");
                hours = notifyDataJsonObject.getInt("hours");
                minutes = notifyDataJsonObject.getInt("minutes");
                timeArray.put(date);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.monthly_on", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("hourly")) {
                hours = notifyDataJsonObject.getInt("hours");
                timeArray.put(hours);
                time.put("client.reports.SchedulerAction.for_each", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("Custom")) {
                hours = notifyDataJsonObject.getInt("hours");
                minutes = notifyDataJsonObject.getInt("minutes");
                time = SchedulerInputsUtil.getTimeString(notifyDataJsonObject.getString("repeatType"), notifyDataJsonObject.getInt("repeatInterval"), notifyDataJsonObject.getString("startDate"), hours, minutes, notifyDataJsonObject.getString("selectedDays"), notifyDataJsonObject.getString("monthdaydate"), notifyDataJsonObject.getInt("monthdatesel"), notifyDataJsonObject.getInt("monthweeksel"), notifyDataJsonObject.getInt("monthdaysel"), notifyDataJsonObject.getString("selectedMonths"), rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time.toString();
    }

    public static void getMsgXMLElement(HttpServletResponse response, String value) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element Values2 = document.createElement("value");
            Values2.setAttribute("VALUE", value);
            data.appendChild(Values2);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getXMLElement(HttpServletResponse response, ArrayList value) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (Object object : value) {
                Hashtable hash = (Hashtable)object;
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    Integer reportId = (Integer)e.nextElement();
                    ArrayList reportDatas = (ArrayList)hash.get(reportId);
                    for (int i = 0; i < reportDatas.size(); ++i) {
                        Hashtable datas = (Hashtable)reportDatas.get(i);
                        Enumeration enumeration = datas.keys();
                        while (enumeration.hasMoreElements()) {
                            Element Values2 = document.createElement("value");
                            String columnName = (String)enumeration.nextElement();
                            Values2.setAttribute("name", columnName);
                            Element val = document.createElement("val");
                            val.setAttribute(columnName, (String)datas.get(columnName));
                            Values2.appendChild(val);
                            data.appendChild(Values2);
                        }
                    }
                }
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] getDomainName(Long schedule_id) {
        String[] domainName = null;
        ArrayList<String> domains = new ArrayList<String>();
        try {
            Column col = new Column("ADSMSchedulersDomainMapping", "SCHEDULE_ID");
            Criteria crit = new Criteria(col, (Object)schedule_id, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMSchedulersDomainMapping", crit);
            if (!dob.isEmpty()) {
                Iterator it = dob.getRows("ADSMSchedulersDomainMapping");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    domains.add((String)row.get("DOMAIN_NAME"));
                }
            }
            domainName = new String[domains.size()];
            domains.toArray(domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static void addOUDetailsofScheduler(Hashtable selectedOUList, Long scheduleId, DataObject dataObj) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMSchedulersOUMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
            Enumeration e = selectedOUList.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                ArrayList ous = (ArrayList)selectedOUList.get(domainName);
                for (int j = 0; j < ous.size(); ++j) {
                    String ouName = (String)ous.get(j);
                    Row row = new Row("ADSMSchedulersOUMapping");
                    row.set("SCHEDULE_ID", (Object)scheduleId);
                    row.set("OU_NAME", (Object)ouName);
                    row.set("DOMAIN_NAME", (Object)domainName);
                    dataObj.addRow(row);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addOUListInScheduler(Hashtable selectedOUList, Long scheduleId, DataObject dataObj, boolean isUpdate) throws Exception {
        if (isUpdate) {
            dataObj.deleteRows("ADSMSchedulersOUMapping", new Criteria(Column.getColumn((String)"ADSMSchedulersOUMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
        }
        Enumeration e = selectedOUList.keys();
        while (e.hasMoreElements()) {
            String domainName = (String)e.nextElement();
            ArrayList ous = (ArrayList)selectedOUList.get(domainName);
            for (int j = 0; j < ous.size(); ++j) {
                String ouName = (String)ous.get(j);
                Row row = new Row("ADSMSchedulersOUMapping");
                row.set("SCHEDULE_ID", (Object)scheduleId);
                row.set("OU_NAME", (Object)ouName);
                row.set("DOMAIN_NAME", (Object)domainName);
                dataObj.addRow(row);
            }
        }
    }

    public static void addExcludedOUListInScheduler(Hashtable selectedOUList, Long scheduleId, DataObject dataObj, boolean isUpdate) throws Exception {
        if (isUpdate) {
            dataObj.deleteRows("ADSMSchedulersExcludeOUMapping", new Criteria(Column.getColumn((String)"ADSMSchedulersExcludeOUMapping", (String)"schedule_id"), (Object)scheduleId, 0));
        }
        Enumeration e = selectedOUList.keys();
        while (e.hasMoreElements()) {
            String domainName = (String)e.nextElement();
            ArrayList ous = (ArrayList)selectedOUList.get(domainName);
            for (int j = 0; j < ous.size(); ++j) {
                String ouName = (String)ous.get(j);
                Row row = new Row("ADSMSchedulersExcludeOUMapping");
                row.set("SCHEDULE_ID", (Object)scheduleId);
                row.set("OU_NAME", (Object)ouName);
                row.set("DOMAIN_NAME", (Object)domainName);
                dataObj.addRow(row);
            }
        }
    }

    public static void addExcludeChildOUListInScheduler(Hashtable exclChildOUList, Long scheduleId, DataObject dataObj, boolean isUpdate) throws Exception {
        if (isUpdate) {
            dataObj.deleteRows("ADSMSchedulersExclChildMapping", new Criteria(Column.getColumn((String)"ADSMSchedulersExclChildMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
        }
        Enumeration e = exclChildOUList.keys();
        while (e.hasMoreElements()) {
            String domainName = (String)e.nextElement();
            Boolean isExclChildOU = (Boolean)exclChildOUList.get(domainName);
            Row row = new Row("ADSMSchedulersExclChildMapping");
            row.set("SCHEDULE_ID", (Object)scheduleId);
            row.set("IS_EXCLUDE_CHILD_OU", (Object)isExclChildOU);
            row.set("DOMAIN_NAME", (Object)domainName);
            dataObj.addRow(row);
        }
    }

    public static void addReportFilterDetails(ReportFilterConfig rfConfig, Long scheduleId, DataObject dataObject, boolean isUpdate) throws Exception {
        if (isUpdate) {
            dataObject.deleteRows("ADSMScheduleReportsMapping", new Criteria(Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
        }
        Row row = new Row("ADSMScheduleReportsMapping");
        row.set("REPORT_ID", (Object)rfConfig.getReportId());
        row.set("SCHEDULE_ID", (Object)scheduleId);
        dataObject.addRow(row);
        DataAccess.fillGeneratedValues((DataObject)dataObject);
        Long schedulerValueMappingId = (Long)row.get("SCHEDULER_VALUES_MAPPING");
        ArrayList tableNames = ReportInputsAPI.getTableNames((Integer)rfConfig.getReportId());
        for (int k = 0; k < tableNames.size(); ++k) {
            Row inputRow;
            String tableName = (String)tableNames.get(k);
            if (tableName.equalsIgnoreCase("ADSMSchedulerValues")) {
                for (AdmpInput admpInput : rfConfig.getInputList()) {
                    if (admpInput.getIsMultiple().booleanValue()) continue;
                    inputRow = new Row(tableName);
                    inputRow.set("PROPERTIES", (Object)admpInput.getName());
                    inputRow.set("VALUE", (Object)admpInput.getValue());
                    inputRow.set("REPORT_VALUE_ID", (Object)schedulerValueMappingId);
                    dataObject.addRow(inputRow);
                }
                continue;
            }
            if (tableName.equalsIgnoreCase("ADSMReportObjectDNDetails")) {
                for (AdmpInput admpInput : rfConfig.getInputList()) {
                    if (!admpInput.getIsMultiple().booleanValue()) continue;
                    inputRow = new Row(tableName);
                    for (FcOption fcOption : admpInput.getMultipleInput()) {
                        inputRow.set(fcOption.getLabel(), (Object)fcOption.getValue());
                    }
                    inputRow.set("REPORT_VALUE_ID", (Object)schedulerValueMappingId);
                    dataObject.addRow(inputRow);
                }
                continue;
            }
            if (tableName.equalsIgnoreCase("ADSMSchedulerMultiValues")) {
                for (AdmpInput admpInput : rfConfig.getInputList()) {
                    if (!admpInput.getIsMultiple().booleanValue()) continue;
                    inputRow = new Row(tableName);
                    for (FcOption fcOption : admpInput.getMultipleInput()) {
                        inputRow.set(fcOption.getLabel(), (Object)fcOption.getValue());
                    }
                    inputRow.set("REPORT_VALUE_ID", (Object)schedulerValueMappingId);
                    dataObject.addRow(inputRow);
                }
                continue;
            }
            System.out.println("For ADSMReportShareDetails table need to construt the deb desing row " + tableName);
        }
        for (ColumnFilter columnFilter : rfConfig.getcolumnFilterList()) {
            columnFilter.addRow(dataObject, schedulerValueMappingId);
        }
    }

    public static ArrayList getScheduledAuditReportDetails(Long loginId, String tableName) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        ArrayList scheduledReportDetails = new ArrayList();
        try {
            ArrayList schedulerList = SchedulerInputsUtil.getSchedulers(loginId, tableName);
            Long[] scheduleID = new Long[schedulerList.size()];
            for (int i = 0; i < schedulerList.size(); ++i) {
                Hashtable schedulerDetails = (Hashtable)schedulerList.get(i);
                scheduleID[i] = (Long)schedulerDetails.get("SCHEDULE_ID");
            }
            ArrayList domainNames = new ArrayList();
            SelectQueryImpl sq = new SelectQueryImpl(new Table("Schedule_Audit"));
            Column column = Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_ID");
            sq.addSelectColumn(Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"Schedule_Audit", (String)"TASK_EXECUTION_STATUS"));
            sq.addSelectColumn(Column.getColumn((String)"Schedule_Audit", (String)"AUDIT_ID"));
            Criteria criteria = new Criteria(column, (Object)scheduleID, 8);
            sq.setCriteria(criteria);
            DataObject datobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator iterator = datobject.getRows("Schedule_Audit");
            while (iterator.hasNext()) {
                Hashtable<String, String> scheduleDetails = new Hashtable<String, String>();
                Row r = (Row)iterator.next();
                scheduleDetails.put("scheduleName", (String)r.get("SCHEDULE_NAME"));
                String status = rb.getString("admp.reports.sche_reports.common.text.failure");
                if (((String)r.get("TASK_EXECUTION_STATUS")).equalsIgnoreCase("success")) {
                    status = rb.getString("admp.reports.sche_reports.common.text.success");
                } else if (((String)r.get("TASK_EXECUTION_STATUS")).equalsIgnoreCase("processing")) {
                    status = rb.getString("admp.reports.sche_reports.common.text.processing");
                }
                scheduleDetails.put("schedulerStatus", status);
                scheduledReportDetails.add(scheduleDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduledReportDetails;
    }

    public static ArrayList getScheduledReportDetails(Long loginId, Boolean ascending) {
        ArrayList scheduledReportDetails = new ArrayList();
        try {
            ArrayList schedulerList = SchedulerInputsUtil.getSchedulers(loginId, "ADSMScheduler");
            Long[] scheduleID = new Long[schedulerList.size()];
            for (int i = 0; i < schedulerList.size(); ++i) {
                Hashtable schedulerDetails = (Hashtable)schedulerList.get(i);
                scheduleID[i] = (Long)schedulerDetails.get("SCHEDULE_ID");
            }
            String desc = "";
            ArrayList domainNames = new ArrayList();
            SelectQueryImpl sq = new SelectQueryImpl(new Table("Schedule_Audit"));
            Column column = new Column("Schedule_Audit", "SCHEDULE_ID");
            sq.addSelectColumn(new Column("Schedule_Audit", "SCHEDULE_NAME"));
            sq.addSelectColumn(new Column("Schedule_Audit", "SCHEDULE_START_TIME"));
            sq.addSelectColumn(new Column("Schedule_Audit", "SCHEDULE_ID"));
            sq.addSelectColumn(new Column("Schedule_Audit", "TASK_EXECUTION_STATUS"));
            sq.addSelectColumn(new Column("Schedule_Audit", "AUDIT_ID"));
            sq.addSortColumn(new SortColumn("Schedule_Audit", "SCHEDULE_START_TIME", false));
            Column col = new Column("Schedule_Audit", "SCHEDULE_NAME");
            if (ascending != null) {
                SortColumn sortCol = new SortColumn(col, ascending.booleanValue());
                sq.addSortColumn(sortCol);
            }
            Criteria criteria = new Criteria(column, (Object)scheduleID, 8);
            sq.setCriteria(criteria);
            DataObject datobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator iterator = datobject.getRows("Schedule_Audit");
            while (iterator.hasNext()) {
                Hashtable<String, Object> scheduleDetails = new Hashtable<String, Object>();
                Row r = (Row)iterator.next();
                scheduleDetails.put("scheduleName", (String)r.get("SCHEDULE_NAME"));
                scheduleDetails.put("startedTime", r.get("SCHEDULE_START_TIME"));
                for (int i = 0; i < schedulerList.size(); ++i) {
                    Hashtable SchedulerDetails = (Hashtable)schedulerList.get(i);
                    if (!SchedulerDetails.get("SCHEDULE_ID").equals(r.get("SCHEDULE_ID"))) continue;
                    desc = (String)SchedulerDetails.get("DESCRIPTION");
                    domainNames = (ArrayList)SchedulerDetails.get("DOMAIN_NAME");
                }
                if (domainNames.size() == 0) {
                    domainNames.add("admp.reports.schedule_reports.scheduler.all_domains");
                }
                scheduleDetails.put("domainDetails", domainNames);
                scheduleDetails.put("description", desc);
                if (((String)r.get("TASK_EXECUTION_STATUS")).equalsIgnoreCase("success")) {
                    scheduleDetails.put("schedulerStatus", "client.util.SchedulerInputsUtil.success");
                } else if (((String)r.get("TASK_EXECUTION_STATUS")).equalsIgnoreCase("processing")) {
                    scheduleDetails.put("schedulerStatus", "client.util.SchedulerInputsUtil.processing");
                } else {
                    scheduleDetails.put("schedulerStatus", "client.util.SchedulerInputsUtil.failure");
                }
                Hashtable folderMessage = SchedulerUtil.getGeneratedReportDetailsFolder((Long)((Long)r.get("AUDIT_ID")));
                if (!folderMessage.isEmpty()) {
                    scheduleDetails.put("path", folderMessage.get("folderPath"));
                    scheduleDetails.put("message", folderMessage.get("message"));
                } else {
                    scheduleDetails.put("path", "");
                    scheduleDetails.put("message", "");
                }
                scheduledReportDetails.add(scheduleDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduledReportDetails;
    }

    public static boolean checkForDuplicateScheduler(String givenScheduleName) {
        boolean duplicate = false;
        try {
            Column col = new Column("Schedule", "*");
            SelectQueryImpl sq = new SelectQueryImpl(new Table("Schedule"));
            sq.addSelectColumn(col);
            Criteria cri = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)givenScheduleName, 0);
            sq.setCriteria(cri);
            DataObject datobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!datobject.isEmpty()) {
                duplicate = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicate;
    }

    public static void addHDTforScheduler(Long scheduleId, ArrayList selectedHDT) {
        try {
            ArrayList<Long> existingHDT = new ArrayList<Long>();
            Criteria criteria = new Criteria(new Column("ADSMAuditTechnicians", "SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAuditTechnicians", criteria);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("ADSMAuditTechnicians");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    existingHDT.add((Long)row.get("TECHNICIAN_ID"));
                }
            }
            for (int i = 0; i < selectedHDT.size(); ++i) {
                Long hdt = Long.valueOf(selectedHDT.get(i).toString());
                if (existingHDT.contains(hdt)) continue;
                Row row = new Row("ADSMAuditTechnicians");
                row.set("SCHEDULE_ID", (Object)scheduleId);
                row.set("TECHNICIAN_ID", (Object)hdt);
                dataObject.addRow(row);
            }
            Criteria crit = new Criteria(new Column("ADSMAuditTechnicians", "SCHEDULE_ID"), (Object)scheduleId, 0);
            crit = crit.and(new Criteria(new Column("ADSMAuditTechnicians", "TECHNICIAN_ID"), (Object)existingHDT.toArray(), 8));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAuditTechnicians", (String)"TECHNICIAN_ID"), (Object)selectedHDT.toArray(), 9));
            dataObject.deleteRows("ADSMAuditTechnicians", crit);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap getScheduleTimeSummary(DynaValidatorForm bean, AdventNetResourceBundle rb, Hashtable customProp) {
        int day = 0;
        int date = 0;
        int hours = 0;
        int minutes = 0;
        String scheduleType = (String)bean.get("repSchedule");
        String timeSummary = null;
        HashMap<String, Object> timeValues = new HashMap<String, Object>();
        JSONObject time = new JSONObject();
        JSONArray timeArray = new JSONArray();
        try {
            if (scheduleType.equalsIgnoreCase("daily")) {
                hours = (Integer)bean.get("dailysel1");
                minutes = (Integer)bean.get("dailysel2");
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.daily", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("weekly")) {
                String[] weekDays = new String[]{"admp.common.days.sunday", "admp.common.days.monday", "admp.common.days.tuesday", "admp.common.days.wednesday", "admp.common.days.thursday", "admp.common.days.friday", "admp.common.days.saturday"};
                day = (Integer)bean.get("weeklysel1");
                hours = (Integer)bean.get("dailysel1");
                minutes = (Integer)bean.get("dailysel2");
                timeArray.put((Object)weekDays[day - 1]);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.weekly_on", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("monthly")) {
                date = (Integer)bean.get("monthsel1");
                hours = (Integer)bean.get("dailysel1");
                minutes = (Integer)bean.get("dailysel2");
                timeArray.put(date);
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(hours, 2));
                timeArray.put((Object)SchedulerInputsUtil.formatNumber(minutes, 2));
                time.put("client.reports.SchedulerAction.monthly_on", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("hourly")) {
                hours = (Integer)bean.get("dailysel1");
                timeArray.put(hours);
                time.put("client.reports.SchedulerAction.for_each", (Object)timeArray);
            } else if (scheduleType.equalsIgnoreCase("Custom")) {
                hours = (Integer)bean.get("dailysel1");
                minutes = (Integer)bean.get("dailysel2");
                String startingDate = (String)bean.get("startDate");
                String freqType = (String)bean.get("frequency");
                String repType = (String)bean.get("repeatType");
                if (freqType.equals("repnone")) {
                    repType = freqType;
                }
                int repInterval = (Integer)bean.get("repeatInterval");
                String monthdaydate = (String)bean.get("monthdaydate");
                if (monthdaydate.equalsIgnoreCase("date")) {
                    customProp.put("dayofmonth", bean.get("monthsel2"));
                } else if (monthdaydate.equalsIgnoreCase("day")) {
                    customProp.put("weekofmonth", bean.get("weekofmonth"));
                    customProp.put("dayofweek", bean.get("weeklysel2"));
                }
                customProp.put("monthdaydate", monthdaydate);
                customProp.put("repType", repType);
                customProp.put("skipFrequency", repInterval);
                customProp.put("selectedDays", bean.get("selectedDayValues"));
                customProp.put("selectedMonths", bean.get("selectedMonthValues"));
                customProp.put("startingDate", startingDate);
                time = SchedulerInputsUtil.getTimeString(repType, repInterval, startingDate, hours, minutes, (String)bean.get("selectedDayValues"), (String)bean.get("monthdaydate"), (Integer)bean.get("monthsel2"), (Integer)bean.get("weekofmonth"), (Integer)bean.get("weeklysel2"), (String)bean.get("selectedMonthValues"), rb);
            }
            timeSummary = time.toString();
            timeValues.put("scheduleType", scheduleType);
            timeValues.put("hours", hours);
            timeValues.put("minutes", minutes);
            timeValues.put("day", day);
            timeValues.put("date", date);
            timeValues.put("timeSummary", timeSummary);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return timeValues;
    }

    public static String formatNumber(int valuleToBeFormat, int numOfDigits) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(numOfDigits);
        String formatString = numberFormat.format(valuleToBeFormat);
        return formatString;
    }

    public static void setValues(String scheduleType, Long schedule_id, boolean custom, DynaValidatorForm bean) {
        ArrayList timeDetails = SchedulerUtil.getScheduleTimeDetails((String)scheduleType, (Long)schedule_id);
        Hashtable hash = (Hashtable)timeDetails.get(0);
        if (scheduleType.equalsIgnoreCase("hourly")) {
            String UNIT_OF_TIME = (String)hash.get("UNIT_OF_TIME");
            Long TIME_PERIOD = (Long)hash.get("TIME_PERIOD");
            if (custom) {
                bean.set("repeatInterval", (Object)TIME_PERIOD.intValue());
                bean.set("startDate", (Object)((String)hash.get("startDate")));
                bean.set("dailysel1", (Object)((Integer)hash.get("hours")));
                bean.set("dailysel2", (Object)((Integer)hash.get("minutes")));
                bean.set("repeatType", (Object)"repminutes");
                bean.set("frequency", (Object)"repeat");
                bean.set("repSchedule", (Object)"custom");
            } else {
                bean.set("dailysel1", (Object)TIME_PERIOD.intValue());
                bean.set("repSchedule", (Object)"hourly");
            }
        } else {
            Integer startDate = (Integer)hash.get("DATE_OF_MONTH");
            Integer startMonth = (Integer)hash.get("MONTH_OF_YEAR");
            Integer startYear = (Integer)hash.get("YEAR_OF_DECADE");
            Integer skipFrequency = (Integer)hash.get("SKIP_FREQUENCY");
            String executionTime = (String)hash.get("EXECUTION_TIME");
            String hrs = executionTime.substring(0, executionTime.indexOf(58));
            String mns = executionTime.substring(executionTime.indexOf(58) + 1, executionTime.lastIndexOf(58));
            Integer hours = Integer.parseInt(hrs);
            Integer minutes = Integer.parseInt(mns);
            bean.set("dailysel1", (Object)hours);
            bean.set("dailysel2", (Object)minutes);
            if (scheduleType.equalsIgnoreCase("Daily")) {
                if (custom) {
                    bean.set("repeatType", (Object)"repdays");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    bean.set("repSchedule", (Object)"daily");
                }
            } else if (scheduleType.equalsIgnoreCase("Weekly")) {
                if (custom) {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Object[] seldayval = new Integer[daysOfWeek.length];
                    for (int i = 0; i < daysOfWeek.length; ++i) {
                        seldayval[i] = daysOfWeek[i];
                    }
                    String selDayVal = Arrays.toString(seldayval);
                    selDayVal = selDayVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                    bean.set("selectedDayValues", (Object)selDayVal);
                    bean.set("repeatType", (Object)"repweeks");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
                    Integer DAY_OF_WEEK = (Integer)hash.get("DAY_OF_WEEK");
                    bean.set("weeklysel1", (Object)days[DAY_OF_WEEK - 1]);
                    bean.set("repSchedule", (Object)"weekly");
                }
            } else if (scheduleType.equalsIgnoreCase("Monthly")) {
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (custom) {
                    startDate = 1;
                    if (DATE_OF_MONTH != -1) {
                        bean.set("monthsel2", (Object)DATE_OF_MONTH);
                        bean.set("monthdaydate", (Object)"date");
                    } else {
                        int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                        Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                        bean.set("weekofmonth", (Object)weekOfMonth.intValue());
                        bean.set("weeklysel2", (Object)daysOfWeek[0]);
                        bean.set("monthdaydate", (Object)"day");
                    }
                    bean.set("repeatType", (Object)"repmonths");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    bean.set("monthsel1", (Object)DATE_OF_MONTH);
                    bean.set("repSchedule", (Object)"monthly");
                }
            } else if (scheduleType.equalsIgnoreCase("Yearly")) {
                startMonth = 1;
                startDate = 1;
                int[] months = (int[])hash.get("MONTHS");
                Object[] selmonthval = new Integer[months.length];
                for (int i = 0; i < months.length; ++i) {
                    selmonthval[i] = months[i] + 1;
                }
                String selMonthVal = Arrays.toString(selmonthval);
                selMonthVal = selMonthVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                bean.set("selectedMonthValues", (Object)selMonthVal);
                bean.set("repeatType", (Object)"repyears");
                bean.set("frequency", (Object)"repeat");
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (DATE_OF_MONTH != -1) {
                    bean.set("monthsel2", (Object)DATE_OF_MONTH);
                    bean.set("monthdaydate", (Object)"date");
                } else {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                    bean.set("weekofmonth", (Object)weekOfMonth.intValue());
                    bean.set("weeklysel2", (Object)daysOfWeek[0]);
                    bean.set("monthdaydate", (Object)"day");
                }
            } else if (scheduleType.equalsIgnoreCase("None")) {
                bean.set("frequency", (Object)"repnone");
            }
            if (custom) {
                String dateStr = startYear.toString() + "-" + startMonth.toString() + "-" + startDate.toString();
                bean.set("repeatInterval", (Object)(skipFrequency + 1));
                bean.set("startDate", (Object)dateStr);
                bean.set("repSchedule", (Object)"custom");
            }
        }
    }
}

