/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util.ajax;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AjaxMessageObject {
    private static final Logger LOGGER = Logger.getLogger(AjaxMessageObject.class.getName());
    private static boolean escape = false;
    private JSONObject msgObj;

    private AjaxMessageObject() {
    }

    public AjaxMessageObject(String module, Object mobj) {
        this(module, mobj, false);
    }

    public AjaxMessageObject(String module, String type, Object mobj) {
        this(module, mobj, false);
        if (type != null) {
            try {
                this.msgObj.put("objType", (Object)type);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public AjaxMessageObject(String module, Object mobj, boolean escape) {
        try {
            AjaxMessageObject.escape = escape;
            this.msgObj = new JSONObject();
            this.msgObj.put("module", (Object)module);
            if (mobj != null) {
                this.constructObjString(mobj);
            } else {
                this.msgObj.put("objType", (Object)"null");
                this.msgObj.put("objString", (Object)"");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void constructObjString(Object mobj) {
        try {
            if (mobj instanceof DataObject) {
                this.msgObj.put("objType", (Object)"do");
                this.msgObj.put("objString", (Object)this.constructDOString((DataObject)mobj));
            } else if (mobj instanceof Hashtable) {
                this.msgObj.put("objType", (Object)"object");
                this.msgObj.put("objString", (Object)new JSONObject((Map)((Hashtable)mobj)));
            } else if (mobj instanceof Collection) {
                this.msgObj.put("objType", (Object)"array");
                this.msgObj.put("objString", (Object)new JSONArray((Collection)mobj));
            } else if (mobj instanceof String) {
                this.msgObj.put("objType", (Object)"string");
                this.msgObj.put("objString", (Object)mobj.toString());
            } else if (mobj instanceof JSONObject) {
                this.msgObj.put("objType", (Object)"jsonstring");
                this.msgObj.put("objString", mobj);
            } else {
                this.msgObj.put("objType", (Object)"unknown");
                this.msgObj.put("objString", (Object)mobj.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private JSONArray constructDOString(DataObject dob) {
        JSONArray doArray = new JSONArray();
        try {
            List tabNames = dob.getTableNames();
            Object value = null;
            for (int i = 0; i < tabNames.size(); ++i) {
                String tableName = (String)tabNames.get(i);
                List columns = dob.getRow(tableName).getColumns();
                int colSize = columns.size();
                Iterator rowsInTable = dob.getRows(tableName);
                JSONArray rows = new JSONArray();
                while (rowsInTable.hasNext()) {
                    JSONArray rowArray = new JSONArray();
                    Row rw = (Row)rowsInTable.next();
                    for (int col = 0; col < colSize; ++col) {
                        value = rw.get((String)columns.get(col));
                        rowArray.put((Object)(value == null ? "" : value.toString()));
                    }
                    rows.put((Object)rowArray);
                }
                JSONObject jobj = new JSONObject();
                jobj.put("tname", (Object)tableName);
                jobj.put("cols", (Object)new JSONArray((Collection)columns));
                jobj.put("rows", (Object)rows);
                doArray.put((Object)jobj);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return doArray;
    }

    public String toString() {
        return this.msgObj.toString();
    }
}

