/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtStatusUpdator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class O365AbstractListener
implements NativeListener {
    protected boolean isCompleted;
    protected String objectClass;
    protected ObjectClass objClass;
    protected ArrayList attributeProps;
    protected AdventNetResourceBundle rb;
    protected Long queueRegID = null;
    protected String baseTableName;
    protected Integer reportId;
    protected String tableKey;
    protected Long loginId;
    protected String tenantId;
    protected String tenantPwd;
    protected ArrayList attributeList;
    protected ArrayList attribDetails;
    protected Hashtable attributeListHash;
    protected boolean isCsvMgmt;
    protected ArrayList<String> informationStrings = new ArrayList();
    protected String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
    protected int licensedCount;
    private static final Integer OFFICE_365_APPID = 3;

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public O365AbstractListener() {
        if (this.noOfObjects == null) {
            this.noOfObjects = "100";
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            this.licensedCount = Integer.parseInt(this.noOfObjects);
        }
    }

    public void addRow(Properties prop) {
        Properties uiProps = new Properties();
        Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)this.attributeProps, (String)"", (Properties)uiProps, (Hashtable)new Properties(), (AdventNetResourceBundle)this.rb);
        QueueHandler.getInstance().getQueue(this.objClass.getId()).updateData(this.queueRegID, tableStringMap);
    }

    protected ArrayList getObjIdList() {
        this.objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(this.baseTableName);
        ArrayList<Integer> objectIds = new ArrayList<Integer>();
        objectIds.add(this.objClass.getId());
        return objectIds;
    }

    public void completedAction() {
        this.endQueue();
    }

    public void endQueue() {
        this.postNativeData();
        this.deRegister();
        this.queueRegID = null;
    }

    private void postNativeData() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
    }

    private void deRegister() {
        QueueHandler.getInstance().deRegister(this.queueRegID);
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public ArrayList getAttributeProps() {
        return this.attributeProps;
    }

    public void setAttributeProps(ArrayList attributeProps) {
        this.attributeProps = attributeProps;
    }

    public void setResourceBundle(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    protected void initAttributeList(int reportId) {
        this.reportId = reportId;
        ArrayList<Object> attribIdList = new ArrayList<Object>();
        this.attributeList = new ArrayList();
        try {
            this.attribDetails = new ArrayList();
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(reportId));
            for (int i = 0; i < tableNames.size(); ++i) {
                ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(reportId));
                for (int j = 0; j < l.size(); ++j) {
                    Properties p = (Properties)l.get(j);
                    if (!this.attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) {
                        attribIdList.add(p.get("ATTRIB_ID"));
                        this.attributeList.add(p.get("ATTRIB_LDAP_NAME"));
                    }
                    this.attribDetails.add(p);
                }
            }
            DataObject attributeDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribIdList.toArray(), 8));
            Iterator it = attributeDO.getRows("ADSMAttributeDetails");
            this.attributeProps = new ArrayList();
            this.attributeListHash = new Hashtable();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                this.attributeProps.add(MultiDCUtil.getProps((Row)r));
                String tableName = (String)r.get("TABLE_NAME");
                String columnName = (String)r.get("ATTRIB_COLUMN_NAME");
                String ldapName = (String)r.get("ATTRIB_LDAP_NAME");
                ArrayList<String> columns = (ArrayList<String>)this.attributeListHash.get(tableName);
                if (columns == null) {
                    columns = new ArrayList<String>();
                    this.attributeListHash.put(tableName, columns);
                }
                columns.add(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract String modifyUser(String var1, String var2, Hashtable var3, DataObject var4, Object var5);

    public abstract Properties updateStatus(Properties var1, String var2);

    private void checkAuthorization(ArrayList userDetailsList, String o365AccountName) {
        try {
            boolean applyOURestriction = O365DelegationUtil.getApplyOURestriction((Long)this.loginId, (String)o365AccountName, (String)"User");
            ArrayList delegatedO365Domains = O365DelegationUtil.getDelegatedIamAppDomains((Long)this.loginId, (String)o365AccountName);
            if ((applyOURestriction || delegatedO365Domains.size() > 0) && userDetailsList.size() > 0) {
                Long waadDomainId = O365MgmtHandler.getWaadDomainId((String)o365AccountName);
                O365DelegationUtil.updateO365ObjectsOUDetails((Long)waadDomainId, (String)"User");
                Hashtable userDetails = (Hashtable)userDetailsList.get(0);
                ArrayList detailsList = (ArrayList)userDetails.get("USER_VALUES");
                String columnName = "";
                for (Hashtable details : detailsList) {
                    String column = (String)details.get("ATTRIB_COLUMN_NAME");
                    if (column.equalsIgnoreCase("OBJECT_ID")) {
                        columnName = column;
                        break;
                    }
                    if (column.equalsIgnoreCase("USER_PRINCIPAL_NAME")) {
                        columnName = column;
                        continue;
                    }
                    if (!column.equalsIgnoreCase("EMAIL_ADDRESS") || !columnName.equalsIgnoreCase("")) continue;
                    columnName = column;
                }
                ArrayList<String> columnValuesList = new ArrayList<String>();
                for (Hashtable userDetailsHash : userDetailsList) {
                    ArrayList userDetsList = (ArrayList)userDetailsHash.get("USER_VALUES");
                    for (Hashtable details : userDetsList) {
                        String value;
                        String column = (String)details.get("ATTRIB_COLUMN_NAME");
                        if (!column.equalsIgnoreCase(columnName) || (value = (String)details.get("ATTRIB_VALUE")) == null) continue;
                        columnValuesList.add(value);
                    }
                }
                String tableName = "O365UserGeneralDetails";
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
                selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
                if (!columnName.equalsIgnoreCase("OBJECT_ID")) {
                    selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_ID"));
                }
                if (!columnName.equalsIgnoreCase("USER_PRINCIPAL_NAME")) {
                    selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"USER_PRINCIPAL_NAME"));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)columnValuesList.toArray(new String[columnValuesList.size()]), 8);
                ArrayList authOUList = O365DelegationUtil.getAuthorizedOUList((Long)this.loginId, (String)o365AccountName);
                if (applyOURestriction) {
                    criteria = criteria.and(O365MgmtHandler.getAuthentictedOUCriteria(null, null, (ArrayList)authOUList, (boolean)false, (String)tableName));
                }
                Criteria domainsCrit = null;
                for (String domain : delegatedO365Domains) {
                    Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"USER_PRINCIPAL_NAME"), (Object)("@" + domain), 11);
                    domainsCrit = domainsCrit == null ? crit : domainsCrit.or(crit);
                }
                if (domainsCrit != null) {
                    criteria = criteria.and(domainsCrit);
                }
                selectQuery.setCriteria(criteria);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
                for (Hashtable userDetailsHash : userDetailsList) {
                    ArrayList userDetsList = (ArrayList)userDetailsHash.get("USER_VALUES");
                    for (Hashtable details : userDetsList) {
                        Criteria crit;
                        Iterator userRows;
                        String column = (String)details.get("ATTRIB_COLUMN_NAME");
                        if (!column.equalsIgnoreCase(columnName)) continue;
                        String value = (String)details.get("ATTRIB_VALUE");
                        boolean isAuthorized = false;
                        if (value != null && dataObject != null && (userRows = dataObject.getRows(tableName, crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)value, 0))) != null && userRows.hasNext()) {
                            isAuthorized = true;
                        }
                        details.put("IS_AUTHORIZED", isAuthorized);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class CreateAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        boolean connectToOffice365 = false;
        String hostId;
        String newPassword;
        String usageLoc;
        String o365SelectedDomain;
        String adDomain;

        public CreateAction(long generationId, JSONArray selectedUsersList, boolean connectToOffice365, String hostId, String newPassword, String usageLoc, String o365SelectedDomain, String adDomain) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.connectToOffice365 = connectToOffice365;
            this.hostId = hostId;
            this.newPassword = newPassword;
            this.usageLoc = usageLoc;
            this.o365SelectedDomain = o365SelectedDomain;
            this.adDomain = adDomain;
            O365AbstractListener.this.isCsvMgmt = false;
        }

        @Override
        public void run() {
            try {
                String connectionMsg;
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ArrayList<String> attribToSelect = new ArrayList<String>();
                attribToSelect.add("OBJECT_GUID");
                attribToSelect.add("CITY");
                attribToSelect.add("COUNTRY");
                attribToSelect.add("DEPARTMENT");
                attribToSelect.add("FAX");
                attribToSelect.add("FIRST_NAME");
                attribToSelect.add("LAST_NAME");
                attribToSelect.add("MOBILE");
                attribToSelect.add("ZIP_POSTAL_CODE");
                attribToSelect.add("OFFICE");
                attribToSelect.add("STATE_PROVINCE");
                attribToSelect.add("STREET_ADDRESS");
                attribToSelect.add("TITLE");
                attribToSelect.add("LOGON_NAME");
                attribToSelect.add("DISPLAY_NAME");
                attribToSelect.add("SAM_ACCOUNT_NAME");
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Hashtable userDetails = O365MgmtHandler.getWAADADSMUserDetails(attribToSelect, (String[])objectIdArr, (String)this.o365SelectedDomain, (String)this.adDomain, (String)"OBJECT_GUID", null);
                objectIdArr = null;
                Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.adDomain, 0));
                ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                if (this.connectToOffice365 && (connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd)) != null && connectionMsg.trim().length() > 0) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(O365AbstractListener.this.rb.getString(connectionMsg));
                    statusUpdater.setIsCompleted(true);
                    O365AbstractListener.this.isCompleted = true;
                    return;
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    String objectGuid = this.selectedUsersList.getString(i);
                    ArrayList userProp = (ArrayList)userDetails.get(objectGuid.toLowerCase());
                    String objName = "";
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Properties extraProp = new Properties();
                    extraProp.put("PARAMETER", "Password");
                    extraProp.put("VALUE", "S:" + this.newPassword);
                    userProp.add(extraProp);
                    if (this.usageLoc != null && !this.usageLoc.equalsIgnoreCase("-")) {
                        extraProp = new Properties();
                        extraProp.put("PARAMETER", "UsageLocation");
                        extraProp.put("VALUE", "S:" + this.usageLoc);
                        userProp.add(extraProp);
                    }
                    Properties updateProp = new Properties();
                    updateProp.put("STATUS", "FAIL");
                    updateProp.put("LOGON_NAME", "-");
                    updateProp.put("SAM_ACCOUNT_NAME", "-");
                    String samAccountName = "";
                    for (int index = 0; index < userProp.size(); ++index) {
                        if (((Properties)userProp.get(index)).getProperty("LOGON_NAME") != null) {
                            objName = ((Properties)userProp.get(index)).getProperty("LOGON_NAME");
                            updateProp.put("LOGON_NAME", objName);
                            continue;
                        }
                        if (((Properties)userProp.get(index)).getProperty("SAM_ACCOUNT_NAME") == null) continue;
                        samAccountName = ((Properties)userProp.get(index)).getProperty("SAM_ACCOUNT_NAME");
                        updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                        userProp.remove(index);
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)this.adDomain, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String message = O365AbstractListener.this.modifyUser(objectGuid, "ObjectGuid", audit_info, auditDataObj, userProp);
                    String objectId = "";
                    try {
                        JSONObject json = new JSONObject(message);
                        objectId = json.getString("ObjectId");
                        updateProp = new Properties();
                        updateProp.put("USER_PRINCIPAL_NAME", json.getString("UserPrincipalName"));
                        updateProp.put("DISPLAY_NAME", json.getString("DisplayName"));
                        updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                        updateProp.put("STATUS", "SUCCESS");
                        message = "admp.mgmt.common.statmsg.successfully_created";
                        auditObjectIdList.add(object_id);
                    }
                    catch (Exception e) {
                        isAllObjectsSucceeded = false;
                    }
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties resProp = O365AbstractListener.this.updateStatus(updateProp, message);
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("WAADCreateUserResult");
                    row.set("OBJECT_GUID", (Object)objectGuid);
                    row.set("OBJECT_ID", (Object)objectId);
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, new Hashtable(), O365AbstractListener.this.loginId, O365AbstractListener.this.reportId, O365AbstractListener.this.tenantId, O365AbstractListener.this.rb, null);
                }
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class CreateCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        boolean connectToOffice365 = false;
        Long userCreationID;
        String hostId;
        String newPassword;
        String usageLoc;
        String o365SelectedDomain;
        String adDomain;
        JSONArray authOUList;

        public CreateCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, boolean connectToOffice365, Long userCreationID, String hostId, String newPassword, String usageLoc, String o365SelectedDomain, String adDomain, JSONArray authOUList) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.connectToOffice365 = connectToOffice365;
            this.userCreationID = userCreationID;
            this.hostId = hostId;
            this.newPassword = newPassword;
            this.usageLoc = usageLoc;
            this.o365SelectedDomain = o365SelectedDomain;
            this.adDomain = adDomain;
            this.authOUList = authOUList;
            O365AbstractListener.this.isCsvMgmt = true;
        }

        public void setActionDetails() {
        }

        @Override
        public void run() {
            try {
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                String uniqueValueParamName = new String();
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                int priority = 4;
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName") && priority > 0) {
                        uniqueValueParamName = "LOGON_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 0;
                    } else if (attr.equalsIgnoreCase("ObjectGuid") && priority > 2) {
                        uniqueValueParamName = "OBJECT_GUID";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1145"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 2;
                    } else if (attr.equalsIgnoreCase("SamAccountName") && priority > 3) {
                        uniqueValueParamName = "SAM_ACCOUNT_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1006"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 3;
                    } else if (attr.equalsIgnoreCase("DistinguishedName") && priority > 1) {
                        uniqueValueParamName = "DISTINGUISHED_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 1;
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList user = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit);
                String[] selectedUsers = new String[user.size()];
                for (int index = 0; index < user.size(); ++index) {
                    Hashtable hashtab = (Hashtable)user.get(index);
                    ArrayList hashtab1 = (ArrayList)hashtab.get("USER_VALUES");
                    for (int i = 0; i < hashtab1.size(); ++i) {
                        Hashtable temp = (Hashtable)hashtab1.get(i);
                        if (!uniqueValueParamName.equalsIgnoreCase((String)temp.get("ATTRIB_COLUMN_NAME"))) continue;
                        selectedUsers[index] = (String)temp.get("ATTRIB_VALUE");
                        break;
                    }
                    if (!uniqueValueParamName.equalsIgnoreCase("OBJECT_GUID") || selectedUsers[index].charAt(0) == '{') continue;
                    selectedUsers[index] = "{" + selectedUsers[index].concat("}");
                }
                ArrayList<String> attribToSelect = new ArrayList<String>();
                attribToSelect.add("OBJECT_GUID");
                attribToSelect.add("CITY");
                attribToSelect.add("COUNTRY");
                attribToSelect.add("DEPARTMENT");
                attribToSelect.add("FAX");
                attribToSelect.add("FIRST_NAME");
                attribToSelect.add("LAST_NAME");
                attribToSelect.add("MOBILE");
                attribToSelect.add("ZIP_POSTAL_CODE");
                attribToSelect.add("OFFICE");
                attribToSelect.add("STATE_PROVINCE");
                attribToSelect.add("STREET_ADDRESS");
                attribToSelect.add("TITLE");
                attribToSelect.add("LOGON_NAME");
                attribToSelect.add("DISPLAY_NAME");
                attribToSelect.add("SAM_ACCOUNT_NAME");
                attribToSelect.add("DISTINGUISHED_NAME");
                Hashtable userDetails = O365MgmtHandler.getWAADADSMUserDetails(attribToSelect, (String[])selectedUsers, (String)this.o365SelectedDomain, (String)this.adDomain, (String)uniqueValueParamName, (JSONArray)this.authOUList);
                if (this.connectToOffice365) {
                    Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                    domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                    domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.adDomain, 0));
                    ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                    O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                    String connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd);
                    if (connectionMsg != null && connectionMsg.trim().length() > 0) {
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(O365AbstractListener.this.rb.getString(connectionMsg));
                        statusUpdater.setIsCompleted(true);
                        O365AbstractListener.this.isCompleted = true;
                        return;
                    }
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < selectedUsers.length; ++i) {
                    String message = new String();
                    if (!O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") && i + 1 > O365AbstractListener.this.licensedCount) break;
                    Hashtable hashtable = (Hashtable)user.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    String uniqueValue = selectedUsers[i];
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)uniqueValue, (String)this.adDomain, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    try {
                        ArrayList userProp = (ArrayList)userDetails.get(uniqueValue.toLowerCase());
                        Properties extraProp = new Properties();
                        if (this.newPassword != null && this.newPassword.length() != 0) {
                            extraProp.put("PARAMETER", "Password");
                            extraProp.put("VALUE", "S:" + this.newPassword);
                            userProp.add(extraProp);
                        }
                        if (this.usageLoc != null && !this.usageLoc.equalsIgnoreCase("-")) {
                            extraProp = new Properties();
                            extraProp.put("PARAMETER", "UsageLocation");
                            extraProp.put("VALUE", "S:" + this.usageLoc);
                            userProp.add(extraProp);
                        }
                        for (int index = 0; index < userProp.size(); ++index) {
                            if (((Properties)userProp.get(index)).getProperty("SAM_ACCOUNT_NAME") == null) continue;
                            userProp.remove(index);
                            break;
                        }
                        message = O365AbstractListener.this.modifyUser(uniqueValue, uniqueValueParamName, audit_info, auditDataObj, userProp);
                        try {
                            JSONObject json = new JSONObject(message);
                            message = "admp.mgmt.common.statmsg.successfully_created";
                            auditObjectIdList.add(object_id);
                        }
                        catch (Exception e) {
                            isAllObjectsSucceeded = false;
                        }
                    }
                    catch (NullPointerException e) {
                        message = "admp.mgmt.common.statmsg.cannot_retrieve_object_does_not_exist_or_access_denied";
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", O365AbstractListener.this.rb.getString(message));
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(O365AbstractListener.this.rb, prop);
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, O365AbstractListener.this.rb.getString(message));
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, new Hashtable(), O365AbstractListener.this.loginId, O365AbstractListener.this.reportId, O365AbstractListener.this.tenantId, O365AbstractListener.this.rb, null);
                }
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ModifyAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        boolean connectToOffice365 = false;
        String hostId;

        public ModifyAction(long generationId, JSONArray selectedUsersList, boolean connectToOffice365, String hostId) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.connectToOffice365 = connectToOffice365;
            this.hostId = hostId;
            O365AbstractListener.this.isCsvMgmt = false;
        }

        @Override
        public void run() {
            try {
                String connectionMsg;
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                ArrayList attribColumnNamesList = new ArrayList();
                Hashtable userDetails = O365MgmtHandler.getWAADUserDetails((ArrayList)O365AbstractListener.this.attribDetails, null, (String[])objectIdArr, (String)"OBJECT_ID");
                objectIdArr = null;
                Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                if (this.connectToOffice365 && (connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd)) != null && connectionMsg.trim().length() > 0) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(connectionMsg);
                    statusUpdater.setIsCompleted(true);
                    O365AbstractListener.this.isCompleted = true;
                    return;
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    String objectId = this.selectedUsersList.getString(i);
                    Properties userProp = (Properties)userDetails.get(objectId);
                    String objName = userProp.getProperty("USER_PRINCIPAL_NAME");
                    Properties resProp = new Properties();
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)O365AbstractListener.this.tenantId, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String message = O365AbstractListener.this.modifyUser(objectId, "ObjectId", audit_info, auditDataObj, userProp);
                    try {
                        JSONObject json = new JSONObject(message);
                        Properties updateProp = new Properties();
                        for (Properties p : O365AbstractListener.this.attribDetails) {
                            String colName = (String)p.get("ATTRIB_COLUMN_NAME");
                            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                            if (!json.has(ldapName)) continue;
                            updateProp.put(colName, json.getString(ldapName));
                        }
                        message = "admp.mgmt.common.statmsg.successfully_modified";
                        auditObjectIdList.add(object_id);
                        resProp = O365AbstractListener.this.updateStatus(updateProp, message);
                    }
                    catch (Exception e) {
                        if (!O365AbstractListener.this.informationStrings.contains(message)) {
                            isAllObjectsSucceeded = false;
                        }
                        message = message.replaceAll("\"", "");
                        message = message.replaceAll("'", "");
                        resProp = O365AbstractListener.this.updateStatus(userProp, message);
                    }
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("ADSMModifyUserResult");
                    row.set("OBJECT_GUID", (Object)objectId);
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, new Hashtable(), O365AbstractListener.this.loginId, O365AbstractListener.this.reportId, O365AbstractListener.this.tenantId, O365AbstractListener.this.rb, null);
                }
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ModifyCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        boolean connectToOffice365 = false;
        Long userCreationID;
        String hostId;

        public ModifyCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, boolean connectToOffice365, Long userCreationID, String hostId) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.connectToOffice365 = connectToOffice365;
            this.userCreationID = userCreationID;
            this.hostId = hostId;
            O365AbstractListener.this.isCsvMgmt = true;
        }

        public void setActionDetails() {
        }

        @Override
        public void run() {
            try {
                String[] mandatoryLdapAttrNames = new String[]{"UserPrincipalName", "ObjectId", "PrimarySmtpAddress"};
                String[] nativeParamNames = new String[]{"UserPrincipalName", "ObjectId", "PrimarySmtpAddress"};
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (attr.equalsIgnoreCase("ObjectId")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17001"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (attr.equalsIgnoreCase("EmailAddress")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17031"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList userDetails = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit, true);
                O365AbstractListener.this.checkAuthorization(userDetails, O365AbstractListener.this.tenantId);
                if (this.connectToOffice365) {
                    Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                    domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                    ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                    O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                    String connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd);
                    if (connectionMsg != null && connectionMsg.trim().length() > 0) {
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(connectionMsg);
                        statusUpdater.setIsCompleted(true);
                        O365AbstractListener.this.isCompleted = true;
                        return;
                    }
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < userDetails.size() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    Hashtable hashtable = (Hashtable)userDetails.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    String mandatoryAttrVal = "";
                    String nativeParamName = "";
                    boolean foundReqVal = false;
                    boolean isAuthorized = true;
                    block4: for (int m = 0; m < mandatoryLdapAttrNames.length && !foundReqVal; ++m) {
                        String reqLdapName = mandatoryLdapAttrNames[m];
                        for (Hashtable hashtable1 : valuesList) {
                            String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                            String ldapVal = (String)hashtable1.get("ATTRIB_VALUE");
                            if (hashtable1.containsKey("IS_AUTHORIZED")) {
                                boolean bl = isAuthorized = isAuthorized && (Boolean)hashtable1.get("IS_AUTHORIZED") != false;
                            }
                            if (!reqLdapName.equals(ldapName) || ldapVal == null || ldapVal.length() <= 0) continue;
                            mandatoryAttrVal = ldapVal;
                            nativeParamName = nativeParamNames[m];
                            foundReqVal = true;
                            continue block4;
                        }
                    }
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)mandatoryAttrVal, (String)O365AbstractListener.this.tenantId, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String message = "";
                    message = !foundReqVal ? "admp.mgmt.o365.error.upn_or_objectid_is_must" : (!isAuthorized ? "admp.mgmt.o365.error.csv_user_not_authorized" : O365AbstractListener.this.modifyUser(mandatoryAttrVal, nativeParamName, audit_info, auditDataObj, hashtable));
                    if (message == null || message.trim().length() == 0) {
                        message = "admp.mgmt.common.statmsg.successfully_modified";
                        auditObjectIdList.add(object_id);
                    } else if (!O365AbstractListener.this.informationStrings.contains(message)) {
                        isAllObjectsSucceeded = false;
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", O365AbstractListener.this.rb.getString(message));
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(O365AbstractListener.this.rb, prop);
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, O365AbstractListener.this.rb.getString(message));
                    Thread.sleep(5000L);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, new Hashtable(), O365AbstractListener.this.loginId, O365AbstractListener.this.reportId, O365AbstractListener.this.tenantId, O365AbstractListener.this.rb, null);
                }
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ModifyMailAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        boolean connectToOffice365 = false;
        String hostId;

        public ModifyMailAction(long generationId, JSONArray selectedUsersList, boolean connectToOffice365, String hostId) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.connectToOffice365 = connectToOffice365;
            this.hostId = hostId;
            O365AbstractListener.this.isCsvMgmt = false;
        }

        @Override
        public void run() {
            try {
                String connectionMsg;
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ArrayList attribToSelect = new ArrayList();
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Hashtable userDetails = O365MgmtHandler.getWAADUserDetailss((ArrayList)O365AbstractListener.this.attribDetails, null, (String[])objectIdArr);
                objectIdArr = null;
                Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                if (this.connectToOffice365 && (connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd)) != null && connectionMsg.trim().length() > 0) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(connectionMsg);
                    statusUpdater.setIsCompleted(true);
                    O365AbstractListener.this.isCompleted = true;
                    return;
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    String message;
                    String objectId = this.selectedUsersList.getString(i);
                    Properties userProp = (Properties)userDetails.get(objectId);
                    String objName = userProp.getProperty("USER_PRINCIPAL_NAME");
                    if (userProp.get("SEND_ON_BEHALF") == null) {
                        userProp.put("SEND_ON_BEHALF", "-");
                    }
                    if (userProp.get("SEND_AS") == null) {
                        userProp.put("SEND_AS", "-");
                    }
                    if (userProp.get("FULL_PERMISSION") == null) {
                        userProp.put("FULL_PERMISSION", "-");
                    }
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)O365AbstractListener.this.tenantId, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    userProp.put("Password", O365AbstractListener.this.tenantPwd);
                    String exMessgae = message = O365AbstractListener.this.modifyUser(objectId, "ObjectId", audit_info, auditDataObj, userProp);
                    Properties resProp = new Properties();
                    try {
                        JSONObject json = new JSONObject(message);
                        Properties updateProp = new Properties();
                        boolean valuePresent = false;
                        for (Properties p : O365AbstractListener.this.attribDetails) {
                            String colName = (String)p.get("ATTRIB_COLUMN_NAME");
                            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                            if (ldapName.equalsIgnoreCase("SendAs") || ldapName.equalsIgnoreCase("GrantSendOnBehalfTo") || ldapName.equalsIgnoreCase("FullPermission")) {
                                JSONArray jsonArray = new JSONArray();
                                if (json.has(ldapName)) {
                                    jsonArray = json.getJSONArray(ldapName);
                                    String val = "";
                                    for (int ii = 0; ii < jsonArray.length(); ++ii) {
                                        val = ii != 0 ? val + "," + jsonArray.getString(ii) : jsonArray.getString(ii);
                                    }
                                    if (val.length() > 20) {
                                        val = val.substring(0, 20) + "...";
                                    }
                                    updateProp.put(colName, val);
                                    valuePresent = true;
                                    continue;
                                }
                                updateProp.put(colName, "-");
                                continue;
                            }
                            if (json.has(ldapName)) {
                                updateProp.put(colName, json.getString(ldapName));
                                valuePresent = true;
                                continue;
                            }
                            updateProp.put(colName, "-");
                        }
                        if (valuePresent) {
                            message = "admp.mgmt.common.statmsg.successfully_modified";
                            auditObjectIdList.add(object_id);
                        } else {
                            isAllObjectsSucceeded = false;
                        }
                        resProp = O365AbstractListener.this.updateStatus(updateProp, message);
                    }
                    catch (Exception e) {
                        message = exMessgae;
                        isAllObjectsSucceeded = false;
                        resProp = O365AbstractListener.this.updateStatus(userProp, message);
                    }
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("ADSMModifyUserResult");
                    row.set("OBJECT_GUID", (Object)objectId);
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ModifyMailCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        boolean connectToOffice365 = false;
        Long userCreationID;
        String hostId;

        public ModifyMailCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, boolean connectToOffice365, Long userCreationID, String hostId) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.connectToOffice365 = connectToOffice365;
            this.userCreationID = userCreationID;
            this.hostId = hostId;
            O365AbstractListener.this.isCsvMgmt = true;
        }

        public void setActionDetails() {
        }

        @Override
        public void run() {
            try {
                String[] mandatoryLdapAttrNames = new String[]{"UserPrincipalName", "ObjectId"};
                String[] nativeParamNames = new String[]{"UserPrincipalName", "ObjectId"};
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (attr.equalsIgnoreCase("ObjectId")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17001"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList userDetails = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit, true);
                O365AbstractListener.this.checkAuthorization(userDetails, O365AbstractListener.this.tenantId);
                if (this.connectToOffice365) {
                    Criteria domainCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)O365AbstractListener.this.tenantId, 0);
                    domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)OFFICE_365_APPID, 0));
                    ArrayList credentials = O365MgmtHandler.getO365Credentials((Criteria)domainCrit);
                    O365AbstractListener.this.tenantPwd = ((Properties)credentials.get(0)).getProperty("WAAD_TENANT_PASSWD");
                    String connectionMsg = ADHandler.connectPowershellService((String)O365AbstractListener.this.tenantId, (String)O365AbstractListener.this.tenantPwd);
                    if (connectionMsg != null && connectionMsg.trim().length() > 0) {
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                        ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(connectionMsg);
                        statusUpdater.setIsCompleted(true);
                        O365AbstractListener.this.isCompleted = true;
                        return;
                    }
                }
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < userDetails.size() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    Hashtable hashtable = (Hashtable)userDetails.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    String mandatoryAttrVal = "";
                    String nativeParamName = "";
                    boolean foundReqVal = false;
                    block6: for (int m = 0; m < mandatoryLdapAttrNames.length && !foundReqVal; ++m) {
                        String reqLdapName = mandatoryLdapAttrNames[m];
                        for (Hashtable hashtable1 : valuesList) {
                            String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                            String ldapVal = (String)hashtable1.get("ATTRIB_VALUE");
                            if (!reqLdapName.equals(ldapName) || ldapVal == null || ldapVal.length() <= 0) continue;
                            mandatoryAttrVal = ldapVal;
                            nativeParamName = nativeParamNames[m];
                            foundReqVal = true;
                            continue block6;
                        }
                    }
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)mandatoryAttrVal, (String)O365AbstractListener.this.tenantId, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    audit_info.put("object_name", mandatoryAttrVal);
                    String message = "";
                    message = !foundReqVal ? "admp.mgmt.o365.error.upn_or_objectid_is_must" : O365AbstractListener.this.modifyUser(mandatoryAttrVal, nativeParamName, audit_info, auditDataObj, hashtable);
                    try {
                        JSONObject json = new JSONObject(message);
                        Properties updateProp = new Properties();
                        boolean exception = true;
                        for (Properties p : O365AbstractListener.this.attribDetails) {
                            String colName = (String)p.get("ATTRIB_COLUMN_NAME");
                            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                            if (ldapName.equalsIgnoreCase("ObjectId")) {
                                ldapName = "ExternalDirectoryObjectId";
                            }
                            if (!json.has(ldapName)) continue;
                            updateProp.put(colName, json.getString(ldapName));
                            exception = false;
                        }
                        if (exception) {
                            throw new Exception(message);
                        }
                        message = "admp.mgmt.common.statmsg.successfully_modified";
                        auditObjectIdList.add(object_id);
                    }
                    catch (Exception e) {
                        isAllObjectsSucceeded = false;
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", O365AbstractListener.this.rb.getString(message));
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(O365AbstractListener.this.rb, prop);
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, O365AbstractListener.this.rb.getString(message));
                    Thread.sleep(5000L);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class RemoteAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        String hostId;
        String adDomain;
        String o365SelectedDomain;
        boolean update = false;

        public RemoteAction(long generationId, JSONArray selectedUsersList, String hostId, String o365SelectedDomain, String adDomain, boolean update) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.hostId = hostId;
            this.adDomain = adDomain;
            this.o365SelectedDomain = o365SelectedDomain;
            O365AbstractListener.this.isCsvMgmt = false;
            this.update = update;
        }

        @Override
        public void run() {
            try {
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ArrayList<String> attribToSelect = new ArrayList<String>();
                attribToSelect.add("OBJECT_GUID");
                attribToSelect.add("LOGON_NAME");
                attribToSelect.add("FOLDER");
                attribToSelect.add("SAM_ACCOUNT_NAME");
                attribToSelect.add("DISTINGUISHED_NAME");
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Hashtable userDetails = O365MgmtHandler.getWAADRemoteUserDetails(attribToSelect, null, (String[])objectIdArr);
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.adDomain, null, (Long)O365AbstractListener.this.loginId);
                objectIdArr = null;
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length() && (O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= O365AbstractListener.this.licensedCount); ++i) {
                    String objectGuid = this.selectedUsersList.getString(i);
                    Properties userProp = (Properties)userDetails.get(objectGuid);
                    String objName = "";
                    Properties updateProp = new Properties();
                    updateProp.put("STATUS", "FAIL");
                    updateProp.put("LOGON_NAME", "-");
                    updateProp.put("SAM_ACCOUNT_NAME", "-");
                    updateProp.put("FOLDER", "-");
                    String samAccountName = "";
                    String ouName = "";
                    if (userProp.getProperty("LOGON_NAME") != null) {
                        objName = userProp.getProperty("LOGON_NAME");
                        updateProp.put("LOGON_NAME", objName);
                    }
                    if (userProp.getProperty("SAM_ACCOUNT_NAME") != null) {
                        samAccountName = userProp.getProperty("SAM_ACCOUNT_NAME");
                        updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                    }
                    if (userProp.getProperty("FOLDER") != null) {
                        ouName = userProp.getProperty("FOLDER");
                        updateProp.put("FOLDER", ouName);
                    }
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)this.adDomain, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    if (userProp.getProperty("DISTINGUISHED_NAME") != null) {
                        audit_info.put("DISTINGUISHED_NAME", userProp.getProperty("DISTINGUISHED_NAME"));
                    }
                    String message = "";
                    String objectId = "";
                    try {
                        message = O365AbstractListener.this.modifyUser(objectGuid, "ObjectGuid", audit_info, auditDataObj, exchangeServerDetails);
                        if (message.length() == 0) {
                            isAllObjectsSucceeded = true;
                            message = "admp.mgmt.common.statmsg.successfully_modified";
                            if (this.update) {
                                UpdateQueryImpl uq = new UpdateQueryImpl("ADSMMailBoxObjects");
                                Criteria crit = new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"RECIPIENT_TYPE"), (Object)"2147483648", 0);
                                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                                uq.setCriteria(crit);
                                uq.setUpdateColumn("RECIPIENT_TYPE", (Object)"-1");
                                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)uq);
                            }
                        } else {
                            isAllObjectsSucceeded = false;
                        }
                        updateProp = new Properties();
                        updateProp.put("LOGON_NAME", objName);
                        updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                        updateProp.put("FOLDER", ouName);
                        updateProp.put("STATUS", "SUCCESS");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        isAllObjectsSucceeded = false;
                    }
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties resProp = O365AbstractListener.this.updateStatus(updateProp, message);
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("WAADCreateUserResult");
                    row.set("OBJECT_GUID", (Object)objectGuid);
                    row.set("OBJECT_ID", (Object)objectId);
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class RemoteCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        Long userCreationID;
        String hostId;
        String o365SelectedDomain;
        String adDomain;
        JSONArray authOUList;
        boolean update = false;

        public RemoteCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, Long userCreationID, String hostId, String o365SelectedDomain, String adDomain, JSONArray authOUList, boolean update) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.userCreationID = userCreationID;
            this.hostId = hostId;
            this.o365SelectedDomain = o365SelectedDomain;
            this.adDomain = adDomain;
            this.authOUList = authOUList;
            O365AbstractListener.this.isCsvMgmt = true;
            this.update = update;
        }

        public void setActionDetails() {
        }

        @Override
        public void run() {
            try {
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                String uniqueValueParamName = new String();
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                int priority = 4;
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName") && priority > 0) {
                        uniqueValueParamName = "LOGON_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4012"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 0;
                    } else if (attr.equalsIgnoreCase("ObjectGuid") && priority > 2) {
                        uniqueValueParamName = "OBJECT_GUID";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 2;
                    } else if (attr.equalsIgnoreCase("SamAccountName") && priority > 3) {
                        uniqueValueParamName = "SAM_ACCOUNT_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4014"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 3;
                    } else if (attr.equalsIgnoreCase("DistinguishedName") && priority > 1) {
                        uniqueValueParamName = "DISTINGUISHED_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4013"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 1;
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList user = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit);
                Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.adDomain, null, (Long)O365AbstractListener.this.loginId);
                String[] selectedUsers = new String[user.size()];
                for (int index = 0; index < user.size(); ++index) {
                    Hashtable hashtab = (Hashtable)user.get(index);
                    ArrayList hashtab1 = (ArrayList)hashtab.get("USER_VALUES");
                    for (int i = 0; i < hashtab1.size(); ++i) {
                        Hashtable temp = (Hashtable)hashtab1.get(i);
                        if (!uniqueValueParamName.equalsIgnoreCase((String)temp.get("ATTRIB_COLUMN_NAME"))) continue;
                        selectedUsers[index] = (String)temp.get("ATTRIB_VALUE");
                        break;
                    }
                    if (!uniqueValueParamName.equalsIgnoreCase("OBJECT_GUID") || selectedUsers[index].charAt(0) == '{') continue;
                    selectedUsers[index] = "{" + selectedUsers[index].concat("}");
                }
                ArrayList<String> attribToSelect = new ArrayList<String>();
                attribToSelect.add("OBJECT_GUID");
                attribToSelect.add("LOGON_NAME");
                attribToSelect.add("SAM_ACCOUNT_NAME");
                attribToSelect.add("DISTINGUISHED_NAME");
                attribToSelect.add("FOLDER");
                Hashtable userDetails = O365MgmtHandler.getWAADADSMRemoteUserDetails(attribToSelect, (String[])selectedUsers, (String)this.o365SelectedDomain, (String)this.adDomain, (String)uniqueValueParamName, (JSONArray)this.authOUList);
                O365AbstractListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(O365AbstractListener.this.getObjIdList(), O365AbstractListener.this.attributeListHash);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)O365AbstractListener.this.loginId, (String)this.hostId, (Integer)O365AbstractListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)O365AbstractListener.this.rb, (String)O365AbstractListener.this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
                boolean isAllObjectsSucceeded = true;
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < selectedUsers.length; ++i) {
                    Hashtable<String, Object> audit_info;
                    ArrayList valuesList;
                    Long userIndex;
                    String message;
                    block22: {
                        message = new String();
                        if (!O365AbstractListener.this.noOfObjects.equalsIgnoreCase("unlimited") && i + 1 > O365AbstractListener.this.licensedCount) break;
                        Hashtable hashtable = (Hashtable)user.get(i);
                        userIndex = (Long)hashtable.get("USER_INDEX");
                        valuesList = (ArrayList)hashtable.get("USER_VALUES");
                        String uniqueValue = selectedUsers[i];
                        audit_info = new Hashtable<String, Object>();
                        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)uniqueValue, (String)this.adDomain, (DataObject)auditDataObj);
                        audit_info.put("object_id", object_id);
                        try {
                            Properties userProp = (Properties)userDetails.get(uniqueValue.toLowerCase());
                            if (userProp.getProperty("DISTINGUISHED_NAME") != null) {
                                audit_info.put("DISTINGUISHED_NAME", userProp.getProperty("DISTINGUISHED_NAME"));
                            }
                            try {
                                message = O365AbstractListener.this.modifyUser(uniqueValue, uniqueValueParamName, audit_info, auditDataObj, exchangeServerDetails);
                                if (message.length() == 0) {
                                    isAllObjectsSucceeded = true;
                                    message = "admp.mgmt.common.statmsg.successfully_modified";
                                    if (this.update) {
                                        UpdateQueryImpl uq = new UpdateQueryImpl("ADSMMailBoxObjects");
                                        Criteria critt = new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"RECIPIENT_TYPE"), (Object)"2147483648", 0);
                                        critt = critt.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)uniqueValueParamName), (Object)uniqueValue, 0));
                                        uq.setCriteria(critt);
                                        uq.setUpdateColumn("RECIPIENT_TYPE", (Object)"-1");
                                        CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)uq);
                                    }
                                    break block22;
                                }
                                isAllObjectsSucceeded = false;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                isAllObjectsSucceeded = false;
                            }
                        }
                        catch (NullPointerException e) {
                            message = "admp.mgmt.common.statmsg.cannot_retrieve_object_does_not_exist_or_access_denied";
                        }
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", O365AbstractListener.this.rb.getString(message));
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(O365AbstractListener.this.rb, prop);
                    audit_info.put("error_msg", O365AbstractListener.this.rb.getString(message));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, O365AbstractListener.this.rb.getString(message));
                }
                O365AbstractListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                O365AbstractListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)O365AbstractListener.this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

