/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class O365BulkCreateUserMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    boolean isAuthorised = false;
    String usageLocation = "-";
    String country = "-";
    String newPassword = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    String o365SelectedDomain = "";
    String adDomain = "";

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_CRT_USER_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.isAuthorised = this.isAuthorized(tenantId, request);
            if (inputJsonObj.has("usageLocation")) {
                this.usageLocation = inputJsonObj.getString("usageLocation");
                this.country = inputJsonObj.getString("country");
            }
            JSONArray authOUList = new JSONArray();
            if (inputJsonObj.has("authOUList")) {
                authOUList = (JSONArray)inputJsonObj.get("authOUList");
            }
            if (inputJsonObj.has("password")) {
                this.newPassword = inputJsonObj.getString("password");
            } else {
                PasswordPolicy pwdPolicy = new PasswordPolicy();
                pwdPolicy.setPolicyDetails();
                this.newPassword = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
            }
            if (inputJsonObj.has("o365SelectedDomain")) {
                this.o365SelectedDomain = inputJsonObj.getString("o365SelectedDomain");
            }
            this.adDomain = inputJsonObj.getString("adDomain");
            JSONArray licArray = inputJsonObj.getJSONArray("Licenses");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < licArray.length(); ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                JSONObject licJson = licArray.getJSONObject(i);
                Properties curLicense = new Properties();
                curLicense.put("AccountSku", licJson.getString("ACCOUNT_SKU_ID"));
                sb.append(rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)licJson.getString("ACCOUNT_SKU_ID"))));
                JSONArray spArray = licJson.getJSONArray("ServicePlans");
                String disabledPlans = new String();
                ArrayList<String> selectedPlans = new ArrayList<String>();
                for (int j = 0; j < spArray.length(); ++j) {
                    JSONObject spJson = spArray.getJSONObject(j);
                    if (spJson.getBoolean("IS_DISABLED")) {
                        if (disabledPlans.length() == 0) {
                            disabledPlans = spJson.getString("SERVICE_NAME");
                            continue;
                        }
                        disabledPlans = disabledPlans.concat("," + spJson.getString("SERVICE_NAME"));
                        continue;
                    }
                    selectedPlans.add(rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)spJson.getString("SERVICE_NAME"))));
                }
                if (disabledPlans != null && disabledPlans.length() != 0) {
                    sb.append(selectedPlans);
                }
                O365InfoCache.getInstance();
                if (O365InfoCache.getInstalledModule().equalsIgnoreCase("AzureAD") && disabledPlans != null && disabledPlans.length() != 0) {
                    String[] planList = disabledPlans.split(",");
                    Properties licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(licJson.getString("ACCOUNT_SKU_ID"));
                    HashMap serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                    disabledPlans = "";
                    for (int j = 0; j < planList.length; ++j) {
                        String serviceName = planList[j];
                        if (disabledPlans.length() > 0) {
                            disabledPlans = disabledPlans + ",";
                        }
                        disabledPlans = disabledPlans + (String)serviceNameVsPlanId.get(serviceName);
                    }
                }
                curLicense.put("DisabledPlans", disabledPlans);
                this.licenseDetails.add(curLicense);
            }
            Properties licProp = new Properties();
            licProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.reports.o365.Licenses"));
            licProp.put("ATTRIB_VALUE", sb.toString());
            this.auditPropList.add(licProp);
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            Properties auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.waad_bulk_mgmt"));
            auditProp.put("ATTRIB_VALUE", rb.getString("admp.mgmt.user_mgmt.cre_single_user.button_create_user"));
            this.auditPropList.add(auditProp);
            auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.usage_location"));
            auditProp.put("ATTRIB_VALUE", this.country);
            this.auditPropList.add(auditProp);
            auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.password"));
            auditProp.put("ATTRIB_VALUE", this.newPassword);
            this.auditPropList.add(auditProp);
            auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.o365.o365_domain"));
            auditProp.put("ATTRIB_VALUE", this.o365SelectedDomain);
            this.auditPropList.add(auditProp);
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                action = new O365AbstractListener.CreateAction(generationId, selectedUsersList, true, request.getRemoteHost(), this.newPassword, this.usageLocation, this.o365SelectedDomain, this.adDomain);
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.CreateCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost(), this.newPassword, this.usageLocation, this.o365SelectedDomain, this.adDomain, authOUList);
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_CRT_USER_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                if (this.isAuthorised) {
                    result = ADHandler.createO365UserFromADUser((String)this.tenantId, (String)this.tenantPwd, (Object)userDetail, this.licenseDetails, (ArrayList)this.attributeList, (NativeListener)this);
                    try {
                        JSONObject json = new JSONObject(result);
                        ArrayList<Object> addedLicenseList = new ArrayList<Object>();
                        for (int i = 0; i < this.licenseDetails.size(); ++i) {
                            addedLicenseList.add(this.licenseDetails.get(i).get("AccountSku"));
                        }
                        O365InfoCache.getInstance().updateLicenseConsumptionData(addedLicenseList, "add");
                        TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.create_user"), objName, this.adDomain, this.auditPropList, new ArrayList(), new ArrayList(), this.rb.getString("admp.mgmt.common.statmsg.successfully_created"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                        return result;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.create_user"), objName, this.adDomain, this.auditPropList, new ArrayList(), new ArrayList(), result, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.getProperty("STATUS").equalsIgnoreCase("SUCCESS")) {
            resProp.put((Object)302, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
            resProp.put((Object)708, statusMessage);
        } else {
            resProp.put((Object)302, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)701, userProp.getProperty("LOGON_NAME"));
            resProp.put((Object)703, "-");
            resProp.put((Object)708, statusMessage);
        }
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41013L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }
}

