/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365BulkLicenseMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    int operationId;
    boolean isAuthorised = false;
    String usageLocation = "";
    String country = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    ArrayList<String> servicePlanNames = new ArrayList();
    boolean isCsvImport = false;
    ArrayList<Properties> authorizedLicenseDetails = new ArrayList();

    public O365BulkLicenseMgmtListener() {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMWAADServicePlanDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"UNIQUE_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"SERVICE_NAME"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMWAADServicePlanDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    this.servicePlanNames.add((String)r.get("SERVICE_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            Properties licenseProp;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_LIC_MGMT_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.operationId = inputJsonObj.getInt("operationId");
            this.isAuthorised = this.isAuthorized(this.operationId, tenantId, request);
            ADMPAuthObject authObj = (ADMPAuthObject)request.getSession().getAttribute("ADMP_AUTH_OBJECT");
            Hashtable iamAppAccountDetails = authObj.getAuthorizedIamAppAccountDetails(tenantId, 3);
            Hashtable skuIdsVsServices = (Hashtable)iamAppAccountDetails.get("SelectedLicenseServiceHash");
            Hashtable skuIdsVsCountDetails = (Hashtable)iamAppAccountDetails.get("SelectedLicenseServiceCountHash");
            Hashtable skuIdsVsUnAuthorizedServices = new Hashtable();
            this.authorizedLicenseDetails = new ArrayList();
            O365InfoCache.getInstance();
            String moduleName = O365InfoCache.getInstalledModule();
            HashMap serviceNameVsPlanId = new HashMap();
            if (skuIdsVsServices != null) {
                Enumeration skuIds = skuIdsVsServices.keys();
                while (skuIds.hasMoreElements()) {
                    Properties skuIdDetails = new Properties();
                    String skuId = (String)skuIds.nextElement();
                    Hashtable countDetails = (Hashtable)skuIdsVsCountDetails.get(skuId);
                    if (((Boolean)countDetails.get("NoServicesSelected")).booleanValue()) continue;
                    skuIdDetails.put("LicenseName", skuId);
                    Hashtable selectedServicesHash = (Hashtable)skuIdsVsServices.get(skuId);
                    if (moduleName.equalsIgnoreCase("AzureAD")) {
                        licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(skuId);
                        serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                    }
                    Enumeration services = selectedServicesHash.keys();
                    ArrayList<Object> authorizedServices = new ArrayList<Object>();
                    while (services.hasMoreElements()) {
                        String service = (String)services.nextElement();
                        if (((Boolean)selectedServicesHash.get(service)).booleanValue()) {
                            if (moduleName.equalsIgnoreCase("AzureAD")) {
                                authorizedServices.add(serviceNameVsPlanId.get(service));
                                continue;
                            }
                            authorizedServices.add(service);
                            continue;
                        }
                        ArrayList<Object> unAuthorizedServices = (ArrayList<Object>)skuIdsVsUnAuthorizedServices.get(skuId);
                        if (unAuthorizedServices == null) {
                            unAuthorizedServices = new ArrayList<Object>();
                            skuIdsVsUnAuthorizedServices.put(skuId, unAuthorizedServices);
                        }
                        if (unAuthorizedServices.contains(service)) continue;
                        if (moduleName.equalsIgnoreCase("AzureAD")) {
                            unAuthorizedServices.add(serviceNameVsPlanId.get(service));
                            continue;
                        }
                        unAuthorizedServices.add(service);
                    }
                    skuIdDetails.put("ServicePlans", authorizedServices);
                    this.authorizedLicenseDetails.add(skuIdDetails);
                }
            }
            if (inputJsonObj.has("usageLocation")) {
                this.usageLocation = inputJsonObj.getString("usageLocation");
                this.country = inputJsonObj.getString("country");
            }
            JSONArray licArray = inputJsonObj.getJSONArray("Licenses");
            for (int i = 0; i < licArray.length(); ++i) {
                ArrayList unAuthorizedServices;
                Properties curSp;
                JSONObject spJson;
                int j;
                JSONObject licJson = licArray.getJSONObject(i);
                Properties curLicense = new Properties();
                String skuId = licJson.getString("ACCOUNT_SKU_ID");
                if (moduleName.equalsIgnoreCase("AzureAD")) {
                    licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(skuId);
                    serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                }
                curLicense.put("LicenseName", skuId);
                JSONArray spArray = licJson.getJSONArray("ServicePlans");
                ArrayList<Properties> spDetails = new ArrayList<Properties>();
                if (moduleName.equalsIgnoreCase("AzureAD")) {
                    for (j = 0; j < spArray.length(); ++j) {
                        spJson = spArray.getJSONObject(j);
                        curSp = new Properties();
                        curSp.put("ServicePlanName", serviceNameVsPlanId.get(spJson.getString("SERVICE_NAME")));
                        curSp.put("TargetClass", spJson.getString("TYPE"));
                        curSp.put("IsDisabled", (Object)spJson.getBoolean("IS_DISABLED"));
                        spDetails.add(curSp);
                    }
                } else {
                    for (j = 0; j < spArray.length(); ++j) {
                        spJson = spArray.getJSONObject(j);
                        curSp = new Properties();
                        curSp.put("ServicePlanName", spJson.getString("SERVICE_NAME"));
                        curSp.put("TargetClass", spJson.getString("TYPE"));
                        curSp.put("IsDisabled", (Object)spJson.getBoolean("IS_DISABLED"));
                        spDetails.add(curSp);
                    }
                }
                if ((unAuthorizedServices = (ArrayList)skuIdsVsUnAuthorizedServices.get(skuId)) != null) {
                    for (String service : unAuthorizedServices) {
                        Properties curSp2 = new Properties();
                        curSp2.put("ServicePlanName", service);
                        curSp2.put("TargetClass", "User");
                        curSp2.put("IsDisabled", (Object)true);
                        spDetails.add(curSp2);
                    }
                }
                curLicense.put("ServicePlans", spDetails);
                this.licenseDetails.add(curLicense);
            }
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            ArrayList<String> infoStrings = new ArrayList<String>();
            infoStrings.add("admp.mgmt.o365.error.specified_lic_already_assigned");
            infoStrings.add("admp.mgmt.o365.error.no_lic_are_present_to_be_removed");
            infoStrings.add("admp.mgmt.o365.error.specified_lic_already_not_assigned");
            this.informationStrings = infoStrings;
            String operation = "";
            switch (this.operationId) {
                case 1: {
                    operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_add_to_existing");
                    break;
                }
                case 2: {
                    operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_replace_existing");
                    break;
                }
                case 3: {
                    operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_revoke_selected_lic");
                    break;
                }
                case 4: {
                    operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_revoke_all");
                }
            }
            if (this.operationId != 4) {
                StringBuilder sb = new StringBuilder();
                for (Properties prop : this.licenseDetails) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)prop.getProperty("LicenseName"))));
                    ArrayList spDetails = (ArrayList)prop.get("ServicePlans");
                    ArrayList<String> selectedServPlanList = new ArrayList<String>();
                    for (Properties spProp : spDetails) {
                        if (((Boolean)spProp.get("IsDisabled")).booleanValue()) continue;
                        selectedServPlanList.add(rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)spProp.getProperty("ServicePlanName"))));
                    }
                    if (spDetails.size() == selectedServPlanList.size()) continue;
                    sb.append(selectedServPlanList.toString());
                }
                Properties licProp = new Properties();
                licProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.reports.o365.Licenses"));
                licProp.put("ATTRIB_VALUE", sb.toString());
                this.auditPropList.add(licProp);
            }
            Properties operationProp = new Properties();
            operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt"));
            operationProp.put("ATTRIB_VALUE", operation);
            this.auditPropList.add(operationProp);
            if (this.country.length() != 0) {
                operationProp = new Properties();
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.usage_location"));
                operationProp.put("ATTRIB_VALUE", this.country);
                this.auditPropList.add(operationProp);
            }
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                this.isCsvImport = true;
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.ModifyCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_LIC_MGMT_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        if (uniqueValueNativeParamName.equalsIgnoreCase("PrimarySmtpAddress")) {
            String userPrincipalName = "";
            try {
                Criteria crit = new Criteria(new Column("O365UserGeneralDetails", "EMAIL_ADDRESS"), (Object)uniqueValue, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("O365UserGeneralDetails", crit);
                if (!dataObj.isEmpty()) {
                    Row r = dataObj.getFirstRow("O365UserGeneralDetails");
                    userPrincipalName = (String)r.get("USER_PRINCIPAL_NAME");
                }
                if (userPrincipalName == null || userPrincipalName.equals("")) {
                    return "admp.mgmt.office365.assign_revoke_licenses.email_address_error";
                }
                uniqueValueNativeParamName = "UserPrincipalName";
                uniqueValue = userPrincipalName;
                O365InfoCache.getInstance();
                if (O365InfoCache.getInstalledModule().equalsIgnoreCase("AzureAD") && uniqueValueNativeParamName.equalsIgnoreCase("UserPrincipalName")) {
                    uniqueValueNativeParamName = "ObjectId";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                ArrayList existingLicenseList = O365MgmtHandler.getExistingLicensesForUser((String)uniqueValue);
                if (this.isAuthorised) {
                    result = ADHandler.updateO365Licenses((String)this.tenantId, (String)this.tenantPwd, (String)uniqueValue, (int)this.operationId, (String)this.usageLocation, this.licenseDetails, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName, this.authorizedLicenseDetails);
                    if (result != null && result.length() > 0) {
                        result = this.getResultString(result);
                    } else {
                        int k;
                        ArrayList<Object> selectedLicenseList = new ArrayList<Object>();
                        for (int i = 0; i < this.licenseDetails.size(); ++i) {
                            selectedLicenseList.add(this.licenseDetails.get(i).get("LicenseName"));
                        }
                        if (this.operationId == 1) {
                            for (k = 0; k < existingLicenseList.size(); ++k) {
                                selectedLicenseList.remove((String)existingLicenseList.get(k));
                            }
                            O365InfoCache.getInstance().updateLicenseConsumptionData(selectedLicenseList, "add");
                        } else if (this.operationId == 2) {
                            O365InfoCache.getInstance().updateLicenseConsumptionData(existingLicenseList, "remove");
                            O365InfoCache.getInstance().updateLicenseConsumptionData(selectedLicenseList, "add");
                        } else if (this.operationId == 3) {
                            for (k = 0; k < selectedLicenseList.size(); ++k) {
                                if (existingLicenseList.contains((String)selectedLicenseList.get(k))) continue;
                                selectedLicenseList.remove(k);
                                --k;
                            }
                            O365InfoCache.getInstance().updateLicenseConsumptionData(selectedLicenseList, "remove");
                        } else {
                            O365InfoCache.getInstance().updateLicenseConsumptionData(existingLicenseList, "remove");
                        }
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String statusMsg = CommonUtil.getStatusMsgForO365Actions((String)result, (AdventNetResourceBundle)this.rb);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtdesc.assign_revoke_licenses"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (json.has("friendlyErrorMsg")) {
                    result = json.getString("friendlyErrorMsg");
                    if (json.getBoolean("scanErrorMsg")) {
                        for (int i = 0; i < this.servicePlanNames.size(); ++i) {
                            String curServicePlan = this.servicePlanNames.get(i);
                            result = result.replaceAll(curServicePlan, this.rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)curServicePlan)));
                        }
                    }
                } else if (this.isCsvImport) {
                    result = "";
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.containsKey("USER_PRINCIPAL_NAME")) {
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        } else {
            resProp.put((Object)701, "-");
        }
        if (userProp.containsKey("DISPLAY_NAME")) {
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
        } else {
            resProp.put((Object)703, "-");
        }
        if (userProp.containsKey("USAGE_LOCATION")) {
            resProp.put((Object)706, userProp.getProperty("USAGE_LOCATION"));
        } else {
            resProp.put((Object)706, "-");
        }
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(int operationId, String tenantId, HttpServletRequest request) {
        Long actionId = 0L;
        switch (operationId) {
            case 1: {
                actionId = 41102L;
                break;
            }
            case 2: {
                actionId = 41103L;
                break;
            }
            case 3: {
                actionId = 41104L;
                break;
            }
            case 4: {
                actionId = 41105L;
            }
        }
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }
}

