/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365BulkLitigationHoldMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    boolean isAuthorised = false;
    ArrayList auditPropList = new ArrayList();
    boolean isLitHoldEnabled = false;
    int litHoldDays;
    boolean isCsvImport = false;

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            ArrayList infoStrings;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_LIT_HOLD_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.isLitHoldEnabled = inputJsonObj.getString("litHold").equalsIgnoreCase("enabled");
            this.litHoldDays = inputJsonObj.has("litHoldDuration") ? inputJsonObj.getInt("litHoldDuration") : -1;
            this.isAuthorised = this.isAuthorized(tenantId, request);
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            this.informationStrings = infoStrings = new ArrayList();
            String operation = "";
            operation = this.isLitHoldEnabled ? rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lit_hold_mgmt_enable") : rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lit_hold_mgmt_disable");
            String duration = "";
            if (this.litHoldDays >= 0) {
                duration = this.litHoldDays > 0 ? (this.litHoldDays > 1 ? this.litHoldDays + " days" : this.litHoldDays + " day") : "Unlimited";
                Properties durProp = new Properties();
                durProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.reports.o365.Lit_hold_duration"));
                durProp.put("ATTRIB_VALUE", duration);
                this.auditPropList.add(durProp);
            }
            Properties operationProp = new Properties();
            operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lit_hold"));
            operationProp.put("ATTRIB_VALUE", operation);
            this.auditPropList.add(operationProp);
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                this.isCsvImport = true;
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.ModifyCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_LIT_HOLD_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                if (this.isAuthorised) {
                    this.attributeList.remove("ImmutableId");
                    this.attributeList.remove("DecodedImmutableId");
                    result = ADHandler.updateO365Mbs((String)this.tenantId, (String)this.tenantPwd, (String)uniqueValue, (int)this.litHoldDays, (boolean)this.isLitHoldEnabled, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName);
                    if (result != null && result.length() > 0) {
                        result = this.getResultString(result);
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String statusMsg = CommonUtil.getStatusMsgForO365Actions((String)result, (AdventNetResourceBundle)this.rb);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.lit_hold"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (!json.has("friendlyErrorMsg")) {
                    if (this.isCsvImport) {
                        result = "";
                    }
                    return result;
                }
                result = json.getString("friendlyErrorMsg");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.containsKey("USER_PRINCIPAL_NAME")) {
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        } else {
            resProp.put((Object)701, "-");
        }
        if (userProp.containsKey("DISPLAY_NAME")) {
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
        } else {
            resProp.put((Object)703, "-");
        }
        if (userProp.containsKey("LITIGATION_HOLD")) {
            resProp.put((Object)720, userProp.getProperty("LITIGATION_HOLD"));
        } else {
            resProp.put((Object)720, "-");
        }
        if (userProp.containsKey("LITIGATION_HOLD_DURATION")) {
            resProp.put((Object)721, userProp.getProperty("LITIGATION_HOLD_DURATION"));
        } else {
            resProp.put((Object)721, "-");
        }
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41108L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }
}

