/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365EmailFrwdStrLimtsMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    int operationId;
    boolean isAuthorised = false;
    String usageLocation = "";
    String country = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    ArrayList<String> servicePlanNames = new ArrayList();
    boolean hidefromAddresslist = false;
    Integer selectedObjectsView = -1;
    String forwardCheckbox = "";
    String selectedAttributes = "";
    String forwardTo = "";
    String warningOption = "";
    String prohibitSendOption = "";
    String prohibitSendAndRecvOption = "";
    String warningSize = "";
    String prohibitSendSize = "";
    String prohibitSendAndRecvSize = "";
    String forwardToAndDeliverMailbox = "false";

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_EMAIL_STR_LIMITS_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.isAuthorised = this.isAuthorized(tenantId, request);
            this.selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            this.forwardCheckbox = inputJsonObj.getString("forwardCheckbox");
            this.selectedAttributes = inputJsonObj.getString("selectedAttributes");
            if (this.forwardCheckbox.equalsIgnoreCase("true")) {
                this.forwardTo = inputJsonObj.getString("forwardTo");
                if (this.forwardTo.equalsIgnoreCase("Both")) {
                    this.forwardTo = inputJsonObj.getString("forwardToAndDeliverMailbox");
                    this.forwardToAndDeliverMailbox = "true";
                } else {
                    this.forwardTo = inputJsonObj.getString("forwardTo");
                }
            }
            if (this.selectedAttributes.equalsIgnoreCase("true")) {
                this.warningOption = inputJsonObj.getString("warningOption");
                this.prohibitSendOption = inputJsonObj.getString("prohibitSendOption");
                this.prohibitSendAndRecvOption = inputJsonObj.getString("prohibitSendAndRecvOption");
                if (this.warningOption.equalsIgnoreCase("true")) {
                    this.warningSize = inputJsonObj.getString("warningSize");
                }
                if (this.prohibitSendOption.equalsIgnoreCase("true")) {
                    this.prohibitSendSize = inputJsonObj.getString("prohibitSendSize");
                }
                if (this.prohibitSendAndRecvOption.equalsIgnoreCase("true")) {
                    this.prohibitSendAndRecvSize = inputJsonObj.getString("prohibitSendAndRecvSize");
                }
            }
            String operation = "";
            Properties operationProp = new Properties();
            if (this.forwardCheckbox.equalsIgnoreCase("true")) {
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.forward"));
                operationProp.put("ATTRIB_VALUE", this.forwardTo);
                this.auditPropList.add(operationProp);
                if (!this.forwardTo.equalsIgnoreCase("none")) {
                    operationProp = new Properties();
                    operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.user_mgmt.cre_single_user.input_deliv_msg_both"));
                    operationProp.put("ATTRIB_VALUE", this.forwardToAndDeliverMailbox);
                    this.auditPropList.add(operationProp);
                }
            }
            if (this.selectedAttributes.equalsIgnoreCase("true")) {
                if (this.warningOption.equalsIgnoreCase("true")) {
                    operationProp = new Properties();
                    operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.warn_at_message_size_GB"));
                    operationProp.put("ATTRIB_VALUE", this.warningSize);
                    this.auditPropList.add(operationProp);
                }
                if (this.prohibitSendOption.equalsIgnoreCase("true")) {
                    operationProp = new Properties();
                    operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.prohibit_message_sending_at_GB"));
                    operationProp.put("ATTRIB_VALUE", this.prohibitSendSize);
                    this.auditPropList.add(operationProp);
                }
                if (this.prohibitSendAndRecvOption.equalsIgnoreCase("true")) {
                    operationProp = new Properties();
                    operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.prohibit_send_and_receive_message_at_GB"));
                    operationProp.put("ATTRIB_VALUE", this.prohibitSendAndRecvSize);
                    this.auditPropList.add(operationProp);
                }
            }
            Hashtable inputDetails = new Hashtable();
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (this.selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyMailAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.ModifyMailCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_EMAIL_STR_LIMITS_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (this.selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                PowerShellCommand powerShellCommand = new PowerShellCommand();
                if (this.isAuthorised) {
                    if (this.forwardCheckbox.equalsIgnoreCase("true")) {
                        powerShellCommand = new PowerShellCommand("Set-Mailbox");
                        powerShellCommand.setIdentity(uniqueValue);
                        if (this.forwardToAndDeliverMailbox.equalsIgnoreCase("true")) {
                            powerShellCommand.addParameter("DeliverToMailboxAndForward", true);
                            powerShellCommand.addParameter("ForwardingAddress", this.forwardTo);
                        } else if (this.forwardTo.equalsIgnoreCase("none")) {
                            powerShellCommand.addParameterNull("ForwardingAddress");
                        } else {
                            powerShellCommand.addParameter("DeliverToMailboxAndForward", false);
                            powerShellCommand.addParameter("ForwardingAddress", this.forwardTo);
                        }
                        powerShellCommand.addParameter("Force");
                    }
                    if (this.selectedAttributes.equalsIgnoreCase("true")) {
                        PowerShellCommand powerShellCommand1 = new PowerShellCommand("Set-Mailbox");
                        powerShellCommand1.setIdentity(uniqueValue);
                        if (this.warningOption.equalsIgnoreCase("true")) {
                            powerShellCommand1.addParameter("IssueWarningQuota", this.warningSize + "gb");
                        }
                        if (this.prohibitSendOption.equalsIgnoreCase("true")) {
                            powerShellCommand1.addParameter("ProhibitSendQuota", this.prohibitSendSize + "gb");
                        }
                        if (this.prohibitSendAndRecvOption.equalsIgnoreCase("true")) {
                            powerShellCommand1.addParameter("ProhibitSendReceiveQuota", this.prohibitSendAndRecvSize + "gb");
                        }
                        powerShellCommand1.addParameter("UseDatabaseQuotaDefaults", false);
                        powerShellCommand.setMultiQuery(powerShellCommand1);
                    }
                    if (this.selectedObjectsView >= 2) {
                        userDetail = new Properties();
                    }
                    PowerShellCommand getCommand = new PowerShellCommand("Get-Mailbox");
                    getCommand.addParameter("Identity", uniqueValue);
                    String res = ADHandler.updateO365Mailboxes((String)this.tenantId, (String)this.tenantPwd, (String)powerShellCommand.toString(), (String)getCommand.toString(), (int)1, (String)uniqueValue, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName, (Properties)((Properties)userDetail));
                    if (res != null && res.length() > 0) {
                        result = this.getResultString(res);
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String statusMsg = CommonUtil.getStatusMsgForO365Actions((String)result, (AdventNetResourceBundle)this.rb);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.email_frwd_str_limts"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (!json.has("friendlyErrorMsg")) {
                    return result;
                }
                result = json.getString("friendlyErrorMsg");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        String val = "-";
        if (userProp.getProperty("FORWARD_TO") != null) {
            val = userProp.getProperty("FORWARD_TO");
        }
        resProp.put((Object)752, val);
        if (userProp.containsKey("DELIVER_AND_REDIRECT")) {
            resProp.put((Object)753, userProp.getProperty("DELIVER_AND_REDIRECT"));
        } else {
            resProp.put((Object)753, "-");
        }
        if (userProp.containsKey("WARN_AT")) {
            resProp.put((Object)754, userProp.getProperty("WARN_AT"));
        } else {
            resProp.put((Object)754, "-");
        }
        if (userProp.containsKey("PROHIBIT_SEND_MESSAGES_AT")) {
            resProp.put((Object)755, userProp.getProperty("PROHIBIT_SEND_MESSAGES_AT"));
        } else {
            resProp.put((Object)755, "-");
        }
        if (userProp.containsKey("PROHIBIT_SEND_REC_MESSAGES_AT")) {
            resProp.put((Object)756, userProp.getProperty("PROHIBIT_SEND_REC_MESSAGES_AT"));
        } else {
            resProp.put((Object)756, "-");
        }
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41017L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }
}

