/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.formats.UserModificationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtAction;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365ProxyAddressesMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    boolean isAuthorised = false;
    ArrayList auditPropList = new ArrayList();
    boolean primaryAddrExists = false;
    boolean isNamingFormatsPresent = true;
    String externalEmail = "";
    Hashtable<String, Properties> selectedUsersDetails = new Hashtable();
    boolean isCsvImport = false;
    ArrayList<String> proxyAddressesArr = new ArrayList();

    private void initSelectedUsersDetails(int reportId, JSONArray selectedUsersList, Long userCreationID, JSONArray headerJsonArray) {
        try {
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(reportId));
            ArrayList attributePropsList = new ArrayList();
            for (int i = 0; i < tableNames.size(); ++i) {
                attributePropsList.addAll(ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(reportId)));
            }
            String[] objectIdArr = StrUtil.getStringArray((JSONArray)selectedUsersList);
            ArrayList<String> selectedObjects = new ArrayList<String>();
            String attribColumnName = "";
            for (int i = 0; i < headerJsonArray.length(); ++i) {
                String attr = headerJsonArray.getString(i);
                if (attr.equalsIgnoreCase("UserPrincipalName")) {
                    attribColumnName = "USER_PRINCIPAL_NAME";
                    break;
                }
                if (!attr.equalsIgnoreCase("ObjectId")) continue;
                attribColumnName = "OBJECT_ID";
                break;
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)AddUserHandler.USER_ATTRIBUTE_TABLE));
            ArrayList<String> userIndexes = new ArrayList<String>();
            for (int i = 0; i < selectedUsersList.length(); ++i) {
                userIndexes.add(selectedUsersList.getString(i));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes.toArray(new String[userIndexes.size()]), 8);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0));
            query.addSelectColumn(Column.getColumn((String)AddUserHandler.USER_ATTRIBUTE_TABLE, (String)"*"));
            query.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(AddUserHandler.USER_ATTRIBUTE_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Object value = row.get(attribColumnName);
                if (value == null) continue;
                selectedObjects.add((String)value);
            }
            this.selectedUsersDetails = O365MgmtHandler.getWAADUserDetails(attributePropsList, null, (String[])selectedObjects.toArray(new String[selectedObjects.size()]), (String)attribColumnName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            ArrayList<String> infoStrings;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_PROXY_ADDRESSES_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.primaryAddrExists = Boolean.parseBoolean(inputJsonObj.getString("primaryAddrExists"));
            this.isNamingFormatsPresent = Boolean.parseBoolean(inputJsonObj.getString("isNamingFormatsPresent"));
            this.externalEmail = inputJsonObj.getString("externalEmail");
            JSONArray proxyAddressesJsonArr = inputJsonObj.getJSONArray("proxyAddresses");
            int len = proxyAddressesJsonArr.length();
            for (int i = 0; i < len; ++i) {
                this.proxyAddressesArr.add(proxyAddressesJsonArr.getString(i));
            }
            this.isAuthorised = this.isAuthorized(tenantId, request);
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            this.informationStrings = infoStrings = new ArrayList<String>();
            infoStrings.add("admp.mgmt.office365.error.external_email_cannot_be_set_for_mailboxes");
            if (this.externalEmail != null && !this.externalEmail.equals("")) {
                Properties externalEmailProp = new Properties();
                externalEmailProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.external_mail_address"));
                externalEmailProp.put("ATTRIB_VALUE", this.externalEmail);
                this.auditPropList.add(externalEmailProp);
            }
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                this.isCsvImport = true;
                this.initSelectedUsersDetails(WAADBulkMgmtAction.O365_PROXY_ADDRESSES_REPORT_ID, selectedUsersList, userCreationID, headerJsonArray);
                action = new O365AbstractListener.ModifyCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_PROXY_ADDRESSES_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                if (this.isAuthorised) {
                    ArrayList<String> proxyAddresses = new ArrayList<String>();
                    String value = "";
                    String msg = "";
                    Properties currentUserDetails = null;
                    if (this.isNamingFormatsPresent) {
                        ArrayList<String> namingFormatAttribList = new ArrayList<String>();
                        namingFormatAttribList.addAll(this.attributeList);
                        ArrayList namingFormatAttribDetails = ReportAttributeHandler.getInstance().getAttributes("O365UserGeneralDetails");
                        namingFormatAttribDetails.addAll(ReportAttributeHandler.getInstance().getAttributes("O365UserExchangeDetails"));
                        Properties ldapNameVsColumnName = new Properties();
                        for (Properties p : namingFormatAttribDetails) {
                            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                            if (!namingFormatAttribList.contains(ldapName)) {
                                namingFormatAttribList.add(ldapName);
                            }
                            ldapNameVsColumnName.put(ldapName, p.get("ATTRIB_COLUMN_NAME"));
                        }
                        msg = ADHandler.getO365DetsForNamingFormats((String)this.tenantId, (String)this.tenantPwd, (String)uniqueValue, (NativeListener)this, namingFormatAttribList, (String)uniqueValueNativeParamName);
                        try {
                            Properties userDets = new Properties();
                            JSONObject json = new JSONObject(msg);
                            Iterator iterator = json.keys();
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                String columnName = (String)ldapNameVsColumnName.get(key);
                                if (columnName == null) continue;
                                userDets.put(columnName, json.getString(key));
                            }
                            currentUserDetails = userDets;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        currentUserDetails = this.isCsvImport ? this.selectedUsersDetails.get(uniqueValue) : (Properties)userDetail;
                    }
                    UserModificationFormatUtil.addUPNPrefixValue(currentUserDetails);
                    for (String address : this.proxyAddressesArr) {
                        value = UserModificationFormatUtil.getFormatValue(address, currentUserDetails, null, this.objectClass);
                        if (value.substring(0, 4).equalsIgnoreCase("smtp")) {
                            value = value.replaceAll(" ", "");
                        }
                        proxyAddresses.add(value);
                    }
                    Properties proxyAddressesProp = new Properties();
                    proxyAddressesProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.reports.o365.proxy_addressses"));
                    proxyAddressesProp.put("ATTRIB_VALUE", proxyAddresses.toString());
                    this.auditPropList.add(proxyAddressesProp);
                    this.attributeList.remove("ImmutableId");
                    this.attributeList.remove("DecodedImmutableId");
                    result = currentUserDetails == null || currentUserDetails.get("RECIPIENT_TYPE") == null ? (this.isNamingFormatsPresent ? "admp.mgmt.office365.error.error_setting_naming_formats" : "admp.restapi.error.user_not_found") : ADHandler.updateO365ProxyAddresses((String)this.tenantId, (String)this.tenantPwd, (String)uniqueValue, proxyAddresses, (String)this.externalEmail, (boolean)this.primaryAddrExists, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName, (Properties)currentUserDetails);
                    if (result != null && result.length() > 0) {
                        result = this.getResultString(result);
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String statusMsg = CommonUtil.getStatusMsgForO365Actions((String)result, (AdventNetResourceBundle)this.rb);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.add_proxy_addresses"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (!json.has("friendlyErrorMsg")) {
                    if (this.isCsvImport) {
                        result = "";
                    }
                    return result;
                }
                result = json.getString("friendlyErrorMsg");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.containsKey("USER_PRINCIPAL_NAME")) {
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        } else {
            resProp.put((Object)701, "-");
        }
        if (userProp.containsKey("DISPLAY_NAME")) {
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
        } else {
            resProp.put((Object)703, "-");
        }
        if (userProp.containsKey("PROXY_ADDRESSES")) {
            resProp.put((Object)720, userProp.getProperty("PROXY_ADDRESSES"));
        } else {
            resProp.put((Object)720, "-");
        }
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41109L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }
}

