/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitAutoReply
extends WorkFlowCommitListener {
    public CommitAutoReply() {
        this.reportId = (int)ReportsUtil.AUTO_REPLY_USER_MGTM_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String resultMsg;
        block30: {
            Object message = null;
            Boolean errorOccured = true;
            String guid = "";
            resultMsg = rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.unable_to_load_dll");
            try {
                String dn = (String)result.get(1004);
                String sid = (String)result.get(1144);
                String domainName = (String)result.get(1143);
                guid = (String)result.get(1145);
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                ArrayList modifyAttributeList = new ArrayList();
                ArrayList winNTProviderList = new ArrayList();
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                Long actionToPerform = (Long)requestActionDetails.get("REQUEST_ACTION");
                if (!actionToPerform.equals(18L) || inputsDetails.isEmpty()) break block30;
                String sendAutoReply = null;
                String sendOutsideMsg = null;
                String isTimeBased = null;
                String replyStartDate = null;
                String replyEndDate = null;
                String startHr = null;
                String startMin = null;
                String endHr = null;
                String endMin = null;
                String insideMsg = null;
                String outsideMsg = null;
                for (AdmpInput admpInput : inputsDetails) {
                    ArrayList inputsList = admpInput.getMultipleInput();
                    for (FcOption fcOption : inputsList) {
                        if (fcOption.getLabel().equalsIgnoreCase("IsSendAutoReply")) {
                            sendAutoReply = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("IsSendOutsideMsg")) {
                            sendOutsideMsg = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("IsTimeBased")) {
                            isTimeBased = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("ReplyEndDate")) {
                            replyEndDate = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("StartHr")) {
                            startHr = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("StartMin")) {
                            startMin = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("EndHr")) {
                            endHr = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("EndMin")) {
                            endMin = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("IsAutoReplyTimeBased")) {
                            isTimeBased = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("InsideMessage")) {
                            insideMsg = fcOption.getValue();
                        }
                        if (fcOption.getLabel().equalsIgnoreCase("OutsideMessage")) {
                            outsideMsg = fcOption.getValue();
                        }
                        if (!fcOption.getLabel().equalsIgnoreCase("ReplyStartDate")) continue;
                        replyStartDate = fcOption.getValue();
                    }
                }
                try {
                    String mailbox = "";
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"OBJECT_GUID"), (Object)guid, 0);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMMailBoxObjects", criteria);
                    if (!dataObj.isEmpty()) {
                        Row row = dataObj.getRow("ADSMMailBoxObjects");
                        mailbox = (String)row.get("HOME_MDB");
                    }
                    String mailBoxServer = "";
                    if (mailbox.equals("")) {
                        Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                        String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
                        String searchString = "(&(objectClass=user)(objectCategory=person)(objectSID=" + sid + "))";
                        ArrayList<String> attribList = new ArrayList<String>();
                        attribList.add("objectGuid");
                        attribList.add("msExchHomeServerName");
                        ArrayList userDetailsList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, attribList, (String)searchString);
                        if (userDetailsList.size() > 0) {
                            Properties userProp = (Properties)userDetailsList.get(0);
                            mailBoxServer = (String)((ArrayList)userProp.get("msExchHomeServerName")).get(0);
                        }
                    } else {
                        mailBoxServer = ExchangeUtil.getMailboxServer((String)mailbox, (String)domainName);
                    }
                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailBoxServer);
                    Properties sidProps = new Properties();
                    sidProps.put("ATTRIB_ID", new Integer(1144));
                    sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
                    sidProps.put("TABLE_NAME", "ADSMUserGeneralDetails");
                    sidProps.put("RELATIONAL_TYPE", new Integer(0));
                    Hashtable r = new Hashtable();
                    r.putAll(result);
                    if (guid.charAt(0) == '{') {
                        guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    }
                    PowerShellCommand powerShellCommand = new PowerShellCommand("Set-MailboxAutoReplyConfiguration");
                    powerShellCommand.setIdentity(guid);
                    if (sendAutoReply.equals("send")) {
                        if (isTimeBased.equals("true")) {
                            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
                            String startTime = outputFormat.format(inputFormat.parse(replyStartDate + " " + startHr + ":" + startMin));
                            String endTime = outputFormat.format(inputFormat.parse(replyEndDate + " " + endHr + ":" + endMin));
                            powerShellCommand.addParameter("AutoReplyState", "Scheduled");
                            powerShellCommand.addParameter("StartTime", startTime);
                            powerShellCommand.addParameter("EndTime", endTime);
                            setAttributeList.add(this.setPropperties(rb.getString("admp.mgmt.user_automation.auto_reply.end_time"), endTime));
                            setAttributeList.add(this.setPropperties(rb.getString("admp.workflow.robo_requester.history.start_time"), startTime));
                        } else {
                            powerShellCommand.addParameter("AutoReplyState", "Enabled");
                        }
                        insideMsg = insideMsg.replaceAll("(?i)%username%", "%name%");
                        insideMsg = FormatClientUtil.getFormatValue(insideMsg, r, domainName, "");
                        insideMsg = EscapeUtil.powershellEscape((String)insideMsg);
                        setAttributeList.add(this.setPropperties(rb.getString("admp.mgmt.user_automation.auto_reply.inside_msg"), insideMsg));
                        powerShellCommand.addParameter("InternalMessage", insideMsg);
                        if (sendOutsideMsg.equals("true")) {
                            outsideMsg = outsideMsg.replaceAll("(?i)%username%", "%name%");
                            outsideMsg = FormatClientUtil.getFormatValue(outsideMsg, r, domainName, "");
                            outsideMsg = EscapeUtil.powershellEscape((String)outsideMsg);
                            setAttributeList.add(this.setPropperties(rb.getString("admp.mgmt.user_automation.auto_reply.outside_msg"), outsideMsg));
                            powerShellCommand.addParameter("ExternalAudience", "All");
                            powerShellCommand.addParameter("ExternalMessage", outsideMsg);
                        } else {
                            powerShellCommand.addParameter("ExternalAudience", "None");
                        }
                    } else {
                        setAttributeList.add(this.setPropperties(rb.getString("o365.reports.col_name.auto_reply_state"), "Disabled"));
                        powerShellCommand.addParameter("AutoReplyState", "Disabled");
                    }
                    if (exchangeServerDetails != null) {
                        resultMsg = rb.getString(ADHandler.executePowershellCMD((String)domainName, (Long)loginId, (String)dn, (PowerShellCommand)powerShellCommand, (Properties)exchangeServerDetails));
                    }
                    if (resultMsg.equals("") || resultMsg == null) {
                        resultMsg = rb.getString("admp.mgmt.common.text.successfully_modified");
                        errorOccured = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.updateResult(guid, resultMsg.toString(), errorOccured);
                TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.mgmtname.auto_reply"), this.getValue(result, (Integer)1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), resultMsg, (Long)audit_info.get("object_id"), auditDataObj, rb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultMsg;
    }

    public Properties setPropperties(String name, String val) {
        Properties p = new Properties();
        p.put("ATTRIB_LDAP_NAME", name);
        p.put("ATTRIB_VALUE", val);
        return p;
    }
}

