/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CommitContactGroupAttributes
extends WorkFlowCommitListener {
    public CommitContactGroupAttributes() {
        this.reportId = (int)ReportsUtil.MODIFY_GROUP_CONTACT_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(10048);
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String dn = (String)result.get(10004);
            guid = (String)result.get(10050);
            String groupModifyStatusMessage = "";
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            if (!inputsDetails.isEmpty()) {
                AdmpInput admpInput = (AdmpInput)inputsDetails.get(0);
                String groupActionType = admpInput.getName();
                ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
                String status = new String();
                ArrayList multiInputDetailsList = admpInput.getMultipleInput();
                Boolean isMultiple = admpInput.getIsMultiple();
                Boolean isRemoveFromAllGroup = false;
                ArrayList existingGroupSidList = new ArrayList();
                ArrayList existingGroupNameList = new ArrayList();
                groupModifyStatusMessage = "";
                ArrayList ouList = null;
                Object includeExcludeGroupOUMap = null;
                Long requestMode = 0L;
                if (this.requestId != null) {
                    Properties requesterProps = WFRequesterUtil.getRequestProps((Long)this.requestId);
                    requestMode = (Long)requesterProps.get("REQUEST_MODE");
                    Long requesterId = (Long)requesterProps.get("REQUESTER_ID");
                    if (requestMode.equals(0L)) {
                        ouList = WFRequesterUtil.getOUListDN((String)this.domainName, (Long)requesterId);
                    }
                }
                String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + CommonUtil.escapeSpecialCharacters((String)dn) + "))";
                Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)loginId);
                ArrayList<String> groupAttributeList = new ArrayList<String>();
                groupAttributeList.add("cn");
                groupAttributeList.add("distinguishedName");
                groupAttributeList.add("objectSid");
                ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
                out.log(Level.INFO, "Membership details of the user : " + grouplistProps);
                for (int index = 0; index < grouplistProps.size(); ++index) {
                    Properties props = (Properties)grouplistProps.get(index);
                    if (props == null) continue;
                    ArrayList dnObject = (ArrayList)props.get("distinguishedName");
                    boolean isAuthorized = false;
                    isAuthorized = requestMode.equals(0L) ? HelpdeskUtil.isAuthorizedGroup((String)((String)dnObject.get(0)), (ArrayList)ouList) : this.isAuthorizedGroup((String)dnObject.get(0), this.domainName);
                    if (!isAuthorized) continue;
                    ArrayList groupObjectSid = (ArrayList)props.get("objectSid");
                    existingGroupSidList.add(groupObjectSid.get(0));
                    ArrayList groupObjectName = (ArrayList)props.get("cn");
                    existingGroupNameList.add(groupObjectName.get(0));
                }
                if (groupActionType.equalsIgnoreCase("AddToGroup")) {
                    ArrayList groupList = new ArrayList();
                    ArrayList<String> addToGroupSidList = new ArrayList<String>();
                    ArrayList<String> addToGroupNameList = new ArrayList<String>();
                    for (FcOption fcoption : multiInputDetailsList) {
                        addToGroupSidList.add(fcoption.getValue());
                        addToGroupNameList.add(fcoption.getLabel());
                    }
                    out.log(Level.INFO, "Selected groupsid details " + addToGroupSidList + " domainName :: " + this.domainName + " addToGroupNameList : " + addToGroupNameList);
                    if (addToGroupSidList != null && addToGroupSidList.size() > 0) {
                        groupList = GroupHandler.getDNList((String)this.domainName, addToGroupSidList);
                        out.log(Level.FINE, "After getting dnlist from DB :: " + groupList);
                    }
                    int totalCount = groupList.size();
                    addToGroupNameList.removeAll(existingGroupNameList);
                    addToGroupSidList.removeAll(existingGroupSidList);
                    int actualCount = addToGroupNameList.size();
                    list = new ArrayList();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", dn);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(3L));
                    list.add(p);
                    if (addToGroupSidList != null && !addToGroupSidList.isEmpty()) {
                        handleErrorList = new ArrayList();
                        errorOccured = false;
                        int addFailCount = 0;
                        out.log(Level.INFO, "Modifying Group :AddToGroup,  Domain Name : " + this.domainName + ", DNList : " + addToGroupSidList + ", list : " + list + " addToGroupNameList : " + addToGroupNameList);
                        for (int index = 0; index < addToGroupSidList.size(); ++index) {
                            try {
                                ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)loginId, (String)((String)addToGroupSidList.get(index)), (String)dn, list, new ArrayList(), (boolean)true);
                                continue;
                            }
                            catch (LocalizedException le) {
                                this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                                status = le.getMsgFromDetails(rb);
                                errorOccured = true;
                                ++addFailCount;
                                continue;
                            }
                            catch (Exception ex) {
                                message.append(ex.getMessage());
                                status = ex.getMessage();
                                errorOccured = true;
                                ++addFailCount;
                            }
                        }
                        if (totalCount != actualCount) {
                            handleErrorList.add(new Hashtable());
                        }
                        groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, totalCount, rb, addToGroupNameList, null, "add", addFailCount += totalCount - actualCount);
                        message.append(groupModifyStatusMessage);
                        out.log(Level.INFO, "User Mgmt - Add to Group Message " + groupModifyStatusMessage);
                    } else {
                        out.log(Level.INFO, "Add to group sid list was empty.... this might be because this contact is already member of selected group list " + dn);
                        message.append(rb.getString("admp.workflow.commitrequest.statmsg.contact_already_memberof_msg"));
                    }
                    this.fillAttribs(list, "memberOf", addToGroupNameList);
                    TechAuditAPI.getInstance().auditContactModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.add_to_group"), this.getValue(result, (Integer)10008), this.domainName, list, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
                } else if (groupActionType.equalsIgnoreCase("RemoveFromGroup")) {
                    ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
                    ArrayList<String> removeFromGroupNameList = new ArrayList<String>();
                    for (FcOption fcoption : multiInputDetailsList) {
                        if (fcoption.getLabel().equalsIgnoreCase("isRemoveAllGroup")) {
                            isRemoveFromAllGroup = Boolean.parseBoolean(fcoption.getValue());
                            continue;
                        }
                        removeFromGroupSidList.add(fcoption.getValue());
                        removeFromGroupNameList.add(fcoption.getLabel());
                    }
                    if (isRemoveFromAllGroup.booleanValue()) {
                        if (existingGroupNameList.isEmpty()) {
                            message = new StringBuffer(rb.getString("admp.workflow.view_request.stat_msg.contact_not_part_of_any_group"));
                        } else {
                            removeFromGroupSidList = existingGroupSidList;
                            removeFromGroupNameList = existingGroupNameList;
                        }
                    }
                    int totalNoOfGroups = removeFromGroupSidList.size();
                    removeFromGroupSidList.retainAll(existingGroupSidList);
                    removeFromGroupNameList.retainAll(existingGroupNameList);
                    int actualNoOfGroups = removeFromGroupSidList.size();
                    list = new ArrayList();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", dn);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    if (removeFromGroupSidList != null && !removeFromGroupSidList.isEmpty()) {
                        handleErrorList = new ArrayList();
                        errorOccured = false;
                        int removeFailCount = 0;
                        out.log(Level.INFO, "Modifying Group :RemoveFromGroup,  Domain Name : " + this.domainName + ", DNList : " + removeFromGroupSidList + ", list : " + list + " removeFromGroupNameList : " + removeFromGroupNameList);
                        for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                            try {
                                ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)loginId, (String)((String)removeFromGroupSidList.get(index)), (String)dn, list, new ArrayList(), (boolean)true);
                                continue;
                            }
                            catch (LocalizedException le) {
                                this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                                status = le.getMsgFromDetails(rb);
                                errorOccured = true;
                                ++removeFailCount;
                                continue;
                            }
                            catch (Exception ex) {
                                message.append(ex.getMessage());
                                status = ex.getMessage();
                                errorOccured = true;
                                ++removeFailCount;
                            }
                        }
                        if (totalNoOfGroups != actualNoOfGroups) {
                            handleErrorList.add(new Hashtable());
                        }
                        groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, totalNoOfGroups, rb, removeFromGroupNameList, null, "remove", removeFailCount += totalNoOfGroups - actualNoOfGroups);
                        message.append(groupModifyStatusMessage);
                        out.log(Level.INFO, "User Mgmt - Remove from Group Message " + groupModifyStatusMessage);
                    } else {
                        out.log(Level.INFO, "Remove group sid list was empty... this should not be the case..severity .. " + dn);
                        message.append(rb.getString("admp.workflow.commitrequest.statmsg.contact_not_memberof_msg"));
                    }
                    this.fillAttribs(list, "memberOf", removeFromGroupNameList);
                    TechAuditAPI.getInstance().auditContactModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.remove_from_group"), this.getValue(result, (Integer)10008), this.domainName, list, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
                }
            }
            try {
                guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                ADHandler.updateContact((String)this.domainName, (Long)loginId, (String)guid, (String)dn, (ArrayList)this.attributeList, (NativeListener)this);
            }
            catch (LocalizedException le) {
                message.append(le.getMessage(rb));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error"));
        }
        this.updateResult(guid, message.toString(), errorOccured);
        return message.toString();
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }
}

