/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitDelete
extends WorkFlowCommitListener {
    public CommitDelete() {
        this.reportId = (int)ReportsUtil.DELETE_USER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(1143);
        try {
            Integer dnId;
            String dn = (String)result.get(1004);
            Hashtable resultHash = new Hashtable();
            resultHash.putAll(result);
            resultHash.put("batchName", requestActionDetails.get("batchName"));
            guid = (String)result.get(1145);
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            String ou = this.getValue(resultHash, 1012);
            if (ou == null || ou.equals("")) {
                ou = StrUtil.getContainerDNFromDN((String)dn);
                resultHash.put(1012, ou);
            }
            if ((dnId = UserMgmtUtil.getAttributeId((String)"distinguishedName")) != null) {
                resultHash.put(dnId, dn);
            }
            message = DeleteUtil.deleteUser(this.domainName, loginId, dn, guid, resultHash, rb);
            guid = "{" + guid + "}";
            errorOccured = false;
            out.log(Level.INFO, " Deleted guid " + guid + " dn " + dn + " domainName " + this.domainName);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(rb));
        }
        catch (Exception e) {
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        this.updateResult(guid, message.toString(), errorOccured);
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.user_mgmt.del_users.mgmtname.delete_users"), this.getValue(result, (Integer)1010), this.domainName, message.toString(), rb);
        return message.toString();
    }
}

